/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.Objects;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.ComputedType;
import org.apache.solr.client.solrj.cloud.autoscaling.Operand;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaCount;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.VariableBase;
import org.apache.solr.common.MapWriter;

public class Condition
implements MapWriter {
    final String name;
    final Object val;
    final Variable.Type varType;
    final ComputedType computedType;
    final Operand op;
    Clause clause;

    Condition(String name, Object val, Operand op, ComputedType computedType, Clause parent) {
        this.name = name;
        this.val = val;
        this.op = op;
        this.varType = VariableBase.getTagType(name);
        this.computedType = computedType;
        this.clause = parent;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        String value = this.op.wrap(this.val);
        if (this.computedType != null) {
            value = this.computedType.wrap(value);
        }
        ew.put((CharSequence)this.name, value);
    }

    public String toString() {
        return this.jsonStr();
    }

    public Clause getClause() {
        return this.clause;
    }

    boolean isPass(Object inputVal) {
        return this.isPass(inputVal, null);
    }

    boolean isPass(Object inputVal, Row row) {
        if (this.computedType != null) {
            throw new IllegalStateException("This is supposed to be called only from a Condition with no computed value or a SealedCondition");
        }
        if (inputVal instanceof ReplicaCount) {
            inputVal = ((ReplicaCount)inputVal).getVal(this.getClause().type);
        }
        return this.varType.match(inputVal, this.op, this.val, this.name, row);
    }

    boolean isPass(Row row) {
        return this.isPass(row.getVal(this.name), row);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.val, this.op});
    }

    public boolean equals(Object that) {
        if (that instanceof Condition) {
            Condition c = (Condition)that;
            return Objects.equals(c.name, this.name) && Objects.equals(c.val, this.val) && c.op == this.op;
        }
        return false;
    }

    public Double replicaCountDelta(Object val) {
        if (val instanceof ReplicaCount) {
            val = ((ReplicaCount)val).getVal(this.getClause().type);
        }
        return this.op.delta(this.val, val);
    }

    public Double delta(Object val) {
        if (this.val instanceof String) {
            if (this.op == Operand.LESS_THAN || this.op == Operand.GREATER_THAN) {
                return this.op.opposite(this.getClause().isReplicaZero() && this == this.getClause().tag).delta(Clause.parseDouble(this.name, this.val), Clause.parseDouble(this.name, val));
            }
            return 0.0;
        }
        return this.op.opposite(this.getClause().isReplicaZero() && this == this.getClause().getTag()).delta(this.val, val);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.val;
    }

    public Operand getOperand() {
        return this.op;
    }
}

