/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.LongAccumulation;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.resources.Resource;

public final class LongLastValueAggregator
implements Aggregator<LongAccumulation, LongExemplarData> {
    private final Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier;

    public LongLastValueAggregator(Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier) {
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<LongAccumulation, LongExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public LongAccumulation merge(LongAccumulation previous, LongAccumulation current) {
        return current;
    }

    @Override
    public LongAccumulation diff(LongAccumulation previous, LongAccumulation current) {
        return current;
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Map<Attributes, LongAccumulation> accumulationByLabels, AggregationTemporality temporality, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return ImmutableMetricData.createLongGauge(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableGaugeData.create(MetricDataUtils.toLongPointList(accumulationByLabels, temporality == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<LongAccumulation, LongExemplarData> {
        @Nullable
        private static final Long DEFAULT_VALUE = null;
        private final AtomicReference<Long> current = new AtomicReference<Long>(DEFAULT_VALUE);

        Handle(ExemplarReservoir<LongExemplarData> exemplarReservoir) {
            super(exemplarReservoir);
        }

        @Override
        protected LongAccumulation doAccumulateThenReset(List<LongExemplarData> exemplars) {
            return LongAccumulation.create(this.current.getAndSet(DEFAULT_VALUE), exemplars);
        }

        @Override
        protected void doRecordLong(long value) {
            this.current.set(value);
        }
    }
}

