/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.metrics.metric;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.LongAdder;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultEndpointMetric;

public class DefaultClientEndpointMetric
extends DefaultEndpointMetric {
    private final LongAdder queue = new LongAdder();
    private long lastNanoTime = System.nanoTime();

    public DefaultClientEndpointMetric(String address) {
        super(address);
    }

    @VisibleForTesting
    public long getLastNanoTime() {
        return this.lastNanoTime;
    }

    @Override
    public void onDisconnect() {
        super.onDisconnect();
        this.lastNanoTime = System.nanoTime();
    }

    public long getQueueCount() {
        return this.queue.longValue();
    }

    public void enqueueRequest() {
        this.queue.increment();
    }

    public void dequeueRequest() {
        this.queue.decrement();
    }

    public boolean isExpired(long nsTimeout) {
        return this.getCurrentConnectionCount() == 0L && System.nanoTime() - this.lastNanoTime > nsTimeout;
    }
}

