/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.Histogram;
import io.micrometer.core.instrument.distribution.HistogramGauges;
import io.micrometer.core.instrument.distribution.StepBucketHistogram;
import io.micrometer.core.instrument.simple.CountingMode;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import org.apache.servicecomb.metrics.core.StepDistributionSummaryExt;

public class SimpleMeterRegistryExt
extends SimpleMeterRegistry {
    private final SimpleConfig config;

    public SimpleMeterRegistryExt(SimpleConfig config, Clock clock) {
        super(config, clock);
        this.config = config;
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        DistributionStatisticConfig merged = distributionStatisticConfig.merge(DistributionStatisticConfig.builder().expiry(this.config.step()).build());
        Object summary = switch (this.config.mode()) {
            case CountingMode.CUMULATIVE -> new CumulativeDistributionSummary(id, this.clock, merged, scale, false);
            default -> new StepDistributionSummaryExt(id, this.clock, merged, scale, this.config.step().toMillis(), (Histogram)new StepBucketHistogram(this.clock, this.config.step().toMillis(), distributionStatisticConfig, false, false));
        };
        HistogramGauges.registerWithCommonFormat((DistributionSummary)summary, (MeterRegistry)this);
        return summary;
    }
}

