/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.validator.operation;

import io.swagger.v3.oas.models.Operation;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.api.OperationValidator;

public class OperationTagsSizeEqValidator
implements OperationValidator {
    public static final String CONFIG_KEY = "operation.tags.size.eq";
    public static final String ERROR = "size must be == ";
    private final int expectedSize;

    public OperationTagsSizeEqValidator(int expectedSize) {
        this.expectedSize = expectedSize;
    }

    public List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, Operation oasObject) {
        List tags = oasObject.getTags();
        if (CollectionUtils.size((Object)tags) != this.expectedSize) {
            return Collections.singletonList(new OasViolation(location.property("tags"), ERROR + this.expectedSize));
        }
        return Collections.emptyList();
    }
}

