/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.validator.paths;

import io.swagger.v3.oas.models.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectPropertyLocation;
import org.apache.servicecomb.toolkit.oasv.common.OasObjectType;
import org.apache.servicecomb.toolkit.oasv.util.StringCaseUtils;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasValidationContext;
import org.apache.servicecomb.toolkit.oasv.validation.api.OasViolation;
import org.apache.servicecomb.toolkit.oasv.validation.api.PathsValidator;

public class PathsKeyCaseValidator
implements PathsValidator {
    public static final String CONFIG_KEY = "paths.key.case";
    public static final String ERROR = "Must be ";
    private static final Pattern TEMPLATE_PATTERN = Pattern.compile("^\\{(.*)\\}$");
    private final String expectedCase;

    public PathsKeyCaseValidator(String expectedCase) {
        this.expectedCase = expectedCase;
    }

    public List<OasViolation> validate(OasValidationContext context, OasObjectPropertyLocation location, Paths oasObject) {
        ArrayList<OasViolation> violations = new ArrayList<OasViolation>();
        Set paths = oasObject.keySet();
        for (String path : paths) {
            if (this.matchCamelCase(path)) continue;
            OasObjectPropertyLocation pathLoc = location.property(path, OasObjectType.PATH_ITEM);
            violations.add(new OasViolation(pathLoc, ERROR + this.expectedCase));
        }
        return violations;
    }

    private boolean matchCamelCase(String path) {
        String[] pathSegments;
        for (String pathSegment : pathSegments = path.split("/")) {
            if (StringUtils.isEmpty((CharSequence)pathSegment)) continue;
            String matchingPart = pathSegment;
            if (this.isTemplate(pathSegment)) {
                matchingPart = this.extractTemplateVariable(pathSegment);
            }
            if (StringCaseUtils.isMatchCase((String)this.expectedCase, (String)matchingPart)) continue;
            return false;
        }
        return true;
    }

    private boolean isTemplate(String pathSegment) {
        return TEMPLATE_PATTERN.matcher(pathSegment).matches();
    }

    private String extractTemplateVariable(String pathSegment) {
        Matcher matcher = TEMPLATE_PATTERN.matcher(pathSegment);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }
}

