/*
 * Decompiled with CFR 0.152.
 */
package config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import config.Config;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigParser.class);

    public static Config read(String location) {
        LOGGER.info("reading config from " + location);
        ObjectMapper mapper = new ObjectMapper();
        Config config = new Config();
        try {
            JsonNode rootNode = mapper.readTree(new File(location));
            Iterator optionNodes = rootNode.fields();
            while (optionNodes.hasNext()) {
                Map.Entry optionNode = (Map.Entry)optionNodes.next();
                if (((JsonNode)optionNode.getValue()).isValueNode()) {
                    config.setOption((String)optionNode.getKey(), ((JsonNode)optionNode.getValue()).asText());
                    continue;
                }
                LOGGER.warn("omitting non-value node " + (String)optionNode.getKey());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return null;
        }
        return config;
    }
}

