/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.util.Constants;

public abstract class AbstractStringLayout
extends AbstractLayout<String> {
    private static final long serialVersionUID = 1L;
    private final Charset charset;

    protected AbstractStringLayout(Charset charset) {
        this(charset, null, null);
    }

    protected AbstractStringLayout(Charset charset, byte[] header, byte[] footer) {
        super(header, footer);
        this.charset = charset == null ? Constants.UTF_8 : charset;
    }

    protected byte[] getBytes(String s) {
        return s.getBytes(this.charset);
    }

    protected Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public byte[] toByteArray(LogEvent event) {
        return ((String)this.toSerializable(event)).getBytes(this.charset);
    }
}

