/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import com.netflix.config.DynamicPropertyFactory;
import io.swagger.models.Operation;
import io.swagger.models.parameters.Parameter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.servicecomb.config.inject.ConfigObjectFactory;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationConfig;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.executor.ExecutorManager;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.swagger.invocation.response.ResponseMeta;
import org.apache.servicecomb.swagger.invocation.response.ResponsesMeta;

public class OperationMeta {
    private SchemaMeta schemaMeta;
    private String schemaQualifiedName;
    private String microserviceQualifiedName;
    private Method method;
    private String httpMethod;
    private String operationPath;
    private Operation swaggerOperation;
    private Executor executor;
    private ResponsesMeta responsesMeta = new ResponsesMeta();
    private Map<String, Object> extData = new ConcurrentHashMapEx();
    private Handler providerQpsFlowControlHandler;
    private boolean providerQpsFlowControlHandlerSearched;
    private String transport = null;
    private OperationConfig config;

    public void init(SchemaMeta schemaMeta, Method method, String operationPath, String httpMethod, Operation swaggerOperation) {
        this.schemaMeta = schemaMeta;
        this.schemaQualifiedName = schemaMeta.getSchemaId() + "." + method.getName();
        this.microserviceQualifiedName = schemaMeta.getMicroserviceName() + "." + this.schemaQualifiedName;
        this.operationPath = operationPath;
        this.method = method;
        this.httpMethod = httpMethod.toUpperCase(Locale.US);
        this.swaggerOperation = swaggerOperation;
        this.config = (OperationConfig)new ConfigObjectFactory().create(OperationConfig.class, new Object[]{"op-any-priority", schemaMeta.getMicroserviceMeta().isConsumer() ? OperationConfig.CONSUMER_OP_ANY_PRIORITY : OperationConfig.PRODUCER_OP_ANY_PRIORITY, "consumer-op-any_priority", OperationConfig.CONSUMER_OP_ANY_PRIORITY, "producer-op-any_priority", OperationConfig.PRODUCER_OP_ANY_PRIORITY, "op-priority", schemaMeta.getMicroserviceMeta().isConsumer() ? OperationConfig.CONSUMER_OP_PRIORITY : OperationConfig.PRODUCER_OP_PRIORITY, "consumer-op-priority", OperationConfig.CONSUMER_OP_PRIORITY, "producer-op-priority", OperationConfig.PRODUCER_OP_PRIORITY, "consumer-producer", schemaMeta.getMicroserviceMeta().isConsumer() ? "Consumer" : "Provider", "consumer-provider", schemaMeta.getMicroserviceMeta().isConsumer() ? "Consumer" : "Provider", "service", schemaMeta.getMicroserviceName(), "schema", schemaMeta.getSchemaId(), "operation", swaggerOperation.getOperationId()});
        this.executor = ExecutorManager.findExecutor(this);
        this.responsesMeta.init(schemaMeta.getSwaggerToClassGenerator(), swaggerOperation, method.getGenericReturnType());
        this.transport = DynamicPropertyFactory.getInstance().getStringProperty("servicecomb.operation." + this.microserviceQualifiedName + ".transport", null).get();
    }

    public OperationConfig getConfig() {
        return this.config;
    }

    public String getTransport() {
        return this.transport;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getOperationPath() {
        return this.operationPath;
    }

    public Operation getSwaggerOperation() {
        return this.swaggerOperation;
    }

    public ResponseMeta findResponseMeta(int statusCode) {
        return this.responsesMeta.findResponseMeta(statusCode);
    }

    public MicroserviceMeta getMicroserviceMeta() {
        return this.schemaMeta.getMicroserviceMeta();
    }

    public SchemaMeta getSchemaMeta() {
        return this.schemaMeta;
    }

    public String getSchemaQualifiedName() {
        return this.schemaQualifiedName;
    }

    public String getMicroserviceQualifiedName() {
        return this.microserviceQualifiedName;
    }

    public String getMicroserviceName() {
        return this.schemaMeta.getMicroserviceName();
    }

    public Method getMethod() {
        return this.method;
    }

    public String getOperationId() {
        return this.swaggerOperation.getOperationId();
    }

    public String getParamName(int idx) {
        return ((Parameter)this.swaggerOperation.getParameters().get(idx)).getName();
    }

    public void putExtData(String key, Object data) {
        this.extData.put(key, data);
    }

    public <T> T getExtData(String key) {
        return (T)this.extData.get(key);
    }

    public Map<String, Object> getExtData() {
        return this.extData;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public int getParamSize() {
        return this.swaggerOperation.getParameters().size();
    }

    @Deprecated
    public Handler getProviderQpsFlowControlHandler() {
        if (this.providerQpsFlowControlHandlerSearched) {
            return this.providerQpsFlowControlHandler;
        }
        List<Handler> providerHandlerChain = this.getSchemaMeta().getProviderHandlerChain();
        for (Handler handler : providerHandlerChain) {
            if (!"org.apache.servicecomb.qps.ProviderQpsFlowControlHandler".equals(handler.getClass().getName())) continue;
            this.providerQpsFlowControlHandler = handler;
            break;
        }
        this.providerQpsFlowControlHandlerSearched = true;
        return this.providerQpsFlowControlHandler;
    }
}

