/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter;

import org.apache.servicecomb.core.CseContext;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.discovery.AbstractEndpointDiscoveryFilter;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryContext;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointDiscoveryFilter
extends AbstractEndpointDiscoveryFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointDiscoveryFilter.class);

    public int getOrder() {
        return Short.MAX_VALUE;
    }

    protected String findTransportName(DiscoveryContext context, DiscoveryTreeNode parent) {
        Invocation invocation = (Invocation)((Object)context.getInputParameters());
        return invocation.getConfigTransportName();
    }

    protected Object createEndpoint(String transportName, String endpoint, MicroserviceInstance instance) {
        Transport transport = CseContext.getInstance().getTransportManager().findTransport(transportName);
        if (transport == null) {
            LOGGER.info("not deployed transport {}, ignore {}.", (Object)transportName, (Object)endpoint);
            return null;
        }
        return new Endpoint(transport, endpoint, instance);
    }
}

