/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.DecimalFunctions;

public final class Epoch
extends FormattableObject {
    public final double value;
    public final int precision;
    private final String keyword;

    public Epoch(Temporal epoch, String keyword) {
        this.keyword = keyword;
        if (epoch instanceof Instant) {
            epoch = OffsetDateTime.ofInstant((Instant)epoch, ZoneOffset.UTC);
        }
        int year = epoch.get(ChronoField.YEAR);
        if (epoch instanceof Year) {
            this.value = year;
            this.precision = 0;
        } else {
            double day = 0.0;
            int fractionDigits = 3;
            if (epoch instanceof YearMonth) {
                epoch = ((YearMonth)epoch).atDay(1);
                fractionDigits = 2;
            } else if (epoch.isSupported(ChronoField.NANO_OF_DAY)) {
                long nano = epoch.getLong(ChronoField.NANO_OF_DAY);
                day = (double)nano / 8.64E13;
                fractionDigits = nano % 1000000000L != 0L ? 16 : 8;
            }
            this.value = (double)year + (day += (double)(epoch.get(ChronoField.DAY_OF_YEAR) - 1)) / (double)Year.of(year).length();
            this.precision = Math.min(DecimalFunctions.fractionDigitsForValue((double)this.value) - 1, fractionDigits);
        }
    }

    public static Temporal fromYear(double epoch, int precision) {
        if (Double.isNaN(epoch)) {
            return null;
        }
        Year year = Year.of((int)epoch);
        double time = epoch - (double)year.getValue();
        long day = Math.round(time * (double)year.length());
        if (day == 0L && precision <= 0) {
            return year;
        }
        LocalDate date = year.atDay(Math.toIntExact(day + 1L));
        if (precision <= 2) {
            return year.atMonth(date.getMonth());
        }
        return date;
    }

    public static Temporal fromYear(String epoch) {
        int precision = 0;
        int i = epoch.indexOf(46);
        if (i >= 0) {
            char c;
            int length = epoch.length();
            while (++i < length && (c = epoch.charAt(i)) >= '0' && c <= '9') {
                ++precision;
            }
        }
        return Epoch.fromYear(Double.parseDouble(epoch), precision);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        formatter.append(this.value, this.precision);
        return this.keyword;
    }
}

