/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sis.io.wkt.Parser;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.internal.ParameterizedTransformBuilder;
import org.apache.sis.referencing.internal.shared.CoordinateOperations;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransform;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.CoordinateSystemTransformBuilder;
import org.apache.sis.referencing.operation.transform.MathTransformBuilder;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.OperationMethodSet;
import org.apache.sis.system.Reflect;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class DefaultMathTransformFactory
extends AbstractFactory
implements MathTransformFactory,
Parser {
    private static volatile Constructor<? extends Parser> parserConstructor;
    private final Iterable<? extends OperationMethod> methods;
    private final ConcurrentMap<String, OperationMethod> methodsByName;
    private final Map<Class<?>, OperationMethodSet> methodsByType;
    final ThreadLocal<OperationMethod> lastMethod;
    private final WeakHashSet<MathTransform> pool;
    private final AtomicReference<Parser> parser;
    private DefaultMathTransformFactory oppositeCachingPolicy;
    private static final DefaultMathTransformFactory INSTANCE;

    public static DefaultMathTransformFactory provider() {
        return INSTANCE;
    }

    public DefaultMathTransformFactory() {
        this(DefaultMathTransformFactory.operations());
    }

    private static ServiceLoader<OperationMethod> operations() {
        try {
            return ServiceLoader.load(OperationMethod.class, Reflect.getContextClassLoader());
        }
        catch (SecurityException e) {
            Reflect.log(DefaultMathTransformFactory.class, (String)"<init>", (SecurityException)e);
            return ServiceLoader.load(OperationMethod.class);
        }
    }

    public DefaultMathTransformFactory(Iterable<? extends OperationMethod> methods) {
        this.methods = Objects.requireNonNull(methods);
        this.methodsByName = new ConcurrentHashMap<String, OperationMethod>();
        this.methodsByType = new IdentityHashMap();
        this.lastMethod = new ThreadLocal();
        this.pool = new WeakHashSet(MathTransform.class);
        this.parser = new AtomicReference();
    }

    private DefaultMathTransformFactory(DefaultMathTransformFactory parent) {
        this.methods = parent.methods;
        this.methodsByName = parent.methodsByName;
        this.methodsByType = parent.methodsByType;
        this.lastMethod = new ThreadLocal();
        this.pool = null;
        this.parser = parent.parser;
        this.oppositeCachingPolicy = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMathTransformFactory caching(boolean enabled) {
        if (enabled) {
            return this;
        }
        DefaultMathTransformFactory defaultMathTransformFactory = this;
        synchronized (defaultMathTransformFactory) {
            if (this.oppositeCachingPolicy == null) {
                this.oppositeCachingPolicy = new NoCache(this);
            }
            return this.oppositeCachingPolicy;
        }
    }

    final DefaultMathTransformFactory oppositeCachingPolicy() {
        return this.oppositeCachingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OperationMethod> getAvailableMethods(Class<? extends SingleOperation> type) {
        OperationMethodSet set;
        Object object = this.methodsByType;
        synchronized (object) {
            set = this.methodsByType.get(Objects.requireNonNull(type));
        }
        if (set == null) {
            OperationMethodSet previous;
            object = this.methods;
            synchronized (object) {
                set = new OperationMethodSet(type, this.methods);
            }
            Map<Class<?>, OperationMethodSet> map = this.methodsByType;
            synchronized (map) {
                previous = this.methodsByType.putIfAbsent(type, set);
            }
            if (previous != null) {
                set = previous;
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationMethod getOperationMethod(String identifier) throws NoSuchIdentifierException {
        identifier = identifier.strip();
        ArgumentChecks.ensureNonEmpty((String)"identifier", (CharSequence)identifier);
        OperationMethod method = (OperationMethod)this.methodsByName.get(identifier);
        if (method == null) {
            Iterable<? extends OperationMethod> iterable = this.methods;
            synchronized (iterable) {
                method = CoordinateOperations.findMethod(this.methods, identifier);
            }
            OperationMethod previous = this.methodsByName.putIfAbsent(identifier.intern(), method);
            if (previous != null) {
                method = previous;
            }
        }
        return method;
    }

    public MathTransformBuilder builder(String method) throws NoSuchIdentifierException {
        if (method.replace('_', ' ').equalsIgnoreCase("Coordinate system conversion")) {
            return new CoordinateSystemTransformBuilder(this);
        }
        return new ParameterizedTransformBuilder(this, this.getOperationMethod(method));
    }

    @Deprecated(since="1.5")
    public ParameterValueGroup getDefaultParameters(String method) throws NoSuchIdentifierException {
        return this.getOperationMethod(method).getParameters().createValue();
    }

    @Deprecated(since="1.5")
    public MathTransform createParameterizedTransform(ParameterValueGroup parameters) throws NoSuchIdentifierException, FactoryException {
        ParameterizedTransformBuilder builder = new ParameterizedTransformBuilder(this, null);
        builder.setParameters(parameters, false);
        return builder.create();
    }

    @Deprecated(since="1.5", forRemoval=true)
    public MathTransform createParameterizedTransform(ParameterValueGroup parameters, Context context) throws NoSuchIdentifierException, FactoryException {
        if (context == null) {
            return this.createParameterizedTransform(parameters);
        }
        context.builder = null;
        context.factory = this;
        context.parameters = parameters;
        return context.builder().create();
    }

    @Deprecated(since="1.5", forRemoval=true)
    public MathTransform swapAndScaleAxes(MathTransform parameterized, Context context) throws FactoryException {
        context.builder = null;
        context.factory = this;
        return context.builder().swapAndScaleAxes(parameterized);
    }

    @Deprecated(since="0.7")
    public MathTransform createBaseToDerived(CoordinateReferenceSystem baseCRS, ParameterValueGroup parameters, CoordinateSystem derivedCS) throws NoSuchIdentifierException, FactoryException {
        ArgumentChecks.ensureNonNull((String)"baseCRS", (Object)baseCRS);
        ArgumentChecks.ensureNonNull((String)"parameters", (Object)parameters);
        ArgumentChecks.ensureNonNull((String)"derivedCS", (Object)derivedCS);
        ParameterizedTransformBuilder builder = new ParameterizedTransformBuilder(this, null);
        builder.setParameters(parameters, true);
        builder.setSourceAxes(baseCRS);
        builder.setTargetAxes(derivedCS, null);
        return builder.create();
    }

    @Deprecated(since="1.5", forRemoval=true)
    public MathTransform createCoordinateSystemChange(CoordinateSystem source, CoordinateSystem target, Ellipsoid ellipsoid) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"source", (Object)source);
        ArgumentChecks.ensureNonNull((String)"target", (Object)target);
        this.lastMethod.remove();
        MathTransformBuilder builder = this.builder("Coordinate system conversion");
        builder.setSourceAxes(source, ellipsoid);
        builder.setTargetAxes(target, ellipsoid);
        return builder.create();
    }

    public MathTransform createAffineTransform(Matrix matrix) throws FactoryException {
        this.lastMethod.remove();
        return this.unique(MathTransforms.linear(matrix));
    }

    public MathTransform createConcatenatedTransform(MathTransform tr1, MathTransform tr2) throws FactoryException {
        MathTransform tr;
        this.lastMethod.remove();
        ArgumentChecks.ensureNonNull((String)"tr1", (Object)tr1);
        ArgumentChecks.ensureNonNull((String)"tr2", (Object)tr2);
        try {
            tr = ConcatenatedTransform.create(this, tr1, tr2);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
        }
        return this.unique(tr);
    }

    public MathTransform createPassThroughTransform(int firstAffectedCoordinate, MathTransform subTransform, int numTrailingCoordinates) throws FactoryException {
        MathTransform tr;
        this.lastMethod.remove();
        try {
            tr = MathTransforms.passThrough(firstAffectedCoordinate, subTransform, numTrailingCoordinates);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
        }
        return this.unique(tr);
    }

    @Deprecated
    public MathTransform createFromXML(String xml) throws FactoryException {
        this.lastMethod.remove();
        throw new FactoryException(Errors.format((short)199, (Object)"createFromXML"));
    }

    public MathTransform createFromWKT(String wkt) throws FactoryException {
        Object object;
        this.lastMethod.remove();
        ArgumentChecks.ensureNonEmpty((String)"wkt", (CharSequence)wkt);
        Parser p = this.parser.getAndSet(null);
        if (p == null) {
            try {
                Constructor<? extends Parser> c = parserConstructor;
                if (c == null) {
                    c = Class.forName("org.apache.sis.io.wkt.MathTransformParser").asSubclass(Parser.class).getConstructor(MathTransformFactory.class);
                    c.setAccessible(true);
                    parserConstructor = c;
                }
                p = c.newInstance(this);
            }
            catch (ReflectiveOperationException e) {
                throw new FactoryException((Throwable)e);
            }
        }
        try {
            object = p.createFromWKT(wkt);
        }
        catch (FactoryException e) {
            for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                if (!(cause instanceof ParameterNotFoundException)) continue;
                throw new InvalidGeodeticParameterException(e.getLocalizedMessage(), cause);
            }
            throw e;
        }
        this.parser.set(p);
        return (MathTransform)object;
    }

    final MathTransform unique(MathTransform tr) {
        return this.pool != null ? (MathTransform)this.pool.unique((Object)tr) : tr;
    }

    @Deprecated(since="1.5")
    public OperationMethod getLastMethodUsed() {
        return this.lastMethod.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Iterable<? extends OperationMethod> iterable = this.methods;
        synchronized (iterable) {
            this.methodsByName.clear();
            Iterable<? extends OperationMethod> m = this.methods;
            if (m instanceof ServiceLoader) {
                ((ServiceLoader)m).reload();
            }
            Map<Class<?>, OperationMethodSet> map = this.methodsByType;
            synchronized (map) {
                for (OperationMethodSet c : this.methodsByType.values()) {
                    c.reset();
                }
            }
            if (this.pool != null) {
                this.pool.clear();
            }
        }
    }

    static {
        INSTANCE = new DefaultMathTransformFactory();
    }

    private static final class NoCache
    extends DefaultMathTransformFactory {
        NoCache(DefaultMathTransformFactory parent) {
            super(parent);
        }

        @Override
        public DefaultMathTransformFactory caching(boolean enabled) {
            return enabled ? this.oppositeCachingPolicy() : this;
        }

        @Override
        public void reload() {
            this.oppositeCachingPolicy().reload();
        }
    }

    @Deprecated(since="1.5", forRemoval=true)
    public static class Context
    implements MathTransformProvider.Context,
    Serializable {
        private transient DefaultMathTransformFactory factory;
        private CoordinateSystem sourceCS;
        private CoordinateSystem targetCS;
        private Ellipsoid sourceEllipsoid;
        private Ellipsoid targetEllipsoid;
        private ParameterizedTransformBuilder builder;
        private ParameterValueGroup parameters;
        private static final String MESSAGE = "createParameterizedTransform has not been invoked.";

        @Deprecated(since="1.5", forRemoval=true)
        public void setSource(CoordinateSystem cs) {
            this.sourceCS = cs;
            this.sourceEllipsoid = null;
            this.builder = null;
        }

        @Deprecated(since="1.5", forRemoval=true)
        public void setSource(GeodeticCRS crs) {
            if (crs != null) {
                this.sourceCS = crs.getCoordinateSystem();
                this.sourceEllipsoid = DatumOrEnsemble.getEllipsoid((CoordinateReferenceSystem)crs).orElse(null);
            } else {
                this.sourceCS = null;
                this.sourceEllipsoid = null;
            }
            this.builder = null;
        }

        @Deprecated(since="1.5", forRemoval=true)
        public void setTarget(CoordinateSystem cs) {
            this.targetCS = cs;
            this.targetEllipsoid = null;
            this.builder = null;
        }

        @Deprecated(since="1.5", forRemoval=true)
        public void setTarget(GeodeticCRS crs) {
            if (crs != null) {
                this.targetCS = crs.getCoordinateSystem();
                this.targetEllipsoid = DatumOrEnsemble.getEllipsoid((CoordinateReferenceSystem)crs).orElse(null);
            } else {
                this.targetCS = null;
                this.targetEllipsoid = null;
            }
            this.builder = null;
        }

        public CoordinateSystem getSourceCS() {
            return this.sourceCS;
        }

        public Ellipsoid getSourceEllipsoid() {
            return this.sourceEllipsoid;
        }

        public CoordinateSystem getTargetCS() {
            return this.targetCS;
        }

        public Ellipsoid getTargetEllipsoid() {
            return this.targetEllipsoid;
        }

        final ParameterizedTransformBuilder builder() throws FactoryException {
            if (this.builder == null) {
                if (this.factory == null) {
                    this.factory = DefaultMathTransformFactory.provider();
                }
                this.builder = new ParameterizedTransformBuilder(this.factory, null);
                if (this.parameters != null) {
                    this.builder.setParameters(this.parameters, false);
                }
            }
            return this.builder;
        }

        public Matrix getMatrix(ContextualParameters.MatrixRole role) throws FactoryException {
            return this.builder().getMatrix(role);
        }

        @Deprecated(since="1.5", forRemoval=true)
        public OperationMethod getMethodUsed() {
            return this.builder != null ? (OperationMethod)this.builder.getMethod().orElse(null) : null;
        }

        @Override
        @Deprecated(since="1.5", forRemoval=true)
        public Map<String, Boolean> getContextualParameters() {
            try {
                return this.builder().getContextualParameters();
            }
            catch (FactoryException e) {
                throw new IllegalStateException(MESSAGE, e);
            }
        }

        @Override
        @Deprecated(since="1.5", forRemoval=true)
        public ParameterValueGroup getCompletedParameters() {
            try {
                return this.builder().getCompletedParameters();
            }
            catch (FactoryException e) {
                throw new IllegalStateException(MESSAGE, e);
            }
        }

        public String toString() {
            return this.builder != null ? this.builder.toString() : super.toString();
        }
    }
}

