/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Map;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.DefaultAffineCS;
import org.apache.sis.referencing.cs.DefaultCylindricalCS;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.cs.DefaultLinearCS;
import org.apache.sis.referencing.cs.DefaultPolarCS;
import org.apache.sis.referencing.cs.DefaultSphericalCS;
import org.apache.sis.referencing.cs.DefaultTimeCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.legacy.DefaultUserDefinedCS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.cs.VerticalCS;

final class SubTypes {
    private SubTypes() {
    }

    static AbstractCS castOrCopy(CoordinateSystem object) {
        if (object instanceof AffineCS) {
            return DefaultAffineCS.castOrCopy((AffineCS)object);
        }
        if (object instanceof SphericalCS) {
            return DefaultSphericalCS.castOrCopy((SphericalCS)object);
        }
        if (object instanceof EllipsoidalCS) {
            return DefaultEllipsoidalCS.castOrCopy((EllipsoidalCS)object);
        }
        if (object instanceof CylindricalCS) {
            return DefaultCylindricalCS.castOrCopy((CylindricalCS)object);
        }
        if (object instanceof PolarCS) {
            return DefaultPolarCS.castOrCopy((PolarCS)object);
        }
        if (object instanceof LinearCS) {
            return DefaultLinearCS.castOrCopy((LinearCS)object);
        }
        if (object instanceof VerticalCS) {
            return DefaultVerticalCS.castOrCopy((VerticalCS)object);
        }
        if (object instanceof TimeCS) {
            return DefaultTimeCS.castOrCopy((TimeCS)object);
        }
        if (object instanceof UserDefinedCS) {
            return DefaultUserDefinedCS.castOrCopy((UserDefinedCS)object);
        }
        if (object == null || object instanceof AbstractCS) {
            return (AbstractCS)object;
        }
        return new AbstractCS(object);
    }

    static AbstractCS createOneDimensional(AbstractCS original, String name, CoordinateSystemAxis[] axes) {
        boolean isTemporal;
        CoordinateSystemAxis axis = axes[0];
        AxisDirection dir = AxisDirections.absolute(axis.getDirection());
        if (dir == AxisDirection.UP) {
            isTemporal = false;
        } else if (dir == AxisDirection.FUTURE) {
            isTemporal = true;
        } else {
            throw AbstractCS.unexpectedDimension(axes, 2, 3);
        }
        Map<String, ?> properties = original.getPropertiesWithoutIdentifiers(name);
        if (isTemporal) {
            return new DefaultTimeCS(properties, axis);
        }
        return new DefaultVerticalCS(properties, axis);
    }
}

