/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.meter;

import java.util.function.Supplier;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.meter.AbstractBuilder;
import org.apache.skywalking.apm.agent.core.meter.BaseMeter;
import org.apache.skywalking.apm.agent.core.meter.MeterId;
import org.apache.skywalking.apm.agent.core.meter.MeterType;
import org.apache.skywalking.apm.network.language.agent.v3.MeterData;
import org.apache.skywalking.apm.network.language.agent.v3.MeterSingleValue;

public class Gauge
extends BaseMeter {
    private static final ILog LOGGER = LogManager.getLogger(Gauge.class);
    protected Supplier<Double> getter;

    public Gauge(MeterId meterId, Supplier<Double> getter) {
        super(meterId);
        this.getter = getter;
    }

    public double get() {
        Double data = this.getter.get();
        return data == null ? 0.0 : data;
    }

    @Override
    public MeterData.Builder transform() {
        double count;
        try {
            count = this.get();
        }
        catch (Exception e) {
            LOGGER.warn(e, "Cannot get the count in meter:{}", this.meterId.getName());
            return null;
        }
        MeterData.Builder builder = MeterData.newBuilder();
        builder.setSingleValue(MeterSingleValue.newBuilder().setName(this.getName()).addAllLabels(this.transformTags()).setValue(count).build());
        return builder;
    }

    public static class Builder
    extends AbstractBuilder<Builder, Gauge> {
        private final Supplier<Double> getter;

        public Builder(String name, Supplier<Double> getter) {
            super(name);
            this.getter = getter;
        }

        @Override
        protected MeterType getType() {
            return MeterType.GAUGE;
        }

        @Override
        protected Gauge create(MeterId meterId) {
            if (this.getter == null) {
                throw new IllegalArgumentException("getter cannot be null");
            }
            return new Gauge(meterId, this.getter);
        }
    }
}

