/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.xmlrules;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.digester3.Rule;
import org.apache.commons.digester3.binder.RulesBinder;
import org.apache.commons.digester3.binder.RulesModule;
import org.apache.commons.digester3.xmlrules.FromXmlRulesModule;
import org.apache.commons.digester3.xmlrules.PrefixedRulesBinder;
import org.apache.commons.digester3.xmlrules.WithMemoryRulesBinder;
import org.xml.sax.Attributes;

final class IncludeRule
extends Rule {
    private static final String CLASSPATH_URL_PREFIX = "classpath:";
    private final WithMemoryRulesBinder memoryRulesBinder;
    private final RulesBinder targetRulesBinder;

    public IncludeRule(WithMemoryRulesBinder memoryRulesBinder, RulesBinder targetRulesBinder) {
        this.memoryRulesBinder = memoryRulesBinder;
        this.targetRulesBinder = targetRulesBinder;
    }

    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        String className;
        String fileName = attributes.getValue("url");
        if (fileName != null && fileName.length() > 0) {
            URL xmlRulesResource;
            if (fileName.startsWith(CLASSPATH_URL_PREFIX)) {
                String path = fileName.substring(CLASSPATH_URL_PREFIX.length());
                if ('/' == path.charAt(0)) {
                    path = path.substring(1);
                }
                if ((xmlRulesResource = this.targetRulesBinder.getContextClassLoader().getResource(path)) == null) {
                    this.targetRulesBinder.addError("Resource '%s' not found, please make sure it is in the classpath", path);
                    return;
                }
            } else {
                try {
                    xmlRulesResource = new URL(fileName);
                }
                catch (MalformedURLException e) {
                    this.targetRulesBinder.addError("An error occurred while inculing file from '%s': %s", fileName, e.getMessage());
                    return;
                }
            }
            if (this.memoryRulesBinder.getIncludedFiles().add(xmlRulesResource.toString())) {
                this.install(new FromXmlRulesModule(){

                    protected void loadRules() {
                        this.loadXMLRules(xmlRulesResource);
                    }
                });
            } else {
                this.targetRulesBinder.addError("Circular file inclusion detected for XML rules: %s", xmlRulesResource);
            }
        }
        if ((className = attributes.getValue("class")) != null && className.length() > 0) {
            try {
                Class<?> cls = Class.forName(className);
                if (!RulesModule.class.isAssignableFrom(cls)) {
                    this.targetRulesBinder.addError("Class '%s' if not a '%s' implementation", className, RulesModule.class.getName());
                    return;
                }
                RulesModule rulesSource = (RulesModule)cls.newInstance();
                this.install(rulesSource);
            }
            catch (Exception e) {
                this.targetRulesBinder.addError("Impossible to include programmatic rules from class '%s': %s", className, e.getMessage());
            }
        }
    }

    private void install(RulesModule rulesModule) {
        rulesModule.configure(new PrefixedRulesBinder(this.targetRulesBinder, this.memoryRulesBinder.getPatternStack().toString()));
    }
}

