/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.items;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemCompiler;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardItemData
implements Serializable,
ItemData,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ITEMS = "items";
    public static final String PROPERTY_DATASET = "dataset";
    private List<Item> itemsList = new ArrayList<Item>();
    private JRElementDataset dataset;
    private transient JRPropertyChangeSupport eventSupport;

    public StandardItemData() {
    }

    public StandardItemData(ItemData data, JRBaseObjectFactory factory) {
        this.itemsList = StandardItemData.getCompiledItems(data.getItems(), factory);
        this.dataset = factory.getElementDataset(data.getDataset());
    }

    private static List<Item> getCompiledItems(List<Item> items, JRBaseObjectFactory factory) {
        if (items == null) {
            return null;
        }
        ArrayList<Item> compiledItems = new ArrayList<Item>(items.size());
        for (Item item : items) {
            StandardItem compiledItem = new StandardItem(StandardItemData.getCompiledProperties(item.getProperties(), factory));
            compiledItems.add(compiledItem);
        }
        return compiledItems;
    }

    public static List<ItemProperty> getCompiledProperties(List<ItemProperty> properties, JRBaseObjectFactory factory) {
        if (properties == null) {
            return null;
        }
        ArrayList<ItemProperty> compiledProperties = new ArrayList<ItemProperty>(properties.size());
        for (ItemProperty property : properties) {
            StandardItemProperty compiledProperty = new StandardItemProperty(property.getName(), property.getValue(), factory.getExpression(property.getValueExpression()));
            compiledProperties.add(compiledProperty);
        }
        return compiledProperties;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        ItemCompiler.collectExpressions(this, collector);
    }

    @Override
    public List<Item> getItems() {
        return this.itemsList;
    }

    public void addItem(Item item) {
        this.itemsList.add(item);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_ITEMS, item, this.itemsList.size() - 1);
    }

    public void addItem(int index, Item item) {
        if (index >= 0 && index < this.itemsList.size()) {
            this.itemsList.add(index, item);
        } else {
            this.itemsList.add(item);
            index = this.itemsList.size() - 1;
        }
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_ITEMS, this.itemsList, index);
    }

    public Item removeItem(Item item) {
        int idx;
        if (item != null && (idx = this.itemsList.indexOf(item)) >= 0) {
            this.itemsList.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_ITEMS, item, idx);
        }
        return item;
    }

    @Override
    public JRElementDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRElementDataset dataset) {
        JRElementDataset old = this.dataset;
        this.dataset = dataset;
        this.getEventSupport().firePropertyChange(PROPERTY_DATASET, old, this.dataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        StandardItemData standardItemData = this;
        synchronized (standardItemData) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public Object clone() {
        StandardItemData clone = null;
        try {
            clone = (StandardItemData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        clone.dataset = JRCloneUtils.nullSafeClone(this.dataset);
        clone.itemsList = JRCloneUtils.cloneList(this.itemsList);
        clone.eventSupport = null;
        return clone;
    }
}

