/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class BinaryScalar
extends Lop {
    private final OperationTypes operation;

    public BinaryScalar(Lop input1, Lop input2, OperationTypes op, Expression.DataType dt, Expression.ValueType vt) {
        super(Lop.Type.BinaryCP, dt, vt);
        this.operation = op;
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        this.lps.addCompatibility(JobType.INVALID);
        this.lps.setProperties(this.inputs, LopProperties.ExecType.CP, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
    }

    @Override
    public String toString() {
        return "Operation: " + (Object)((Object)this.operation);
    }

    public OperationTypes getOperationType() {
        return this.operation;
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(BinaryScalar.getOpcode(this.operation));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public Lop.SimpleInstType getSimpleInstructionType() {
        return Lop.SimpleInstType.Scalar;
    }

    public static String getOpcode(OperationTypes op) {
        if (op == null) {
            throw new UnsupportedOperationException("Unable to get opcode for 'null'.");
        }
        switch (op) {
            case ADD: {
                return "+";
            }
            case SUBTRACT: {
                return "-";
            }
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case MODULUS: {
                return "%%";
            }
            case INTDIV: {
                return "%/%";
            }
            case POW: {
                return "^";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_THAN_OR_EQUALS: {
                return "<=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_THAN_OR_EQUALS: {
                return ">=";
            }
            case EQUALS: {
                return "==";
            }
            case NOT_EQUALS: {
                return "!=";
            }
            case AND: {
                return "&&";
            }
            case OR: {
                return "||";
            }
            case XOR: {
                return "xor";
            }
            case BW_AND: {
                return "bitwAnd";
            }
            case BW_OR: {
                return "bitwOr";
            }
            case BW_XOR: {
                return "bitwXor";
            }
            case BW_SHIFTL: {
                return "bitwShiftL";
            }
            case BW_SHIFTR: {
                return "bitwShiftR";
            }
            case LOG: {
                return "log";
            }
            case MIN: {
                return "min";
            }
            case MAX: {
                return "max";
            }
            case PRINT: {
                return "print";
            }
            case IQSIZE: {
                return "iqsize";
            }
        }
        throw new UnsupportedOperationException("Instruction is not defined for BinaryScalar operator: " + (Object)((Object)op));
    }

    public static enum OperationTypes {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MODULUS,
        INTDIV,
        LESS_THAN,
        LESS_THAN_OR_EQUALS,
        GREATER_THAN,
        GREATER_THAN_OR_EQUALS,
        EQUALS,
        NOT_EQUALS,
        AND,
        OR,
        XOR,
        LOG,
        POW,
        MAX,
        MIN,
        PRINT,
        IQSIZE,
        BW_AND,
        BW_OR,
        BW_XOR,
        BW_SHIFTL,
        BW_SHIFTR;

    }
}

