/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.api;

import java.util.List;
import java.util.Set;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.api.mlcontext.ScriptExecutor;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.conf.DMLConfig;
import org.apache.sysds.hops.codegen.SpoofCompiler;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.gpu.context.GPUContext;
import org.apache.sysds.runtime.instructions.gpu.context.GPUContextPool;
import org.apache.sysds.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysds.utils.Statistics;

public class ScriptExecutorUtils {
    public static void executeRuntimeProgram(ScriptExecutor se, int statisticsMaxHeavyHitters) {
        Program prog = se.getRuntimeProgram();
        ExecutionContext ec = se.getExecutionContext();
        DMLConfig config = se.getConfig();
        ScriptExecutorUtils.executeRuntimeProgram(prog, ec, config, statisticsMaxHeavyHitters, se.getScript().getOutputVariables());
    }

    public static void executeRuntimeProgram(Program rtprog, ExecutionContext ec, DMLConfig dmlconf, int statisticsMaxHeavyHitters, Set<String> outputVariables) {
        block16: {
            block17: {
                Statistics.startRunTimer();
                try {
                    if (DMLScript.USE_ACCELERATOR && ec != null) {
                        List<GPUContext> gCtxs = GPUContextPool.reserveAllGPUContexts();
                        if (gCtxs == null) {
                            throw new DMLRuntimeException("GPU : Could not create GPUContext, either no GPU or all GPUs currently in use");
                        }
                        gCtxs.get(0).initializeThread();
                        ec.setGPUContexts(gCtxs);
                    }
                    rtprog.execute(ec);
                    if (!DMLScript.USE_ACCELERATOR || ec.getGPUContexts().isEmpty()) break block16;
                    if (outputVariables == null) break block17;
                }
                catch (Throwable e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (DMLScript.USE_ACCELERATOR && !ec.getGPUContexts().isEmpty()) {
                            if (outputVariables != null) {
                                for (String outVar : outputVariables) {
                                    Data data = ec.getVariable(outVar);
                                    if (data == null || !(data instanceof MatrixObject)) continue;
                                    for (GPUContext gCtx : ec.getGPUContexts()) {
                                        GPUObject gpuObj = ((MatrixObject)data).getGPUObject(gCtx);
                                        if (gpuObj == null || !gpuObj.isDirty()) continue;
                                        gpuObj.acquireHostRead(null);
                                    }
                                }
                            }
                            for (GPUContext gCtx : ec.getGPUContexts()) {
                                gCtx.clearTemporaryMemory();
                            }
                            GPUContextPool.freeAllGPUContexts();
                        }
                        if (ConfigurationManager.isCodegenEnabled()) {
                            SpoofCompiler.cleanupCodeGenerator();
                        }
                        Statistics.stopRunTimer();
                        System.out.println(Statistics.display(statisticsMaxHeavyHitters > 0 ? statisticsMaxHeavyHitters : DMLScript.STATISTICS_COUNT));
                        throw throwable;
                    }
                }
                for (String outVar : outputVariables) {
                    Data data = ec.getVariable(outVar);
                    if (data == null || !(data instanceof MatrixObject)) continue;
                    for (GPUContext gCtx : ec.getGPUContexts()) {
                        GPUObject gpuObj = ((MatrixObject)data).getGPUObject(gCtx);
                        if (gpuObj == null || !gpuObj.isDirty()) continue;
                        gpuObj.acquireHostRead(null);
                    }
                }
            }
            for (GPUContext gCtx : ec.getGPUContexts()) {
                gCtx.clearTemporaryMemory();
            }
            GPUContextPool.freeAllGPUContexts();
        }
        if (ConfigurationManager.isCodegenEnabled()) {
            SpoofCompiler.cleanupCodeGenerator();
        }
        Statistics.stopRunTimer();
        System.out.println(Statistics.display(statisticsMaxHeavyHitters > 0 ? statisticsMaxHeavyHitters : DMLScript.STATISTICS_COUNT));
    }
}

