/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.lops.MapMultChain;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.AbstractCompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.compress.colgroup.ColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConverter;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupIO;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupValue;
import org.apache.sysds.runtime.compress.colgroup.DenseRowIterator;
import org.apache.sysds.runtime.compress.colgroup.SparseRowIterator;
import org.apache.sysds.runtime.compress.utils.ColumnGroupIterator;
import org.apache.sysds.runtime.compress.utils.LinearAlgebraUtils;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.KahanFunction;
import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.functionobjects.KahanPlusSq;
import org.apache.sysds.runtime.functionobjects.Mean;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.ReduceAll;
import org.apache.sysds.runtime.functionobjects.ReduceCol;
import org.apache.sysds.runtime.functionobjects.ReduceRow;
import org.apache.sysds.runtime.instructions.cp.KahanObject;
import org.apache.sysds.runtime.matrix.data.IJV;
import org.apache.sysds.runtime.matrix.data.LibMatrixBincell;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.MatrixValue;
import org.apache.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.LeftScalarOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class CompressedMatrixBlock
extends AbstractCompressedMatrixBlock {
    private static final Log LOG = LogFactory.getLog((String)CompressedMatrixBlock.class.getName());
    private static final long serialVersionUID = 7319372019143154058L;
    private static final long MIN_PAR_AGG_THRESHOLD = 0x800000L;

    public CompressedMatrixBlock() {
    }

    protected CompressedMatrixBlock(int rl, int cl, boolean sparse) {
        super(rl, cl, sparse);
    }

    protected CompressedMatrixBlock(MatrixBlock that) {
        super(that.getNumRows(), that.getNumColumns(), that.isInSparseFormat());
        if (this.isInSparseFormat()) {
            this.sparseBlock = that.getSparseBlock();
        } else {
            this.denseBlock = that.getDenseBlock();
        }
        this.nonZeros = that.getNonZeros();
    }

    public boolean isSingleUncompressedGroup() {
        return this._colGroups != null && this._colGroups.size() == 1 && ((ColGroup)this._colGroups.get(0)).getCompType() == ColGroup.CompressionType.UNCOMPRESSED;
    }

    public void allocateColGroupList(List<ColGroup> colGroups) {
        this._colGroups = colGroups;
    }

    public List<ColGroup> getColGroups() {
        return this._colGroups;
    }

    @Override
    public MatrixBlock decompress() {
        Timing time = new Timing(true);
        MatrixBlock ret = new MatrixBlock(this.getNumRows(), this.getNumColumns(), this.isInSparseFormat(), this.getNonZeros());
        if (ret.isInSparseFormat()) {
            int[] rnnz = new int[this.rlen];
            for (ColGroup grp : this._colGroups) {
                grp.countNonZerosPerRow(rnnz, 0, this.rlen);
            }
            ret.allocateSparseRowsBlock();
            SparseBlock rows = ret.getSparseBlock();
            for (int i = 0; i < this.rlen; ++i) {
                rows.allocate(i, rnnz[i]);
            }
        }
        for (ColGroup grp : this._colGroups) {
            grp.decompressToBlock(ret, 0, this.rlen);
        }
        ret.setNonZeros(this.nonZeros);
        if (ret.isInSparseFormat()) {
            ret.sortSparseRows();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("decompressed block in " + time.stop() + "ms."));
        }
        return ret;
    }

    public MatrixBlock decompress(int k) {
        if (k <= 1) {
            return this.decompress();
        }
        Timing time = new Timing(true);
        MatrixBlock ret = new MatrixBlock(this.rlen, this.clen, this.sparse, this.nonZeros).allocateBlock();
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            int rlen = this.getNumRows();
            int blklen = CompressedMatrixBlock.getAlignedBlockSize((int)Math.ceil((double)rlen / (double)k));
            ArrayList<DecompressTask> tasks = new ArrayList<DecompressTask>();
            int i = 0;
            while (i < k & i * blklen < this.getNumRows()) {
                tasks.add(new DecompressTask(this._colGroups, ret, i * blklen, Math.min((i + 1) * blklen, rlen)));
                ++i;
            }
            List rtasks = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future rt : rtasks) {
                rt.get();
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.error((Object)("Parallel decompression failed defaulting to non parallel implementation " + ex.getMessage()));
            return this.decompress();
        }
        ret.setNonZeros(this.nonZeros);
        LOG.debug((Object)("decompressed block w/ k=" + k + " in " + time.stop() + "ms."));
        return ret;
    }

    public long estimateCompressedSizeInMemory() {
        long total = CompressedMatrixBlock.baseSizeInMemory();
        for (ColGroup grp : this._colGroups) {
            total += grp.estimateInMemorySize();
        }
        return total;
    }

    public static long baseSizeInMemory() {
        long total = 16L;
        total += 40L;
        total += 8L;
        total += 8L;
        return total += 40L;
    }

    @Override
    public double quickGetValue(int r, int c) {
        ColGroup grp = null;
        for (ColGroup group : this._colGroups) {
            if (Arrays.binarySearch(group.getColIndices(), c) < 0) continue;
            grp = group;
            break;
        }
        return grp.get(r, c);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = 20L;
        for (ColGroup grp : this._colGroups) {
            ++ret;
            ret += grp.getExactSizeOnDisk();
        }
        return ret;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.rlen = in.readInt();
        this.clen = in.readInt();
        this.nonZeros = in.readLong();
        this._colGroups = ColGroupIO.readGroups(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.rlen);
        out.writeInt(this.clen);
        out.writeLong(this.nonZeros);
        ColGroupIO.writeGroups(out, this._colGroups);
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException {
        this.readFields(is);
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        this.write(os);
    }

    public Iterator<IJV> getIterator(int rl, int ru, boolean inclZeros) {
        return this.getIterator(rl, ru, 0, this._colGroups.size(), inclZeros);
    }

    public Iterator<IJV> getIterator(int rl, int ru, int cgl, int cgu, boolean inclZeros) {
        return new ColumnGroupIterator(rl, ru, cgl, cgu, inclZeros, this._colGroups);
    }

    public Iterator<double[]> getDenseRowIterator(int rl, int ru) {
        return new DenseRowIterator(rl, ru, this._colGroups, this.clen);
    }

    public Iterator<SparseRow> getSparseRowIterator(int rl, int ru) {
        return new SparseRowIterator(rl, ru, this._colGroups, this.clen);
    }

    public int[] countNonZerosPerRow(int rl, int ru) {
        int[] rnnz = new int[ru - rl];
        for (ColGroup grp : this._colGroups) {
            grp.countNonZerosPerRow(rnnz, rl, ru);
        }
        return rnnz;
    }

    @Override
    public MatrixBlock scalarOperations(ScalarOperator sop, MatrixValue result) {
        CompressedMatrixBlock ret = null;
        if (result == null || !(result instanceof CompressedMatrixBlock)) {
            ret = new CompressedMatrixBlock(this.getNumRows(), this.getNumColumns(), this.sparse);
        } else {
            ret = (CompressedMatrixBlock)result;
            ret.reset(this.rlen, this.clen);
        }
        int threads = OptimizerUtils.getConstrainedNumThreads(this._colGroups.size());
        if (threads > 1) {
            ExecutorService pool = CommonThreadPool.get(sop.getNumThreads());
            ArrayList<ScalarTask> tasks = new ArrayList<ScalarTask>();
            ArrayList<ColGroup> small = new ArrayList<ColGroup>();
            for (ColGroup grp : this._colGroups) {
                if (grp instanceof ColGroupUncompressed) {
                    ArrayList<ColGroup> uc = new ArrayList<ColGroup>();
                    uc.add(grp);
                    tasks.add(new ScalarTask(uc, sop));
                } else {
                    int nv = ((ColGroupValue)grp).getNumValues();
                    if (nv < 256) {
                        small.add(grp);
                    } else {
                        ArrayList<ColGroup> large = new ArrayList<ColGroup>();
                        large.add(grp);
                        tasks.add(new ScalarTask(large, sop));
                    }
                }
                if (small.size() <= 10) continue;
                tasks.add(new ScalarTask(small, sop));
                small = new ArrayList();
            }
            if (small.size() > 0) {
                tasks.add(new ScalarTask(small, sop));
            }
            try {
                List rtasks = pool.invokeAll(tasks);
                pool.shutdown();
                ArrayList<ColGroup> newColGroups = new ArrayList<ColGroup>();
                for (Future f : rtasks) {
                    for (ColGroup x : (List)f.get()) {
                        newColGroups.add(x);
                    }
                }
                ret._colGroups = newColGroups;
                ret.setNonZeros(this.rlen * this.clen);
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.fatal((Object)("UnaryAggregate Exception: " + e.getMessage()), (Throwable)e);
                throw new DMLRuntimeException(e);
            }
        } else {
            ArrayList<ColGroup> newColGroups = new ArrayList<ColGroup>();
            for (ColGroup grp : this._colGroups) {
                newColGroups.add(grp.scalarOperation(sop));
            }
            ret._colGroups = newColGroups;
            ret.setNonZeros(this.rlen * this.clen);
        }
        return ret;
    }

    @Override
    protected void binaryMV(MatrixBlock m2, CompressedMatrixBlock ret, BinaryOperator op, LibMatrixBincell.BinaryAccessType aType) {
        if (aType == LibMatrixBincell.BinaryAccessType.MATRIX_COL_VECTOR) {
            throw new NotImplementedException("Binary Matrix Col Vector operations are not implemented CLA");
        }
        if (aType == LibMatrixBincell.BinaryAccessType.MATRIX_ROW_VECTOR) {
            ArrayList<ColGroup> newColGroups = new ArrayList<ColGroup>();
            for (ColGroup grp : this._colGroups) {
                if (grp instanceof ColGroupUncompressed) {
                    LOG.error((Object)"NOT HANDLING UNCOMPRESSED IN BINARY MV");
                    continue;
                }
                if (grp.getNumCols() == 1) {
                    LeftScalarOperator sop = new LeftScalarOperator(op.fn, m2.getValue(0, grp.getColIndices()[0]), 1);
                    newColGroups.add(grp.scalarOperation(sop));
                    continue;
                }
                throw new NotImplementedException("Cocoded columns (nr cols:" + grp.getNumCols() + ") groupType: not implemented for Binary Matrix Row Vector operations");
            }
            ret._colGroups = newColGroups;
        }
    }

    @Override
    protected void binaryVV(MatrixBlock m2, CompressedMatrixBlock ret, BinaryOperator op, LibMatrixBincell.BinaryAccessType aType) {
        throw new NotImplementedException("Binary Vector Vector operations are not implemented");
    }

    @Override
    protected void binaryMM(MatrixBlock m2, CompressedMatrixBlock ret, BinaryOperator op) {
        throw new NotImplementedException("Binary Matrix Matrix operations are not implemented");
    }

    @Override
    public MatrixBlock append(MatrixBlock that, MatrixBlock ret) {
        int m = this.rlen;
        int n = this.clen + that.getNumColumns();
        long nnz = this.nonZeros + that.getNonZeros();
        CompressedMatrixBlock ret2 = null;
        if (ret == null || !(ret instanceof CompressedMatrixBlock)) {
            ret2 = new CompressedMatrixBlock(m, n, this.isInSparseFormat());
        } else {
            ret2 = (CompressedMatrixBlock)ret;
            ret2.reset(m, n);
        }
        ret2.allocateColGroupList(new ArrayList<ColGroup>());
        ret2._colGroups.addAll(this._colGroups);
        if (!(that instanceof CompressedMatrixBlock)) {
            that = (MatrixBlock)CompressedMatrixBlockFactory.compress(that).getLeft();
        }
        List inColGroups = ((CompressedMatrixBlock)that)._colGroups;
        for (ColGroup group : inColGroups) {
            ColGroup tmp = ColGroupConverter.copyColGroup(group);
            tmp.shiftColIndices(this.clen);
            ret2._colGroups.add(tmp);
        }
        ret2.setNonZeros(nnz);
        return ret2;
    }

    @Override
    public MatrixBlock chainMatrixMultOperations(MatrixBlock v, MatrixBlock w, MatrixBlock out, MapMultChain.ChainType ctype) {
        if (this.getNumColumns() != v.getNumRows()) {
            throw new DMLRuntimeException("Dimensions mismatch on mmchain operation (" + this.getNumColumns() + " != " + v.getNumRows() + ")");
        }
        if (v.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid input vector (column vector expected, but ncol=" + v.getNumColumns() + ")");
        }
        if (w != null && w.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid weight vector (column vector expected, but ncol=" + w.getNumColumns() + ")");
        }
        if (this.isSingleUncompressedGroup()) {
            return ((ColGroupUncompressed)this._colGroups.get(0)).getData().chainMatrixMultOperations(v, w, out, ctype);
        }
        if (out != null) {
            out.reset(this.clen, 1, false);
        } else {
            out = new MatrixBlock(this.clen, 1, false);
        }
        if (this.isEmptyBlock(false)) {
            return out;
        }
        MatrixBlock tmp = new MatrixBlock(this.rlen, 1, false);
        this.rightMultByVector(v, tmp);
        if (ctype == MapMultChain.ChainType.XtwXv) {
            BinaryOperator bop = new BinaryOperator(Multiply.getMultiplyFnObject());
            LibMatrixBincell.bincellOpInPlace(tmp, w, bop);
        }
        CompressedMatrixBlock.leftMultByVectorTranspose(this._colGroups, tmp, out, true, true);
        return out;
    }

    @Override
    public MatrixBlock chainMatrixMultOperations(MatrixBlock v, MatrixBlock w, MatrixBlock out, MapMultChain.ChainType ctype, int k) {
        if (this.getNumColumns() != v.getNumRows()) {
            throw new DMLRuntimeException("Dimensions mismatch on mmchain operation (" + this.getNumColumns() + " != " + v.getNumRows() + ")");
        }
        if (v.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid input vector (column vector expected, but ncol=" + v.getNumColumns() + ")");
        }
        if (w != null && w.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid weight vector (column vector expected, but ncol=" + w.getNumColumns() + ")");
        }
        if (this.isSingleUncompressedGroup()) {
            return ((ColGroupUncompressed)this._colGroups.get(0)).getData().chainMatrixMultOperations(v, w, out, ctype, k);
        }
        if (out != null) {
            out.reset(this.clen, 1, false);
        } else {
            out = new MatrixBlock(this.clen, 1, false);
        }
        if (this.isEmptyBlock(false)) {
            return out;
        }
        MatrixBlock tmp = new MatrixBlock(this.rlen, 1, false);
        this.rightMultByVector(v, tmp, k);
        if (ctype == MapMultChain.ChainType.XtwXv) {
            BinaryOperator bop = new BinaryOperator(Multiply.getMultiplyFnObject());
            LibMatrixBincell.bincellOpInPlace(tmp, w, bop);
        }
        this.leftMultByVectorTranspose(this._colGroups, tmp, out, true, k);
        return out;
    }

    @Override
    public MatrixBlock aggregateBinaryOperations(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, AggregateBinaryOperator op) {
        MatrixBlock that;
        boolean right = m1 == this;
        MatrixBlock matrixBlock = that = right ? m2 : m1;
        if (!right && m2 != this) {
            throw new DMLRuntimeException("Invalid inputs for aggregate Binary Operation which expect either m1 or m2 to be equal to the object calling");
        }
        int rl = m1.getNumRows();
        int cl = m2.getNumColumns();
        if (ret == null) {
            ret = new MatrixBlock(rl, cl, false, rl * cl);
        } else {
            ret.reset(rl, cl, false, rl * cl);
        }
        if (right) {
            if (that.getNumColumns() == 1) {
                if (op.getNumThreads() > 1) {
                    this.rightMultByVector(that, ret, op.getNumThreads());
                } else {
                    this.rightMultByVector(that, ret);
                }
            } else {
                that = that instanceof CompressedMatrixBlock ? ((CompressedMatrixBlock)that).decompress() : that;
                ret = CompressedMatrixBlock.rightMultByMatrix(this._colGroups, that, ret, op.getNumThreads(), this.getNumColumns());
            }
        } else {
            MatrixBlock matrixBlock2 = that = that instanceof CompressedMatrixBlock ? ((CompressedMatrixBlock)that).decompress() : that;
            if (that.getNumRows() == 1) {
                if (op.getNumThreads() > 1) {
                    this.leftMultByVectorTranspose(this._colGroups, that, ret, false, op.getNumThreads());
                } else {
                    CompressedMatrixBlock.leftMultByVectorTranspose(this._colGroups, that, ret, false, true);
                }
            } else {
                CompressedMatrixBlock.leftMultByMatrix(this._colGroups, that, ret, op.getNumThreads(), 1);
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public MatrixBlock aggregateUnaryOperations(AggregateUnaryOperator op, MatrixValue result, int blen, MatrixIndexes indexesIn, boolean inCP) {
        if (!(op.aggOp.increOp.fn instanceof KahanPlus || op.aggOp.increOp.fn instanceof KahanPlusSq || op.aggOp.increOp.fn instanceof Mean || op.aggOp.increOp.fn instanceof Builtin && (((Builtin)op.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MIN || ((Builtin)op.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MAX))) {
            throw new NotImplementedException("Unary aggregate " + op.aggOp.increOp.fn + " not supported yet.");
        }
        tempCellIndex = new MatrixValue.CellIndex(-1, -1);
        op.indexFn.computeDimension(this.rlen, this.clen, tempCellIndex);
        if (op.aggOp.existsCorrection()) {
            switch (1.$SwitchMap$org$apache$sysds$common$Types$CorrectionLocationType[op.aggOp.correction.ordinal()]) {
                case 1: {
                    ++tempCellIndex.row;
                    break;
                }
                case 2: {
                    ++tempCellIndex.column;
                    break;
                }
                case 3: {
                    tempCellIndex.row += 2;
                    break;
                }
                case 4: {
                    tempCellIndex.column += 2;
                    break;
                }
                default: {
                    throw new DMLRuntimeException("unrecognized correctionLocation: " + (Object)op.aggOp.correction);
                }
            }
        }
        if (result == null) {
            result = new MatrixBlock(tempCellIndex.row, tempCellIndex.column, false);
        } else {
            result.reset(tempCellIndex.row, tempCellIndex.column, false);
        }
        ret = (MatrixBlock)result;
        ret.allocateDenseBlock();
        if (op.aggOp.increOp.fn instanceof Builtin) {
            val = null;
            switch (1.$SwitchMap$org$apache$sysds$runtime$functionobjects$Builtin$BuiltinCode[((Builtin)op.aggOp.increOp.fn).getBuiltinCode().ordinal()]) {
                case 1: {
                    val = -Infinity;
                    break;
                }
                case 2: {
                    val = Infinity;
                    break;
                }
            }
            if (val != null) {
                ret.getDenseBlock().set(val);
            }
        }
        if (op.getNumThreads() > 1 && this.getExactSizeOnDisk() > 0x800000L) {
            grpParts = CompressedMatrixBlock.createStaticTaskPartitioning(this._colGroups, op.indexFn instanceof ReduceCol != false ? 1 : op.getNumThreads(), false);
            uc = this.getUncompressedColGroup();
            try {
                if (uc != null) {
                    uc.unaryAggregateOperations(op, ret);
                }
                pool = CommonThreadPool.get(op.getNumThreads());
                tasks = new ArrayList<UnaryAggregateTask>();
                if (op.indexFn instanceof ReduceCol && grpParts.length > 0) {
                    blklen = CompressedMatrixBlock.getAlignedBlockSize((int)Math.ceil((double)this.rlen / (double)op.getNumThreads()));
                    i = 0;
                    while (i < op.getNumThreads() & i * blklen < this.rlen) {
                        tasks.add(new UnaryAggregateTask(grpParts[0], ret, i * blklen, Math.min((i + 1) * blklen, this.rlen), op));
                        ++i;
                    }
                } else {
                    for (ArrayList<ColGroup> grp : grpParts) {
                        tasks.add(new UnaryAggregateTask(grp, ret, 0, this.rlen, op));
                    }
                }
                rtasks = pool.invokeAll(tasks);
                pool.shutdown();
                if (!(op.indexFn instanceof ReduceAll)) ** GOTO lbl88
                if (op.aggOp.increOp.fn instanceof KahanFunction) {
                    kbuff = new KahanObject(ret.quickGetValue(0, 0), 0.0);
                    for (Future<T> rtask : rtasks) {
                        tmp = ((MatrixBlock)rtask.get()).quickGetValue(0, 0);
                        ((KahanFunction)op.aggOp.increOp.fn).execute2(kbuff, tmp);
                    }
                    ret.quickSetValue(0, 0, kbuff._sum);
                }
                val = ret.quickGetValue(0, 0);
                for (Future<T> rtask : rtasks) {
                    tmp = ((MatrixBlock)rtask.get()).quickGetValue(0, 0);
                    val = op.aggOp.increOp.fn.execute(val, tmp);
                }
                ret.quickSetValue(0, 0, val);
            }
            catch (InterruptedException | ExecutionException e) {
                CompressedMatrixBlock.LOG.fatal((Object)("UnaryAggregate Exception: " + e.getMessage()), (Throwable)e);
                throw new DMLRuntimeException(e);
            }
        } else {
            for (Object grp : this._colGroups) {
                if (!(grp instanceof ColGroupUncompressed)) continue;
                ((ColGroupUncompressed)grp).unaryAggregateOperations(op, ret);
            }
            CompressedMatrixBlock.aggregateUnaryOperations(op, this._colGroups, ret, 0, this.rlen);
        }
lbl88:
        // 4 sources

        if (op.indexFn instanceof ReduceCol && op.aggOp.increOp.fn instanceof Builtin) {
            rnnz = new int[this.rlen];
            for (ColGroup grp : this._colGroups) {
                grp.countNonZerosPerRow(rnnz, 0, this.rlen);
            }
            builtin = (Builtin)op.aggOp.increOp.fn;
            for (i = 0; i < this.rlen; ++i) {
                if (rnnz[i] >= this.clen) continue;
                ret.quickSetValue(i, 0, builtin.execute(ret.quickGetValue(i, 0), 0.0));
            }
        }
        if (op.aggOp.increOp.fn instanceof Mean) {
            if (op.indexFn instanceof ReduceAll) {
                ret.quickSetValue(0, 0, ret.quickGetValue(0, 0) / (double)(this.getNumColumns() * this.getNumRows()));
            } else if (op.indexFn instanceof ReduceCol) {
                for (i = 0; i < this.getNumRows(); ++i) {
                    ret.quickSetValue(i, 0, ret.quickGetValue(i, 0) / (double)this.getNumColumns());
                }
            } else if (op.indexFn instanceof ReduceRow) {
                for (i = 0; i < this.getNumColumns(); ++i) {
                    ret.quickSetValue(0, i, ret.quickGetValue(0, i) / (double)this.getNumRows());
                }
            }
        }
        if (op.aggOp.existsCorrection() && inCP) {
            ret.dropLastRowsOrColumns(op.aggOp.correction);
        }
        ret.recomputeNonZeros();
        return ret;
    }

    @Override
    public MatrixBlock aggregateUnaryOperations(AggregateUnaryOperator op, MatrixValue result, int blen, MatrixIndexes indexesIn) {
        return this.aggregateUnaryOperations(op, result, blen, indexesIn, false);
    }

    private static void aggregateUnaryOperations(AggregateUnaryOperator op, List<ColGroup> groups, MatrixBlock ret, int rl, int ru) {
        double[] c = ret.getDenseBlockValues();
        if (c == null) {
            c = ret.getSparseBlock().values(0);
        }
        for (ColGroup grp : groups) {
            if (grp instanceof ColGroupUncompressed) continue;
            grp.unaryAggregateOperations(op, c, rl, ru);
        }
    }

    @Override
    public MatrixBlock transposeSelfMatrixMultOperations(MatrixBlock out, MMTSJ.MMTSJType tstype) {
        Timing time;
        Timing timing = time = LOG.isDebugEnabled() ? new Timing(true) : null;
        if (tstype != MMTSJ.MMTSJType.LEFT) {
            throw new DMLRuntimeException("Invalid MMTSJ type '" + tstype.toString() + "'.");
        }
        if (out == null) {
            out = new MatrixBlock(this.clen, this.clen, false);
        } else {
            out.reset(this.clen, this.clen, false);
        }
        out.allocateDenseBlock();
        if (!this.isEmptyBlock(false)) {
            CompressedMatrixBlock.leftMultByTransposeSelf(this._colGroups, out, 0, this._colGroups.size());
            out.setNonZeros(LinearAlgebraUtils.copyUpperToLowerTriangle(out));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Compressed TSMM in " + time.stop()));
        }
        return out;
    }

    @Override
    public MatrixBlock transposeSelfMatrixMultOperations(MatrixBlock out, MMTSJ.MMTSJType tstype, int k) {
        Timing time;
        if (k <= 1) {
            return this.transposeSelfMatrixMultOperations(out, tstype);
        }
        Timing timing = time = LOG.isDebugEnabled() ? new Timing(true) : null;
        if (tstype != MMTSJ.MMTSJType.LEFT) {
            throw new DMLRuntimeException("Invalid MMTSJ type '" + tstype.toString() + "'.");
        }
        if (out == null) {
            out = new MatrixBlock(this.clen, this.clen, false);
        } else {
            out.reset(this.clen, this.clen, false);
        }
        out.allocateDenseBlock();
        if (!this.isEmptyBlock(false)) {
            try {
                ExecutorService pool = CommonThreadPool.get(k);
                ArrayList<MatrixMultTransposeTask> tasks = new ArrayList<MatrixMultTransposeTask>();
                int numgrp = this._colGroups.size();
                int blklen = (int)Math.ceil((double)numgrp / (double)(2 * k));
                int i = 0;
                while (i < 2 * k & i * blklen < this.clen) {
                    tasks.add(new MatrixMultTransposeTask(this._colGroups, out, i * blklen, Math.min((i + 1) * blklen, numgrp)));
                    ++i;
                }
                List ret = pool.invokeAll(tasks);
                for (Future tret : ret) {
                    tret.get();
                }
                pool.shutdown();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new DMLRuntimeException(e);
            }
            out.setNonZeros(LinearAlgebraUtils.copyUpperToLowerTriangle(out));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Compressed TSMM k=" + k + " in " + time.stop()));
        }
        return out;
    }

    private void rightMultByVector(MatrixBlock vector, MatrixBlock result) {
        result.allocateDenseBlock();
        CompressedMatrixBlock.rightMultByVector(this._colGroups, vector, result, 0, result.getNumRows());
        result.recomputeNonZeros();
    }

    private void rightMultByVector(MatrixBlock vector, MatrixBlock result, int k) {
        result.allocateDenseBlock();
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            int rlen = this.getNumRows();
            int seqsz = 65536;
            int blklen = (int)Math.ceil((double)rlen / (double)k);
            blklen += blklen % seqsz != 0 ? seqsz - blklen % seqsz : 0;
            ArrayList<RightMatrixMultTask> tasks = new ArrayList<RightMatrixMultTask>();
            int i = 0;
            while (i < k & i * blklen < this.getNumRows()) {
                tasks.add(new RightMatrixMultTask(this._colGroups, vector, result, i * blklen, Math.min((i + 1) * blklen, rlen)));
                ++i;
            }
            List ret = pool.invokeAll(tasks);
            pool.shutdown();
            long lnnz = 0L;
            for (Future tmp : ret) {
                lnnz += ((Long)tmp.get()).longValue();
            }
            result.setNonZeros(lnnz);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            throw new DMLRuntimeException(e);
        }
    }

    private static void rightMultByVector(List<ColGroup> groups, MatrixBlock vect, MatrixBlock ret, int rl, int ru) {
        ColGroupValue.setupThreadLocalMemory((Integer)CompressedMatrixBlock.getMaxNumValues(groups).getLeft() + 1);
        for (ColGroup grp : groups) {
            if (!(grp instanceof ColGroupUncompressed)) continue;
            ((ColGroupUncompressed)grp).rightMultByVector(vect, ret, rl, ru);
        }
        double[] values = ret.getDenseBlockValues();
        for (ColGroup grp : groups) {
            if (grp instanceof ColGroupUncompressed) continue;
            grp.rightMultByVector(vect.getDenseBlockValues(), values, rl, ru, grp.getValues());
        }
        ColGroupValue.cleanupThreadLocalMemory();
    }

    private static void leftMultByVectorTranspose(List<ColGroup> colGroups, MatrixBlock vector, MatrixBlock result, boolean doTranspose, boolean allocTmp) {
        LOG.debug((Object)("Left Mult vector Transpose " + vector.getClass()));
        MatrixBlock rowVector = vector;
        if (doTranspose) {
            rowVector = new MatrixBlock(1, vector.getNumRows(), false);
            LibMatrixReorg.transpose(vector, rowVector);
        }
        result.reset();
        result.allocateDenseBlock();
        if (allocTmp) {
            Pair<Integer, List<Integer>> v = CompressedMatrixBlock.getMaxNumValues(colGroups);
            ColGroupValue.setupThreadLocalMemory((Integer)v.getLeft());
            for (int i = 0; i < colGroups.size(); ++i) {
                colGroups.get(i).leftMultByRowVector(rowVector.getDenseBlockValues(), result.getDenseBlockValues(), (Integer)((List)v.getRight()).get(i));
            }
        } else {
            for (ColGroup grp : colGroups) {
                grp.leftMultByRowVector(rowVector.getDenseBlockValues(), result.getDenseBlockValues(), -1);
            }
        }
        if (allocTmp) {
            ColGroupValue.cleanupThreadLocalMemory();
        }
        result.recomputeNonZeros();
    }

    private void leftMultByVectorTranspose(List<ColGroup> colGroups, MatrixBlock vector, MatrixBlock result, boolean doTranspose, int k) {
        MatrixBlock rowVector = vector;
        if (doTranspose) {
            rowVector = new MatrixBlock(1, vector.getNumRows(), false);
            LibMatrixReorg.transpose(vector, rowVector);
        }
        result.reset();
        result.allocateDenseBlock();
        try {
            ExecutorService pool = CommonThreadPool.get(Math.min(colGroups.size(), k));
            ArrayList<ColGroup>[] grpParts = CompressedMatrixBlock.createStaticTaskPartitioning(this._colGroups, 4 * k, true);
            ArrayList<LeftMatrixVectorMultTask> tasks = new ArrayList<LeftMatrixVectorMultTask>();
            for (ArrayList<ColGroup> groups : grpParts) {
                tasks.add(new LeftMatrixVectorMultTask(groups, rowVector, result));
            }
            List ret = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future tmp : ret) {
                tmp.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error((Object)e);
            throw new DMLRuntimeException(e);
        }
        result.recomputeNonZeros();
    }

    private static void leftMultByMatrix(List<ColGroup> colGroups, MatrixBlock that, MatrixBlock ret, int k, int numColumns) {
        ret.reset();
        ret.allocateDenseBlock();
        if (that.isInSparseFormat()) {
            LOG.warn((Object)"Inefficient materialization of sparse matrix for left compressed matrix mult.");
            CompressedMatrixBlock.leftMultByDenseMatrix(colGroups, that.allocateDenseBlock(), ret, k, numColumns);
        } else {
            CompressedMatrixBlock.leftMultByDenseMatrix(colGroups, that, ret, k, numColumns);
        }
        ret.recomputeNonZeros();
    }

    private static MatrixBlock rightMultByMatrix(List<ColGroup> colGroups, MatrixBlock that, MatrixBlock ret, int k, int numColumns) {
        ret.reset();
        ret.allocateDenseBlock();
        that = LibMatrixReorg.transpose(that, new MatrixBlock(that.getNumColumns(), that.getNumRows(), that.isInSparseFormat()), k);
        if (that.isInSparseFormat()) {
            LOG.warn((Object)"Inefficient materialization of sparse matrix for right compressed matrix mult.");
            CompressedMatrixBlock.rightMultByDenseMatrix(colGroups, that.allocateDenseBlock(), ret, k, numColumns);
        } else {
            CompressedMatrixBlock.rightMultByDenseMatrix(colGroups, that, ret, k, numColumns);
        }
        ret.recomputeNonZeros();
        return ret;
    }

    private static void leftMultByDenseMatrix(List<ColGroup> colGroups, MatrixBlock that, MatrixBlock ret, int k, int numColumns) {
        DenseBlock db = that.getDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int blockL = 0;
        for (ColGroup grp : colGroups) {
            if (!(grp instanceof ColGroupUncompressed)) continue;
            ((ColGroupUncompressed)grp).leftMultByMatrix(that, ret);
        }
        for (int b = 0; b <= db.numBlocks(); ++b) {
            int blockSize = db.blockSize(b);
            int blockU = Math.min(blockL + blockSize, ret.getNumRows());
            double[] thatV = db.valuesAt(b);
            if (k == 1) {
                double[][] materialized = new double[colGroups.size()][];
                for (int i = 0; i < colGroups.size(); ++i) {
                    materialized[i] = colGroups.get(i).getValues();
                }
                Pair<Integer, List<Integer>> v = CompressedMatrixBlock.getMaxNumValues(colGroups);
                for (int j = 0; j < colGroups.size(); ++j) {
                    colGroups.get(j).leftMultByMatrix(thatV, retV, (Integer)((List)v.getRight()).get(j), materialized[j], that.getNumRows(), ret.getNumColumns(), blockL, blockU, 0);
                }
            } else {
                try {
                    ExecutorService pool = CommonThreadPool.get(Math.min(colGroups.size(), k));
                    ArrayList<LeftMatrixMatrixMultTask> tasks = new ArrayList<LeftMatrixMatrixMultTask>();
                    List<ColGroup>[] parts = CompressedMatrixBlock.createStaticTaskPartitioningForMatrixMult(colGroups, k, false);
                    int rowBlockSize = 10;
                    for (List<ColGroup> part : parts) {
                        for (int blo = blockL; blo < blockU; blo += rowBlockSize) {
                            tasks.add(new LeftMatrixMatrixMultTask(part, thatV, retV, that.getNumRows(), numColumns, blo, Math.min(blo + rowBlockSize, blockU), blo - blockL));
                        }
                    }
                    List futures = pool.invokeAll(tasks);
                    pool.shutdown();
                    for (Future future : futures) {
                        future.get();
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error((Object)e);
                    throw new DMLRuntimeException(e);
                }
            }
            blockL += blockSize;
        }
    }

    private static void rightMultByDenseMatrix(List<ColGroup> colGroups, MatrixBlock that, MatrixBlock ret, int k, int numColumns) {
        DenseBlock db = that.getDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int blockL = 0;
        for (ColGroup grp : colGroups) {
            if (!(grp instanceof ColGroupUncompressed)) continue;
            ((ColGroupUncompressed)grp).rightMultByMatrix(that, ret, 0, ret.getNumRows());
        }
        double[][] materialized = new double[colGroups.size()][];
        for (int b = 0; b <= db.numBlocks(); ++b) {
            int blockSize = db.blockSize(b);
            int blockU = Math.min(blockL + blockSize, ret.getNumRows());
            double[] thatV = db.valuesAt(b);
            for (int i = 0; i < colGroups.size(); ++i) {
                materialized[i] = colGroups.get(i).getValues();
            }
            Pair<Integer, List<Integer>> v = CompressedMatrixBlock.getMaxNumValues(colGroups);
            for (int j = 0; j < colGroups.size(); ++j) {
                colGroups.get(j).rightMultByMatrix(thatV, retV, (Integer)((List)v.getRight()).get(j), materialized[j], blockL, blockU, 0);
            }
        }
    }

    private static void leftMultByTransposeSelf(List<ColGroup> groups, MatrixBlock result, int gl, int gu) {
        int numRows = groups.get(0).getNumRows();
        int numGroups = groups.size();
        MatrixBlock lhs = new MatrixBlock(1, numRows, false);
        MatrixBlock tmpret = new MatrixBlock(1, result.getNumColumns(), false);
        lhs.allocateDenseBlock();
        tmpret.allocateDenseBlock();
        ColGroupValue.setupThreadLocalMemory((Integer)CompressedMatrixBlock.getMaxNumValues(groups).getLeft());
        for (int i = gl; i < gu; ++i) {
            ColGroup group = groups.get(i);
            int[] ixgroup = group.getColIndices();
            List<ColGroup> tmpList = groups.subList(i, numGroups);
            for (int j = 0; j < ixgroup.length; ++j) {
                group.decompressToBlock(lhs, j);
                if (lhs.isEmptyBlock(false)) continue;
                CompressedMatrixBlock.leftMultByVectorTranspose(tmpList, lhs, tmpret, false, false);
                LinearAlgebraUtils.copyNonZerosToUpperTriangle(result, tmpret, ixgroup[j]);
            }
        }
        ColGroupValue.cleanupThreadLocalMemory();
    }

    private static ArrayList<ColGroup>[] createStaticTaskPartitioning(List<ColGroup> colGroups, int k, boolean inclUncompressed) {
        if (colGroups.size() == 1 && colGroups.get(0) instanceof ColGroupUncompressed) {
            return new ArrayList[0];
        }
        int numTasks = Math.min(k, colGroups.size());
        ArrayList[] grpParts = new ArrayList[numTasks];
        int pos = 0;
        for (ColGroup grp : colGroups) {
            if (grpParts[pos] == null) {
                grpParts[pos] = new ArrayList();
            }
            if (!inclUncompressed && grp instanceof ColGroupUncompressed) continue;
            grpParts[pos].add(grp);
            pos = pos == numTasks - 1 ? 0 : pos + 1;
        }
        return grpParts;
    }

    private static List<ColGroup>[] createStaticTaskPartitioningForMatrixMult(List<ColGroup> colGroups, int k, boolean inclUncompressed) {
        int numTasks = Math.min(k, colGroups.size());
        ArrayList[] grpParts = new ArrayList[numTasks];
        int pos = 0;
        for (int i = 0; i < numTasks; ++i) {
            grpParts[pos++] = new ArrayList();
        }
        pos = 0;
        for (ColGroup grp : colGroups) {
            if (!(grp instanceof ColGroupDDC)) continue;
            grpParts[pos].add((ColGroupDDC)grp);
            pos = pos == numTasks - 1 ? 0 : pos + 1;
        }
        for (ColGroup grp : colGroups) {
            if (grp instanceof ColGroupDDC || !inclUncompressed && grp instanceof ColGroupUncompressed) continue;
            grpParts[pos].add(grp);
            pos = pos == numTasks - 1 ? 0 : pos + 1;
        }
        return grpParts;
    }

    private static Pair<Integer, List<Integer>> getMaxNumValues(List<ColGroup> groups) {
        int numVals = 1;
        ArrayList<Integer> numValues = new ArrayList<Integer>(groups.size());
        for (ColGroup grp : groups) {
            if (grp instanceof ColGroupValue) {
                int nr = ((ColGroupValue)grp).getNumValues();
                numValues.add(nr);
                numVals = Math.max(numVals, nr);
                continue;
            }
            numValues.add(-1);
        }
        return new ImmutablePair((Object)numVals, numValues);
    }

    public boolean hasUncompressedColGroup() {
        return this.getUncompressedColGroup() != null;
    }

    private ColGroupUncompressed getUncompressedColGroup() {
        for (ColGroup grp : this._colGroups) {
            if (!(grp instanceof ColGroupUncompressed)) continue;
            return (ColGroupUncompressed)grp;
        }
        return null;
    }

    private static int getAlignedBlockSize(int blklen) {
        return blklen + (blklen % 65536 != 0 ? 65536 - blklen % 65536 : 0);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nCompressed Matrix:");
        sb.append("\nCols:" + this.getNumColumns() + " Rows:" + this.getNumRows());
        for (ColGroup cg : this._colGroups) {
            sb.append("\n" + cg);
        }
        return sb.toString();
    }

    private static class ScalarTask
    implements Callable<List<ColGroup>> {
        private final List<ColGroup> _colGroups;
        private final ScalarOperator _sop;

        protected ScalarTask(List<ColGroup> colGroups, ScalarOperator sop) {
            this._colGroups = colGroups;
            this._sop = sop;
        }

        @Override
        public List<ColGroup> call() {
            ArrayList<ColGroup> res = new ArrayList<ColGroup>();
            for (ColGroup x : this._colGroups) {
                res.add(x.scalarOperation(this._sop));
            }
            return res;
        }
    }

    private static class DecompressTask
    implements Callable<Object> {
        private final List<ColGroup> _colGroups;
        private final MatrixBlock _ret;
        private final int _rl;
        private final int _ru;

        protected DecompressTask(List<ColGroup> colGroups, MatrixBlock ret, int rl, int ru) {
            this._colGroups = colGroups;
            this._ret = ret;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Object call() {
            if (this._ret.isInSparseFormat()) {
                int[] rnnz = new int[this._ru - this._rl];
                for (ColGroup grp : this._colGroups) {
                    grp.countNonZerosPerRow(rnnz, this._rl, this._ru);
                }
                SparseBlock rows = this._ret.getSparseBlock();
                for (int i = this._rl; i < this._ru; ++i) {
                    rows.allocate(i, rnnz[i - this._rl]);
                }
            }
            for (ColGroup grp : this._colGroups) {
                grp.decompressToBlock(this._ret, this._rl, this._ru);
            }
            if (this._ret.isInSparseFormat()) {
                this._ret.sortSparseRows(this._rl, this._ru);
            }
            return null;
        }
    }

    private static class UnaryAggregateTask
    implements Callable<MatrixBlock> {
        private final List<ColGroup> _groups;
        private final int _rl;
        private final int _ru;
        private final MatrixBlock _ret;
        private final AggregateUnaryOperator _op;

        protected UnaryAggregateTask(List<ColGroup> groups, MatrixBlock ret, int rl, int ru, AggregateUnaryOperator op) {
            this._groups = groups;
            this._op = op;
            this._rl = rl;
            this._ru = ru;
            if (this._op.indexFn instanceof ReduceAll) {
                this._ret = new MatrixBlock(ret.getNumRows(), ret.getNumColumns(), false);
                this._ret.allocateDenseBlock();
                if (this._op.aggOp.increOp.fn instanceof Builtin) {
                    System.arraycopy(ret.getDenseBlockValues(), 0, this._ret.getDenseBlockValues(), 0, ret.getNumRows() * ret.getNumColumns());
                }
            } else {
                this._ret = ret;
            }
        }

        @Override
        public MatrixBlock call() {
            CompressedMatrixBlock.aggregateUnaryOperations(this._op, this._groups, this._ret, this._rl, this._ru);
            return this._ret;
        }
    }

    private static class MatrixMultTransposeTask
    implements Callable<Object> {
        private final List<ColGroup> _groups;
        private final MatrixBlock _ret;
        private final int _gl;
        private final int _gu;

        protected MatrixMultTransposeTask(List<ColGroup> groups, MatrixBlock ret, int gl, int gu) {
            this._groups = groups;
            this._ret = ret;
            this._gl = gl;
            this._gu = gu;
        }

        @Override
        public Object call() {
            CompressedMatrixBlock.leftMultByTransposeSelf(this._groups, this._ret, this._gl, this._gu);
            return null;
        }
    }

    private static class RightMatrixMultTask
    implements Callable<Long> {
        private final List<ColGroup> _groups;
        private final MatrixBlock _vect;
        private final MatrixBlock _ret;
        private final int _rl;
        private final int _ru;

        protected RightMatrixMultTask(List<ColGroup> groups, MatrixBlock vect, MatrixBlock ret, int rl, int ru) {
            this._groups = groups;
            this._vect = vect;
            this._ret = ret;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Long call() {
            try {
                CompressedMatrixBlock.rightMultByVector(this._groups, this._vect, this._ret, this._rl, this._ru);
                return this._ret.recomputeNonZeros(this._rl, this._ru - 1, 0, 0);
            }
            catch (Exception e) {
                LOG.error((Object)e);
                throw new DMLRuntimeException(e);
            }
        }
    }

    private static class LeftMatrixMatrixMultTask
    implements Callable<Object> {
        private final List<ColGroup> _group;
        private final double[] _that;
        private final double[] _ret;
        private final int _numRows;
        private final int _numCols;
        private final int _rl;
        private final int _ru;
        private final int _vOff;

        protected LeftMatrixMatrixMultTask(List<ColGroup> group, double[] that, double[] ret, int numRows, int numCols, int rl, int ru, int vOff) {
            this._group = group;
            this._that = that;
            this._ret = ret;
            this._numRows = numRows;
            this._numCols = numCols;
            this._rl = rl;
            this._ru = ru;
            this._vOff = vOff;
        }

        @Override
        public Object call() {
            double[][] materialized = new double[this._group.size()][];
            for (int i = 0; i < this._group.size(); ++i) {
                materialized[i] = this._group.get(i).getValues();
            }
            Pair v = CompressedMatrixBlock.getMaxNumValues(this._group);
            try {
                ColGroupValue.setupThreadLocalMemory((Integer)v.getLeft());
                for (int j = 0; j < this._group.size(); ++j) {
                    this._group.get(j).leftMultByMatrix(this._that, this._ret, (Integer)((List)v.getRight()).get(j), materialized[j], this._numRows, this._numCols, this._rl, this._ru, this._vOff);
                }
                ColGroupValue.cleanupThreadLocalMemory();
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
            return null;
        }
    }

    private static class LeftMatrixVectorMultTask
    implements Callable<Object> {
        private final ArrayList<ColGroup> _groups;
        private final MatrixBlock _vect;
        private final MatrixBlock _ret;

        protected LeftMatrixVectorMultTask(ArrayList<ColGroup> groups, MatrixBlock vect, MatrixBlock ret) {
            this._groups = groups;
            this._vect = vect;
            this._ret = ret;
        }

        @Override
        public Object call() {
            try {
                Pair v = CompressedMatrixBlock.getMaxNumValues(this._groups);
                ColGroupValue.setupThreadLocalMemory((Integer)v.getLeft());
                for (int i = 0; i < this._groups.size(); ++i) {
                    this._groups.get(i).leftMultByRowVector(this._vect.getDenseBlockValues(), this._ret.getDenseBlockValues(), (Integer)((List)v.getRight()).get(i));
                }
                ColGroupValue.cleanupThreadLocalMemory();
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
            return null;
        }
    }
}

