/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.sample;

import org.apache.sysds.runtime.compress.estim.sample.FrequencyCount;
import org.apache.sysds.runtime.compress.utils.Bitmap;

public class SmoothedJackknifeEstimator {
    public static int get(Bitmap ubm, int nRows, int sampleSize) {
        int numVals = ubm.getNumValues();
        int[] freqCounts = FrequencyCount.get(ubm);
        if (freqCounts.length == 0) {
            return 0;
        }
        int d = numVals;
        double f1 = freqCounts[0];
        int Nn = nRows * sampleSize;
        double D0 = ((double)d - f1 / (double)sampleSize) / (1.0 - (double)(nRows - sampleSize + 1) * f1 / (double)Nn);
        double NTilde = (double)nRows / D0;
        double A = (double)nRows - NTilde;
        double B = A - (double)sampleSize + 1.0;
        double D = nRows - sampleSize + 1;
        A = Math.min(A, D - 1.0);
        D = Math.max(A + 1.0, D);
        double h = 1.0;
        for (double C = (double)nRows; A >= B || C >= D; A -= 1.0, C -= 1.0) {
            if (A >= B) {
                h *= A;
            }
            if (!(C >= D)) continue;
            h /= C;
        }
        double g = 0.0;
        double gamma = 0.0;
        for (int k = 2; k <= sampleSize + 1; ++k) {
            g += 1.0 / ((double)nRows - NTilde - (double)sampleSize + (double)k);
        }
        for (int i = 1; i <= freqCounts.length; ++i) {
            gamma += (double)(i * (i - 1) * freqCounts[i - 1]);
        }
        gamma *= (double)(nRows - 1) * D0 / (double)Nn / (double)(sampleSize - 1);
        double estimate = ((double)d + (double)nRows * h * g * (gamma += D0 / (double)nRows - 1.0)) / (1.0 - ((double)nRows - NTilde - (double)sampleSize + 1.0) * f1 / (double)Nn);
        return estimate < 1.0 ? 1 : (int)Math.round(estimate);
    }
}

