/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONArray;

public abstract class Encoder
implements Serializable {
    private static final long serialVersionUID = 2299156350718979064L;
    protected static final Log LOG = LogFactory.getLog((String)Encoder.class.getName());
    protected int _clen = -1;
    protected int[] _colList = null;

    protected Encoder(int[] colList, int clen) {
        this._colList = colList;
        this._clen = clen;
    }

    public int[] getColList() {
        return this._colList;
    }

    public void setColList(int[] colList) {
        this._colList = colList;
    }

    public int getNumCols() {
        return this._clen;
    }

    public int initColList(JSONArray attrs) {
        this._colList = new int[attrs.size()];
        for (int i = 0; i < this._colList.length; ++i) {
            this._colList[i] = UtilFunctions.toInt(attrs.get(i));
        }
        return this._colList.length;
    }

    public int initColList(int[] colList) {
        this._colList = colList;
        return this._colList.length;
    }

    public boolean isApplicable() {
        return this._colList != null && this._colList.length > 0;
    }

    public int isApplicable(int colID) {
        if (this._colList == null) {
            return -1;
        }
        int idx = Arrays.binarySearch(this._colList, colID);
        return idx >= 0 ? idx : -1;
    }

    public abstract MatrixBlock encode(FrameBlock var1, MatrixBlock var2);

    public abstract void build(FrameBlock var1);

    public abstract MatrixBlock apply(FrameBlock var1, MatrixBlock var2);

    protected int[] subRangeColList(IndexRange ixRange) {
        ArrayList<Integer> cols = new ArrayList<Integer>();
        for (int col : this._colList) {
            if (!ixRange.inColRange(col)) continue;
            int corrColumn = (int)((long)col - (ixRange.colStart - 1L));
            cols.add(corrColumn);
        }
        return cols.stream().mapToInt(i -> i).toArray();
    }

    public Encoder subRangeEncoder(IndexRange ixRange) {
        throw new DMLRuntimeException(this.getClass().getSimpleName() + " does not support the creation of a sub-range encoder");
    }

    protected void mergeColumnInfo(Encoder other, int col) {
        this._clen = Math.max(this._clen, col - 1 + other._clen);
        HashSet<Integer> colListAgg = new HashSet<Integer>();
        for (int i2 : this._colList) {
            colListAgg.add(i2);
        }
        for (int i2 : other._colList) {
            colListAgg.add(col - 1 + i2);
        }
        this._colList = colListAgg.stream().mapToInt(i -> i).toArray();
    }

    public void mergeAt(Encoder other, int row, int col) {
        throw new DMLRuntimeException(this.getClass().getSimpleName() + " does not support merging with " + other.getClass().getSimpleName());
    }

    public void updateIndexRanges(long[] beginDims, long[] endDims) {
    }

    public abstract FrameBlock getMetaData(FrameBlock var1);

    public abstract void initMetaData(FrameBlock var1);

    public MatrixBlock getColMapping(FrameBlock meta, MatrixBlock out) {
        return out;
    }
}

