/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.security;

import java.nio.ByteBuffer;
import javax.crypto.SecretKey;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.util.Records;

public class MasterKeyData {
    private final MasterKey masterKeyRecord;
    private final SecretKey generatedSecretKey;

    public MasterKeyData(int serialNo, SecretKey secretKey) {
        this.masterKeyRecord = (MasterKey)Records.newRecord(MasterKey.class);
        this.masterKeyRecord.setKeyId(serialNo);
        this.generatedSecretKey = secretKey;
        this.masterKeyRecord.setBytes(ByteBuffer.wrap(this.generatedSecretKey.getEncoded()));
    }

    public MasterKeyData(MasterKey masterKeyRecord, SecretKey secretKey) {
        this.masterKeyRecord = masterKeyRecord;
        this.generatedSecretKey = secretKey;
    }

    public MasterKey getMasterKey() {
        return this.masterKeyRecord;
    }

    public SecretKey getSecretKey() {
        return this.generatedSecretKey;
    }
}

