/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.api.jmlc.JMLCUtils;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.recompile.Recompiler;
import org.apache.sysds.parser.ParseInfo;
import org.apache.sysds.parser.StatementBlock;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.DMLScriptException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.BooleanObject;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.IntObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.StringObject;
import org.apache.sysds.runtime.lineage.LineageCache;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.privacy.propagation.PrivacyPropagator;
import org.apache.sysds.utils.Statistics;

public abstract class ProgramBlock
implements ParseInfo {
    public static final String PRED_VAR = "__pred";
    protected static final Log LOG = LogFactory.getLog((String)ProgramBlock.class.getName());
    private static final boolean CHECK_MATRIX_PROPERTIES = false;
    protected Program _prog;
    protected Instruction _exitInstruction = null;
    protected StatementBlock _sb = null;
    protected long _tid = 0L;
    public String _filename;
    public int _beginLine;
    public int _beginColumn;
    public int _endLine;
    public int _endColumn;
    public String _text;

    public ProgramBlock(Program prog) {
        this._prog = prog;
    }

    public Program getProgram() {
        return this._prog;
    }

    public void setProgram(Program prog) {
        this._prog = prog;
    }

    public StatementBlock getStatementBlock() {
        return this._sb;
    }

    public void setStatementBlock(StatementBlock sb) {
        this._sb = sb;
    }

    public void setThreadID(long id) {
        this._tid = id;
    }

    public boolean hasThreadID() {
        return this._tid != 0L;
    }

    public static boolean isThreadID(long tid) {
        return tid != 0L;
    }

    public long getThreadID() {
        return this._tid;
    }

    public void setExitInstruction(Instruction rmVar) {
        this._exitInstruction = rmVar;
    }

    public Instruction getExitInstruction() {
        return this._exitInstruction;
    }

    public abstract ArrayList<ProgramBlock> getChildBlocks();

    public abstract boolean isNested();

    public abstract void execute(ExecutionContext var1);

    public ScalarObject executePredicate(ArrayList<Instruction> inst, Hop hops, boolean requiresRecompile, Types.ValueType retType, ExecutionContext ec) {
        ArrayList<Instruction> tmp = inst;
        try {
            long t0;
            long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            if (ConfigurationManager.isDynamicRecompilation() && requiresRecompile) {
                tmp = Recompiler.recompileHopsDag(hops, ec.getVariables(), null, false, true, this._tid);
                tmp = JMLCUtils.cleanupRuntimeInstructions(tmp, PRED_VAR);
            }
            if (DMLScript.STATISTICS) {
                long t1 = System.nanoTime();
                Statistics.incrementHOPRecompileTime(t1 - t0);
                if (tmp != inst) {
                    Statistics.incrementHOPRecompilePred();
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to recompile predicate instructions.", ex);
        }
        return this.executePredicateInstructions(tmp, retType, ec);
    }

    protected void executeExitInstructions(Instruction inst, String ctx, ExecutionContext ec) {
        try {
            if (this._exitInstruction != null) {
                this.executeSingleInstruction(this._exitInstruction, ec);
            }
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating " + ctx + " exit instructions ", e);
        }
    }

    protected void executeInstructions(ArrayList<Instruction> inst, ExecutionContext ec) {
        for (int i = 0; i < inst.size(); ++i) {
            Instruction currInst = inst.get(i);
            this.executeSingleInstruction(currInst, ec);
        }
    }

    protected ScalarObject executePredicateInstructions(ArrayList<Instruction> inst, Types.ValueType retType, ExecutionContext ec) {
        for (Instruction currInst : inst) {
            this.executeSingleInstruction(currInst, ec);
        }
        ScalarObject ret = ec.getScalarInput(PRED_VAR, retType, false);
        if (retType != null && retType != ret.getValueType()) {
            switch (retType) {
                case BOOLEAN: {
                    ret = new BooleanObject(ret.getBooleanValue());
                    break;
                }
                case INT64: {
                    ret = new IntObject(ret.getLongValue());
                    break;
                }
                case FP64: {
                    ret = new DoubleObject(ret.getDoubleValue());
                    break;
                }
                case STRING: {
                    ret = new StringObject(ret.getStringValue());
                    break;
                }
            }
        }
        ec.removeVariable(PRED_VAR);
        return ret;
    }

    private void executeSingleInstruction(Instruction currInst, ExecutionContext ec) {
        try {
            long t0 = DMLScript.STATISTICS || LOG.isTraceEnabled() ? System.nanoTime() : 0L;
            Instruction tmp = currInst.preprocessInstruction(ec);
            if (!LineageCache.reuse(tmp, ec)) {
                long et0 = !LineageCacheConfig.ReuseCacheType.isNone() || DMLScript.LINEAGE_ESTIMATE ? System.nanoTime() : 0L;
                tmp.processInstruction(ec);
                LineageCache.putValue(tmp, ec, et0);
                tmp.postprocessInstruction(ec);
                if (DMLScript.STATISTICS) {
                    Statistics.maintainCPHeavyHitters(tmp.getExtendedOpcode(), System.nanoTime() - t0);
                }
            }
            PrivacyPropagator.postProcessInstruction(tmp, ec);
            if (LOG.isTraceEnabled()) {
                long t1 = System.nanoTime();
                String time = String.format("%.3f", ((double)t1 - (double)t0) / 1.0E9);
                LOG.trace((Object)("Instruction: " + tmp + " (executed in " + time + "s)."));
            }
        }
        catch (DMLScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(this.printBlockErrorLocation() + "Error evaluating instruction: " + currInst.toString(), e);
        }
    }

    protected MatrixObject.UpdateType[] prepareUpdateInPlaceVariables(ExecutionContext ec, long tid) {
        if (this._sb == null || this._sb.getUpdateInPlaceVars().isEmpty()) {
            return null;
        }
        ArrayList<String> varnames = this._sb.getUpdateInPlaceVars();
        MatrixObject.UpdateType[] flags = new MatrixObject.UpdateType[varnames.size()];
        for (int i = 0; i < flags.length; ++i) {
            String varname = varnames.get(i);
            if (!ec.isMatrixObject(varname)) continue;
            MatrixObject mo = ec.getMatrixObject(varname);
            flags[i] = mo.getUpdateType();
            if (flags[i] != MatrixObject.UpdateType.COPY || !(OptimizerUtils.getLocalMemBudget() / 2.0 > (double)OptimizerUtils.estimateSizeExactSparsity(mo.getDataCharacteristics()))) continue;
            MatrixObject moNew = new MatrixObject(mo);
            MatrixBlock mbVar = (MatrixBlock)mo.acquireRead();
            moNew.acquireModify(mbVar instanceof CompressedMatrixBlock ? new CompressedMatrixBlock((CompressedMatrixBlock)mbVar) : (!mbVar.isInSparseFormat() ? new MatrixBlock(mbVar) : new MatrixBlock(mbVar, MatrixBlock.DEFAULT_INPLACE_SPARSEBLOCK, true)));
            moNew.setFileName(mo.getFileName() + "_uip" + tid);
            mo.release();
            if (ec.removeVariable(varname) != null) {
                ec.cleanupCacheableData(mo);
            }
            moNew.release();
            moNew.setUpdateType(MatrixObject.UpdateType.INPLACE);
            ec.setVariable(varname, moNew);
        }
        return flags;
    }

    protected void resetUpdateInPlaceVariableFlags(ExecutionContext ec, MatrixObject.UpdateType[] flags) {
        if (flags == null) {
            return;
        }
        ArrayList<String> varnames = this._sb.getUpdateInPlaceVars();
        for (int i = 0; i < varnames.size(); ++i) {
            if (ec.getVariable(varnames.get(i)) == null || flags[i] == null) continue;
            MatrixObject mo = ec.getMatrixObject(varnames.get(i));
            mo.setUpdateType(flags[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkSparsity(Instruction lastInst, LocalVariableMap vars) {
        for (String varname : vars.keySet()) {
            MatrixObject mo;
            Data dat = vars.get(varname);
            if (!(dat instanceof MatrixObject) || !(mo = (MatrixObject)dat).isDirty() || mo.isPartitioned()) continue;
            MatrixBlock mb = (MatrixBlock)mo.acquireRead();
            boolean sparse1 = mb.isInSparseFormat();
            long nnz1 = mb.getNonZeros();
            MatrixBlock matrixBlock = mb;
            synchronized (matrixBlock) {
                mb.recomputeNonZeros();
                mb.examSparsity();
            }
            if (mb.isInSparseFormat() && mb.isAllocated()) {
                mb.getSparseBlock().checkValidity(mb.getNumRows(), mb.getNumColumns(), mb.getNonZeros(), true);
            }
            boolean sparse2 = mb.isInSparseFormat();
            long nnz2 = mb.getNonZeros();
            mo.release();
            if (nnz1 != nnz2) {
                throw new DMLRuntimeException("Matrix nnz meta data was incorrect: (" + varname + ", actual=" + nnz1 + ", expected=" + nnz2 + ", inst=" + lastInst + ")");
            }
            if (sparse1 == sparse2 || !mb.isAllocated()) continue;
            throw new DMLRuntimeException("Matrix was in wrong data representation: (" + varname + ", actual=" + sparse1 + ", expected=" + sparse2 + ", nrow=" + mb.getNumRows() + ", ncol=" + mb.getNumColumns() + ", nnz=" + nnz1 + ", inst=" + lastInst + ")");
        }
    }

    private static void checkFederated(Instruction lastInst, LocalVariableMap vars) {
        for (String varname : vars.keySet()) {
            CacheableData mo;
            Data dat = vars.get(varname);
            if (!(dat instanceof CacheableData) || !(mo = (CacheableData)dat).isFederated() || !mo.getFedMapping().getMap().isEmpty()) continue;
            throw new DMLRuntimeException("Invalid empty FederationMap for: " + mo);
        }
    }

    @Override
    public void setFilename(String passed) {
        this._filename = passed;
    }

    @Override
    public void setBeginLine(int passed) {
        this._beginLine = passed;
    }

    @Override
    public void setBeginColumn(int passed) {
        this._beginColumn = passed;
    }

    @Override
    public void setEndLine(int passed) {
        this._endLine = passed;
    }

    @Override
    public void setEndColumn(int passed) {
        this._endColumn = passed;
    }

    @Override
    public void setText(String text) {
        this._text = text;
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    @Override
    public int getBeginLine() {
        return this._beginLine;
    }

    @Override
    public int getBeginColumn() {
        return this._beginColumn;
    }

    @Override
    public int getEndLine() {
        return this._endLine;
    }

    @Override
    public int getEndColumn() {
        return this._endColumn;
    }

    @Override
    public String getText() {
        return this._text;
    }

    public String printBlockErrorLocation() {
        return "ERROR: Runtime error in program block generated from statement block between lines " + this._beginLine + " and " + this._endLine + " -- ";
    }

    public void setParseInfo(ParseInfo parseInfo) {
        this._beginLine = parseInfo.getBeginLine();
        this._beginColumn = parseInfo.getBeginColumn();
        this._endLine = parseInfo.getEndLine();
        this._endColumn = parseInfo.getEndColumn();
        this._text = parseInfo.getText();
        this._filename = parseInfo.getFilename();
    }
}

