/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.concurrent.Future;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.UnaryFEDInstruction;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class AggregateUnaryFEDInstruction
extends UnaryFEDInstruction {
    private AggregateUnaryFEDInstruction(AggregateUnaryOperator auop, CPOperand in, CPOperand out, String opcode, String istr, FEDInstruction.FederatedOutput fedOut) {
        super(FEDInstruction.FEDType.AggregateUnary, (Operator)auop, in, out, opcode, istr, fedOut);
    }

    protected AggregateUnaryFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr, FEDInstruction.FederatedOutput fedOut) {
        super(FEDInstruction.FEDType.AggregateUnary, op, in1, in2, out, opcode, istr, fedOut);
    }

    protected AggregateUnaryFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(FEDInstruction.FEDType.AggregateUnary, op, in1, in2, out, opcode, istr);
    }

    protected AggregateUnaryFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(FEDInstruction.FEDType.AggregateUnary, op, in1, in2, in3, out, opcode, istr);
    }

    public static AggregateUnaryFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        AggregateUnaryOperator aggun = null;
        aggun = opcode.equalsIgnoreCase("uarimax") || opcode.equalsIgnoreCase("uarimin") ? InstructionUtils.parseAggregateUnaryRowIndexOperator(opcode, Integer.parseInt(parts[4]), 1) : InstructionUtils.parseBasicAggregateUnaryOperator(opcode);
        if (InstructionUtils.getExecType(str) == Types.ExecType.SPARK) {
            str = InstructionUtils.replaceOperand(str, 4, "-1");
        }
        FEDInstruction.FederatedOutput fedOut = null;
        fedOut = parts.length == 5 && !parts[4].equals("uarimin") && !parts[4].equals("uarimax") ? FEDInstruction.FederatedOutput.valueOf(parts[4]) : FEDInstruction.FederatedOutput.valueOf(parts[5]);
        return new AggregateUnaryFEDInstruction(aggun, in1, out, opcode, str, fedOut);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (this.getOpcode().contains("var")) {
            this.processVar(ec);
        } else {
            this.processDefault(ec);
        }
    }

    private void processDefault(ExecutionContext ec) {
        AggregateUnaryOperator aop = (AggregateUnaryOperator)this._optr;
        MatrixObject in = ec.getMatrixObject(this.input1);
        FederationMap map = in.getFedMapping();
        if ((this.instOpcode.equalsIgnoreCase("uarimax") || this.instOpcode.equalsIgnoreCase("uarimin")) && in.isFederated(FederationMap.FType.COL)) {
            this.instString = InstructionUtils.replaceOperand(this.instString, 5, "2");
        }
        if (this._fedOut.isForcedFederated()) {
            this.processFederatedOutput(map, in, ec);
        } else {
            this.processGetOutput(map, aop, ec, in);
        }
    }

    private void processFederatedOutput(FederationMap map, MatrixObject in, ExecutionContext ec) {
        if (this.output.isScalar()) {
            throw new DMLRuntimeException("Output of FED instruction, " + this.output.toString() + ", is a scalar and the output is set to be federated. Scalars cannot be federated. ");
        }
        FederatedRequest fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1}, new long[]{in.getFedMapping().getID()}, true);
        map.execute(this.getTID(), fr1);
        MatrixObject out = ec.getMatrixObject(this.output);
        out.setFedMapping(in.getFedMapping().copyWithNewID(fr1.getID()));
    }

    private void processGetOutput(FederationMap map, AggregateUnaryOperator aggUOptr, ExecutionContext ec, MatrixObject in) {
        FederatedRequest fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1}, new long[]{in.getFedMapping().getID()}, true);
        FederatedRequest fr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr1.getID());
        FederatedRequest fr3 = map.cleanup(this.getTID(), fr1.getID());
        Future<FederatedResponse>[] tmp = map.execute(this.getTID(), fr1, fr2, fr3);
        if (this.output.isScalar()) {
            ec.setVariable(this.output.getName(), FederationUtils.aggScalar(aggUOptr, tmp, map));
        } else {
            ec.setMatrixOutput(this.output.getName(), FederationUtils.aggMatrix(aggUOptr, tmp, map));
        }
    }

    private void processVar(ExecutionContext ec) {
        if (this._fedOut.isForcedFederated()) {
            throw new DMLRuntimeException("Output of " + this.toString() + " should not be federated since the instruction requires consolidation of partial results to be computed.");
        }
        AggregateUnaryOperator aop = (AggregateUnaryOperator)this._optr;
        MatrixObject in = ec.getMatrixObject(this.input1);
        FederationMap map = in.getFedMapping();
        Future<FederatedResponse>[] meanTmp = null;
        if (this.getOpcode().contains("var")) {
            String meanInstr = this.instString.replace(this.getOpcode(), this.getOpcode().replace("var", "mean"));
            FederatedRequest meanFr1 = FederationUtils.callInstruction(meanInstr, this.output, new CPOperand[]{this.input1}, new long[]{in.getFedMapping().getID()});
            FederatedRequest meanFr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, meanFr1.getID());
            FederatedRequest meanFr3 = map.cleanup(this.getTID(), meanFr1.getID());
            meanTmp = map.execute(this.getTID(), meanFr1, meanFr2, meanFr3);
        }
        FederatedRequest fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1}, new long[]{in.getFedMapping().getID()});
        FederatedRequest fr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr1.getID());
        FederatedRequest fr3 = map.cleanup(this.getTID(), fr1.getID());
        Future<FederatedResponse>[] tmp = map.execute(this.getTID(), fr1, fr2, fr3);
        if (this.output.isScalar()) {
            ec.setVariable(this.output.getName(), FederationUtils.aggScalar(aop, tmp, meanTmp, map));
        } else {
            ec.setMatrixOutput(this.output.getName(), FederationUtils.aggMatrix(aop, tmp, meanTmp, map));
        }
    }
}

