/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.random.Well1024a;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.lops.MapMultChain;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupIO;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.lib.CLALibAppend;
import org.apache.sysds.runtime.compress.lib.CLALibBinaryCellOp;
import org.apache.sysds.runtime.compress.lib.CLALibCMOps;
import org.apache.sysds.runtime.compress.lib.CLALibCompAgg;
import org.apache.sysds.runtime.compress.lib.CLALibDecompress;
import org.apache.sysds.runtime.compress.lib.CLALibMMChain;
import org.apache.sysds.runtime.compress.lib.CLALibMatrixMult;
import org.apache.sysds.runtime.compress.lib.CLALibRexpand;
import org.apache.sysds.runtime.compress.lib.CLALibScalar;
import org.apache.sysds.runtime.compress.lib.CLALibSlice;
import org.apache.sysds.runtime.compress.lib.CLALibSquash;
import org.apache.sysds.runtime.compress.lib.CLALibTSMM;
import org.apache.sysds.runtime.compress.lib.CLALibUnary;
import org.apache.sysds.runtime.compress.lib.CLALibUtils;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseRow;
import org.apache.sysds.runtime.functionobjects.MinusMultiply;
import org.apache.sysds.runtime.functionobjects.PlusMultiply;
import org.apache.sysds.runtime.functionobjects.TernaryValueFunction;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.spark.data.IndexedMatrixValue;
import org.apache.sysds.runtime.matrix.data.CTableMap;
import org.apache.sysds.runtime.matrix.data.IJV;
import org.apache.sysds.runtime.matrix.data.LibMatrixDatagen;
import org.apache.sysds.runtime.matrix.data.LibMatrixTercell;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.MatrixValue;
import org.apache.sysds.runtime.matrix.data.RandomMatrixGenerator;
import org.apache.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateTernaryOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.COVOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.QuaternaryOperator;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.TernaryOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.utils.DMLCompressionStatistics;

public class CompressedMatrixBlock
extends MatrixBlock {
    private static final Log LOG = LogFactory.getLog((String)CompressedMatrixBlock.class.getName());
    private static final long serialVersionUID = 73193720143154058L;
    protected transient List<AColGroup> _colGroups;
    protected boolean overlappingColGroups = false;
    protected transient SoftReference<MatrixBlock> decompressedVersion;

    public CompressedMatrixBlock() {
        super(true);
        this.sparse = false;
        this.nonZeros = -1L;
    }

    public CompressedMatrixBlock(int rl, int cl) {
        super(true);
        this.rlen = rl;
        this.clen = cl;
        this.sparse = false;
        this.nonZeros = -1L;
    }

    public CompressedMatrixBlock(CompressedMatrixBlock that) {
        super(true);
        this.rlen = that.getNumRows();
        this.clen = that.getNumColumns();
        this.copyCompressedMatrix(that);
    }

    protected CompressedMatrixBlock(MatrixBlock uncompressedMatrixBlock) {
        super(true);
        this.rlen = uncompressedMatrixBlock.getNumRows();
        this.clen = uncompressedMatrixBlock.getNumColumns();
        this.sparse = false;
        this.nonZeros = uncompressedMatrixBlock.getNonZeros();
        this.decompressedVersion = new SoftReference<MatrixBlock>(uncompressedMatrixBlock);
    }

    public CompressedMatrixBlock(int rl, int cl, long nnz, boolean overlapping, List<AColGroup> groups) {
        super(true);
        this.rlen = rl;
        this.clen = cl;
        this.sparse = false;
        this.nonZeros = nnz;
        this.overlappingColGroups = overlapping;
        this._colGroups = groups;
    }

    @Override
    public void reset(int rl, int cl, boolean sp, long estnnz, double val) {
        throw new DMLCompressionException("Invalid to reset a Compressed MatrixBlock");
    }

    public void allocateColGroup(AColGroup cg) {
        this._colGroups = new ArrayList<AColGroup>(1);
        this._colGroups.add(cg);
    }

    public void allocateColGroupList(List<AColGroup> colGroups) {
        this._colGroups = colGroups;
    }

    public List<AColGroup> getColGroups() {
        return this._colGroups;
    }

    public MatrixBlock decompress() {
        return this.decompress(1);
    }

    public synchronized MatrixBlock decompress(int k) {
        if (this.isEmpty()) {
            return new MatrixBlock(this.rlen, this.clen, true, 0L);
        }
        MatrixBlock ret = this.getCachedDecompressed();
        if (ret != null) {
            return ret;
        }
        ret = CLALibDecompress.decompress(this, k);
        this.decompressedVersion = new SoftReference<MatrixBlock>(ret);
        return ret;
    }

    @Override
    public void putInto(MatrixBlock target, int rowOffset, int colOffset, boolean sparseCopyShallow) {
        CLALibDecompress.decompressTo(this, target, rowOffset, colOffset, 1);
    }

    public MatrixBlock getCachedDecompressed() {
        MatrixBlock mb;
        if (this.decompressedVersion != null && (mb = this.decompressedVersion.get()) != null) {
            DMLCompressionStatistics.addDecompressCacheCount();
            LOG.trace((Object)"Decompressed block was in soft reference.");
            return mb;
        }
        return null;
    }

    public CompressedMatrixBlock squash(int k) {
        return CLALibSquash.squash(this, k);
    }

    @Override
    public long recomputeNonZeros() {
        if (this.isOverlapping()) {
            this.nonZeros = this.clen * this.rlen;
        } else {
            long nnz = 0L;
            for (AColGroup g : this._colGroups) {
                nnz += g.getNumberNonZeros(this.rlen);
            }
            this.nonZeros = nnz;
        }
        if (this.nonZeros == 0L) {
            this.allocateColGroup(ColGroupEmpty.create(this.getNumColumns()));
        }
        return this.nonZeros;
    }

    @Override
    public long recomputeNonZeros(int rl, int ru) {
        throw new NotImplementedException();
    }

    @Override
    public long recomputeNonZeros(int rl, int ru, int cl, int cu) {
        throw new NotImplementedException();
    }

    @Override
    public long getInMemorySize() {
        return this.estimateCompressedSizeInMemory();
    }

    @Override
    public long estimateSizeInMemory() {
        return this.estimateCompressedSizeInMemory();
    }

    public long estimateCompressedSizeInMemory() {
        long total = CompressedMatrixBlock.baseSizeInMemory();
        for (AColGroup grp : this._colGroups) {
            total += grp.estimateInMemorySize();
        }
        return total;
    }

    public static long baseSizeInMemory() {
        long total = 16L;
        total += CompressedMatrixBlock.getHeaderSize();
        total += 8L;
        total += 8L;
        total += 8L;
        total += 8L;
        return total += 40L;
    }

    @Override
    public double quickGetValue(int r, int c) {
        if (this.isOverlapping()) {
            double v = 0.0;
            for (AColGroup group : this._colGroups) {
                v += group.get(r, c);
            }
            return v;
        }
        for (AColGroup group : this._colGroups) {
            int idx = group.getColIndices().findIndex(c);
            if (idx < 0) continue;
            return group.getIdx(r, idx);
        }
        return 0.0;
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = 17L;
        return ret += ColGroupIO.getExactSizeOnDisk(this._colGroups);
    }

    @Override
    public long estimateSizeOnDisk() {
        return this.getExactSizeOnDisk();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.rlen = in.readInt();
        this.clen = in.readInt();
        this.nonZeros = in.readLong();
        this.overlappingColGroups = in.readBoolean();
        this._colGroups = ColGroupIO.readGroups(in, this.rlen);
    }

    public static CompressedMatrixBlock read(DataInput in) throws IOException {
        int rlen = in.readInt();
        int clen = in.readInt();
        long nonZeros = in.readLong();
        boolean overlappingColGroups = in.readBoolean();
        List<AColGroup> groups = ColGroupIO.readGroups(in, rlen);
        return new CompressedMatrixBlock(rlen, clen, nonZeros, overlappingColGroups, groups);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        long estDisk;
        long estimateUncompressed = this.nonZeros > 0L ? MatrixBlock.estimateSizeOnDisk(this.rlen, this.clen, this.nonZeros) : Long.MAX_VALUE;
        long l = estDisk = this.nonZeros > 0L ? this.getExactSizeOnDisk() : Long.MAX_VALUE;
        if (this.nonZeros > 0L && estDisk > estimateUncompressed) {
            MatrixBlock uncompressed = this.getUncompressed("smaller serialization size: compressed: " + estDisk + " vs uncompressed: " + estimateUncompressed);
            ColGroupUncompressed cg = (ColGroupUncompressed)ColGroupUncompressed.create(uncompressed);
            if (estDisk / 10L > estimateUncompressed) {
                LOG.error((Object)this);
            }
            this.allocateColGroup(cg);
            this.nonZeros = cg.getNumberNonZeros(this.rlen);
            this.clearSoftReferenceToDecompressed();
        }
        out.writeInt(this.rlen);
        out.writeInt(this.clen);
        out.writeLong(this.nonZeros);
        out.writeBoolean(this.overlappingColGroups);
        ColGroupIO.writeGroups(out, this._colGroups);
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException {
        this.readFields(is);
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        this.write(os);
    }

    @Override
    public MatrixBlock scalarOperations(ScalarOperator sop, MatrixValue result) {
        return CLALibScalar.scalarOperations(sop, this, result);
    }

    @Override
    public MatrixBlock binaryOperations(BinaryOperator op, MatrixValue thatValue, MatrixValue result) {
        MatrixBlock that = thatValue == null ? null : (MatrixBlock)thatValue;
        MatrixBlock ret = result == null ? null : (MatrixBlock)result;
        return CLALibBinaryCellOp.binaryOperationsRight(op, this, that, ret);
    }

    public MatrixBlock binaryOperationsLeft(BinaryOperator op, MatrixValue thatValue, MatrixValue result) {
        MatrixBlock that = thatValue == null ? null : (MatrixBlock)thatValue;
        MatrixBlock ret = result == null ? null : (MatrixBlock)result;
        return CLALibBinaryCellOp.binaryOperationsLeft(op, this, that, ret);
    }

    @Override
    public MatrixBlock append(MatrixBlock[] that, MatrixBlock ret, boolean cbind) {
        if (cbind && that.length == 1) {
            return CLALibAppend.append(this, that[0], InfrastructureAnalyzer.getLocalParallelism());
        }
        MatrixBlock left = this.getUncompressed("append list or r-bind not supported in compressed");
        MatrixBlock[] thatUC = new MatrixBlock[that.length];
        for (int i = 0; i < that.length; ++i) {
            thatUC[i] = CompressedMatrixBlock.getUncompressed(that[i]);
        }
        return left.append(thatUC, ret, cbind);
    }

    @Override
    public void append(MatrixValue v2, ArrayList<IndexedMatrixValue> outlist, int blen, boolean cbind, boolean m2IsLast, int nextNCol) {
        MatrixBlock left = this.getUncompressed("append ArrayList");
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(v2);
        left.append(right, outlist, blen, cbind, m2IsLast, nextNCol);
    }

    @Override
    public MatrixBlock chainMatrixMultOperations(MatrixBlock v, MatrixBlock w, MatrixBlock out, MapMultChain.ChainType ctype, int k) {
        this.checkMMChain(ctype, v, w);
        if (this._colGroups != null && this._colGroups.size() == 1 && this._colGroups.get(0).getCompType() == AColGroup.CompressionType.UNCOMPRESSED) {
            return ((ColGroupUncompressed)this._colGroups.get(0)).getData().chainMatrixMultOperations(v, w, out, ctype, k);
        }
        return CLALibMMChain.mmChain(this, v, w, out, ctype, k);
    }

    @Override
    public MatrixBlock aggregateBinaryOperations(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, AggregateBinaryOperator op) {
        this.checkAggregateBinaryOperations(m1, m2, op);
        return CLALibMatrixMult.matrixMultiply(m1, m2, ret, op.getNumThreads(), false, false);
    }

    public MatrixBlock aggregateBinaryOperations(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, AggregateBinaryOperator op, boolean transposeLeft, boolean transposeRight) {
        this.checkAggregateBinaryOperations(m1, m2, op, transposeLeft, transposeRight);
        return CLALibMatrixMult.matrixMultiply(m1, m2, ret, op.getNumThreads(), transposeLeft, transposeRight);
    }

    @Override
    public MatrixBlock aggregateUnaryOperations(AggregateUnaryOperator op, MatrixValue result, int blen, MatrixIndexes indexesIn, boolean inCP) {
        MatrixBlock ret = result == null ? null : (MatrixBlock)result;
        return CLALibCompAgg.aggregateUnary(this, ret, op, blen, indexesIn, inCP);
    }

    @Override
    public MatrixBlock transposeSelfMatrixMultOperations(MatrixBlock out, MMTSJ.MMTSJType tstype, int k) {
        if (tstype == MMTSJ.MMTSJType.LEFT) {
            if (this.isEmpty()) {
                return new MatrixBlock(this.clen, this.clen, true);
            }
            if (out == null) {
                out = new MatrixBlock(this.clen, this.clen, false);
            } else {
                out.reset(this.clen, this.clen, false);
            }
            out.allocateDenseBlock();
            CLALibTSMM.leftMultByTransposeSelf(this, out, k);
            return out;
        }
        throw new DMLRuntimeException("Invalid MMTSJ type '" + tstype.toString() + "'.");
    }

    @Override
    public MatrixBlock replaceOperations(MatrixValue result, double pattern, double replacement) {
        if (Double.isInfinite(pattern)) {
            LOG.info((Object)"Ignoring replace infinite in compression since it does not contain this value");
            return this;
        }
        if (this.isOverlapping()) {
            String message = "replaceOperations " + pattern + " -> " + replacement;
            return this.getUncompressed(message).replaceOperations(result, pattern, replacement);
        }
        CompressedMatrixBlock ret = new CompressedMatrixBlock(this.getNumRows(), this.getNumColumns());
        List<AColGroup> prev = this.getColGroups();
        int colGroupsLength = prev.size();
        ArrayList<AColGroup> retList = new ArrayList<AColGroup>(colGroupsLength);
        for (int i = 0; i < colGroupsLength; ++i) {
            retList.add(prev.get(i).replace(pattern, replacement));
        }
        ret.allocateColGroupList(retList);
        ret.recomputeNonZeros();
        return ret;
    }

    @Override
    public MatrixBlock reorgOperations(ReorgOperator op, MatrixValue ret, int startRow, int startColumn, int length) {
        CompressedMatrixBlock.printDecompressWarning(op.getClass().getSimpleName() + " -- " + op.fn.getClass().getSimpleName());
        MatrixBlock tmp = this.decompress(op.getNumThreads());
        return tmp.reorgOperations(op, ret, startRow, startColumn, length);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompressedMatrixBlock:");
        sb.append("\nCols:" + this.getNumColumns() + " Rows:" + this.getNumRows() + " Overlapping: " + this.isOverlapping() + " nnz: " + this.nonZeros);
        if (this._colGroups != null) {
            for (AColGroup cg : this._colGroups) {
                sb.append("\n" + cg);
            }
        } else {
            sb.append("\nEmptyColGroups");
        }
        return sb.toString();
    }

    public boolean isOverlapping() {
        return this._colGroups.size() != 1 && this.overlappingColGroups;
    }

    public void setOverlapping(boolean overlapping) {
        this.overlappingColGroups = overlapping;
    }

    @Override
    public MatrixBlock slice(int rl, int ru, int cl, int cu, boolean deep, MatrixBlock ret) {
        this.validateSliceArgument(rl, ru, cl, cu);
        return CLALibSlice.slice(this, rl, ru, cl, cu, deep);
    }

    @Override
    public void slice(ArrayList<IndexedMatrixValue> outlist, IndexRange range, int rowCut, int colCut, int blen, int boundaryRlen, int boundaryClen) {
        MatrixBlock tmp = this.getUncompressed("slice for distribution to spark. (Could be implemented such that it does not decompress)");
        tmp.slice(outlist, range, rowCut, colCut, blen, boundaryRlen, boundaryClen);
    }

    @Override
    public MatrixBlock unaryOperations(UnaryOperator op, MatrixValue result) {
        return CLALibUnary.unaryOperations(this, op, result);
    }

    @Override
    public boolean containsValue(double pattern) {
        if (this.isOverlapping()) {
            return this.getUncompressed("ContainsValue").containsValue(pattern);
        }
        for (AColGroup g : this._colGroups) {
            if (!g.containsValue(pattern)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double max() {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uamax", 1);
        return this.aggregateUnaryOperations(op, null, 1000, null).getValue(0, 0);
    }

    @Override
    public double min() {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uamin", 1);
        return this.aggregateUnaryOperations(op, null, 1000, null).getValue(0, 0);
    }

    @Override
    public double sum() {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uak+", 1);
        return this.aggregateUnaryOperations(op, null, 1000, null).getValue(0, 0);
    }

    @Override
    public MatrixBlock colSum() {
        MatrixBlock res = new MatrixBlock(1, this.getNumColumns(), false);
        res.allocateDenseBlock();
        double[] resV = res.getDenseBlockValues();
        AColGroup.colSum(this._colGroups, resV, this.getNumRows());
        res.recomputeNonZeros();
        return res;
    }

    @Override
    public double sumSq() {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uasqk+", 1);
        return this.aggregateUnaryOperations(op, null, 1000, null).getValue(0, 0);
    }

    @Override
    public double prod() {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("ua*", 1);
        return this.aggregateUnaryOperations(op, null, 1000, null).getValue(0, 0);
    }

    @Override
    public double mean() {
        AggregateUnaryOperator op = InstructionUtils.parseBasicAggregateUnaryOperator("uamean", 1);
        return this.aggregateUnaryOperations(op, null, 1000, null).getValue(0, 0);
    }

    @Override
    public MatrixBlock rexpandOperations(MatrixBlock ret, double max, boolean rows, boolean cast, boolean ignore, int k) {
        return CLALibRexpand.rexpand(this, ret, max, rows, cast, ignore, k);
    }

    @Override
    public boolean isEmptyBlock(boolean safe) {
        long nonZeros = this.getNonZeros();
        return this._colGroups == null || nonZeros == 0L || nonZeros == -1L && this.recomputeNonZeros() == 0L;
    }

    @Override
    public MatrixBlock binaryOperationsInPlace(BinaryOperator op, MatrixValue thatValue) {
        CompressedMatrixBlock.printDecompressWarning("binaryOperationsInPlace", (MatrixBlock)thatValue);
        MatrixBlock left = new MatrixBlock();
        left.copy(this.getUncompressed());
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(thatValue);
        left.binaryOperationsInPlace(op, right);
        return left;
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue correction, MatrixValue newWithCorrection, boolean deep) {
        CompressedMatrixBlock.printDecompressWarning("IncrementalAggregate not supported");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock correctionMatrixBlock = CompressedMatrixBlock.getUncompressed(correction);
        MatrixBlock newWithCorrectionMatrixBlock = CompressedMatrixBlock.getUncompressed(newWithCorrection);
        left.incrementalAggregate(aggOp, correctionMatrixBlock, newWithCorrectionMatrixBlock, deep);
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue newWithCorrection) {
        CompressedMatrixBlock.printDecompressWarning("IncrementalAggregate not supported");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock newWithCorrectionMatrixBlock = CompressedMatrixBlock.getUncompressed(newWithCorrection);
        left.incrementalAggregate(aggOp, newWithCorrectionMatrixBlock);
    }

    @Override
    public void permutationMatrixMultOperations(MatrixValue m2Val, MatrixValue out1Val, MatrixValue out2Val, int k) {
        CompressedMatrixBlock.printDecompressWarning("permutationMatrixMultOperations", (MatrixBlock)m2Val);
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(m2Val);
        left.permutationMatrixMultOperations(right, out1Val, out2Val, k);
    }

    @Override
    public MatrixBlock leftIndexingOperations(MatrixBlock rhsMatrix, int rl, int ru, int cl, int cu, MatrixBlock ret, MatrixObject.UpdateType update) {
        CompressedMatrixBlock.printDecompressWarning("leftIndexingOperations");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(rhsMatrix);
        return left.leftIndexingOperations(right, rl, ru, cl, cu, ret, update);
    }

    @Override
    public MatrixBlock leftIndexingOperations(ScalarObject scalar, int rl, int cl, MatrixBlock ret, MatrixObject.UpdateType update) {
        CompressedMatrixBlock.printDecompressWarning("leftIndexingOperations");
        MatrixBlock tmp = this.getUncompressed();
        return tmp.leftIndexingOperations(scalar, rl, cl, ret, update);
    }

    @Override
    public MatrixBlock zeroOutOperations(MatrixValue result, IndexRange range, boolean complementary) {
        CompressedMatrixBlock.printDecompressWarning("zeroOutOperations");
        MatrixBlock tmp = this.getUncompressed();
        return tmp.zeroOutOperations(result, range, complementary);
    }

    @Override
    public CM_COV_Object cmOperations(CMOperator op) {
        return CLALibCMOps.centralMoment(this, op);
    }

    @Override
    public CM_COV_Object cmOperations(CMOperator op, MatrixBlock weights) {
        CompressedMatrixBlock.printDecompressWarning("cmOperations");
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(weights);
        if (this.isEmpty()) {
            return super.cmOperations(op, right);
        }
        AColGroup grp = this._colGroups.get(0);
        if (grp instanceof ColGroupUncompressed) {
            return ((ColGroupUncompressed)grp).getData().cmOperations(op, right);
        }
        return this.getUncompressed().cmOperations(op, right);
    }

    @Override
    public CM_COV_Object covOperations(COVOperator op, MatrixBlock that) {
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(that);
        return this.getUncompressed("covOperations", op.getNumThreads()).covOperations(op, right);
    }

    @Override
    public CM_COV_Object covOperations(COVOperator op, MatrixBlock that, MatrixBlock weights) {
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(that);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(weights);
        return this.getUncompressed("covOperations", op.getNumThreads()).covOperations(op, right1, right2);
    }

    @Override
    public MatrixBlock sortOperations(MatrixValue weights, MatrixBlock result) {
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(weights);
        return this.getUncompressed("sortOperations").sortOperations(right, result);
    }

    @Override
    public MatrixBlock aggregateTernaryOperations(MatrixBlock m1, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret, AggregateTernaryOperator op, boolean inCP) {
        boolean m1C = m1 instanceof CompressedMatrixBlock;
        boolean m2C = m2 instanceof CompressedMatrixBlock;
        boolean m3C = m3 instanceof CompressedMatrixBlock;
        CompressedMatrixBlock.printDecompressWarning("aggregateTernaryOperations " + op.aggOp.getClass().getSimpleName() + " " + op.indexFn.getClass().getSimpleName() + " " + op.aggOp.increOp.fn.getClass().getSimpleName() + " " + op.binaryFn.getClass().getSimpleName() + " m1,m2,m3 " + m1C + " " + m2C + " " + m3C);
        MatrixBlock left = CompressedMatrixBlock.getUncompressed(m1);
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(m2);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(m3);
        ret = left.aggregateTernaryOperations(left, right1, right2, ret, op, inCP);
        if (ret.getNumRows() == 0 || ret.getNumColumns() == 0) {
            throw new DMLCompressionException("Invalid output");
        }
        return ret;
    }

    @Override
    public MatrixBlock uaggouterchainOperations(MatrixBlock mbLeft, MatrixBlock mbRight, MatrixBlock mbOut, BinaryOperator bOp, AggregateUnaryOperator uaggOp) {
        CompressedMatrixBlock.printDecompressWarning("uaggouterchainOperations");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(mbRight);
        return left.uaggouterchainOperations(left, right, mbOut, bOp, uaggOp);
    }

    @Override
    public MatrixBlock groupedAggOperations(MatrixValue tgt, MatrixValue wghts, MatrixValue ret, int ngroups, Operator op, int k) {
        CompressedMatrixBlock.printDecompressWarning("groupedAggOperations");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(wghts);
        return left.groupedAggOperations(left, right, ret, ngroups, op, k);
    }

    @Override
    public MatrixBlock removeEmptyOperations(MatrixBlock ret, boolean rows, boolean emptyReturn, MatrixBlock select) {
        CompressedMatrixBlock.printDecompressWarning("removeEmptyOperations");
        MatrixBlock tmp = this.getUncompressed();
        return tmp.removeEmptyOperations(ret, rows, emptyReturn, select);
    }

    @Override
    public void ctableOperations(Operator op, double scalar, MatrixValue that, CTableMap resultMap, MatrixBlock resultBlock) {
        CompressedMatrixBlock.printDecompressWarning("ctableOperations Var 1");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(that);
        left.ctableOperations(op, scalar, (MatrixValue)right, resultMap, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, double scalar, double scalar2, CTableMap resultMap, MatrixBlock resultBlock) {
        CompressedMatrixBlock.printDecompressWarning("ctableOperations Var 2");
        MatrixBlock tmp = this.getUncompressed();
        tmp.ctableOperations(op, scalar, scalar2, resultMap, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, MatrixIndexes ix1, double scalar, boolean left, int brlen, CTableMap resultMap, MatrixBlock resultBlock) {
        CompressedMatrixBlock.printDecompressWarning("ctableOperations Var 3");
        MatrixBlock tmp = this.getUncompressed();
        tmp.ctableOperations(op, ix1, scalar, left, brlen, resultMap, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, MatrixValue that, double scalar, boolean ignoreZeros, CTableMap resultMap, MatrixBlock resultBlock) {
        CompressedMatrixBlock.printDecompressWarning("ctableOperations Var 4");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(that);
        left.ctableOperations(op, right, scalar, ignoreZeros, resultMap, resultBlock);
    }

    @Override
    public MatrixBlock ctableSeqOperations(MatrixValue thatMatrix, double thatScalar, MatrixBlock resultBlock, boolean updateClen) {
        CompressedMatrixBlock.printDecompressWarning("ctableOperations Var 5");
        MatrixBlock left = this.getUncompressed();
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(thatMatrix);
        return left.ctableSeqOperations(right, thatScalar, resultBlock, updateClen);
    }

    @Override
    public void ctableOperations(Operator op, MatrixValue that, MatrixValue that2, CTableMap resultMap, MatrixBlock resultBlock) {
        MatrixBlock left = this.getUncompressed("ctableOperations Var 7");
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(that);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(that2);
        left.ctableOperations(op, right1, (MatrixValue)right2, resultMap, resultBlock);
    }

    @Override
    public MatrixBlock ternaryOperations(TernaryOperator op, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret) {
        boolean PM_Or_MM;
        int r1 = this.getNumRows();
        int r2 = m2.getNumRows();
        int r3 = m3.getNumRows();
        int c1 = this.getNumColumns();
        int c2 = m2.getNumColumns();
        int c3 = m3.getNumColumns();
        boolean s1 = r1 == 1 && c1 == 1;
        boolean s2 = r2 == 1 && c2 == 1;
        boolean s3 = r3 == 1 && c3 == 1;
        double d1 = s1 ? this.quickGetValue(0, 0) : Double.NaN;
        double d2 = s2 ? m2.quickGetValue(0, 0) : Double.NaN;
        double d3 = s3 ? m3.quickGetValue(0, 0) : Double.NaN;
        int m = Math.max(Math.max(r1, r2), r3);
        int n = Math.max(Math.max(c1, c2), c3);
        CompressedMatrixBlock.ternaryOperationCheck(s1, s2, s3, m, r1, r2, r3, n, c1, c2, c3);
        boolean bl = PM_Or_MM = op.fn instanceof PlusMultiply || op.fn instanceof MinusMultiply;
        if (PM_Or_MM && (s2 && d2 == 0.0 || s3 && d3 == 0.0)) {
            ret = new CompressedMatrixBlock();
            ret.copy(this);
            return ret;
        }
        if (m2 instanceof CompressedMatrixBlock) {
            m2 = ((CompressedMatrixBlock)m2).getUncompressed("Ternary Operator arg2 " + op.fn.getClass().getSimpleName(), op.getNumThreads());
        }
        if (m3 instanceof CompressedMatrixBlock) {
            m3 = ((CompressedMatrixBlock)m3).getUncompressed("Ternary Operator arg3 " + op.fn.getClass().getSimpleName(), op.getNumThreads());
        }
        if (s2 != s3 && (op.fn instanceof PlusMultiply || op.fn instanceof MinusMultiply)) {
            BinaryOperator bop = ((TernaryValueFunction.ValueFunctionWithConstant)((Object)op.fn)).setOp2Constant(s2 ? d2 : d3);
            bop.setNumThreads(op.getNumThreads());
            ret = CLALibBinaryCellOp.binaryOperationsRight(bop, this, s2 ? m3 : m2, ret);
        } else {
            boolean sparseOutput = CompressedMatrixBlock.evalSparseFormatInMemory(m, n, (s1 ? (long)(m * n * (d1 != 0.0 ? 1 : 0)) : this.getNonZeros()) + Math.min(s2 ? (long)(m * n) : m2.getNonZeros(), s3 ? (long)(m * n) : m3.getNonZeros()));
            ret.reset(m, n, sparseOutput);
            MatrixBlock thisUncompressed = this.getUncompressed("Ternary Operation not supported");
            LibMatrixTercell.tercellOp(thisUncompressed, m2, m3, ret, op);
            ret.examSparsity();
        }
        return ret;
    }

    @Override
    public MatrixBlock quaternaryOperations(QuaternaryOperator qop, MatrixBlock um, MatrixBlock vm, MatrixBlock wm, MatrixBlock out, int k) {
        MatrixBlock left = this.getUncompressed("quaternaryOperations");
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(um);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(vm);
        MatrixBlock right3 = CompressedMatrixBlock.getUncompressed(wm);
        return left.quaternaryOperations(qop, right1, right2, right3, out, k);
    }

    @Override
    public MatrixBlock randOperationsInPlace(RandomMatrixGenerator rgen, Well1024a bigrand, long bSeed) {
        LOG.info((Object)"Inplace rand ops not on CompressedMatrix");
        MatrixBlock ret = new MatrixBlock(this.getNumRows(), this.getNumColumns(), true);
        LibMatrixDatagen.generateRandomMatrix(ret, rgen, bigrand, bSeed);
        return ret;
    }

    @Override
    public MatrixBlock randOperationsInPlace(RandomMatrixGenerator rgen, Well1024a bigrand, long bSeed, int k) {
        LOG.info((Object)"Inplace rand ops not on CompressedMatrix");
        MatrixBlock ret = new MatrixBlock(this.getNumRows(), this.getNumColumns(), true);
        LibMatrixDatagen.generateRandomMatrix(ret, rgen, bigrand, bSeed, k);
        return ret;
    }

    @Override
    public MatrixBlock seqOperationsInPlace(double from, double to, double incr) {
        throw new DMLRuntimeException("CompressedMatrixBlock: seqOperationsInPlace not supported.");
    }

    private static boolean isCompressed(MatrixBlock mb) {
        return mb instanceof CompressedMatrixBlock;
    }

    public static MatrixBlock getUncompressed(MatrixValue mVal) {
        return CompressedMatrixBlock.isCompressed((MatrixBlock)mVal) ? ((CompressedMatrixBlock)mVal).getUncompressed() : (MatrixBlock)mVal;
    }

    public static MatrixBlock getUncompressed(MatrixValue mVal, String message) {
        return CompressedMatrixBlock.isCompressed((MatrixBlock)mVal) ? ((CompressedMatrixBlock)mVal).getUncompressed(message) : (MatrixBlock)mVal;
    }

    public MatrixBlock getUncompressed() {
        return this.getUncompressed(null);
    }

    public MatrixBlock getUncompressed(String operation) {
        return this.getUncompressed(operation, ConfigurationManager.isParallelMatrixOperations() ? InfrastructureAnalyzer.getLocalParallelism() : 1);
    }

    public MatrixBlock getUncompressed(String operation, int k) {
        MatrixBlock d_compressed = this.getCachedDecompressed();
        if (d_compressed != null) {
            return d_compressed;
        }
        if (operation != null) {
            CompressedMatrixBlock.printDecompressWarning(operation);
        }
        if (this.isEmpty()) {
            return new MatrixBlock(this.getNumRows(), this.getNumColumns(), true);
        }
        return this.decompress(k);
    }

    private static void printDecompressWarning(String operation) {
        LOG.warn((Object)("Decompressing because: " + operation));
    }

    private static void printDecompressWarning(String operation, MatrixBlock m2) {
        if (CompressedMatrixBlock.isCompressed(m2)) {
            CompressedMatrixBlock.printDecompressWarning(operation);
        }
    }

    @Override
    public boolean isShallowSerialize(boolean inclConvert) {
        return true;
    }

    @Override
    public void toShallowSerializeBlock() {
    }

    @Override
    public void copy(MatrixValue thatValue) {
        this.copy(thatValue, false);
    }

    private static CompressedMatrixBlock checkType(MatrixValue thatValue) {
        if (thatValue == null || !(thatValue instanceof CompressedMatrixBlock)) {
            throw new DMLRuntimeException("Invalid call to copy, require a compressed MatrixBlock to copy to");
        }
        return (CompressedMatrixBlock)thatValue;
    }

    @Override
    public void copy(MatrixValue thatValue, boolean sp) {
        CompressedMatrixBlock that = CompressedMatrixBlock.checkType(thatValue);
        if (this == that) {
            throw new RuntimeException("Copy must not overwrite itself!");
        }
        this.copyCompressedMatrix(that);
    }

    @Override
    public MatrixBlock copyShallow(MatrixBlock that) {
        if (that instanceof CompressedMatrixBlock) {
            throw new NotImplementedException();
        }
        throw new DMLCompressionException("Invalid copy shallow, since the matrixBlock given is not of type CompressedMatrixBlock");
    }

    @Override
    public void copy(int rl, int ru, int cl, int cu, MatrixBlock src, boolean awareDestNZ) {
        throw new DMLCompressionException("Invalid copy into CompressedMatrixBlock");
    }

    private void copyCompressedMatrix(CompressedMatrixBlock that) {
        this.rlen = that.getNumRows();
        this.clen = that.getNumColumns();
        this.sparseBlock = null;
        this.denseBlock = null;
        this.nonZeros = that.getNonZeros();
        this._colGroups = new ArrayList<AColGroup>(that.getColGroups().size());
        for (AColGroup cg : that._colGroups) {
            this._colGroups.add(cg);
        }
        this.overlappingColGroups = that.overlappingColGroups;
    }

    public SoftReference<MatrixBlock> getSoftReferenceToDecompressed() {
        return this.decompressedVersion;
    }

    public void clearSoftReferenceToDecompressed() {
        this.decompressedVersion = null;
    }

    @Override
    public DenseBlock getDenseBlock() {
        throw new DMLCompressionException("Should not get DenseBlock on a compressed Matrix");
    }

    @Override
    public void setDenseBlock(DenseBlock dblock) {
        throw new DMLCompressionException("Should not set DenseBlock on a compressed Matrix");
    }

    @Override
    public double[] getDenseBlockValues() {
        throw new DMLCompressionException("Should not get DenseBlock values on a compressed Matrix");
    }

    @Override
    public SparseBlock getSparseBlock() {
        throw new DMLCompressionException("Should not get SparseBlock on a compressed Matrix");
    }

    @Override
    public void setSparseBlock(SparseBlock sblock) {
        throw new DMLCompressionException("Should not set SparseBlock on a compressed Matrix");
    }

    @Override
    public Iterator<IJV> getSparseBlockIterator() {
        throw new DMLCompressionException("Should not get SparseBlockIterator on a compressed Matrix");
    }

    @Override
    public Iterator<IJV> getSparseBlockIterator(int rl, int ru) {
        throw new DMLCompressionException("Should not get SparseBlockIterator on a compressed Matrix");
    }

    @Override
    public void quickSetValue(int r, int c, double v) {
        throw new DMLCompressionException("Should not set a value on a compressed Matrix");
    }

    @Override
    public double quickGetValueThreadSafe(int r, int c) {
        throw new DMLCompressionException("Thread safe execution does not work on Compressed Matrix");
    }

    @Override
    public double getValueDenseUnsafe(int r, int c) {
        throw new DMLCompressionException("Compressed Matrix does not have a dense matrix block");
    }

    @Override
    public void appendValue(int r, int c, double v) {
        throw new DMLCompressionException("Cant append value to compressed Matrix");
    }

    @Override
    public void appendValuePlain(int r, int c, double v) {
        throw new DMLCompressionException("Can't append value to compressed Matrix");
    }

    @Override
    public void appendRow(int r, SparseRow row, boolean deep) {
        throw new DMLCompressionException("Can't append row to compressed Matrix");
    }

    @Override
    public void appendRowToSparse(SparseBlock dest, MatrixBlock src, int i, int rowoffset, int coloffset, boolean deep) {
        throw new DMLCompressionException("Can't append row to compressed Matrix");
    }

    @Override
    public void sortSparseRows() {
        throw new DMLCompressionException("It does not make sense to sort the rows in a compressed matrix");
    }

    @Override
    public void sortSparseRows(int rl, int ru) {
        throw new DMLCompressionException("It does not make sense to sort the rows in a compressed matrix");
    }

    @Override
    public double minNonZero() {
        throw new NotImplementedException();
    }

    @Override
    public boolean isInSparseFormat() {
        return false;
    }

    @Override
    public boolean isUltraSparse() {
        return false;
    }

    @Override
    public boolean isUltraSparse(boolean checkNnz) {
        return false;
    }

    @Override
    public boolean isSparsePermutationMatrix() {
        return false;
    }

    @Override
    public boolean evalSparseFormatInMemory() {
        return false;
    }

    @Override
    public boolean evalSparseFormatOnDisk() {
        return false;
    }

    @Override
    public void examSparsity(boolean allowCSR) {
    }

    @Override
    public void sparseToDense() {
    }

    @Override
    public void merge(MatrixBlock that, boolean appendOnly, boolean par, boolean deep) {
        throw new NotImplementedException();
    }

    @Override
    public void compactEmptyBlock() {
        if (this.isEmptyBlock(false)) {
            this.cleanupBlock(true, true);
            CLALibUtils.combineConstColumns(this);
            this.overlappingColGroups = false;
            this.decompressedVersion = null;
        }
    }

    @Override
    public void dropLastRowsOrColumns(Types.CorrectionLocationType correctionLocation) {
        throw new NotImplementedException();
    }

    @Override
    public double interQuartileMean() {
        return this.getUncompressed("interQuartileMean").interQuartileMean();
    }

    @Override
    public MatrixBlock pickValues(MatrixValue quantiles, MatrixValue ret) {
        return this.getUncompressed("pickValues").pickValues(quantiles, ret);
    }

    @Override
    public double pickValue(double quantile, boolean average) {
        return this.getUncompressed("pickValue").pickValue(quantile, average);
    }

    @Override
    public double sumWeightForQuantile() {
        return this.getUncompressed("sumWeightForQuantile").sumWeightForQuantile();
    }

    @Override
    public MatrixBlock extractTriangular(MatrixBlock ret, boolean lower, boolean diag, boolean values) {
        return this.getUncompressed("extractTriangular").extractTriangular(ret, lower, diag, values);
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public void checkNaN() {
        throw new NotImplementedException();
    }

    @Override
    public void init(double[][] arr, int r, int c) {
        throw new DMLCompressionException("Invalid to init on a compressed MatrixBlock");
    }

    @Override
    public void init(double[] arr, int r, int c) {
        throw new DMLCompressionException("Invalid to init on a compressed MatrixBlock");
    }

    @Override
    public boolean isAllocated() {
        return true;
    }

    @Override
    public Future<MatrixBlock> allocateBlockAsync() {
        throw new DMLCompressionException("Invalid to allocate dense block on a compressed MatrixBlock");
    }

    @Override
    public boolean allocateDenseBlock(boolean clearNNZ) {
        throw new DMLCompressionException("Invalid to allocate dense block on a compressed MatrixBlock");
    }

    @Override
    public boolean allocateSparseRowsBlock(boolean clearNNZ) {
        throw new DMLCompressionException("Invalid to allocate sparse block on a compressed MatrixBlock");
    }

    @Override
    public void allocateAndResetSparseBlock(boolean clearNNZ, SparseBlock.Type stype) {
        throw new DMLCompressionException("Invalid to allocate block on a compressed MatrixBlock");
    }
}

