/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.indexes;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.colgroup.indexes.AColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.ArrayIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IIterate;
import org.apache.sysds.runtime.compress.colgroup.indexes.SingleIndex;

public class TwoIndex
extends AColIndex {
    private final int id1;
    private final int id2;

    public TwoIndex(int id1, int id2) {
        this.id1 = id1;
        this.id2 = id2;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public int get(int i) {
        if (i == 0) {
            return this.id1;
        }
        return this.id2;
    }

    @Override
    public TwoIndex shift(int i) {
        return new TwoIndex(this.id1 + i, this.id2 + i);
    }

    @Override
    public IIterate iterator() {
        return new TwoIterator();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(IColIndex.ColIndexType.TWO.ordinal());
        out.writeInt(this.id1);
        out.writeInt(this.id2);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9L;
    }

    @Override
    public long estimateInMemorySize() {
        return TwoIndex.estimateInMemorySizeStatic();
    }

    public static long estimateInMemorySizeStatic() {
        return 24L;
    }

    @Override
    public int findIndex(int i) {
        if (i < this.id1) {
            return -1;
        }
        if (i == this.id1) {
            return 0;
        }
        if (i < this.id2) {
            return -2;
        }
        if (i == this.id2) {
            return 1;
        }
        return -3;
    }

    @Override
    public IColIndex.SliceResult slice(int l, int u) {
        IColIndex.SliceResult ret = l <= this.id1 && u > this.id2 ? new IColIndex.SliceResult(0, 2, l == 0 ? this : new TwoIndex(this.id1 - l, this.id2 - l)) : (l <= this.id1 && u > this.id1 ? new IColIndex.SliceResult(0, 1, new SingleIndex(this.id1 - l)) : (l <= this.id2 && u > this.id2 ? new IColIndex.SliceResult(1, 2, new SingleIndex(this.id2 - l)) : new IColIndex.SliceResult(0, 0, null)));
        return ret;
    }

    @Override
    public boolean equals(IColIndex other) {
        return other.size() == 2 && other.get(0) == this.id1 && other.get(1) == this.id2;
    }

    @Override
    public IColIndex combine(IColIndex other) {
        if (other instanceof SingleIndex) {
            int otherV = other.get(0);
            if (otherV < this.id1) {
                return new ArrayIndex(new int[]{otherV, this.id1, this.id2});
            }
            if (otherV < this.id2) {
                return new ArrayIndex(new int[]{this.id1, otherV, this.id2});
            }
            return new ArrayIndex(new int[]{this.id1, this.id2, otherV});
        }
        if (other instanceof TwoIndex) {
            int[] vals = new int[]{other.get(0), other.get(1), this.id1, this.id2};
            Arrays.sort(vals);
            return new ArrayIndex(vals);
        }
        return other.combine(this);
    }

    @Override
    public boolean isContiguous() {
        return this.id1 + 1 == this.id2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        sb.append(this.id1);
        sb.append(", ");
        sb.append(this.id2);
        sb.append("]");
        return sb.toString();
    }

    protected class TwoIterator
    implements IIterate {
        int id = 0;

        protected TwoIterator() {
        }

        @Override
        public int next() {
            if (this.id++ == 0) {
                return TwoIndex.this.id1;
            }
            return TwoIndex.this.id2;
        }

        @Override
        public boolean hasNext() {
            return this.id < 2;
        }
    }
}

