/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.controllers;

import io.netty.handler.codec.http.FullHttpResponse;
import java.util.List;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.Request;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.Response;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.controllers.IController;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.WorkerModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.services.MapperService;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.services.WorkerService;

public class WorkerController
implements IController {
    private final WorkerService workerService = new WorkerService();

    @Override
    public FullHttpResponse create(Request request) {
        WorkerModel model = MapperService.getModelFromBody(request, WorkerModel.class);
        model.id = this.workerService.create(model);
        return Response.ok(model.toString());
    }

    @Override
    public FullHttpResponse update(Request request, Long objectId) {
        WorkerModel result = this.workerService.get(objectId);
        if (result == null) {
            return Response.notFound("{\"message\": \"Entity not found\"}");
        }
        WorkerModel model = MapperService.getModelFromBody(request, WorkerModel.class);
        model.id = objectId;
        model.address = model.address == null ? result.address : model.address;
        model.name = model.name == null ? result.name : model.name;
        this.workerService.update(model);
        model.setOnlineStatus(this.workerService.getWorkerOnlineStatus(model.id));
        return Response.ok(model.toString());
    }

    @Override
    public FullHttpResponse delete(Request request, Long objectId) {
        this.workerService.remove(objectId);
        return Response.ok("{\"message\": \"Success\"}");
    }

    @Override
    public FullHttpResponse get(Request request, Long objectId) {
        WorkerModel result = this.workerService.get(objectId);
        if (result == null) {
            return Response.notFound("{\"message\": \"Entity not found\"}");
        }
        result.setOnlineStatus(this.workerService.getWorkerOnlineStatus(result.id));
        return Response.ok(result.toString());
    }

    @Override
    public FullHttpResponse getAll(Request request) {
        List<WorkerModel> workers = this.workerService.getAll();
        for (WorkerModel worker : workers) {
            worker.setOnlineStatus(this.workerService.getWorkerOnlineStatus(worker.id));
        }
        return Response.ok(workers.toString());
    }
}

