/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.columns.ABooleanArray;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.BooleanArray;
import org.apache.sysds.runtime.frame.data.columns.CharArray;
import org.apache.sysds.runtime.frame.data.columns.DoubleArray;
import org.apache.sysds.runtime.frame.data.columns.FloatArray;
import org.apache.sysds.runtime.frame.data.columns.IntegerArray;
import org.apache.sysds.runtime.frame.data.columns.LongArray;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.frame.data.columns.StringArray;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class BitSetArray
extends ABooleanArray {
    private static final boolean useVectorizedKernel = true;
    long[] _data;

    protected BitSetArray(int size) {
        this(new long[BitSetArray.longSize(size)], size);
    }

    public BitSetArray(boolean[] data) {
        super(data.length);
        this._data = new long[BitSetArray.longSize(this._size)];
        for (int i = 0; i < data.length; ++i) {
            if (!data[i]) continue;
            this.set(i, true);
        }
    }

    public BitSetArray(long[] data, int size) {
        super(size);
        this._data = data;
        if (this._size > this._data.length * 64) {
            throw new DMLRuntimeException("Invalid allocation long array must be long enough");
        }
        if (this._data.length > BitSetArray.longSize(this._size)) {
            throw new DMLRuntimeException("Invalid allocation long array must not be to long: " + this._data.length + " " + this._size + " " + BitSetArray.longSize(this._size));
        }
    }

    private static int longSize(int size) {
        return Math.max(size >> 6, 0) + 1;
    }

    public BitSetArray(BitSet data, int size) {
        super(size);
        this._data = BitSetArray.toLongArrayPadded(data, size);
    }

    @Override
    public BitSet get() {
        return BitSet.valueOf(this._data);
    }

    public long[] getLongs() {
        return this._data;
    }

    @Override
    public Boolean get(int index) {
        if (index >= this._size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int wIdx = index >> 6;
        return (this._data[wIdx] & 1L << index) != 0L;
    }

    @Override
    public void set(int index, Boolean value) {
        this.set(index, value != null && value != false);
    }

    @Override
    public synchronized void set(int index, boolean value) {
        int wIdx = index >> 6;
        if (value) {
            int n = wIdx;
            this._data[n] = this._data[n] | 1L << index;
        } else {
            int n = wIdx;
            this._data[n] = this._data[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    @Override
    public void set(int index, double value) {
        this.set(index, value == 1.0);
    }

    @Override
    public void set(int index, String value) {
        this.set(index, BooleanArray.parseBoolean(value));
    }

    @Override
    public void set(int rl, int ru, Array<Boolean> value) {
        this.set(rl, ru, value, 0);
    }

    @Override
    public void setFromOtherType(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            this.set(i, UtilFunctions.objectToBoolean(vt, value.get(i)));
        }
    }

    private static long[] toLongArrayPadded(BitSet data, int minLength) {
        int len;
        long[] ret = data.toLongArray();
        if (ret.length != (len = minLength / 64 + 1)) {
            return Arrays.copyOf(ret, len);
        }
        return ret;
    }

    @Override
    public void set(int rl, int ru, Array<Boolean> value, int rlSrc) {
        if (value instanceof BitSetArray && ru - rl >= 64) {
            this.setVectorized(rl, ru, (BitSetArray)value, rlSrc);
        } else {
            int i = rl;
            int off = rlSrc;
            while (i <= ru) {
                this.set(i, value.get(off));
                ++i;
                ++off;
            }
        }
    }

    private void setVectorized(int rl, int ru, BitSetArray value, int rlSrc) {
        int rangeLength = ru - rl + 1;
        BitSetArray v = value.slice(rlSrc, rangeLength + rlSrc);
        long[] otherValues = v.getLongs();
        this.setVectorizedLongs(rl, ru, otherValues);
    }

    private void setVectorizedLongs(int rl, int ru, long[] ov) {
        long remainder = (long)rl % 64L;
        if (remainder == 0L) {
            this.setVectorizedLongsNoOffset(rl, ru, ov);
        } else {
            this.setVectorizedLongsWithOffset(rl, ru, ov);
        }
    }

    private void setVectorizedLongsNoOffset(int rl, int ru, long[] ov) {
        long remainderEnd = (long)(ru + 1) % 64L;
        long remainderEndInv = 64L - remainderEnd;
        int last = ov.length - 1;
        int retP = rl / 64;
        int j = 0;
        while (j < last) {
            this._data[retP] = ov[j];
            ++j;
            ++retP;
        }
        if (remainderEnd != 0L) {
            long r = this._data[retP] >>> (int)remainderEnd << (int)remainderEnd;
            long v = ov[last] << (int)remainderEndInv >>> (int)remainderEndInv;
            this._data[retP] = r ^ v;
        } else {
            this._data[retP] = ov[last];
        }
    }

    private void setVectorizedLongsWithOffset(int rl, int ru, long[] ov) {
        long remainder = (long)rl % 64L;
        long invRemainder = 64L - remainder;
        int last = ov.length - 1;
        int lastP = (ru + 1) / 64;
        long finalOriginal = this._data[lastP];
        int retP = rl / 64;
        this._data[retP] = this._data[retP] << (int)invRemainder >>> (int)invRemainder;
        for (int j = 0; j < last; ++j) {
            long v = ov[j];
            this._data[retP] = this._data[retP] ^ v << (int)remainder;
            this._data[++retP] = v >>> (int)invRemainder;
        }
        this._data[retP] = ov[last] << (int)remainder ^ this._data[retP];
        if (++retP < this._data.length && retP <= lastP) {
            this._data[retP] = ov[last] >>> (int)invRemainder;
        }
        long remainderEnd = (long)(ru + 1) % 64L;
        long remainderEndInv = 64L - remainderEnd;
        this._data[lastP] = this._data[lastP] << (int)remainderEndInv >>> (int)remainderEndInv;
        this._data[lastP] = this._data[lastP] ^ finalOriginal >>> (int)remainderEnd << (int)remainderEnd;
    }

    @Override
    public void setNz(int rl, int ru, Array<Boolean> value) {
        if (value instanceof BooleanArray) {
            boolean[] data2 = ((BooleanArray)value)._data;
            for (int i = rl; i <= ru; ++i) {
                if (!data2[i]) continue;
                this.set(i, data2[i]);
            }
        } else {
            for (int i = rl; i <= ru; ++i) {
                boolean v = value.get(i);
                if (!v) continue;
                this.set(i, v);
            }
        }
    }

    @Override
    public void setFromOtherTypeNz(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            boolean v = UtilFunctions.objectToBoolean(vt, value.get(i));
            if (!v) continue;
            this.set(i, v);
        }
    }

    @Override
    public void append(String value) {
        this.append(BooleanArray.parseBoolean(value));
    }

    @Override
    public Array<Boolean> append(Array<Boolean> other) {
        int endSize = this._size + other.size();
        ABooleanArray retBS = ArrayFactory.allocateBoolean(endSize);
        retBS.set(0, this._size - 1, this);
        if (other instanceof OptionalArray) {
            retBS.set(this._size, endSize - 1, ((OptionalArray)other)._a);
            return OptionalArray.appendOther((OptionalArray)other, retBS);
        }
        retBS.set(this._size, endSize - 1, other);
        return retBS;
    }

    @Override
    public void append(Boolean value) {
        if (this._data.length * 64 < this._size + 1) {
            this._data = Arrays.copyOf(this._data, this.newSize());
        }
        this.set(this._size, value);
        ++this._size;
    }

    @Override
    public int newSize() {
        return this._data.length * 2;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.BITSET.ordinal());
        out.writeInt(this._size);
        out.writeInt(this._data.length);
        for (int i = 0; i < this._data.length; ++i) {
            out.writeLong(this._data[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this._size = in.readInt();
        this._data = new long[in.readInt()];
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = in.readLong();
        }
    }

    @Override
    public BitSetArray clone() {
        return new BitSetArray(Arrays.copyOf(this._data, this._size / 64 + 1), this._size);
    }

    @Override
    public BitSetArray slice(int rl, int ru) {
        return ru - rl > 30 ? this.sliceVectorized(rl, ru) : this.sliceSimple(rl, ru);
    }

    private BitSetArray sliceSimple(int rl, int ru) {
        boolean[] ret = new boolean[ru - rl];
        int i = rl;
        int off = 0;
        while (i < ru) {
            ret[off] = this.get(i);
            ++i;
            ++off;
        }
        return new BitSetArray(ret);
    }

    private BitSetArray sliceVectorized(int rl, int ru) {
        boolean aligned;
        long[] ret = new long[(ru - rl) / 64 + 1];
        long BitIndexMask = 63L;
        long lastMask = -1L >>> -ru;
        int tW = (ru - rl - 1 >>> 6) + 1;
        int sI = rl >> 6;
        boolean bl = aligned = ((long)rl & 0x3FL) == 0L;
        if (aligned) {
            int i = 0;
            while (i < tW - 1) {
                ret[i] = this._data[sI];
                ++i;
                ++sI;
            }
        } else {
            int i = 0;
            while (i < tW - 1) {
                ret[i] = this._data[sI] >>> rl | this._data[sI + 1] << -rl;
                ++i;
                ++sI;
            }
        }
        ret[tW - 1] = ((long)(ru - 1) & 0x3FL) < ((long)rl & 0x3FL) ? this._data[sI] >>> rl | (this._data[sI + 1] & lastMask) << -rl : (this._data[sI] & lastMask) >>> rl;
        return new BitSetArray(ret, ru - rl);
    }

    @Override
    public void reset(int size) {
        this._data = new long[size / 64 + 1];
        this._size = size;
    }

    @Override
    public byte[] getAsByteArray() {
        ByteBuffer booleanBuffer = ByteBuffer.allocate(this._size);
        booleanBuffer.order(ByteOrder.nativeOrder());
        for (int i = 0; i < this._size; ++i) {
            booleanBuffer.put((byte)(this.get(i) != false ? 1 : 0));
        }
        return booleanBuffer.array();
    }

    @Override
    public Types.ValueType getValueType() {
        return Types.ValueType.BOOLEAN;
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType() {
        return new Pair<Types.ValueType, Boolean>(Types.ValueType.BOOLEAN, false);
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.BITSET;
    }

    @Override
    public long getInMemorySize() {
        return BitSetArray.estimateInMemorySize(this._size);
    }

    public static long estimateInMemorySize(int nRow) {
        long size = BitSetArray.baseMemoryCost();
        size = (long)((double)size + MemoryEstimates.longArrayCost(nRow >> 7));
        return size;
    }

    @Override
    public long getExactSerializedSize() {
        long size = 9L;
        return size += (long)(this._data.length * 8);
    }

    @Override
    protected Array<Boolean> changeTypeBitSet() {
        return this;
    }

    @Override
    protected Array<Boolean> changeTypeBoolean() {
        boolean[] ret = new boolean[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this.get(i);
        }
        return new BooleanArray(ret);
    }

    @Override
    protected Array<Double> changeTypeDouble() {
        double[] ret = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this.get(i) != false ? 1.0 : 0.0;
        }
        return new DoubleArray(ret);
    }

    @Override
    protected Array<Float> changeTypeFloat() {
        float[] ret = new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this.get(i) != false ? 1.0f : 0.0f;
        }
        return new FloatArray(ret);
    }

    @Override
    protected Array<Integer> changeTypeInteger() {
        int[] ret = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this.get(i) != false ? 1 : 0;
        }
        return new IntegerArray(ret);
    }

    @Override
    protected Array<Long> changeTypeLong() {
        long[] ret = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this.get(i) != false ? 1L : 0L;
        }
        return new LongArray(ret);
    }

    @Override
    protected Array<String> changeTypeString() {
        String[] ret = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this.get(i).toString();
        }
        return new StringArray(ret);
    }

    @Override
    public Array<Character> changeTypeCharacter() {
        char[] ret = new char[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = (char)(this.get(i) != false ? 1 : 0);
        }
        return new CharArray(ret);
    }

    @Override
    public void fill(String value) {
        this.fill(BooleanArray.parseBoolean(value));
    }

    @Override
    public void fill(Boolean value) {
        value = value != null ? value : false;
        for (int i = 0; i < this._size / 64 + 1; ++i) {
            this._data[i] = value != false ? -1L : 0L;
        }
    }

    @Override
    public double getAsDouble(int i) {
        return this.get(i) != false ? 1.0 : 0.0;
    }

    @Override
    public boolean isShallowSerialize() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this._data.length; ++i) {
            if (this._data[i] == 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllTrue() {
        for (int i = 0; i < this._data.length; ++i) {
            if (this._data[i] == -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public ABooleanArray select(int[] indices) {
        boolean[] ret = new boolean[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = this.get(indices[i]);
        }
        return new BitSetArray(ret);
    }

    @Override
    public ABooleanArray select(boolean[] select, int nTrue) {
        boolean[] ret = new boolean[nTrue];
        int k = 0;
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            ret[k++] = this.get(i);
        }
        return new BitSetArray(ret);
    }

    @Override
    public final boolean isNotEmpty(int i) {
        return this.get(i);
    }

    @Override
    public void findEmptyInverse(boolean[] select) {
        for (int i = 0; i < select.length; ++i) {
            if (this.get(i).booleanValue()) continue;
            select[i] = true;
        }
    }

    public static String longToBits(long l) {
        String bits = Long.toBinaryString(l);
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < 64 - bits.length(); ++i) {
            sb.append('0');
        }
        sb.append(bits);
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._size + 10);
        sb.append(super.toString() + ":[");
        for (int i = 0; i < this._size; ++i) {
            sb.append(this.get(i) != false ? 1 : 0);
        }
        sb.append("]");
        return sb.toString();
    }
}

