/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.lang.ref.SoftReference;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ADictBasedColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.operators.CMOperator;

public abstract class AColGroupValue
extends ADictBasedColGroup {
    private static final long serialVersionUID = -6835757655517301955L;
    private SoftReference<int[]> counts = null;

    protected AColGroupValue(IColIndex colIndices, ADictionary dict, int[] cachedCounts) {
        super(colIndices, dict);
        if (cachedCounts != null) {
            this.counts = new SoftReference<int[]>(cachedCounts);
        }
    }

    @Override
    public int getNumValues() {
        return this._dict.getNumberOfValues(this._colIndexes.size());
    }

    public final int[] getCounts() {
        int[] ret = this.getCachedCounts();
        if (ret == null) {
            ret = this.getCounts(new int[this.getNumValues()]);
            this.counts = new SoftReference<int[]>(ret);
        }
        return ret;
    }

    protected final int[] getCachedCounts() {
        return this.counts != null ? this.counts.get() : null;
    }

    protected abstract int[] getCounts(int[] var1);

    @Override
    protected void computeSum(double[] c, int nRows) {
        c[0] = c[0] + this._dict.sum(this.getCounts(), this._colIndexes.size());
    }

    @Override
    public void computeColSums(double[] c, int nRows) {
        this._dict.colSum(c, this.getCounts(), this._colIndexes);
    }

    @Override
    protected void computeSumSq(double[] c, int nRows) {
        c[0] = c[0] + this._dict.sumSq(this.getCounts(), this._colIndexes.size());
    }

    @Override
    protected void computeColSumsSq(double[] c, int nRows) {
        this._dict.colSumSq(c, this.getCounts(), this._colIndexes);
    }

    @Override
    protected void computeProduct(double[] c, int nRows) {
        this._dict.product(c, this.getCounts(), this._colIndexes.size());
    }

    @Override
    protected void computeColProduct(double[] c, int nRows) {
        this._dict.colProduct(c, this.getCounts(), this._colIndexes);
    }

    @Override
    protected double[] preAggSumRows() {
        return this._dict.sumAllRowsToDouble(this._colIndexes.size());
    }

    @Override
    protected double[] preAggSumSqRows() {
        return this._dict.sumAllRowsToDoubleSq(this._colIndexes.size());
    }

    @Override
    protected double[] preAggProductRows() {
        return this._dict.productAllRowsToDouble(this._colIndexes.size());
    }

    @Override
    protected double[] preAggBuiltinRows(Builtin builtin) {
        return this._dict.aggregateRows(builtin, this._colIndexes.size());
    }

    @Override
    protected AColGroup sliceSingleColumn(int idx) {
        IColIndex retIndexes = ColIndexFactory.create(1);
        if (this._colIndexes.size() == 1) {
            return this.copyAndSet(retIndexes, this._dict);
        }
        ADictionary retDict = this._dict.sliceOutColumnRange(idx, idx + 1, this._colIndexes.size());
        if (retDict == null) {
            return new ColGroupEmpty(retIndexes);
        }
        return this.copyAndSet(retIndexes, retDict);
    }

    @Override
    protected AColGroup sliceMultiColumns(int idStart, int idEnd, IColIndex outputCols) {
        ADictionary retDict = this._dict.sliceOutColumnRange(idStart, idEnd, this._colIndexes.size());
        if (retDict == null) {
            return new ColGroupEmpty(outputCols);
        }
        return this.copyAndSet(outputCols, retDict);
    }

    @Override
    protected void tsmm(double[] result, int numColumns, int nRows) {
        int[] counts = this.getCounts();
        AColGroupValue.tsmm(result, numColumns, counts, this._dict, this._colIndexes);
    }

    @Override
    public long getNumberNonZeros(int nRows) {
        int[] counts = this.getCounts();
        return this._dict.getNumberNonZeros(counts, this._colIndexes.size());
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        return size += 8L;
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        ADictionary replaced = this._dict.replace(pattern, replace, this._colIndexes.size());
        return this.copyAndSet(replaced);
    }

    @Override
    public CM_COV_Object centralMoment(CMOperator op, int nRows) {
        return this._dict.centralMoment(op.fn, this.getCounts(), nRows);
    }

    @Override
    public AColGroup rexpandCols(int max, boolean ignore, boolean cast, int nRows) {
        try {
            ADictionary d = this._dict.rexpandCols(max, ignore, cast, this._colIndexes.size());
            if (d == null) {
                return ColGroupEmpty.create(max);
            }
            return this.copyAndSet(ColIndexFactory.create(max), d);
        }
        catch (DMLCompressionException e) {
            return ColGroupEmpty.create(max);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s%s", "Values: ", this._dict.getClass().getSimpleName()));
        sb.append(this._dict.getString(this._colIndexes.size()));
        return sb.toString();
    }
}

