/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.ConnectionPoolKeyStrategy;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Request;
import com.ning.http.client.listenable.AbstractListenableFuture;
import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.ning.http.client.providers.netty.timeout.TimeoutsHolder;
import com.ning.http.util.DateUtil;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NettyResponseFuture<V>
extends AbstractListenableFuture<V> {
    private static final Logger logger = LoggerFactory.getLogger(NettyResponseFuture.class);
    public static final String MAX_RETRY = "com.ning.http.client.providers.netty.maxRetry";
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    private AsyncHandler<V> asyncHandler;
    private final int requestTimeoutInMs;
    private final int idleConnectionTimeoutInMs;
    private Request request;
    private HttpRequest nettyRequest;
    private final AtomicReference<V> content = new AtomicReference();
    private URI uri;
    private boolean keepAlive = true;
    private HttpResponse httpResponse;
    private final AtomicReference<ExecutionException> exEx = new AtomicReference();
    private final AtomicInteger redirectCount = new AtomicInteger();
    private volatile boolean requestTimeoutReached;
    private volatile boolean idleConnectionTimeoutReached;
    private volatile TimeoutsHolder timeoutsHolder;
    private final AtomicBoolean inAuth = new AtomicBoolean(false);
    private final AtomicBoolean statusReceived = new AtomicBoolean(false);
    private final AtomicLong touch = new AtomicLong(DateUtil.millisTime());
    private final long start = DateUtil.millisTime();
    private final NettyAsyncHttpProvider asyncHttpProvider;
    private final AtomicReference<STATE> state = new AtomicReference<STATE>(STATE.NEW);
    private final AtomicBoolean contentProcessed = new AtomicBoolean(false);
    private Channel channel;
    private boolean reuseChannel = false;
    private final AtomicInteger currentRetry = new AtomicInteger(0);
    private final int maxRetry;
    private boolean writeHeaders;
    private boolean writeBody;
    private final AtomicBoolean onThrowableCalled = new AtomicBoolean(false);
    private boolean allowConnect = false;
    private final ConnectionPoolKeyStrategy connectionPoolKeyStrategy;
    private final ProxyServer proxyServer;

    public NettyResponseFuture(URI uri, Request request, AsyncHandler<V> asyncHandler, HttpRequest nettyRequest, int requestTimeoutInMs, int idleConnectionTimeoutInMs, NettyAsyncHttpProvider asyncHttpProvider, ConnectionPoolKeyStrategy connectionPoolKeyStrategy, ProxyServer proxyServer) {
        this.asyncHandler = asyncHandler;
        this.requestTimeoutInMs = requestTimeoutInMs;
        this.idleConnectionTimeoutInMs = idleConnectionTimeoutInMs;
        this.request = request;
        this.nettyRequest = nettyRequest;
        this.uri = uri;
        this.asyncHttpProvider = asyncHttpProvider;
        this.connectionPoolKeyStrategy = connectionPoolKeyStrategy;
        this.proxyServer = proxyServer;
        this.maxRetry = System.getProperty(MAX_RETRY) != null ? Integer.valueOf(System.getProperty(MAX_RETRY)).intValue() : asyncHttpProvider.getConfig().getMaxRequestRetry();
        this.writeHeaders = true;
        this.writeBody = true;
    }

    protected URI getURI() {
        return this.uri;
    }

    protected void setURI(URI uri) {
        this.uri = uri;
    }

    public ConnectionPoolKeyStrategy getConnectionPoolKeyStrategy() {
        return this.connectionPoolKeyStrategy;
    }

    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    @Override
    public boolean isDone() {
        return this.isDone.get() || this.isCancelled.get();
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled.get();
    }

    void setAsyncHandler(AsyncHandler<V> asyncHandler) {
        this.asyncHandler = asyncHandler;
    }

    @Override
    public boolean cancel(boolean force) {
        this.cancelTimeouts();
        if (this.isCancelled.getAndSet(true)) {
            return false;
        }
        try {
            this.channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment((Object)new NettyAsyncHttpProvider.DiscardEvent());
            this.channel.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (!this.onThrowableCalled.getAndSet(true)) {
            try {
                this.asyncHandler.onThrowable(new CancellationException());
            }
            catch (Throwable t) {
                logger.warn("cancel", t);
            }
        }
        this.latch.countDown();
        this.runListeners();
        return true;
    }

    public boolean hasExpired() {
        return this.requestTimeoutReached || this.idleConnectionTimeoutReached;
    }

    public void setRequestTimeoutReached() {
        this.requestTimeoutReached = true;
    }

    public boolean isRequestTimeoutReached() {
        return this.requestTimeoutReached;
    }

    public void setIdleConnectionTimeoutReached() {
        this.idleConnectionTimeoutReached = true;
    }

    public boolean isIdleConnectionTimeoutReached() {
        return this.idleConnectionTimeoutReached;
    }

    public void setTimeoutsHolder(TimeoutsHolder timeoutsHolder) {
        this.timeoutsHolder = timeoutsHolder;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.requestTimeoutInMs, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.cancelTimeouts();
            throw new ExecutionException(e);
        }
    }

    public void cancelTimeouts() {
        if (this.timeoutsHolder != null) {
            this.timeoutsHolder.cancel();
            this.timeoutsHolder = null;
        }
    }

    @Override
    public V get(long l, TimeUnit tu) throws InterruptedException, TimeoutException, ExecutionException {
        if (!this.isDone() && !this.isCancelled()) {
            boolean expired = false;
            if (l == -1L) {
                this.latch.await();
            } else {
                boolean bl = expired = !this.latch.await(l, tu);
            }
            if (expired) {
                this.isCancelled.set(true);
                try {
                    this.channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment((Object)new NettyAsyncHttpProvider.DiscardEvent());
                    this.channel.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (!this.onThrowableCalled.getAndSet(true)) {
                    try {
                        TimeoutException te = new TimeoutException(String.format("No response received after %s", l));
                        try {
                            this.asyncHandler.onThrowable(te);
                        }
                        catch (Throwable t) {
                            logger.debug("asyncHandler.onThrowable", t);
                        }
                        throw new ExecutionException(te);
                    }
                    catch (Throwable throwable) {
                        this.cancelTimeouts();
                        throw throwable;
                    }
                }
            }
            this.isDone.set(true);
            ExecutionException e = this.exEx.getAndSet(null);
            if (e != null) {
                throw e;
            }
        }
        return this.getContent();
    }

    V getContent() throws ExecutionException {
        ExecutionException e = this.exEx.getAndSet(null);
        if (e != null) {
            throw e;
        }
        V update = this.content.get();
        this.currentRetry.set(this.maxRetry);
        if (this.exEx.get() == null && !this.contentProcessed.getAndSet(true)) {
            block8: {
                try {
                    update = this.asyncHandler.onCompleted();
                }
                catch (Throwable ex) {
                    if (this.onThrowableCalled.getAndSet(true)) break block8;
                    try {
                        try {
                            this.asyncHandler.onThrowable(ex);
                        }
                        catch (Throwable t) {
                            logger.debug("asyncHandler.onThrowable", t);
                        }
                        throw new RuntimeException(ex);
                    }
                    catch (Throwable throwable) {
                        this.cancelTimeouts();
                        throw throwable;
                    }
                }
            }
            this.content.compareAndSet(null, update);
        }
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void done() {
        this.cancelTimeouts();
        try {
            if (this.exEx.get() != null) {
                return;
            }
            this.getContent();
            this.isDone.set(true);
        }
        catch (ExecutionException t) {
            return;
        }
        catch (RuntimeException t) {
            Throwable exception = t.getCause() != null ? t.getCause() : t;
            this.exEx.compareAndSet(null, new ExecutionException(exception));
        }
        finally {
            this.latch.countDown();
        }
        this.runListeners();
    }

    @Override
    public final void abort(Throwable t) {
        this.cancelTimeouts();
        if (this.isDone.get() || this.isCancelled.getAndSet(true)) {
            return;
        }
        this.isCancelled.set(true);
        this.exEx.compareAndSet(null, new ExecutionException(t));
        if (this.onThrowableCalled.compareAndSet(false, true)) {
            try {
                this.asyncHandler.onThrowable(t);
            }
            catch (Throwable te) {
                logger.debug("asyncHandler.onThrowable", te);
            }
        }
        this.latch.countDown();
        this.runListeners();
    }

    @Override
    public void content(V v) {
        this.content.set(v);
    }

    protected final Request getRequest() {
        return this.request;
    }

    public final HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    protected final void setNettyRequest(HttpRequest nettyRequest) {
        this.nettyRequest = nettyRequest;
    }

    protected final AsyncHandler<V> getAsyncHandler() {
        return this.asyncHandler;
    }

    protected final boolean getKeepAlive() {
        return this.keepAlive;
    }

    protected final void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    protected final HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    protected final void setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    protected int incrementAndGetCurrentRedirectCount() {
        return this.redirectCount.incrementAndGet();
    }

    protected boolean isInAuth() {
        return this.inAuth.get();
    }

    protected boolean getAndSetAuth(boolean inDigestAuth) {
        return this.inAuth.getAndSet(inDigestAuth);
    }

    protected STATE getState() {
        return this.state.get();
    }

    protected void setState(STATE state) {
        this.state.set(state);
    }

    public boolean getAndSetStatusReceived(boolean sr) {
        return this.statusReceived.getAndSet(sr);
    }

    @Override
    public void touch() {
        this.touch.set(DateUtil.millisTime());
    }

    public long getLastTouch() {
        return this.touch.get();
    }

    @Override
    public boolean getAndSetWriteHeaders(boolean writeHeaders) {
        boolean b = this.writeHeaders;
        this.writeHeaders = writeHeaders;
        return b;
    }

    @Override
    public boolean getAndSetWriteBody(boolean writeBody) {
        boolean b = this.writeBody;
        this.writeBody = writeBody;
        return b;
    }

    protected NettyAsyncHttpProvider provider() {
        return this.asyncHttpProvider;
    }

    protected void attachChannel(Channel channel) {
        this.channel = channel;
    }

    public void setReuseChannel(boolean reuseChannel) {
        this.reuseChannel = reuseChannel;
    }

    public boolean isConnectAllowed() {
        return this.allowConnect;
    }

    public void setConnectAllowed(boolean allowConnect) {
        this.allowConnect = allowConnect;
    }

    protected void attachChannel(Channel channel, boolean reuseChannel) {
        this.channel = channel;
        this.reuseChannel = reuseChannel;
    }

    protected Channel channel() {
        return this.channel;
    }

    protected boolean reuseChannel() {
        return this.reuseChannel;
    }

    protected boolean canRetry() {
        return this.currentRetry.incrementAndGet() <= this.maxRetry;
    }

    public SocketAddress getChannelRemoteAddress() {
        return this.channel() != null ? this.channel().getRemoteAddress() : null;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public boolean cannotBeReplay() {
        return this.isDone() || !this.canRetry() || this.isCancelled() || this.channel() != null && this.channel().isOpen() && this.uri.getScheme().compareToIgnoreCase("https") != 0 || this.isInAuth();
    }

    public long getStart() {
        return this.start;
    }

    public long getRequestTimeoutInMs() {
        return this.requestTimeoutInMs;
    }

    public long getIdleConnectionTimeoutInMs() {
        return this.idleConnectionTimeoutInMs;
    }

    public String toString() {
        return "NettyResponseFuture{currentRetry=" + this.currentRetry + ",\n\tisDone=" + this.isDone + ",\n\tisCancelled=" + this.isCancelled + ",\n\tasyncHandler=" + this.asyncHandler + ",\n\trequestTimeoutInMs=" + this.requestTimeoutInMs + ",\n\tnettyRequest=" + this.nettyRequest + ",\n\tcontent=" + this.content + ",\n\turi=" + this.uri + ",\n\tkeepAlive=" + this.keepAlive + ",\n\thttpResponse=" + this.httpResponse + ",\n\texEx=" + this.exEx + ",\n\tredirectCount=" + this.redirectCount + ",\n\ttimeoutsHolder=" + this.timeoutsHolder + ",\n\tinAuth=" + this.inAuth + ",\n\tstatusReceived=" + this.statusReceived + ",\n\ttouch=" + this.touch + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum STATE {
        NEW,
        POOLED,
        RECONNECTED,
        CLOSED;

    }
}

