/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.security;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.common.security.JobTokenIdentifier;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobTokenSecretManager
extends SecretManager<JobTokenIdentifier> {
    private static final String DEFAULT_HMAC_ALGORITHM = "HmacSHA1";
    private final SecretKey masterKey;
    private final Map<String, SecretKey> currentJobTokens;
    private final Mac mac;

    public static SecretKey createSecretKey(byte[] key) {
        return SecretManager.createSecretKey((byte[])key);
    }

    public static byte[] computeHash(byte[] msg, SecretKey key) {
        return JobTokenSecretManager.createPassword((byte[])msg, (SecretKey)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] computeHash(byte[] msg) {
        Mac mac = this.mac;
        synchronized (mac) {
            return this.mac.doFinal(msg);
        }
    }

    public JobTokenSecretManager() {
        this(null);
    }

    public JobTokenSecretManager(SecretKey key) {
        this.masterKey = key == null ? this.generateSecret() : key;
        this.currentJobTokens = new TreeMap<String, SecretKey>();
        try {
            this.mac = Mac.getInstance(DEFAULT_HMAC_ALGORITHM);
            this.mac.init(this.masterKey);
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new IllegalArgumentException("Can't find HmacSHA1 algorithm.", nsa);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException("Invalid key to HMAC computation", ike);
        }
    }

    public byte[] createPassword(JobTokenIdentifier identifier) {
        return this.computeHash(identifier.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTokenForJob(String jobId, Token<JobTokenIdentifier> token) {
        SecretKey tokenSecret = JobTokenSecretManager.createSecretKey(token.getPassword());
        Map<String, SecretKey> map = this.currentJobTokens;
        synchronized (map) {
            this.currentJobTokens.put(jobId, tokenSecret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTokenForJob(String jobId) {
        Map<String, SecretKey> map = this.currentJobTokens;
        synchronized (map) {
            this.currentJobTokens.remove(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecretKey retrieveTokenSecret(String jobId) throws SecretManager.InvalidToken {
        SecretKey tokenSecret = null;
        Map<String, SecretKey> map = this.currentJobTokens;
        synchronized (map) {
            tokenSecret = this.currentJobTokens.get(jobId);
        }
        if (tokenSecret == null) {
            throw new SecretManager.InvalidToken("Can't find job token for job " + jobId + " !!");
        }
        return tokenSecret;
    }

    public byte[] retrievePassword(JobTokenIdentifier identifier) throws SecretManager.InvalidToken {
        return this.retrieveTokenSecret(identifier.getJobId().toString()).getEncoded();
    }

    public JobTokenIdentifier createIdentifier() {
        return new JobTokenIdentifier();
    }
}

