/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.utils;

import com.google.common.base.Preconditions;

public class Grouper {
    private int numGroup;
    private int numItem;
    private int numGroup1;
    private int itemPerGroup1;
    private int numGroup2;
    private int itemPerGroup2;

    public Grouper init(int numItem, int numGroup) {
        Preconditions.checkArgument((numGroup > 0 ? 1 : 0) != 0, (Object)("Number of groups is " + numGroup + ". Should be positive"));
        Preconditions.checkArgument((numItem > 0 ? 1 : 0) != 0, (Object)("Number of items is " + numItem + ". Should be positive"));
        Preconditions.checkArgument((numItem >= numGroup ? 1 : 0) != 0, (Object)("Num of groups + " + numGroup + " shouldn't be more than number of items " + numItem));
        this.numItem = numItem;
        this.numGroup = numGroup;
        this.itemPerGroup1 = numItem / numGroup;
        this.itemPerGroup2 = this.itemPerGroup1 + 1;
        this.numGroup2 = numItem % numGroup;
        this.numGroup1 = numGroup - this.numGroup2;
        return this;
    }

    public int getFirstItemInGroup(int groupId) {
        Preconditions.checkArgument((0 <= groupId && groupId < this.numGroup ? 1 : 0) != 0, (Object)("Invalid groupId " + groupId));
        if (groupId < this.numGroup1) {
            return groupId * this.itemPerGroup1;
        }
        return groupId * this.itemPerGroup1 + (groupId - this.numGroup1);
    }

    public int getNumItemsInGroup(int groupId) {
        Preconditions.checkArgument((0 <= groupId && groupId < this.numGroup ? 1 : 0) != 0, (Object)("Invalid groupId" + groupId));
        return groupId < this.numGroup1 ? this.itemPerGroup1 : this.itemPerGroup2;
    }

    public int getLastItemInGroup(int groupId) {
        Preconditions.checkArgument((0 <= groupId && groupId < this.numGroup ? 1 : 0) != 0, (Object)("Invalid groupId" + groupId));
        return this.getFirstItemInGroup(groupId) + this.getNumItemsInGroup(groupId) - 1;
    }

    public int getGroupId(int itemId) {
        Preconditions.checkArgument((0 <= itemId && itemId < this.numItem ? 1 : 0) != 0, (Object)("Invalid itemId" + itemId));
        if (itemId < this.itemPerGroup1 * this.numGroup1) {
            return itemId / this.itemPerGroup1;
        }
        return this.numGroup1 + (itemId - this.itemPerGroup1 * this.numGroup1) / this.itemPerGroup2;
    }

    public boolean isInGroup(int itemId, int groupId) {
        Preconditions.checkArgument((0 <= groupId && groupId < this.numGroup ? 1 : 0) != 0, (Object)("Invalid groupId" + groupId));
        Preconditions.checkArgument((0 <= itemId && itemId < this.numItem ? 1 : 0) != 0, (Object)("Invalid itemId" + itemId));
        return this.getFirstItemInGroup(groupId) <= itemId && itemId < this.getFirstItemInGroup(groupId) + this.getNumItemsInGroup(groupId);
    }
}

