/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Configuring;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.PropertyType;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public class PropertiesStep<E>
extends FlatMapStep<Element, E>
implements AutoCloseable,
Configuring {
    protected Parameters parameters = new Parameters();
    protected final String[] propertyKeys;
    protected final PropertyType returnType;

    public PropertiesStep(Traversal.Admin traversal, PropertyType propertyType, String ... propertyKeys) {
        super(traversal);
        this.returnType = propertyType;
        this.propertyKeys = propertyKeys;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void configure(Object ... keyValues) {
        this.parameters.set(null, keyValues);
    }

    @Override
    protected Iterator<E> flatMap(Traverser.Admin<Element> traverser) {
        return this.returnType.equals((Object)PropertyType.VALUE) ? ((Element)traverser.get()).values(this.propertyKeys) : ((Element)traverser.get()).properties(this.propertyKeys);
    }

    public PropertyType getReturnType() {
        return this.returnType;
    }

    public String[] getPropertyKeys() {
        return this.propertyKeys;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, Arrays.asList(this.propertyKeys), this.returnType.name().toLowerCase());
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(new Object[]{super.hashCode(), this.returnType});
        if (this.propertyKeys != null) {
            List sortedPropertyKeys = Arrays.stream(this.propertyKeys).sorted(Comparator.nullsLast(Comparator.naturalOrder())).collect(Collectors.toList());
            for (String propertyKey : sortedPropertyKeys) {
                result = 31 * result + Objects.hashCode(propertyKey);
            }
        }
        return result;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public void close() throws Exception {
        this.closeIterator();
    }
}

