/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tinkerpop.gremlin.process.traversal.GType;
import org.apache.tinkerpop.gremlin.process.traversal.PBiPredicate;

public enum CompareType implements PBiPredicate<Object, Object>
{
    typeOf{

        @Override
        public boolean test(Object first, Object second) {
            if (first == null) {
                return second == null || second instanceof GType && ((GType)((Object)second)).getType() == null;
            }
            Class<?> valueClass = second instanceof String ? GlobalTypeCache.getRegisteredType((String)second).orElseThrow(() -> new IllegalArgumentException(second + " is not a registered type")) : (second instanceof GType ? ((GType)((Object)second)).getType() : (Class<?>)second);
            return valueClass != null && valueClass.isAssignableFrom(first.getClass());
        }
    };


    public static final class GlobalTypeCache {
        private static final Map<String, Class<?>> GLOBAL_TYPE_REGISTRY = new ConcurrentHashMap();

        private GlobalTypeCache() {
            throw new IllegalStateException("Utility class");
        }

        public static void registerDataType(String name, Class<?> type) {
            GLOBAL_TYPE_REGISTRY.put(name, type);
        }

        public static void registerDataType(Class<?> type) {
            GLOBAL_TYPE_REGISTRY.put(type.getSimpleName(), type);
        }

        public static void unregisterDataType(String name) {
            GLOBAL_TYPE_REGISTRY.remove(name);
        }

        public static Optional<Class<?>> getRegisteredType(String typeName) {
            if (GLOBAL_TYPE_REGISTRY.containsKey(typeName)) {
                return Optional.of(GLOBAL_TYPE_REGISTRY.get(typeName));
            }
            return Optional.empty();
        }

        static {
            for (GType value : GType.values()) {
                if (value == GType.NULL) continue;
                GlobalTypeCache.registerDataType(value.getType());
            }
        }
    }
}

