/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tinkerpop.gremlin.process.traversal.PBiPredicate;

public enum Text implements PBiPredicate<String, String>
{
    startingWith{

        @Override
        public boolean test(String value, String prefix) {
            if (Text.isNull(value, prefix)) {
                return false;
            }
            return value.startsWith(prefix);
        }

        @Override
        public Text negate() {
            return notStartingWith;
        }
    }
    ,
    notStartingWith{

        @Override
        public boolean test(String value, String prefix) {
            return !startingWith.test(value, prefix);
        }

        @Override
        public Text negate() {
            return startingWith;
        }
    }
    ,
    endingWith{

        @Override
        public boolean test(String value, String suffix) {
            if (Text.isNull(value, suffix)) {
                return false;
            }
            return value.endsWith(suffix);
        }

        @Override
        public Text negate() {
            return notEndingWith;
        }
    }
    ,
    notEndingWith{

        @Override
        public boolean test(String value, String prefix) {
            return !endingWith.test(value, prefix);
        }

        @Override
        public Text negate() {
            return endingWith;
        }
    }
    ,
    containing{

        @Override
        public boolean test(String value, String search) {
            if (Text.isNull(value, search)) {
                return false;
            }
            return value.contains(search);
        }

        @Override
        public Text negate() {
            return notContaining;
        }
    }
    ,
    notContaining{

        @Override
        public boolean test(String value, String search) {
            return !containing.test(value, search);
        }

        @Override
        public Text negate() {
            return containing;
        }
    };


    private static boolean isNull(String ... args) {
        for (String arg : args) {
            if (arg != null) continue;
            return true;
        }
        return false;
    }

    public abstract Text negate();

    public static class RegexPredicate
    implements PBiPredicate<String, String>,
    Serializable {
        private final Pattern pattern;
        private final boolean negate;

        public RegexPredicate(String expression, boolean negate) {
            this.pattern = Pattern.compile(expression);
            this.negate = negate;
        }

        public boolean isNegate() {
            return this.negate;
        }

        public String getPattern() {
            return this.pattern.pattern();
        }

        @Override
        public boolean test(String value, String expression) {
            Matcher matcher = this.pattern.matcher(value);
            return this.negate != matcher.find();
        }

        @Override
        public PBiPredicate<String, String> negate() {
            return new RegexPredicate(this.pattern.pattern(), !this.negate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegexPredicate that = (RegexPredicate)o;
            return this.negate == that.negate && this.pattern.pattern().equals(that.pattern.pattern());
        }

        public int hashCode() {
            return Objects.hash(this.pattern.pattern(), this.negate);
        }

        public String toString() {
            return String.format("regex(%s)", this.pattern.pattern());
        }

        @Override
        public String getPredicateName() {
            return this.isNegate() ? "notRegex" : "regex";
        }
    }
}

