/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.upload;

import com.github.openjson.JSONObject;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class FileDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String fileName;
    private final long fileSize;
    private final Date lastModified;
    private final String mimeType;

    public FileDescription(JSONObject jsonObject) {
        this(jsonObject.getString("fileName"), jsonObject.getLong("fileSize"), jsonObject.getLong("lastModified"), jsonObject.getString("mimeType"));
    }

    public FileDescription(String fileName, long fileSize, long lastModified, String mimeType) {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.lastModified = new Date(lastModified);
        this.mimeType = mimeType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileDescription that = (FileDescription)o;
        return this.fileName.equals(that.fileName);
    }

    public int hashCode() {
        return Objects.hash(this.fileName);
    }
}

