/* BezierTool.c generated by valac 0.56.17, the Vala compiler
 * generated from BezierTool.vala, do not modify */

/*
Copyright (C) 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_BEZIER_TOOL_0_PROPERTY,
	BIRD_FONT_BEZIER_TOOL_NUM_PROPERTIES
};
static GParamSpec* bird_font_bezier_tool_properties[BIRD_FONT_BEZIER_TOOL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _BirdFontBezierToolPrivate {
	guint state;
	BirdFontPath* current_path;
	BirdFontEditPoint* current_point;
	gint last_x;
	gint last_y;
	gdouble last_release_time;
	gdouble last_press_time;
	gboolean button_down;
	gboolean corner_node;
	gboolean swap;
};

static gint BirdFontBezierTool_private_offset;
static gpointer bird_font_bezier_tool_parent_class = NULL;

static void __lambda138_ (BirdFontBezierTool* self,
                   BirdFontTool* _self_);
static void ___lambda138__bird_font_tool_select_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 gpointer self);
static void __lambda139_ (BirdFontBezierTool* self,
                   BirdFontTool* _self_);
static void ___lambda139__bird_font_tool_deselect_action (BirdFontTool* _sender,
                                                   BirdFontTool* selected,
                                                   gpointer self);
static void __lambda140_ (BirdFontBezierTool* self,
                   BirdFontTool* _self_,
                   gint b,
                   gint x,
                   gint y);
static void ___lambda140__bird_font_tool_press_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                gint button,
                                                gint x,
                                                gint y,
                                                gpointer self);
static void __lambda141_ (BirdFontBezierTool* self,
                   BirdFontTool* _self_,
                   gint b,
                   gint x,
                   gint y);
static void ___lambda141__bird_font_tool_double_click_action (BirdFontTool* _sender,
                                                       BirdFontTool* selected,
                                                       gint button,
                                                       gint x,
                                                       gint y,
                                                       gpointer self);
static void __lambda142_ (BirdFontBezierTool* self,
                   BirdFontTool* _self_,
                   gint b,
                   gint x,
                   gint y);
static void ___lambda142__bird_font_tool_release_action (BirdFontTool* _sender,
                                                  BirdFontTool* selected,
                                                  gint button,
                                                  gint x,
                                                  gint y,
                                                  gpointer self);
static void __lambda143_ (BirdFontBezierTool* self,
                   BirdFontTool* _self_,
                   gint x,
                   gint y);
static void ___lambda143__bird_font_tool_move_action (BirdFontTool* _sender,
                                               BirdFontTool* selected,
                                               gint x,
                                               gint y,
                                               gpointer self);
static void __lambda144_ (BirdFontBezierTool* self,
                   BirdFontTool* _self_,
                   guint32 keyval);
static void ___lambda144__bird_font_tool_key_press_action (BirdFontTool* _sender,
                                                    BirdFontTool* selected,
                                                    guint32 keyval,
                                                    gpointer self);
static void __lambda145_ (BirdFontBezierTool* self,
                   BirdFontTool* _self_,
                   guint32 keyval);
static void ___lambda145__bird_font_tool_key_release_action (BirdFontTool* _sender,
                                                      BirdFontTool* selected,
                                                      guint32 keyval,
                                                      gpointer self);
static void __lambda146_ (BirdFontBezierTool* self,
                   BirdFontTool* tool,
                   cairo_t* cairo_context,
                   BirdFontGlyph* glyph);
static void ___lambda146__bird_font_tool_draw_action (BirdFontTool* _sender,
                                               BirdFontTool* selected,
                                               cairo_t* cr,
                                               BirdFontGlyph* glyph,
                                               gpointer self);
static gchar* bird_font_bezier_tool_real_get_tip (BirdFontTool* base);
static void bird_font_bezier_tool_set_point_type (BirdFontBezierTool* self);
static void bird_font_bezier_tool_convert_zero_length_handles_to_lines (BirdFontBezierTool* self);
static void bird_font_bezier_tool_real_before_undo (BirdFontTool* base);
static void bird_font_bezier_tool_real_after_undo (BirdFontTool* base);
static void bird_font_bezier_tool_finalize (GObject * obj);
static GType bird_font_bezier_tool_get_type_once (void);

static inline gpointer
bird_font_bezier_tool_get_instance_private (BirdFontBezierTool* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontBezierTool_private_offset);
}

static void
__lambda138_ (BirdFontBezierTool* self,
              BirdFontTool* _self_)
{
	g_return_if_fail (_self_ != NULL);
	self->priv->state = BIRD_FONT_BEZIER_TOOL_NONE;
	bird_font_main_window_set_cursor (BIRD_FONT_NATIVE_WINDOW_VISIBLE);
}

static void
___lambda138__bird_font_tool_select_action (BirdFontTool* _sender,
                                            BirdFontTool* selected,
                                            gpointer self)
{
	__lambda138_ ((BirdFontBezierTool*) self, selected);
}

static void
__lambda139_ (BirdFontBezierTool* self,
              BirdFontTool* _self_)
{
	g_return_if_fail (_self_ != NULL);
	self->priv->state = BIRD_FONT_BEZIER_TOOL_NONE;
	bird_font_main_window_set_cursor (BIRD_FONT_NATIVE_WINDOW_VISIBLE);
}

static void
___lambda139__bird_font_tool_deselect_action (BirdFontTool* _sender,
                                              BirdFontTool* selected,
                                              gpointer self)
{
	__lambda139_ ((BirdFontBezierTool*) self, selected);
}

static void
__lambda140_ (BirdFontBezierTool* self,
              BirdFontTool* _self_,
              gint b,
              gint x,
              gint y)
{
	g_return_if_fail (_self_ != NULL);
	bird_font_bezier_tool_press (self, b, x, y);
}

static void
___lambda140__bird_font_tool_press_action (BirdFontTool* _sender,
                                           BirdFontTool* selected,
                                           gint button,
                                           gint x,
                                           gint y,
                                           gpointer self)
{
	__lambda140_ ((BirdFontBezierTool*) self, selected, button, x, y);
}

static void
__lambda141_ (BirdFontBezierTool* self,
              BirdFontTool* _self_,
              gint b,
              gint x,
              gint y)
{
	g_return_if_fail (_self_ != NULL);
}

static void
___lambda141__bird_font_tool_double_click_action (BirdFontTool* _sender,
                                                  BirdFontTool* selected,
                                                  gint button,
                                                  gint x,
                                                  gint y,
                                                  gpointer self)
{
	__lambda141_ ((BirdFontBezierTool*) self, selected, button, x, y);
}

static void
__lambda142_ (BirdFontBezierTool* self,
              BirdFontTool* _self_,
              gint b,
              gint x,
              gint y)
{
	g_return_if_fail (_self_ != NULL);
	bird_font_bezier_tool_release (self, b, x, y);
}

static void
___lambda142__bird_font_tool_release_action (BirdFontTool* _sender,
                                             BirdFontTool* selected,
                                             gint button,
                                             gint x,
                                             gint y,
                                             gpointer self)
{
	__lambda142_ ((BirdFontBezierTool*) self, selected, button, x, y);
}

static void
__lambda143_ (BirdFontBezierTool* self,
              BirdFontTool* _self_,
              gint x,
              gint y)
{
	g_return_if_fail (_self_ != NULL);
	bird_font_bezier_tool_move (self, x, y);
}

static void
___lambda143__bird_font_tool_move_action (BirdFontTool* _sender,
                                          BirdFontTool* selected,
                                          gint x,
                                          gint y,
                                          gpointer self)
{
	__lambda143_ ((BirdFontBezierTool*) self, selected, x, y);
}

static void
__lambda144_ (BirdFontBezierTool* self,
              BirdFontTool* _self_,
              guint32 keyval)
{
	g_return_if_fail (_self_ != NULL);
}

static void
___lambda144__bird_font_tool_key_press_action (BirdFontTool* _sender,
                                               BirdFontTool* selected,
                                               guint32 keyval,
                                               gpointer self)
{
	__lambda144_ ((BirdFontBezierTool*) self, selected, keyval);
}

static void
__lambda145_ (BirdFontBezierTool* self,
              BirdFontTool* _self_,
              guint32 keyval)
{
	g_return_if_fail (_self_ != NULL);
}

static void
___lambda145__bird_font_tool_key_release_action (BirdFontTool* _sender,
                                                 BirdFontTool* selected,
                                                 guint32 keyval,
                                                 gpointer self)
{
	__lambda145_ ((BirdFontBezierTool*) self, selected, keyval);
}

static void
__lambda146_ (BirdFontBezierTool* self,
              BirdFontTool* tool,
              cairo_t* cairo_context,
              BirdFontGlyph* glyph)
{
	BirdFontEditPoint* _tmp0_;
	g_return_if_fail (tool != NULL);
	g_return_if_fail (cairo_context != NULL);
	g_return_if_fail (glyph != NULL);
	_tmp0_ = self->priv->current_point;
	if (bird_font_pen_tool_can_join (_tmp0_)) {
		bird_font_pen_tool_draw_join_icon (cairo_context, (gdouble) self->priv->last_x, (gdouble) self->priv->last_y);
	}
}

static void
___lambda146__bird_font_tool_draw_action (BirdFontTool* _sender,
                                          BirdFontTool* selected,
                                          cairo_t* cr,
                                          BirdFontGlyph* glyph,
                                          gpointer self)
{
	__lambda146_ ((BirdFontBezierTool*) self, selected, cr, glyph);
}

BirdFontBezierTool*
bird_font_bezier_tool_construct (GType object_type,
                                 const gchar* name)
{
	BirdFontBezierTool * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (BirdFontBezierTool*) bird_font_tool_construct (object_type, name, "");
	g_signal_connect_object ((BirdFontTool*) self, "select-action", (GCallback) ___lambda138__bird_font_tool_select_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "deselect-action", (GCallback) ___lambda139__bird_font_tool_deselect_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "press-action", (GCallback) ___lambda140__bird_font_tool_press_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "double-click-action", (GCallback) ___lambda141__bird_font_tool_double_click_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "release-action", (GCallback) ___lambda142__bird_font_tool_release_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "move-action", (GCallback) ___lambda143__bird_font_tool_move_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "key-press-action", (GCallback) ___lambda144__bird_font_tool_key_press_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "key-release-action", (GCallback) ___lambda145__bird_font_tool_key_release_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "draw-action", (GCallback) ___lambda146__bird_font_tool_draw_action, self, 0);
	return self;
}

BirdFontBezierTool*
bird_font_bezier_tool_new (const gchar* name)
{
	return bird_font_bezier_tool_construct (BIRD_FONT_TYPE_BEZIER_TOOL, name);
}

static gchar*
bird_font_bezier_tool_real_get_tip (BirdFontTool* base)
{
	BirdFontBezierTool * self;
	gchar* tip = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	BirdFontTool* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	BirdFontTool* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	BirdFontTool* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* result;
	self = (BirdFontBezierTool*) base;
	_tmp0_ = bird_font_t_ ("Create Bézier curves");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "\n", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	tip = _tmp3_;
	_tmp4_ = tip;
	_tmp5_ = bird_font_hidden_tools_bezier_line;
	_tmp6_ = bird_font_tool_get_key_binding (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
	_g_free0 (tip);
	tip = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp9_ = tip;
	_tmp10_ = g_strconcat (_tmp9_, " - ", NULL);
	_g_free0 (tip);
	tip = _tmp10_;
	_tmp11_ = tip;
	_tmp12_ = bird_font_t_ ("line");
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "\n", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp11_, _tmp15_, NULL);
	_g_free0 (tip);
	tip = _tmp16_;
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp17_ = tip;
	_tmp18_ = bird_font_hidden_tools_bezier_corner;
	_tmp19_ = bird_font_tool_get_key_binding (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp17_, _tmp20_, NULL);
	_g_free0 (tip);
	tip = _tmp21_;
	_g_free0 (_tmp20_);
	_tmp22_ = tip;
	_tmp23_ = g_strconcat (_tmp22_, " - ", NULL);
	_g_free0 (tip);
	tip = _tmp23_;
	_tmp24_ = tip;
	_tmp25_ = bird_font_t_ ("corner");
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat (_tmp26_, "\n", NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat (_tmp24_, _tmp28_, NULL);
	_g_free0 (tip);
	tip = _tmp29_;
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_tmp30_ = tip;
	_tmp31_ = bird_font_hidden_tools_move_along_axis;
	_tmp32_ = bird_font_tool_get_key_binding (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp30_, _tmp33_, NULL);
	_g_free0 (tip);
	tip = _tmp34_;
	_g_free0 (_tmp33_);
	_tmp35_ = tip;
	_tmp36_ = g_strconcat (_tmp35_, " - ", NULL);
	_g_free0 (tip);
	tip = _tmp36_;
	_tmp37_ = tip;
	_tmp38_ = bird_font_t_ ("on axis");
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strconcat (_tmp39_, "\n", NULL);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strconcat (_tmp37_, _tmp41_, NULL);
	_g_free0 (tip);
	tip = _tmp42_;
	_g_free0 (_tmp41_);
	_g_free0 (_tmp39_);
	result = tip;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
bird_font_bezier_tool_press (BirdFontBezierTool* self,
                             gint b,
                             gint x,
                             gint y)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	gdouble px = 0.0;
	gdouble py = 0.0;
	BirdFontPath* p = NULL;
	BirdFontPath* path = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	BirdFontGlyph* _tmp6_;
	BirdFontGlyph* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	if (self->priv->button_down) {
		g_warning ("BezierTool.vala:115: Discarding event.");
		_g_object_unref0 (path);
		_g_object_unref0 (p);
		_g_object_unref0 (g);
		return;
	}
	self->priv->button_down = TRUE;
	if (self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_HANDLES) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_LAST_HANDLE_RIGHT;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_LAST_HANDLE_LEFT;
	}
	if (_tmp1_) {
		_g_object_unref0 (path);
		_g_object_unref0 (p);
		_g_object_unref0 (g);
		return;
	}
	if (b == 2) {
		BirdFontGlyph* _tmp3_;
		_tmp3_ = g;
		if (bird_font_glyph_is_open (_tmp3_)) {
			BirdFontGlyph* _tmp4_;
			bird_font_bezier_tool_stop_drawing (self);
			_tmp4_ = g;
			bird_font_glyph_close_path (_tmp4_);
		} else {
			BirdFontGlyph* _tmp5_;
			_tmp5_ = g;
			bird_font_glyph_open_path (_tmp5_);
		}
		bird_font_main_window_set_cursor (BIRD_FONT_NATIVE_WINDOW_VISIBLE);
		self->priv->state = BIRD_FONT_BEZIER_TOOL_NONE;
		_g_object_unref0 (path);
		_g_object_unref0 (p);
		_g_object_unref0 (g);
		return;
	}
	if (((g_get_real_time () - self->priv->last_press_time) / 1000000.0) < 0.2) {
		self->priv->last_press_time = (gdouble) g_get_real_time ();
		_g_object_unref0 (path);
		_g_object_unref0 (p);
		_g_object_unref0 (g);
		return;
	}
	self->priv->last_press_time = (gdouble) g_get_real_time ();
	_tmp6_ = g;
	bird_font_glyph_store_undo_state (_tmp6_, FALSE);
	bird_font_pen_tool_update_orientation ();
	bird_font_main_window_set_cursor (BIRD_FONT_NATIVE_WINDOW_HIDDEN);
	_tmp7_ = g;
	bird_font_glyph_open_path (_tmp7_);
	px = bird_font_glyph_path_coordinate_x ((gdouble) x);
	py = bird_font_glyph_path_coordinate_y ((gdouble) y);
	if (bird_font_grid_tool_is_visible ()) {
		bird_font_grid_tool_tie_coordinate (&px, &py);
	}
	if (self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_HANDLE_ON_AXIS) {
		BirdFontPath* _tmp8_;
		BirdFontEditPoint* _tmp9_;
		BirdFontPath* _tmp10_;
		BirdFontEditPoint* _tmp11_;
		BirdFontEditPointHandle* _tmp12_;
		BirdFontPath* _tmp13_;
		BirdFontEditPoint* _tmp14_;
		_tmp8_ = self->priv->current_path;
		_tmp9_ = bird_font_path_add (_tmp8_, px, py);
		_g_object_unref0 (self->priv->current_point);
		self->priv->current_point = _tmp9_;
		_tmp10_ = self->priv->current_path;
		_tmp10_->hide_end_handle = TRUE;
		_tmp11_ = self->priv->current_point;
		_tmp12_ = bird_font_edit_point_get_left_handle (_tmp11_);
		bird_font_edit_point_handle_convert_to_line (_tmp12_);
		_tmp13_ = self->priv->current_path;
		_tmp14_ = self->priv->current_point;
		bird_font_path_recalculate_linear_handles_for_point (_tmp13_, _tmp14_);
		bird_font_bezier_tool_set_point_type (self);
		self->priv->corner_node = FALSE;
		self->priv->state = BIRD_FONT_BEZIER_TOOL_MOVE_POINT;
	} else {
		if (self->priv->corner_node) {
			BirdFontPath* _tmp15_;
			_tmp15_ = self->priv->current_path;
			if (bird_font_path_is_open (_tmp15_)) {
				BirdFontPath* _tmp16_;
				BirdFontEditPoint* _tmp17_;
				BirdFontPath* _tmp18_;
				BirdFontEditPoint* _tmp19_;
				BirdFontEditPointHandle* _tmp20_;
				BirdFontPath* _tmp21_;
				BirdFontEditPoint* _tmp22_;
				BirdFontGlyph* _tmp23_;
				BirdFontGlyph* _tmp24_;
				BirdFontPath* _tmp25_;
				_tmp16_ = self->priv->current_path;
				_tmp17_ = bird_font_path_add (_tmp16_, px, py);
				_g_object_unref0 (self->priv->current_point);
				self->priv->current_point = _tmp17_;
				_tmp18_ = self->priv->current_path;
				_tmp18_->hide_end_handle = TRUE;
				_tmp19_ = self->priv->current_point;
				_tmp20_ = bird_font_edit_point_get_left_handle (_tmp19_);
				bird_font_edit_point_handle_convert_to_line (_tmp20_);
				_tmp21_ = self->priv->current_path;
				_tmp22_ = self->priv->current_point;
				bird_font_path_recalculate_linear_handles_for_point (_tmp21_, _tmp22_);
				bird_font_bezier_tool_set_point_type (self);
				_tmp23_ = g;
				bird_font_glyph_clear_active_paths (_tmp23_);
				_tmp24_ = g;
				_tmp25_ = self->priv->current_path;
				bird_font_glyph_add_active_path (_tmp24_, NULL, _tmp25_);
				bird_font_glyph_canvas_redraw ();
				self->priv->state = BIRD_FONT_BEZIER_TOOL_MOVE_POINT;
			} else {
				self->priv->state = BIRD_FONT_BEZIER_TOOL_NONE;
			}
		} else {
			if (self->priv->state == BIRD_FONT_BEZIER_TOOL_NONE) {
				BirdFontGlyph* _tmp26_;
				BirdFontPath* _tmp27_;
				BirdFontPath* _tmp28_;
				BirdFontPath* _tmp29_;
				BirdFontPath* _tmp30_;
				BirdFontEditPoint* _tmp31_;
				BirdFontEditPoint* _tmp32_;
				BirdFontEditPointHandle* _tmp33_;
				BirdFontPath* _tmp34_;
				BirdFontEditPoint* _tmp35_;
				BirdFontGlyph* _tmp36_;
				BirdFontPath* _tmp37_;
				BirdFontFont* _tmp40_;
				BirdFontFont* _tmp41_;
				_tmp26_ = g;
				bird_font_glyph_open_path (_tmp26_);
				_tmp27_ = bird_font_path_new ();
				_g_object_unref0 (self->priv->current_path);
				self->priv->current_path = _tmp27_;
				_tmp28_ = self->priv->current_path;
				bird_font_path_reopen (_tmp28_);
				_tmp29_ = self->priv->current_path;
				_tmp29_->hide_end_handle = TRUE;
				_tmp30_ = self->priv->current_path;
				_tmp31_ = bird_font_path_add (_tmp30_, px, py);
				_g_object_unref0 (self->priv->current_point);
				self->priv->current_point = _tmp31_;
				_tmp32_ = self->priv->current_point;
				_tmp33_ = bird_font_edit_point_get_left_handle (_tmp32_);
				bird_font_edit_point_handle_convert_to_line (_tmp33_);
				_tmp34_ = self->priv->current_path;
				_tmp35_ = self->priv->current_point;
				bird_font_path_recalculate_linear_handles_for_point (_tmp34_, _tmp35_);
				_tmp36_ = g;
				_tmp37_ = self->priv->current_path;
				bird_font_glyph_add_path (_tmp36_, _tmp37_);
				bird_font_bezier_tool_set_point_type (self);
				if (bird_font_stroke_tool_add_stroke) {
					BirdFontPath* _tmp38_;
					BirdFontPath* _tmp39_;
					_tmp38_ = self->priv->current_path;
					bird_font_path_set_stroke (_tmp38_, bird_font_stroke_tool_stroke_width);
					_tmp39_ = self->priv->current_path;
					_tmp39_->line_cap = bird_font_stroke_tool_line_cap;
				}
				_tmp40_ = bird_font_bird_font_get_current_font ();
				_tmp41_ = _tmp40_;
				bird_font_font_touch (_tmp41_);
				_g_object_unref0 (_tmp41_);
				bird_font_glyph_canvas_redraw ();
				self->priv->state = BIRD_FONT_BEZIER_TOOL_MOVE_POINT;
			} else {
				if (self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_POINT) {
					BirdFontEditPoint* _tmp42_;
					_tmp42_ = self->priv->current_point;
					if (bird_font_pen_tool_can_join (_tmp42_)) {
						BirdFontEditPoint* first = NULL;
						BirdFontPath* _tmp43_;
						BirdFontEditPoint* _tmp44_;
						BirdFontEditPoint* _tmp45_;
						BirdFontPath* _tmp46_;
						BirdFontPath* _tmp47_;
						BirdFontPath* _tmp48_;
						BirdFontPath* _tmp49_;
						BirdFontPath* _tmp50_;
						BirdFontEditPoint* _tmp51_;
						BirdFontEditPoint* _tmp52_;
						BirdFontEditPoint* _tmp53_;
						BirdFontPath* _tmp54_;
						GeeArrayList* _tmp55_;
						GeeArrayList* _tmp56_;
						gint _tmp57_;
						gint _tmp58_;
						_tmp43_ = self->priv->current_path;
						_tmp44_ = bird_font_path_get_first_point (_tmp43_);
						first = _tmp44_;
						_tmp45_ = self->priv->current_point;
						_tmp46_ = bird_font_pen_tool_join_paths (_tmp45_);
						_g_object_unref0 (p);
						p = _tmp46_;
						_tmp47_ = p;
						g_return_if_fail (_tmp47_ != NULL);
						_tmp48_ = p;
						_tmp49_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, BIRD_FONT_TYPE_PATH, BirdFontPath));
						_g_object_unref0 (path);
						path = _tmp49_;
						_tmp50_ = path;
						_tmp51_ = bird_font_path_get_first_point (_tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = first;
						self->priv->swap = _tmp52_ != _tmp53_;
						_g_object_unref0 (_tmp52_);
						_tmp54_ = self->priv->current_path;
						_tmp55_ = bird_font_path_get_points (_tmp54_);
						_tmp56_ = _tmp55_;
						_tmp57_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp56_);
						_tmp58_ = _tmp57_;
						if (_tmp58_ == 1) {
							BirdFontPath* _tmp59_;
							BirdFontPath* _tmp60_;
							BirdFontPath* _tmp61_;
							BirdFontPath* _tmp62_;
							BirdFontEditPoint* _tmp63_;
							_tmp59_ = path;
							g_return_if_fail (bird_font_path_is_open (_tmp59_));
							_tmp60_ = path;
							_tmp61_ = _g_object_ref0 (_tmp60_);
							_g_object_unref0 (self->priv->current_path);
							self->priv->current_path = _tmp61_;
							_tmp62_ = path;
							_tmp63_ = bird_font_path_get_last_point (_tmp62_);
							_g_object_unref0 (self->priv->current_point);
							self->priv->current_point = _tmp63_;
							self->priv->state = BIRD_FONT_BEZIER_TOOL_MOVE_POINT;
						} else {
							BirdFontGlyph* _tmp64_;
							BirdFontPath* _tmp65_;
							BirdFontPath* _tmp66_;
							BirdFontEditPoint* _tmp67_ = NULL;
							BirdFontEditPoint* _tmp72_;
							guint _tmp73_ = 0U;
							_tmp64_ = g;
							bird_font_glyph_open_path (_tmp64_);
							_tmp65_ = path;
							_tmp66_ = _g_object_ref0 (_tmp65_);
							_g_object_unref0 (self->priv->current_path);
							self->priv->current_path = _tmp66_;
							if (!self->priv->swap) {
								BirdFontPath* _tmp68_;
								BirdFontEditPoint* _tmp69_;
								_tmp68_ = path;
								_tmp69_ = bird_font_path_get_first_point (_tmp68_);
								_g_object_unref0 (_tmp67_);
								_tmp67_ = _tmp69_;
							} else {
								BirdFontPath* _tmp70_;
								BirdFontEditPoint* _tmp71_;
								_tmp70_ = path;
								_tmp71_ = bird_font_path_get_last_point (_tmp70_);
								_g_object_unref0 (_tmp67_);
								_tmp67_ = _tmp71_;
							}
							_tmp72_ = _g_object_ref0 (_tmp67_);
							_g_object_unref0 (self->priv->current_point);
							self->priv->current_point = _tmp72_;
							if (!self->priv->swap) {
								_tmp73_ = BIRD_FONT_BEZIER_TOOL_MOVE_LAST_HANDLE_RIGHT;
							} else {
								_tmp73_ = BIRD_FONT_BEZIER_TOOL_MOVE_LAST_HANDLE_LEFT;
							}
							self->priv->state = _tmp73_;
							_g_object_unref0 (_tmp67_);
						}
						_g_object_unref0 (first);
					} else {
						self->priv->state = BIRD_FONT_BEZIER_TOOL_MOVE_HANDLES;
					}
				}
			}
		}
	}
	_g_object_unref0 (path);
	_g_object_unref0 (p);
	_g_object_unref0 (g);
}

static void
bird_font_bezier_tool_set_point_type (BirdFontBezierTool* self)
{
	BirdFontPointType pt = 0;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPointHandle* _tmp2_;
	BirdFontEditPoint* _tmp3_;
	BirdFontEditPointHandle* _tmp4_;
	BirdFontEditPoint* _tmp5_;
	BirdFontEditPointHandle* _tmp6_;
	BirdFontEditPoint* _tmp7_;
	BirdFontEditPointHandle* _tmp8_;
	g_return_if_fail (self != NULL);
	pt = bird_font_drawing_tools_get_selected_point_type ();
	_tmp0_ = self->priv->current_point;
	_tmp0_->type = pt;
	_tmp1_ = self->priv->current_point;
	_tmp2_ = bird_font_edit_point_get_left_handle (_tmp1_);
	_tmp2_->type = pt;
	_tmp3_ = self->priv->current_point;
	_tmp4_ = bird_font_edit_point_get_right_handle (_tmp3_);
	_tmp4_->type = pt;
	_tmp5_ = self->priv->current_point;
	_tmp6_ = bird_font_edit_point_get_left_handle (_tmp5_);
	bird_font_edit_point_handle_convert_to_line (_tmp6_);
	_tmp7_ = self->priv->current_point;
	_tmp8_ = bird_font_edit_point_get_right_handle (_tmp7_);
	bird_font_edit_point_handle_convert_to_line (_tmp8_);
}

void
bird_font_bezier_tool_release (BirdFontBezierTool* self,
                               gint b,
                               gint x,
                               gint y)
{
	gdouble px = 0.0;
	gdouble py = 0.0;
	BirdFontGlyph* g = NULL;
	gboolean _tmp0_ = FALSE;
	BirdFontGlyph* _tmp1_;
	g_return_if_fail (self != NULL);
	if (!self->priv->button_down) {
		g_warning ("BezierTool.vala:249: Discarding event.");
		_g_object_unref0 (g);
		return;
	}
	self->priv->button_down = FALSE;
	if (self->priv->state == BIRD_FONT_BEZIER_TOOL_NONE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_POINT;
	}
	if (_tmp0_) {
		_g_object_unref0 (g);
		return;
	}
	bird_font_bezier_tool_convert_zero_length_handles_to_lines (self);
	self->priv->corner_node = FALSE;
	if (((g_get_real_time () - self->priv->last_release_time) / 1000000.0) < 0.2) {
		self->priv->last_release_time = (gdouble) g_get_real_time ();
		_g_object_unref0 (g);
		return;
	}
	self->priv->last_release_time = (gdouble) g_get_real_time ();
	px = bird_font_glyph_path_coordinate_x ((gdouble) x);
	py = bird_font_glyph_path_coordinate_y ((gdouble) y);
	if (bird_font_grid_tool_is_visible ()) {
		bird_font_grid_tool_tie_coordinate (&px, &py);
	}
	_tmp1_ = bird_font_main_window_get_current_glyph ();
	_g_object_unref0 (g);
	g = _tmp1_;
	if (self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_HANDLES) {
		BirdFontPath* _tmp2_;
		BirdFontEditPoint* _tmp3_;
		BirdFontPath* _tmp4_;
		BirdFontEditPoint* _tmp5_;
		BirdFontEditPointHandle* _tmp6_;
		BirdFontPath* _tmp7_;
		BirdFontEditPoint* _tmp8_;
		BirdFontGlyph* _tmp9_;
		BirdFontGlyph* _tmp10_;
		BirdFontPath* _tmp11_;
		_tmp2_ = self->priv->current_path;
		_tmp3_ = bird_font_path_add (_tmp2_, px, py);
		_g_object_unref0 (self->priv->current_point);
		self->priv->current_point = _tmp3_;
		_tmp4_ = self->priv->current_path;
		_tmp4_->hide_end_handle = TRUE;
		_tmp5_ = self->priv->current_point;
		_tmp6_ = bird_font_edit_point_get_left_handle (_tmp5_);
		bird_font_edit_point_handle_convert_to_line (_tmp6_);
		_tmp7_ = self->priv->current_path;
		_tmp8_ = self->priv->current_point;
		bird_font_path_recalculate_linear_handles_for_point (_tmp7_, _tmp8_);
		bird_font_bezier_tool_set_point_type (self);
		_tmp9_ = g;
		bird_font_glyph_clear_active_paths (_tmp9_);
		_tmp10_ = g;
		_tmp11_ = self->priv->current_path;
		bird_font_glyph_add_active_path (_tmp10_, NULL, _tmp11_);
		bird_font_glyph_canvas_redraw ();
		self->priv->state = BIRD_FONT_BEZIER_TOOL_MOVE_POINT;
	} else {
		gboolean _tmp12_ = FALSE;
		if (self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_LAST_HANDLE_LEFT) {
			_tmp12_ = TRUE;
		} else {
			_tmp12_ = self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_LAST_HANDLE_RIGHT;
		}
		if (_tmp12_) {
			BirdFontPath* _tmp13_;
			BirdFontGlyph* _tmp14_;
			BirdFontGlyph* _tmp15_;
			BirdFontPathList* _tmp16_;
			BirdFontPathList* _tmp17_;
			BirdFontPath* _tmp18_;
			gboolean _tmp19_;
			BirdFontPath* _tmp22_;
			_tmp13_ = self->priv->current_path;
			bird_font_path_update_region_boundaries (_tmp13_);
			_tmp14_ = g;
			bird_font_glyph_close_path (_tmp14_);
			bird_font_main_window_set_cursor (BIRD_FONT_NATIVE_WINDOW_VISIBLE);
			_tmp15_ = g;
			_tmp16_ = bird_font_glyph_get_visible_path_list (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->priv->current_path;
			_tmp19_ = bird_font_path_is_counter (_tmp17_, _tmp18_);
			_g_object_unref0 (_tmp17_);
			if (_tmp19_) {
				BirdFontPath* _tmp20_;
				_tmp20_ = self->priv->current_path;
				bird_font_path_force_direction (_tmp20_, BIRD_FONT_DIRECTION_COUNTER_CLOCKWISE);
			} else {
				BirdFontPath* _tmp21_;
				_tmp21_ = self->priv->current_path;
				bird_font_path_force_direction (_tmp21_, BIRD_FONT_DIRECTION_CLOCKWISE);
			}
			_tmp22_ = self->priv->current_path;
			bird_font_path_reset_stroke (_tmp22_);
			self->priv->state = BIRD_FONT_BEZIER_TOOL_NONE;
		}
	}
	bird_font_bezier_tool_convert_zero_length_handles_to_lines (self);
	_g_object_unref0 (g);
}

static void
bird_font_bezier_tool_convert_zero_length_handles_to_lines (BirdFontBezierTool* self)
{
	BirdFontEditPoint* first = NULL;
	BirdFontEditPoint* last = NULL;
	BirdFontPath* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* _tmp2_;
	BirdFontEditPoint* _tmp3_;
	BirdFontEditPoint* _tmp4_;
	BirdFontEditPointHandle* _tmp5_;
	BirdFontEditPoint* _tmp8_;
	BirdFontEditPointHandle* _tmp9_;
	BirdFontPath* _tmp12_;
	BirdFontEditPoint* _tmp13_;
	BirdFontEditPoint* _tmp14_;
	BirdFontEditPoint* _tmp15_;
	BirdFontEditPoint* _tmp16_;
	BirdFontEditPointHandle* _tmp17_;
	BirdFontEditPoint* _tmp20_;
	BirdFontEditPointHandle* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_path;
	_tmp1_ = bird_font_path_get_first_point (_tmp0_);
	_g_object_unref0 (first);
	first = _tmp1_;
	_tmp2_ = first;
	bird_font_edit_point_set_tie_handles (_tmp2_, FALSE);
	_tmp3_ = first;
	bird_font_edit_point_set_reflective_point (_tmp3_, FALSE);
	_tmp4_ = first;
	_tmp5_ = bird_font_edit_point_get_left_handle (_tmp4_);
	if (_tmp5_->length == ((gdouble) 0)) {
		BirdFontEditPoint* _tmp6_;
		BirdFontEditPointHandle* _tmp7_;
		_tmp6_ = first;
		_tmp7_ = bird_font_edit_point_get_left_handle (_tmp6_);
		_tmp7_->length = 0.001;
	}
	_tmp8_ = first;
	_tmp9_ = bird_font_edit_point_get_right_handle (_tmp8_);
	if (_tmp9_->length == ((gdouble) 0)) {
		BirdFontEditPoint* _tmp10_;
		BirdFontEditPointHandle* _tmp11_;
		_tmp10_ = first;
		_tmp11_ = bird_font_edit_point_get_right_handle (_tmp10_);
		bird_font_edit_point_handle_convert_to_line (_tmp11_);
	}
	_tmp12_ = self->priv->current_path;
	_tmp13_ = bird_font_path_get_last_point (_tmp12_);
	_g_object_unref0 (last);
	last = _tmp13_;
	_tmp14_ = last;
	bird_font_edit_point_set_tie_handles (_tmp14_, FALSE);
	_tmp15_ = last;
	bird_font_edit_point_set_reflective_point (_tmp15_, FALSE);
	_tmp16_ = last;
	_tmp17_ = bird_font_edit_point_get_left_handle (_tmp16_);
	if (_tmp17_->length == ((gdouble) 0)) {
		BirdFontEditPoint* _tmp18_;
		BirdFontEditPointHandle* _tmp19_;
		_tmp18_ = last;
		_tmp19_ = bird_font_edit_point_get_left_handle (_tmp18_);
		_tmp19_->length = 0.001;
	}
	_tmp20_ = last;
	_tmp21_ = bird_font_edit_point_get_right_handle (_tmp20_);
	if (_tmp21_->length == ((gdouble) 0)) {
		BirdFontEditPoint* _tmp22_;
		BirdFontEditPointHandle* _tmp23_;
		_tmp22_ = last;
		_tmp23_ = bird_font_edit_point_get_right_handle (_tmp22_);
		bird_font_edit_point_handle_convert_to_line (_tmp23_);
	}
	_g_object_unref0 (last);
	_g_object_unref0 (first);
}

void
bird_font_bezier_tool_move (BirdFontBezierTool* self,
                            gint x,
                            gint y)
{
	gdouble px = 0.0;
	gdouble py = 0.0;
	BirdFontPath* _tmp36_;
	GeeArrayList* _tmp37_;
	GeeArrayList* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	g_return_if_fail (self != NULL);
	self->priv->last_x = x;
	self->priv->last_y = y;
	px = bird_font_glyph_path_coordinate_x ((gdouble) x);
	py = bird_font_glyph_path_coordinate_y ((gdouble) y);
	if (bird_font_grid_tool_is_visible ()) {
		bird_font_grid_tool_tie_coordinate (&px, &py);
	}
	if (self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_POINT) {
		BirdFontEditPoint* _tmp0_;
		BirdFontEditPoint* _tmp1_;
		BirdFontPath* _tmp2_;
		BirdFontPath* _tmp3_;
		BirdFontEditPoint* _tmp4_;
		BirdFontPath* _tmp5_;
		BirdFontEditPoint* _tmp6_;
		_tmp0_ = self->priv->current_point;
		_tmp0_->x = px;
		_tmp1_ = self->priv->current_point;
		_tmp1_->y = py;
		_tmp2_ = self->priv->current_path;
		_tmp2_->hide_end_handle = TRUE;
		_tmp3_ = self->priv->current_path;
		_tmp4_ = self->priv->current_point;
		bird_font_path_recalculate_linear_handles_for_point (_tmp3_, _tmp4_);
		_tmp5_ = self->priv->current_path;
		bird_font_path_reset_stroke (_tmp5_);
		_tmp6_ = self->priv->current_point;
		if (_tmp6_->type == BIRD_FONT_POINT_TYPE_QUADRATIC) {
			BirdFontPath* _tmp7_;
			BirdFontEditPoint* _tmp8_;
			BirdFontEditPoint* _tmp9_;
			BirdFontEditPointHandle* _tmp10_;
			_tmp7_ = self->priv->current_path;
			bird_font_path_create_list (_tmp7_);
			_tmp8_ = self->priv->current_point;
			_tmp9_ = bird_font_edit_point_get_prev (_tmp8_);
			_tmp10_ = bird_font_edit_point_get_right_handle (_tmp9_);
			bird_font_edit_point_handle_process_connected_handle (_tmp10_);
		}
		bird_font_glyph_canvas_redraw ();
	} else {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		if (self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_HANDLES) {
			_tmp12_ = TRUE;
		} else {
			_tmp12_ = self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_LAST_HANDLE_LEFT;
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_LAST_HANDLE_RIGHT;
		}
		if (_tmp11_) {
			BirdFontPath* _tmp13_;
			BirdFontPath* _tmp20_;
			_tmp13_ = self->priv->current_path;
			_tmp13_->hide_end_handle = FALSE;
			if (!self->priv->corner_node) {
				BirdFontEditPoint* _tmp14_;
				BirdFontEditPoint* _tmp15_;
				_tmp14_ = self->priv->current_point;
				bird_font_edit_point_set_reflective_handles (_tmp14_, TRUE);
				_tmp15_ = self->priv->current_point;
				bird_font_edit_point_convert_to_curve (_tmp15_);
			}
			if (self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_LAST_HANDLE_LEFT) {
				BirdFontEditPoint* _tmp16_;
				BirdFontEditPointHandle* _tmp17_;
				_tmp16_ = self->priv->current_point;
				_tmp17_ = bird_font_edit_point_get_left_handle (_tmp16_);
				bird_font_edit_point_handle_move_to_coordinate (_tmp17_, px, py);
			} else {
				BirdFontEditPoint* _tmp18_;
				BirdFontEditPointHandle* _tmp19_;
				_tmp18_ = self->priv->current_point;
				_tmp19_ = bird_font_edit_point_get_right_handle (_tmp18_);
				bird_font_edit_point_handle_move_to_coordinate (_tmp19_, px, py);
			}
			_tmp20_ = self->priv->current_path;
			bird_font_path_reset_stroke (_tmp20_);
			bird_font_glyph_canvas_redraw ();
		} else {
			if (self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_HANDLE_ON_AXIS) {
				BirdFontEditPointHandle* h = NULL;
				BirdFontEditPoint* _tmp21_;
				BirdFontEditPointHandle* _tmp22_;
				BirdFontEditPointHandle* _tmp23_;
				BirdFontPath* _tmp24_;
				BirdFontEditPoint* _tmp25_;
				BirdFontEditPoint* _tmp26_;
				gdouble tied_x = 0.0;
				gdouble tied_y = 0.0;
				BirdFontEditPointHandle* _tmp27_;
				BirdFontEditPoint* _tmp28_;
				BirdFontEditPointHandle* _tmp29_;
				BirdFontEditPoint* _tmp30_;
				gdouble _tmp31_ = 0.0;
				gdouble _tmp32_ = 0.0;
				BirdFontEditPointHandle* _tmp33_;
				BirdFontEditPointHandle* _tmp34_;
				BirdFontPath* _tmp35_;
				_tmp21_ = self->priv->current_point;
				_tmp22_ = bird_font_edit_point_get_right_handle (_tmp21_);
				_tmp23_ = _g_object_ref0 (_tmp22_);
				h = _tmp23_;
				_tmp24_ = self->priv->current_path;
				_tmp24_->hide_end_handle = FALSE;
				_tmp25_ = self->priv->current_point;
				bird_font_edit_point_set_reflective_handles (_tmp25_, TRUE);
				_tmp26_ = self->priv->current_point;
				bird_font_edit_point_convert_to_curve (_tmp26_);
				tied_x = (gdouble) 0;
				tied_y = (gdouble) 0;
				_tmp27_ = h;
				_tmp28_ = _tmp27_->parent;
				_tmp29_ = h;
				_tmp30_ = _tmp29_->parent;
				bird_font_point_tool_tie_angle (_tmp28_->x, _tmp30_->y, px, py, &_tmp31_, &_tmp32_);
				tied_x = _tmp31_;
				tied_y = _tmp32_;
				_tmp33_ = h;
				bird_font_edit_point_handle_set_x (_tmp33_, tied_x);
				_tmp34_ = h;
				bird_font_edit_point_handle_set_y (_tmp34_, tied_y);
				_tmp35_ = self->priv->current_path;
				bird_font_path_reset_stroke (_tmp35_);
				bird_font_glyph_canvas_redraw ();
				_g_object_unref0 (h);
			}
		}
	}
	_tmp36_ = self->priv->current_path;
	_tmp37_ = bird_font_path_get_points (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ > 0) {
		BirdFontPath* _tmp41_;
		BirdFontEditPoint* _tmp42_;
		BirdFontEditPoint* _tmp43_;
		BirdFontPath* _tmp44_;
		BirdFontEditPoint* _tmp45_;
		BirdFontEditPoint* _tmp46_;
		_tmp41_ = self->priv->current_path;
		_tmp42_ = bird_font_path_get_first_point (_tmp41_);
		_tmp43_ = _tmp42_;
		bird_font_edit_point_set_reflective_handles (_tmp43_, FALSE);
		_g_object_unref0 (_tmp43_);
		_tmp44_ = self->priv->current_path;
		_tmp45_ = bird_font_path_get_last_point (_tmp44_);
		_tmp46_ = _tmp45_;
		bird_font_edit_point_set_reflective_handles (_tmp46_, FALSE);
		_g_object_unref0 (_tmp46_);
	}
	bird_font_bezier_tool_convert_zero_length_handles_to_lines (self);
}

void
bird_font_bezier_tool_switch_to_line_mode (BirdFontBezierTool* self)
{
	gint s = 0;
	BirdFontPath* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	BirdFontEditPoint* p = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_path;
	_tmp1_ = bird_font_path_get_points (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	s = _tmp4_;
	if (s > 2) {
		BirdFontPath* _tmp5_;
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
		gpointer _tmp8_;
		BirdFontEditPoint* _tmp9_;
		BirdFontEditPoint* _tmp10_;
		BirdFontEditPoint* _tmp11_;
		BirdFontEditPointHandle* _tmp12_;
		BirdFontEditPoint* _tmp13_;
		BirdFontEditPointHandle* _tmp14_;
		BirdFontPath* _tmp15_;
		BirdFontEditPoint* _tmp16_;
		BirdFontPath* _tmp17_;
		BirdFontEditPoint* _tmp18_;
		BirdFontPath* _tmp19_;
		_tmp5_ = self->priv->current_path;
		_tmp6_ = bird_font_path_get_points (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, s - 2);
		_g_object_unref0 (p);
		p = (BirdFontEditPoint*) _tmp8_;
		_tmp9_ = p;
		bird_font_edit_point_set_tie_handle (_tmp9_, FALSE);
		_tmp10_ = p;
		bird_font_edit_point_set_reflective_handles (_tmp10_, FALSE);
		_tmp11_ = p;
		_tmp12_ = bird_font_edit_point_get_right_handle (_tmp11_);
		bird_font_edit_point_handle_convert_to_line (_tmp12_);
		_tmp13_ = self->priv->current_point;
		_tmp14_ = bird_font_edit_point_get_left_handle (_tmp13_);
		bird_font_edit_point_handle_convert_to_line (_tmp14_);
		_tmp15_ = self->priv->current_path;
		_tmp16_ = p;
		bird_font_path_recalculate_linear_handles_for_point (_tmp15_, _tmp16_);
		_tmp17_ = self->priv->current_path;
		_tmp18_ = self->priv->current_point;
		bird_font_path_recalculate_linear_handles_for_point (_tmp17_, _tmp18_);
		_tmp19_ = self->priv->current_path;
		bird_font_path_reset_stroke (_tmp19_);
		bird_font_glyph_canvas_redraw ();
		self->priv->state = BIRD_FONT_BEZIER_TOOL_MOVE_POINT;
	}
	_g_object_unref0 (p);
}

void
bird_font_bezier_tool_stop_drawing (BirdFontBezierTool* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->state == BIRD_FONT_BEZIER_TOOL_MOVE_POINT) {
		BirdFontPath* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp2_ = self->priv->current_path;
		_tmp3_ = bird_font_path_get_points (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		BirdFontPath* _tmp7_;
		_tmp7_ = self->priv->current_path;
		_tmp0_ = bird_font_path_is_open (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BirdFontPath* _tmp8_;
		BirdFontEditPoint* _tmp9_;
		BirdFontEditPoint* _tmp10_;
		BirdFontPath* _tmp11_;
		BirdFontPath* _tmp12_;
		_tmp8_ = self->priv->current_path;
		_tmp9_ = bird_font_path_delete_last_point (_tmp8_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp10_);
		_tmp11_ = self->priv->current_path;
		bird_font_path_reset_stroke (_tmp11_);
		_tmp12_ = self->priv->current_path;
		bird_font_path_create_full_stroke (_tmp12_);
	}
	self->priv->state = BIRD_FONT_BEZIER_TOOL_NONE;
}

static void
bird_font_bezier_tool_real_before_undo (BirdFontTool* base)
{
	BirdFontBezierTool * self;
	self = (BirdFontBezierTool*) base;
}

static void
bird_font_bezier_tool_real_after_undo (BirdFontTool* base)
{
	BirdFontBezierTool * self;
	self = (BirdFontBezierTool*) base;
	if (self->priv->state != BIRD_FONT_BEZIER_TOOL_NONE) {
		bird_font_main_window_set_cursor (BIRD_FONT_NATIVE_WINDOW_VISIBLE);
		self->priv->state = BIRD_FONT_BEZIER_TOOL_NONE;
	}
}

void
bird_font_bezier_tool_create_corner (BirdFontBezierTool* self)
{
	BirdFontGlyph* g = NULL;
	BirdFontGlyph* _tmp0_;
	BirdFontGlyph* _tmp1_;
	BirdFontPath* _tmp2_;
	BirdFontEditPoint* _tmp12_;
	BirdFontEditPoint* _tmp13_;
	BirdFontEditPointHandle* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_main_window_get_current_glyph ();
	g = _tmp0_;
	self->priv->corner_node = TRUE;
	_tmp1_ = g;
	bird_font_glyph_open_path (_tmp1_);
	_tmp2_ = self->priv->current_path;
	if (bird_font_path_is_open (_tmp2_)) {
		BirdFontPath* _tmp3_;
		BirdFontEditPoint* _tmp4_;
		BirdFontEditPoint* _tmp5_;
		BirdFontPath* _tmp6_;
		BirdFontPath* _tmp7_;
		BirdFontEditPoint* _tmp8_;
		BirdFontEditPoint* _tmp9_;
		BirdFontEditPoint* _tmp10_;
		_tmp3_ = self->priv->current_path;
		_tmp4_ = bird_font_path_delete_last_point (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp5_);
		_tmp6_ = self->priv->current_path;
		bird_font_path_reset_stroke (_tmp6_);
		_tmp7_ = self->priv->current_path;
		_tmp8_ = bird_font_path_get_last_point (_tmp7_);
		_g_object_unref0 (self->priv->current_point);
		self->priv->current_point = _tmp8_;
		_tmp9_ = self->priv->current_point;
		bird_font_edit_point_set_tie_handle (_tmp9_, FALSE);
		_tmp10_ = self->priv->current_point;
		bird_font_edit_point_set_reflective_handles (_tmp10_, FALSE);
		self->priv->state = BIRD_FONT_BEZIER_TOOL_MOVE_HANDLES;
	} else {
		guint _tmp11_ = 0U;
		if (self->priv->swap) {
			_tmp11_ = BIRD_FONT_BEZIER_TOOL_MOVE_LAST_HANDLE_RIGHT;
		} else {
			_tmp11_ = BIRD_FONT_BEZIER_TOOL_MOVE_LAST_HANDLE_LEFT;
		}
		self->priv->state = _tmp11_;
	}
	_tmp12_ = self->priv->current_point;
	bird_font_edit_point_set_reflective_handles (_tmp12_, FALSE);
	_tmp13_ = self->priv->current_point;
	_tmp14_ = bird_font_edit_point_get_right_handle (_tmp13_);
	bird_font_edit_point_handle_convert_to_curve (_tmp14_);
	_g_object_unref0 (g);
}

void
bird_font_bezier_tool_move_handle_on_axis (BirdFontBezierTool* self)
{
	g_return_if_fail (self != NULL);
	self->priv->state = BIRD_FONT_BEZIER_TOOL_MOVE_HANDLE_ON_AXIS;
}

static void
bird_font_bezier_tool_class_init (BirdFontBezierToolClass * klass,
                                  gpointer klass_data)
{
	bird_font_bezier_tool_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontBezierTool_private_offset);
	((BirdFontToolClass *) klass)->get_tip = (gchar* (*) (BirdFontTool*)) bird_font_bezier_tool_real_get_tip;
	((BirdFontToolClass *) klass)->before_undo = (void (*) (BirdFontTool*)) bird_font_bezier_tool_real_before_undo;
	((BirdFontToolClass *) klass)->after_undo = (void (*) (BirdFontTool*)) bird_font_bezier_tool_real_after_undo;
	G_OBJECT_CLASS (klass)->finalize = bird_font_bezier_tool_finalize;
}

static void
bird_font_bezier_tool_instance_init (BirdFontBezierTool * self,
                                     gpointer klass)
{
	BirdFontPath* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	self->priv = bird_font_bezier_tool_get_instance_private (self);
	self->priv->state = BIRD_FONT_BEZIER_TOOL_NONE;
	_tmp0_ = bird_font_path_new ();
	self->priv->current_path = _tmp0_;
	_tmp1_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	self->priv->current_point = _tmp1_;
	self->priv->last_x = 0;
	self->priv->last_y = 0;
	self->priv->last_release_time = (gdouble) 0;
	self->priv->last_press_time = (gdouble) 0;
	self->priv->button_down = FALSE;
	self->priv->corner_node = FALSE;
	self->priv->swap = FALSE;
}

static void
bird_font_bezier_tool_finalize (GObject * obj)
{
	BirdFontBezierTool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_BEZIER_TOOL, BirdFontBezierTool);
	_g_object_unref0 (self->priv->current_path);
	_g_object_unref0 (self->priv->current_point);
	G_OBJECT_CLASS (bird_font_bezier_tool_parent_class)->finalize (obj);
}

/** Create Bezier curves. */
static GType
bird_font_bezier_tool_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontBezierToolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_bezier_tool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontBezierTool), 0, (GInstanceInitFunc) bird_font_bezier_tool_instance_init, NULL };
	GType bird_font_bezier_tool_type_id;
	bird_font_bezier_tool_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL, "BirdFontBezierTool", &g_define_type_info, 0);
	BirdFontBezierTool_private_offset = g_type_add_instance_private (bird_font_bezier_tool_type_id, sizeof (BirdFontBezierToolPrivate));
	return bird_font_bezier_tool_type_id;
}

GType
bird_font_bezier_tool_get_type (void)
{
	static volatile gsize bird_font_bezier_tool_type_id__once = 0;
	if (g_once_init_enter (&bird_font_bezier_tool_type_id__once)) {
		GType bird_font_bezier_tool_type_id;
		bird_font_bezier_tool_type_id = bird_font_bezier_tool_get_type_once ();
		g_once_init_leave (&bird_font_bezier_tool_type_id__once, bird_font_bezier_tool_type_id);
	}
	return bird_font_bezier_tool_type_id__once;
}

