/* FkTable.c generated by valac 0.56.17, the Vala compiler
 * generated from FkTable.vala, do not modify */

/*
Copyright (C) 2022 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_FK_TABLE_0_PROPERTY,
	BIRD_FONT_FK_TABLE_NUM_PROPERTIES
};
static GParamSpec* bird_font_fk_table_properties[BIRD_FONT_FK_TABLE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block73Data Block73Data;

struct _BirdFontFkTablePrivate {
	BirdFontGlyfTable* glyf_table;
	BirdFontKernTable* kern_table;
};

struct _Block73Data {
	int _ref_count_;
	BirdFontFkTable* self;
	GeeArrayList* pairs;
};

static gint BirdFontFkTable_private_offset;
static gpointer bird_font_fk_table_parent_class = NULL;

static void bird_font_fk_table_real_parse (BirdFontOtfTable* base,
                                    BirdFontFontData* dis,
                                    GError** error);
static Block73Data* block73_data_ref (Block73Data* _data73_);
static void block73_data_unref (void * _userdata_);
static void __lambda58_ (Block73Data* _data73_,
                  const gchar* g1,
                  const gchar* g2,
                  gdouble kerning);
static void ___lambda58__bird_font_kerning_classes_kerning_class_iterator (const gchar* left,
                                                                    const gchar* right,
                                                                    gdouble kerning,
                                                                    gpointer self);
static gint __lambda59_ (BirdFontFkTable* self,
                  BirdFontFkKern* a,
                  BirdFontFkKern* b);
static gint ___lambda59__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void bird_font_fk_table_finalize (GObject * obj);
static GType bird_font_fk_table_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_fk_table_get_instance_private (BirdFontFkTable* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontFkTable_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontFkTable*
bird_font_fk_table_construct (GType object_type,
                              BirdFontGlyfTable* glyf_table,
                              BirdFontKernTable* kern_table)
{
	BirdFontFkTable * self = NULL;
	BirdFontGlyfTable* _tmp0_;
	BirdFontKernTable* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (glyf_table != NULL, NULL);
	g_return_val_if_fail (kern_table != NULL, NULL);
	self = (BirdFontFkTable*) bird_font_otf_table_construct (object_type);
	_tmp0_ = _g_object_ref0 (glyf_table);
	_g_object_unref0 (self->priv->glyf_table);
	self->priv->glyf_table = _tmp0_;
	_tmp1_ = _g_object_ref0 (kern_table);
	_g_object_unref0 (self->priv->kern_table);
	self->priv->kern_table = _tmp1_;
	_tmp2_ = g_strdup ("FK  ");
	_g_free0 (((BirdFontOtfTable*) self)->id);
	((BirdFontOtfTable*) self)->id = _tmp2_;
	return self;
}

BirdFontFkTable*
bird_font_fk_table_new (BirdFontGlyfTable* glyf_table,
                        BirdFontKernTable* kern_table)
{
	return bird_font_fk_table_construct (BIRD_FONT_TYPE_FK_TABLE, glyf_table, kern_table);
}

gint32
bird_font_fk_table_to_fixed (gdouble d)
{
	gint32 val = 0;
	gint32 mant = 0;
	gint32 result;
	val = (gint32) floor (d);
	mant = (gint32) floor (0x10000 * (d - val));
	val = (val << 16) | mant;
	result = val;
	return result;
}

gdouble
bird_font_fk_table_from_fixed (gint32 val)
{
	gdouble result;
	result = val / 65536.0;
	return result;
}

static void
bird_font_fk_table_real_parse (BirdFontOtfTable* base,
                               BirdFontFontData* dis,
                               GError** error)
{
	BirdFontFkTable * self;
	guint16 version_upper = 0U;
	guint16 version_lower = 0U;
	guint32 n_pairs = 0U;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	guint32 gid1 = 0U;
	guint32 gid2 = 0U;
	gint32 k = 0;
	gdouble kerning = 0.0;
	self = (BirdFontFkTable*) base;
	g_return_if_fail (dis != NULL);
	bird_font_font_data_seek (dis, (guint) ((BirdFontOtfTable*) self)->offset);
	version_upper = bird_font_font_data_read_ushort (dis);
	version_lower = bird_font_font_data_read_ushort (dis);
	if (((gint) version_upper) == 1) {
		_tmp0_ = ((gint) version_lower) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (!_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = g_strdup_printf ("%hu", version_upper);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf ("%hu", version_lower);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat ("Expecting version 1.0. Found version: ", _tmp2_, ".", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		g_warning ("FkTable.vala:50: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		return;
	}
	n_pairs = bird_font_font_data_read_ulong (dis);
	_tmp7_ = g_strdup_printf ("%u", n_pairs);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat ("Pairs in fk table ", _tmp8_, "\n", NULL);
	_tmp10_ = _tmp9_;
	bird_font_printd (_tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	gid1 = (guint32) -1;
	gid2 = (guint32) -1;
	k = (gint32) -1;
	kerning = (gdouble) -1;
	{
		guint32 i = 0U;
		i = (guint32) 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				BirdFontKernTable* _tmp13_;
				GeeArrayList* _tmp14_;
				BirdFontFkKern* _tmp15_;
				BirdFontFkKern* _tmp16_;
				if (!_tmp11_) {
					guint32 _tmp12_;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(i < n_pairs)) {
					break;
				}
				gid1 = bird_font_font_data_read_ulong (dis);
				gid2 = bird_font_font_data_read_ulong (dis);
				k = bird_font_font_data_read_int32 (dis);
				kerning = bird_font_fk_table_from_fixed (k);
				_tmp13_ = self->priv->kern_table;
				_tmp14_ = _tmp13_->fk_kerning;
				_tmp15_ = bird_font_fk_kern_new ((gint) gid1, (gint) gid2, kerning);
				_tmp16_ = _tmp15_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp16_);
				_g_object_unref0 (_tmp16_);
			}
		}
	}
	if (((guint) bird_font_font_data_get_read_pos (dis)) != bird_font_font_data_length_with_padding (dis)) {
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp17_ = g_strdup_printf ("%i", bird_font_font_data_get_read_pos (dis));
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("%u", bird_font_font_data_length_with_padding (dis));
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat ("Data left in fk table. Read pos ", _tmp18_, ", length: ", _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		g_warning ("FkTable.vala:72: %s", _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
	}
}

void
bird_font_fk_table_process (BirdFontFkTable* self,
                            GError** error)
{
	BirdFontFontData* fd = NULL;
	BirdFontFontData* _tmp0_;
	BirdFontKerningClasses* classes = NULL;
	BirdFontFont* _tmp1_;
	BirdFontFont* _tmp2_;
	BirdFontKerningClasses* _tmp3_;
	BirdFontKerningClasses* _tmp4_;
	BirdFontFontData* _tmp5_;
	BirdFontFontData* _tmp6_;
	BirdFontFontData* _tmp7_;
	BirdFontFontData* _tmp8_;
	BirdFontFontData* _tmp9_;
	BirdFontFontData* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_font_data_new ((guint32) 1024);
	fd = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	_tmp2_ = _tmp1_;
	_tmp3_ = bird_font_font_get_kerning_classes (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	classes = _tmp4_;
	_tmp5_ = fd;
	bird_font_font_data_add_ushort (_tmp5_, (guint16) 1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (classes);
		_g_object_unref0 (fd);
		return;
	}
	_tmp6_ = fd;
	bird_font_font_data_add_ushort (_tmp6_, (guint16) 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (classes);
		_g_object_unref0 (fd);
		return;
	}
	_tmp7_ = fd;
	bird_font_fk_table_write_kerning_pairs (self, _tmp7_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (classes);
		_g_object_unref0 (fd);
		return;
	}
	_tmp8_ = fd;
	bird_font_font_data_pad (_tmp8_);
	_tmp9_ = fd;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (((BirdFontOtfTable*) self)->font_data);
	((BirdFontOtfTable*) self)->font_data = _tmp10_;
	_g_object_unref0 (classes);
	_g_object_unref0 (fd);
}

static Block73Data*
block73_data_ref (Block73Data* _data73_)
{
	g_atomic_int_inc (&_data73_->_ref_count_);
	return _data73_;
}

static void
block73_data_unref (void * _userdata_)
{
	Block73Data* _data73_;
	_data73_ = (Block73Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data73_->_ref_count_)) {
		BirdFontFkTable* self;
		self = _data73_->self;
		_g_object_unref0 (_data73_->pairs);
		_g_object_unref0 (self);
		g_slice_free (Block73Data, _data73_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
__lambda58_ (Block73Data* _data73_,
             const gchar* g1,
             const gchar* g2,
             gdouble kerning)
{
	BirdFontFkTable* self;
	gint gid1 = 0;
	BirdFontGlyfTable* _tmp0_;
	gint gid2 = 0;
	BirdFontGlyfTable* _tmp1_;
	GeeArrayList* _tmp8_;
	BirdFontFkKern* _tmp9_;
	BirdFontFkKern* _tmp10_;
	self = _data73_->self;
	g_return_if_fail (g1 != NULL);
	g_return_if_fail (g2 != NULL);
	_tmp0_ = self->priv->glyf_table;
	gid1 = bird_font_glyf_table_get_gid (_tmp0_, g1);
	_tmp1_ = self->priv->glyf_table;
	gid2 = bird_font_glyf_table_get_gid (_tmp1_, g2);
	if (gid1 == -1) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = string_to_string (g1);
		_tmp3_ = g_strconcat ("Glyph id not found for ", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		g_warning ("FkTable.vala:98: %s", _tmp4_);
		_g_free0 (_tmp4_);
		return;
	}
	if (gid2 == -1) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = string_to_string (g2);
		_tmp6_ = g_strconcat ("Glyph not found for ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		g_warning ("FkTable.vala:103: %s", _tmp7_);
		_g_free0 (_tmp7_);
		return;
	}
	_tmp8_ = _data73_->pairs;
	_tmp9_ = bird_font_fk_kern_new ((gint) gid1, (gint) gid2, kerning);
	_tmp10_ = _tmp9_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp10_);
	_g_object_unref0 (_tmp10_);
}

static void
___lambda58__bird_font_kerning_classes_kerning_class_iterator (const gchar* left,
                                                               const gchar* right,
                                                               gdouble kerning,
                                                               gpointer self)
{
	__lambda58_ (self, left, right, kerning);
}

static gint
__lambda59_ (BirdFontFkTable* self,
             BirdFontFkKern* a,
             BirdFontFkKern* b)
{
	BirdFontFkKern* first = NULL;
	BirdFontFkKern* _tmp0_;
	BirdFontFkKern* next = NULL;
	BirdFontFkKern* _tmp1_;
	BirdFontFkKern* _tmp2_;
	BirdFontFkKern* _tmp3_;
	BirdFontFkKern* _tmp6_;
	BirdFontFkKern* _tmp7_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, BIRD_FONT_TYPE_FK_KERN, BirdFontFkKern));
	first = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, BIRD_FONT_TYPE_FK_KERN, BirdFontFkKern));
	next = _tmp1_;
	_tmp2_ = first;
	_tmp3_ = next;
	if (_tmp2_->left == _tmp3_->left) {
		BirdFontFkKern* _tmp4_;
		BirdFontFkKern* _tmp5_;
		_tmp4_ = first;
		_tmp5_ = next;
		result = _tmp4_->right - _tmp5_->right;
		_g_object_unref0 (next);
		_g_object_unref0 (first);
		return result;
	}
	_tmp6_ = first;
	_tmp7_ = next;
	result = _tmp6_->left - _tmp7_->left;
	_g_object_unref0 (next);
	_g_object_unref0 (first);
	return result;
}

static gint
___lambda59__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda59_ ((BirdFontFkTable*) self, (BirdFontFkKern*) a, (BirdFontFkKern*) b);
	return result;
}

void
bird_font_fk_table_write_kerning_pairs (BirdFontFkTable* self,
                                        BirdFontFontData* fd,
                                        GError** error)
{
	Block73Data* _data73_;
	BirdFontKerningClasses* classes = NULL;
	BirdFontFont* _tmp0_;
	BirdFontFont* _tmp1_;
	BirdFontKerningClasses* _tmp2_;
	BirdFontKerningClasses* _tmp3_;
	GeeArrayList* _tmp4_;
	BirdFontKerningClasses* _tmp5_;
	GeeArrayList* _tmp6_;
	guint32 num_pairs = 0U;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fd != NULL);
	_data73_ = g_slice_new0 (Block73Data);
	_data73_->_ref_count_ = 1;
	_data73_->self = g_object_ref (self);
	_tmp0_ = bird_font_bird_font_get_current_font ();
	_tmp1_ = _tmp0_;
	_tmp2_ = bird_font_font_get_kerning_classes (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	classes = _tmp3_;
	_tmp4_ = gee_array_list_new (BIRD_FONT_TYPE_FK_KERN, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data73_->pairs = _tmp4_;
	_tmp5_ = classes;
	bird_font_kerning_classes_each_pair (_tmp5_, ___lambda58__bird_font_kerning_classes_kerning_class_iterator, _data73_);
	_tmp6_ = _data73_->pairs;
	gee_list_sort ((GeeList*) _tmp6_, ___lambda59__gcompare_data_func, g_object_ref (self), g_object_unref);
	_tmp7_ = _data73_->pairs;
	_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	num_pairs = (guint32) _tmp9_;
	bird_font_font_data_add_ulong (fd, num_pairs, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (classes);
		block73_data_unref (_data73_);
		_data73_ = NULL;
		return;
	}
	{
		GeeArrayList* _k_list = NULL;
		GeeArrayList* _tmp10_;
		gint _k_size = 0;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _k_index = 0;
		_tmp10_ = _data73_->pairs;
		_k_list = _tmp10_;
		_tmp11_ = _k_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_k_size = _tmp13_;
		_k_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			BirdFontFkKern* k = NULL;
			GeeArrayList* _tmp16_;
			gpointer _tmp17_;
			BirdFontFkKern* _tmp18_;
			BirdFontFkKern* _tmp19_;
			BirdFontFkKern* _tmp20_;
			_k_index = _k_index + 1;
			_tmp14_ = _k_index;
			_tmp15_ = _k_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _k_list;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _k_index);
			k = (BirdFontFkKern*) _tmp17_;
			_tmp18_ = k;
			_tmp19_ = k;
			_tmp20_ = k;
			bird_font_fk_table_write_pair (self, fd, _tmp18_->left, _tmp19_->right, _tmp20_->kerning, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (k);
				_g_object_unref0 (classes);
				block73_data_unref (_data73_);
				_data73_ = NULL;
				return;
			}
			_g_object_unref0 (k);
		}
	}
	_g_object_unref0 (classes);
	block73_data_unref (_data73_);
	_data73_ = NULL;
}

void
bird_font_fk_table_write_pair (BirdFontFkTable* self,
                               BirdFontFontData* fd,
                               gint gid1,
                               gint gid2,
                               gdouble kerning,
                               GError** error)
{
	gint32 fixed_kerning = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fd != NULL);
	if (gid1 < 0) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		GError* _tmp5_;
		g_warning ("FkTable.vala:131: %s", "Negative gid1.");
		_tmp0_ = g_strdup_printf ("%i", gid1);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strconcat ("gid1 is ", _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, _tmp3_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (gid2 < 0) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GError* _tmp10_;
		GError* _tmp11_;
		g_warning ("FkTable.vala:136: %s", "Negative gid2.");
		_tmp6_ = g_strdup_printf ("%i", gid2);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("gid2 is ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_inner_error0_ = _tmp11_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	fixed_kerning = bird_font_fk_table_to_fixed (kerning * bird_font_head_table_UNITS);
	bird_font_font_data_add_ulong (fd, (guint32) ((guint) gid1), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	bird_font_font_data_add_ulong (fd, (guint32) ((guint) gid2), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	bird_font_font_data_add_long (fd, fixed_kerning, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
bird_font_fk_table_class_init (BirdFontFkTableClass * klass,
                               gpointer klass_data)
{
	bird_font_fk_table_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontFkTable_private_offset);
	((BirdFontOtfTableClass *) klass)->parse = (void (*) (BirdFontOtfTable*, BirdFontFontData*, GError**)) bird_font_fk_table_real_parse;
	G_OBJECT_CLASS (klass)->finalize = bird_font_fk_table_finalize;
}

static void
bird_font_fk_table_instance_init (BirdFontFkTable * self,
                                  gpointer klass)
{
	self->priv = bird_font_fk_table_get_instance_private (self);
}

static void
bird_font_fk_table_finalize (GObject * obj)
{
	BirdFontFkTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_FK_TABLE, BirdFontFkTable);
	_g_object_unref0 (self->priv->glyf_table);
	_g_object_unref0 (self->priv->kern_table);
	G_OBJECT_CLASS (bird_font_fk_table_parent_class)->finalize (obj);
}

static GType
bird_font_fk_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontFkTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_fk_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontFkTable), 0, (GInstanceInitFunc) bird_font_fk_table_instance_init, NULL };
	GType bird_font_fk_table_type_id;
	bird_font_fk_table_type_id = g_type_register_static (BIRD_FONT_TYPE_OTF_TABLE, "BirdFontFkTable", &g_define_type_info, 0);
	BirdFontFkTable_private_offset = g_type_add_instance_private (bird_font_fk_table_type_id, sizeof (BirdFontFkTablePrivate));
	return bird_font_fk_table_type_id;
}

GType
bird_font_fk_table_get_type (void)
{
	static volatile gsize bird_font_fk_table_type_id__once = 0;
	if (g_once_init_enter (&bird_font_fk_table_type_id__once)) {
		GType bird_font_fk_table_type_id;
		bird_font_fk_table_type_id = bird_font_fk_table_get_type_once ();
		g_once_init_leave (&bird_font_fk_table_type_id__once, bird_font_fk_table_type_id);
	}
	return bird_font_fk_table_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

