/* KerningStrings.c generated by valac 0.56.17, the Vala compiler
 * generated from KerningStrings.vala, do not modify */

/*
Copyright (C) 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_KERNING_STRINGS_0_PROPERTY,
	BIRD_FONT_KERNING_STRINGS_NUM_PROPERTIES
};
static GParamSpec* bird_font_kerning_strings_properties[BIRD_FONT_KERNING_STRINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BirdFontKerningStringsPrivate {
	GeeArrayList* kerning_strings;
	gint current_position;
};

static gint BirdFontKerningStrings_private_offset;
static gpointer bird_font_kerning_strings_parent_class = NULL;

static void __lambda321_ (BirdFontKerningStrings* self,
                   const gchar* f);
static void ___lambda321__bird_font_file_chooser_file_selected (BirdFontFileChooser* _sender,
                                                         const gchar* path,
                                                         gpointer self);
static void bird_font_kerning_strings_finalize (GObject * obj);
static GType bird_font_kerning_strings_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
bird_font_kerning_strings_get_instance_private (BirdFontKerningStrings* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontKerningStrings_private_offset);
}

BirdFontKerningStrings*
bird_font_kerning_strings_construct (GType object_type)
{
	BirdFontKerningStrings * self = NULL;
	self = (BirdFontKerningStrings*) g_object_new (object_type, NULL);
	return self;
}

BirdFontKerningStrings*
bird_font_kerning_strings_new (void)
{
	return bird_font_kerning_strings_construct (BIRD_FONT_TYPE_KERNING_STRINGS);
}

gboolean
bird_font_kerning_strings_is_empty (BirdFontKerningStrings* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->kerning_strings;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == 0;
	return result;
}

gchar*
bird_font_kerning_strings_next (BirdFontKerningStrings* self)
{
	gchar* w = NULL;
	gchar* _tmp0_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	w = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	font = _tmp1_;
	_tmp2_ = self->priv->kerning_strings;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->current_position;
	if ((0 <= _tmp5_) && (_tmp5_ < _tmp4_)) {
		GeeArrayList* _tmp6_;
		gpointer _tmp7_;
		gint _tmp8_;
		BirdFontFont* _tmp9_;
		BirdFontFontSettings* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp6_ = self->priv->kerning_strings;
		_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, self->priv->current_position);
		_g_free0 (w);
		w = (gchar*) _tmp7_;
		_tmp8_ = self->priv->current_position;
		self->priv->current_position = _tmp8_ + 1;
		_tmp9_ = font;
		_tmp10_ = _tmp9_->settings;
		_tmp11_ = g_strdup_printf ("%i", self->priv->current_position);
		_tmp12_ = _tmp11_;
		bird_font_font_settings_set_setting (_tmp10_, "kerning_string_position", _tmp12_);
		_g_free0 (_tmp12_);
	}
	result = w;
	_g_object_unref0 (font);
	return result;
}

gchar*
bird_font_kerning_strings_previous (BirdFontKerningStrings* self)
{
	gchar* w = NULL;
	gchar* _tmp0_;
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	w = _tmp0_;
	_tmp1_ = bird_font_bird_font_get_current_font ();
	font = _tmp1_;
	_tmp2_ = self->priv->kerning_strings;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->current_position - 1;
	if ((0 <= _tmp5_) && (_tmp5_ < _tmp4_)) {
		gint _tmp6_;
		GeeArrayList* _tmp7_;
		gpointer _tmp8_;
		BirdFontFont* _tmp9_;
		BirdFontFontSettings* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp6_ = self->priv->current_position;
		self->priv->current_position = _tmp6_ - 1;
		_tmp7_ = self->priv->kerning_strings;
		_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, self->priv->current_position);
		_g_free0 (w);
		w = (gchar*) _tmp8_;
		_tmp9_ = font;
		_tmp10_ = _tmp9_->settings;
		_tmp11_ = g_strdup_printf ("%i", self->priv->current_position);
		_tmp12_ = _tmp11_;
		bird_font_font_settings_set_setting (_tmp10_, "kerning_string_position", _tmp12_);
		_g_free0 (_tmp12_);
	}
	result = w;
	_g_object_unref0 (font);
	return result;
}

static void
__lambda321_ (BirdFontKerningStrings* self,
              const gchar* f)
{
	BirdFontFont* font = NULL;
	BirdFontFont* _tmp0_;
	_tmp0_ = bird_font_bird_font_get_current_font ();
	font = _tmp0_;
	if (f != NULL) {
		BirdFontFont* _tmp1_;
		_tmp1_ = font;
		bird_font_kerning_strings_load_new_string (self, _tmp1_, (const gchar*) f);
	}
	_g_object_unref0 (font);
}

static void
___lambda321__bird_font_file_chooser_file_selected (BirdFontFileChooser* _sender,
                                                    const gchar* path,
                                                    gpointer self)
{
	__lambda321_ ((BirdFontKerningStrings*) self, path);
}

void
bird_font_kerning_strings_load_file (BirdFontKerningStrings* self)
{
	BirdFontFileChooser* fc = NULL;
	BirdFontFileChooser* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bird_font_file_chooser_new ();
	fc = _tmp0_;
	g_signal_connect_object (fc, "file-selected", (GCallback) ___lambda321__bird_font_file_chooser_file_selected, self, 0);
	_tmp1_ = bird_font_t_ ("Load kerning strings");
	_tmp2_ = _tmp1_;
	bird_font_main_window_file_chooser (_tmp2_, fc, BIRD_FONT_FILE_CHOOSER_LOAD);
	_g_free0 (_tmp2_);
	_g_object_unref0 (fc);
}

void
bird_font_kerning_strings_load (BirdFontKerningStrings* self,
                                BirdFontFont* font)
{
	gchar* path = NULL;
	BirdFontFontSettings* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (font != NULL);
	_tmp0_ = font->settings;
	_tmp1_ = bird_font_font_settings_get_setting (_tmp0_, "kerning_string_file");
	_g_free0 (path);
	path = _tmp1_;
	_tmp2_ = path;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		const gchar* _tmp3_;
		BirdFontFontSettings* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = path;
		bird_font_kerning_strings_load_new_string (self, font, _tmp3_);
		_tmp4_ = font->settings;
		_tmp5_ = bird_font_font_settings_get_setting (_tmp4_, "kerning_string_position");
		_tmp6_ = _tmp5_;
		self->priv->current_position = atoi (_tmp6_);
		_g_free0 (_tmp6_);
	}
	_g_free0 (path);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
bird_font_kerning_strings_load_new_string (BirdFontKerningStrings* self,
                                           BirdFontFont* font,
                                           const gchar* kerning_strings_file)
{
	gchar* data = NULL;
	gchar** strings = NULL;
	gint strings_length1 = 0;
	gint _strings_size_ = 0;
	gchar* w = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (font != NULL);
	g_return_if_fail (kerning_strings_file != NULL);
	{
		GeeArrayList* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		BirdFontFontSettings* _tmp13_;
		_tmp0_ = self->priv->kerning_strings;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
		g_file_get_contents (kerning_strings_file, &_tmp1_, NULL, &_inner_error0_);
		_g_free0 (data);
		data = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = string_replace (data, "\n", " ");
		_tmp3_ = _tmp2_;
		_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, " ", 0);
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
		strings = _tmp5_;
		strings_length1 = _vala_array_length (_tmp4_);
		_strings_size_ = strings_length1;
		_g_free0 (_tmp3_);
		_tmp6_ = strings;
		_tmp6__length1 = strings_length1;
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp6_;
			s_collection_length1 = _tmp6__length1;
			for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
				gchar* _tmp7_;
				gchar* s = NULL;
				_tmp7_ = g_strdup (s_collection[s_it]);
				s = _tmp7_;
				{
					const gchar* _tmp8_;
					gchar* _tmp9_;
					const gchar* _tmp10_;
					_tmp8_ = s;
					_tmp9_ = string_replace (_tmp8_, "\r", "");
					_g_free0 (w);
					w = _tmp9_;
					_tmp10_ = w;
					if (g_strcmp0 (_tmp10_, "") != 0) {
						GeeArrayList* _tmp11_;
						const gchar* _tmp12_;
						_tmp11_ = self->priv->kerning_strings;
						_tmp12_ = s;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
					}
					_g_free0 (s);
				}
			}
		}
		self->priv->current_position = 0;
		_tmp13_ = font->settings;
		bird_font_font_settings_set_setting (_tmp13_, "kerning_string_file", kerning_strings_file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("KerningStrings.vala:101: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (w);
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (w);
	strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
}

static void
bird_font_kerning_strings_class_init (BirdFontKerningStringsClass * klass,
                                      gpointer klass_data)
{
	bird_font_kerning_strings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontKerningStrings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_kerning_strings_finalize;
}

static void
bird_font_kerning_strings_instance_init (BirdFontKerningStrings * self,
                                         gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = bird_font_kerning_strings_get_instance_private (self);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->priv->kerning_strings = _tmp0_;
	self->priv->current_position = 0;
}

static void
bird_font_kerning_strings_finalize (GObject * obj)
{
	BirdFontKerningStrings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_KERNING_STRINGS, BirdFontKerningStrings);
	_g_object_unref0 (self->priv->kerning_strings);
	G_OBJECT_CLASS (bird_font_kerning_strings_parent_class)->finalize (obj);
}

static GType
bird_font_kerning_strings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontKerningStringsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_kerning_strings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontKerningStrings), 0, (GInstanceInitFunc) bird_font_kerning_strings_instance_init, NULL };
	GType bird_font_kerning_strings_type_id;
	bird_font_kerning_strings_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontKerningStrings", &g_define_type_info, 0);
	BirdFontKerningStrings_private_offset = g_type_add_instance_private (bird_font_kerning_strings_type_id, sizeof (BirdFontKerningStringsPrivate));
	return bird_font_kerning_strings_type_id;
}

GType
bird_font_kerning_strings_get_type (void)
{
	static volatile gsize bird_font_kerning_strings_type_id__once = 0;
	if (g_once_init_enter (&bird_font_kerning_strings_type_id__once)) {
		GType bird_font_kerning_strings_type_id;
		bird_font_kerning_strings_type_id = bird_font_kerning_strings_get_type_once ();
		g_once_init_leave (&bird_font_kerning_strings_type_id__once, bird_font_kerning_strings_type_id);
	}
	return bird_font_kerning_strings_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

