/* PointConverter.c generated by valac 0.56.17, the Vala compiler
 * generated from PointConverter.vala, do not modify */

/*
Copyright (C) 2014 2016 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block53Data Block53Data;
typedef struct _Block54Data Block54Data;
typedef struct _BirdFontParamSpecPointConverter BirdFontParamSpecPointConverter;

struct _BirdFontPointConverterPrivate {
	BirdFontPath* original_path;
	BirdFontPath* quadratic_path;
};

struct _Block53Data {
	int _ref_count_;
	gdouble max_d;
	gdouble min_d;
	gint steps;
	gdouble x_out;
	gdouble y_out;
	gdouble step_out;
	BirdFontEditPoint* b0;
	BirdFontEditPoint* b1;
};

struct _Block54Data {
	int _ref_count_;
	Block53Data * _data53_;
	gdouble xa;
	gdouble ya;
};

struct _BirdFontParamSpecPointConverter {
	GParamSpec parent_instance;
};

static gint BirdFontPointConverter_private_offset;
static gpointer bird_font_point_converter_parent_class = NULL;

static Block53Data* block53_data_ref (Block53Data* _data53_);
static void block53_data_unref (void * _userdata_);
static gboolean __lambda117_ (Block53Data* _data53_,
                       gdouble xa,
                       gdouble ya,
                       gdouble ta);
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
static gboolean __lambda118_ (Block54Data* _data54_,
                       gdouble xb,
                       gdouble yb,
                       gdouble tb);
static gboolean ___lambda118__bird_font_path_raster_iterator (gdouble x,
                                                       gdouble y,
                                                       gdouble step,
                                                       gpointer self);
static gboolean ___lambda117__bird_font_path_raster_iterator (gdouble x,
                                                       gdouble y,
                                                       gdouble step,
                                                       gpointer self);
static void bird_font_point_converter_finalize (BirdFontPointConverter * obj);
static GType bird_font_point_converter_get_type_once (void);

static inline gpointer
bird_font_point_converter_get_instance_private (BirdFontPointConverter* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontPointConverter_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BirdFontPointConverter*
bird_font_point_converter_construct (GType object_type,
                                     BirdFontPath* path)
{
	BirdFontPointConverter* self = NULL;
	BirdFontPath* _tmp0_;
	g_return_val_if_fail (path != NULL, NULL);
	self = (BirdFontPointConverter*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (path);
	_g_object_unref0 (self->priv->original_path);
	self->priv->original_path = _tmp0_;
	return self;
}

BirdFontPointConverter*
bird_font_point_converter_new (BirdFontPath* path)
{
	return bird_font_point_converter_construct (BIRD_FONT_TYPE_POINT_CONVERTER, path);
}

BirdFontPath*
bird_font_point_converter_get_quadratic_path (BirdFontPointConverter* self)
{
	gboolean add_more_points = FALSE;
	BirdFontPath* _tmp0_;
	BirdFontPath* _tmp1_;
	BirdFontPath* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	BirdFontPath* _tmp23_;
	BirdFontPath* _tmp35_;
	BirdFontPath* _tmp36_;
	BirdFontPath* _tmp37_;
	BirdFontPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	add_more_points = FALSE;
	_tmp0_ = self->priv->original_path;
	_tmp1_ = bird_font_path_copy (_tmp0_);
	_g_object_unref0 (self->priv->quadratic_path);
	self->priv->quadratic_path = _tmp1_;
	bird_font_point_converter_estimated_cubic_path (self);
	if (add_more_points) {
		g_warning ("PointConverter.vala:38: Too many points in segment.");
	}
	_tmp2_ = self->priv->quadratic_path;
	_tmp3_ = bird_font_path_get_points (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ < 2) {
		BirdFontPath* _tmp7_;
		_tmp7_ = bird_font_path_new ();
		result = _tmp7_;
		return result;
	}
	{
		GeeArrayList* _e_list = NULL;
		BirdFontPath* _tmp8_;
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		gint _e_size = 0;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _e_index = 0;
		_tmp8_ = self->priv->quadratic_path;
		_tmp9_ = bird_font_path_get_points (_tmp8_);
		_tmp10_ = _tmp9_;
		_e_list = _tmp10_;
		_tmp11_ = _e_list;
		_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_e_size = _tmp13_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			BirdFontEditPoint* e = NULL;
			GeeArrayList* _tmp16_;
			gpointer _tmp17_;
			BirdFontEditPoint* _tmp18_;
			BirdFontEditPointHandle* _tmp19_;
			_e_index = _e_index + 1;
			_tmp14_ = _e_index;
			_tmp15_ = _e_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _e_list;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _e_index);
			e = (BirdFontEditPoint*) _tmp17_;
			_tmp18_ = e;
			_tmp19_ = bird_font_edit_point_get_right_handle (_tmp18_);
			if (_tmp19_->type == BIRD_FONT_POINT_TYPE_CUBIC) {
				BirdFontEditPoint* _tmp20_;
				BirdFontEditPoint* _tmp21_;
				BirdFontEditPoint* _tmp22_;
				_tmp20_ = e;
				_tmp21_ = e;
				_tmp22_ = bird_font_edit_point_get_next (_tmp21_);
				bird_font_pen_tool_convert_point_segment_type (_tmp20_, _tmp22_, BIRD_FONT_POINT_TYPE_DOUBLE_CURVE);
			}
			_g_object_unref0 (e);
		}
	}
	_tmp23_ = self->priv->original_path;
	if (!bird_font_path_is_open (_tmp23_)) {
		BirdFontPath* _tmp24_;
		BirdFontEditPoint* _tmp25_;
		BirdFontEditPoint* _tmp26_;
		BirdFontEditPointHandle* _tmp27_;
		gboolean _tmp28_;
		_tmp24_ = self->priv->quadratic_path;
		_tmp25_ = bird_font_path_get_last_point (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = bird_font_edit_point_get_right_handle (_tmp26_);
		_tmp28_ = _tmp27_->type == BIRD_FONT_POINT_TYPE_CUBIC;
		_g_object_unref0 (_tmp26_);
		if (_tmp28_) {
			BirdFontPath* _tmp29_;
			BirdFontEditPoint* _tmp30_;
			BirdFontEditPoint* _tmp31_;
			BirdFontPath* _tmp32_;
			BirdFontEditPoint* _tmp33_;
			BirdFontEditPoint* _tmp34_;
			_tmp29_ = self->priv->quadratic_path;
			_tmp30_ = bird_font_path_get_last_point (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = self->priv->quadratic_path;
			_tmp33_ = bird_font_path_get_first_point (_tmp32_);
			_tmp34_ = _tmp33_;
			bird_font_pen_tool_convert_point_segment_type (_tmp31_, _tmp34_, BIRD_FONT_POINT_TYPE_DOUBLE_CURVE);
			_g_object_unref0 (_tmp34_);
			_g_object_unref0 (_tmp31_);
		}
	}
	_tmp35_ = self->priv->quadratic_path;
	bird_font_path_add_hidden_double_points (_tmp35_);
	_tmp36_ = self->priv->quadratic_path;
	_tmp37_ = _g_object_ref0 (_tmp36_);
	result = _tmp37_;
	return result;
}

void
bird_font_point_converter_estimated_cubic_path (BirdFontPointConverter* self)
{
	BirdFontEditPoint* segment_start = NULL;
	BirdFontEditPoint* segment_stop = NULL;
	BirdFontEditPoint* quadratic_segment_start = NULL;
	BirdFontEditPoint* quadratic_segment_stop = NULL;
	BirdFontEditPoint* e = NULL;
	gdouble distance = 0.0;
	gdouble step = 0.0;
	gint points_in_segment = 0;
	gint size = 0;
	BirdFontPath* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	BirdFontPath* _tmp17_;
	BirdFontEditPoint* _tmp18_;
	BirdFontPath* _tmp19_;
	g_return_if_fail (self != NULL);
	points_in_segment = 0;
	{
		GeeArrayList* _ep_list = NULL;
		BirdFontPath* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _ep_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _ep_index = 0;
		_tmp0_ = self->priv->quadratic_path;
		_tmp1_ = bird_font_path_get_points (_tmp0_);
		_tmp2_ = _tmp1_;
		_ep_list = _tmp2_;
		_tmp3_ = _ep_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_ep_size = _tmp5_;
		_ep_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			BirdFontEditPoint* ep = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			BirdFontEditPoint* _tmp10_;
			BirdFontEditPoint* _tmp11_;
			_ep_index = _ep_index + 1;
			_tmp6_ = _ep_index;
			_tmp7_ = _ep_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _ep_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _ep_index);
			ep = (BirdFontEditPoint*) _tmp9_;
			_tmp10_ = ep;
			bird_font_edit_point_set_tie_handle (_tmp10_, FALSE);
			_tmp11_ = ep;
			bird_font_edit_point_set_reflective_handles (_tmp11_, FALSE);
			_g_object_unref0 (ep);
		}
	}
	_tmp12_ = self->priv->quadratic_path;
	_tmp13_ = bird_font_path_get_points (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	size = _tmp16_;
	_tmp17_ = self->priv->quadratic_path;
	_tmp18_ = bird_font_path_get_first_point (_tmp17_);
	_g_object_unref0 (segment_start);
	segment_start = _tmp18_;
	_tmp19_ = self->priv->original_path;
	if (bird_font_path_is_open (_tmp19_)) {
		gint _tmp20_;
		_tmp20_ = size;
		size = _tmp20_ - 1;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				BirdFontEditPoint* _tmp23_ = NULL;
				BirdFontEditPoint* _tmp29_;
				BirdFontEditPoint* _tmp30_;
				BirdFontEditPoint* _tmp31_;
				BirdFontEditPoint* _tmp32_;
				BirdFontEditPoint* _tmp33_;
				BirdFontEditPoint* _tmp34_;
				BirdFontEditPoint* _tmp35_;
				BirdFontEditPoint* _tmp36_;
				gboolean _tmp37_ = FALSE;
				BirdFontEditPoint* _tmp38_;
				BirdFontEditPointHandle* _tmp39_;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				if (!(i < size)) {
					break;
				}
				if (i == (size - 1)) {
					BirdFontPath* _tmp24_;
					BirdFontEditPoint* _tmp25_;
					_tmp24_ = self->priv->quadratic_path;
					_tmp25_ = bird_font_path_get_first_point (_tmp24_);
					_g_object_unref0 (_tmp23_);
					_tmp23_ = _tmp25_;
				} else {
					BirdFontEditPoint* _tmp26_;
					BirdFontEditPoint* _tmp27_;
					BirdFontEditPoint* _tmp28_;
					_tmp26_ = segment_start;
					_tmp27_ = bird_font_edit_point_get_next (_tmp26_);
					_tmp28_ = _g_object_ref0 (_tmp27_);
					_g_object_unref0 (_tmp23_);
					_tmp23_ = _tmp28_;
				}
				_tmp29_ = _g_object_ref0 (_tmp23_);
				_g_object_unref0 (segment_stop);
				segment_stop = _tmp29_;
				_tmp30_ = segment_start;
				_tmp31_ = bird_font_edit_point_copy (_tmp30_);
				_g_object_unref0 (quadratic_segment_start);
				quadratic_segment_start = _tmp31_;
				_tmp32_ = segment_stop;
				_tmp33_ = bird_font_edit_point_copy (_tmp32_);
				_g_object_unref0 (quadratic_segment_stop);
				quadratic_segment_stop = _tmp33_;
				_tmp34_ = quadratic_segment_start;
				_tmp35_ = quadratic_segment_stop;
				bird_font_pen_tool_convert_point_segment_type (_tmp34_, _tmp35_, BIRD_FONT_POINT_TYPE_DOUBLE_CURVE);
				distance = (gdouble) 0;
				_tmp36_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
				_g_object_unref0 (e);
				e = _tmp36_;
				_tmp38_ = segment_start;
				_tmp39_ = bird_font_edit_point_get_right_handle (_tmp38_);
				if (bird_font_edit_point_handle_is_line (_tmp39_)) {
					BirdFontEditPoint* _tmp40_;
					BirdFontEditPointHandle* _tmp41_;
					_tmp40_ = segment_stop;
					_tmp41_ = bird_font_edit_point_get_left_handle (_tmp40_);
					_tmp37_ = bird_font_edit_point_handle_is_line (_tmp41_);
				} else {
					_tmp37_ = FALSE;
				}
				if (_tmp37_) {
				} else {
					if (points_in_segment >= 10) {
						g_warning ("PointConverter.vala:105: Too many points.");
					} else {
						BirdFontEditPoint* _tmp42_;
						BirdFontEditPoint* _tmp43_;
						BirdFontEditPoint* _tmp44_;
						BirdFontEditPoint* _tmp45_;
						gdouble _tmp46_ = 0.0;
						BirdFontEditPoint* _tmp47_ = NULL;
						gdouble _tmp48_ = 0.0;
						_tmp42_ = segment_start;
						_tmp43_ = segment_stop;
						_tmp44_ = quadratic_segment_start;
						_tmp45_ = quadratic_segment_stop;
						bird_font_point_converter_find_largest_distance (_tmp42_, _tmp43_, _tmp44_, _tmp45_, &_tmp46_, &_tmp47_, &_tmp48_);
						distance = _tmp46_;
						_g_object_unref0 (e);
						e = _tmp47_;
						step = _tmp48_;
					}
				}
				if (distance > 0.2) {
					BirdFontPath* _tmp49_;
					BirdFontEditPoint* _tmp50_;
					gint _tmp51_;
					_tmp49_ = self->priv->quadratic_path;
					_tmp50_ = e;
					bird_font_path_insert_new_point_on_path (_tmp49_, _tmp50_, (gdouble) -1, FALSE);
					_tmp51_ = points_in_segment;
					points_in_segment = _tmp51_ + 1;
					size += 2;
				} else {
					BirdFontEditPoint* _tmp52_;
					BirdFontEditPoint* _tmp53_;
					points_in_segment = 0;
					_tmp52_ = segment_stop;
					_tmp53_ = _g_object_ref0 (_tmp52_);
					_g_object_unref0 (segment_start);
					segment_start = _tmp53_;
				}
				_g_object_unref0 (_tmp23_);
			}
		}
	}
	_g_object_unref0 (e);
	_g_object_unref0 (quadratic_segment_stop);
	_g_object_unref0 (quadratic_segment_start);
	_g_object_unref0 (segment_stop);
	_g_object_unref0 (segment_start);
}

static Block53Data*
block53_data_ref (Block53Data* _data53_)
{
	g_atomic_int_inc (&_data53_->_ref_count_);
	return _data53_;
}

static void
block53_data_unref (void * _userdata_)
{
	Block53Data* _data53_;
	_data53_ = (Block53Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data53_->_ref_count_)) {
		_g_object_unref0 (_data53_->b0);
		_g_object_unref0 (_data53_->b1);
		g_slice_free (Block53Data, _data53_);
	}
}

static Block54Data*
block54_data_ref (Block54Data* _data54_)
{
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}

static void
block54_data_unref (void * _userdata_)
{
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		block53_data_unref (_data54_->_data53_);
		_data54_->_data53_ = NULL;
		g_slice_free (Block54Data, _data54_);
	}
}

static gboolean
__lambda118_ (Block54Data* _data54_,
              gdouble xb,
              gdouble yb,
              gdouble tb)
{
	Block53Data* _data53_;
	gdouble d = 0.0;
	gboolean result;
	_data53_ = _data54_->_data53_;
	d = bird_font_path_distance (_data54_->xa, xb, _data54_->ya, yb);
	if (d < _data53_->min_d) {
		_data53_->min_d = d;
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda118__bird_font_path_raster_iterator (gdouble x,
                                              gdouble y,
                                              gdouble step,
                                              gpointer self)
{
	gboolean result;
	result = __lambda118_ (self, x, y, step);
	return result;
}

static gboolean
__lambda117_ (Block53Data* _data53_,
              gdouble xa,
              gdouble ya,
              gdouble ta)
{
	Block54Data* _data54_;
	gboolean result;
	_data54_ = g_slice_new0 (Block54Data);
	_data54_->_ref_count_ = 1;
	_data54_->_data53_ = block53_data_ref (_data53_);
	_data54_->xa = xa;
	_data54_->ya = ya;
	_data53_->min_d = DBL_MAX;
	bird_font_path_all_of (_data53_->b0, _data53_->b1, ___lambda118__bird_font_path_raster_iterator, _data54_, _data53_->steps, (gdouble) 0, (gdouble) 1);
	if (_data53_->min_d > _data53_->max_d) {
		_data53_->max_d = _data53_->min_d;
		_data53_->x_out = _data54_->xa;
		_data53_->y_out = _data54_->ya;
		_data53_->step_out = ta;
	}
	result = TRUE;
	block54_data_unref (_data54_);
	_data54_ = NULL;
	return result;
}

static gboolean
___lambda117__bird_font_path_raster_iterator (gdouble x,
                                              gdouble y,
                                              gdouble step,
                                              gpointer self)
{
	gboolean result;
	result = __lambda117_ (self, x, y, step);
	return result;
}

void
bird_font_point_converter_find_largest_distance (BirdFontEditPoint* a0,
                                                 BirdFontEditPoint* a1,
                                                 BirdFontEditPoint* b0,
                                                 BirdFontEditPoint* b1,
                                                 gdouble* distance,
                                                 BirdFontEditPoint** new_point,
                                                 gdouble* step)
{
	gdouble _vala_distance = 0.0;
	BirdFontEditPoint* _vala_new_point = NULL;
	gdouble _vala_step = 0.0;
	Block53Data* _data53_;
	BirdFontEditPoint* _tmp0_;
	BirdFontEditPoint* _tmp1_;
	BirdFontEditPoint* _tmp2_;
	BirdFontEditPoint* _tmp3_;
	BirdFontEditPoint* _tmp4_;
	BirdFontEditPoint* _tmp5_;
	BirdFontEditPointHandle* _tmp6_;
	BirdFontEditPoint* _tmp7_;
	BirdFontEditPointHandle* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	BirdFontEditPointHandle* _tmp12_;
	BirdFontEditPoint* _tmp16_;
	BirdFontEditPoint* _tmp17_;
	g_return_if_fail (a0 != NULL);
	g_return_if_fail (a1 != NULL);
	g_return_if_fail (b0 != NULL);
	g_return_if_fail (b1 != NULL);
	_data53_ = g_slice_new0 (Block53Data);
	_data53_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (b0);
	_g_object_unref0 (_data53_->b0);
	_data53_->b0 = _tmp0_;
	_tmp1_ = _g_object_ref0 (b1);
	_g_object_unref0 (_data53_->b1);
	_data53_->b1 = _tmp1_;
	_data53_->x_out = (gdouble) 0;
	_data53_->y_out = (gdouble) 0;
	_data53_->step_out = (gdouble) 0;
	_vala_step = (gdouble) 0;
	_vala_distance = (gdouble) 0;
	_tmp2_ = bird_font_edit_point_new ((gdouble) 0, (gdouble) 0, BIRD_FONT_POINT_TYPE_NONE);
	_g_object_unref0 (_vala_new_point);
	_vala_new_point = _tmp2_;
	_tmp3_ = _vala_new_point;
	_tmp3_->prev = a0;
	_tmp4_ = _vala_new_point;
	_tmp4_->next = a1;
	_tmp5_ = _vala_new_point;
	_tmp6_ = bird_font_edit_point_get_right_handle (_tmp5_);
	_tmp6_->type = BIRD_FONT_POINT_TYPE_CUBIC;
	_tmp7_ = _vala_new_point;
	_tmp8_ = bird_font_edit_point_get_left_handle (_tmp7_);
	_tmp8_->type = BIRD_FONT_POINT_TYPE_CUBIC;
	_data53_->steps = 20;
	_tmp12_ = bird_font_edit_point_get_right_handle (a0);
	if (_tmp12_->type == BIRD_FONT_POINT_TYPE_QUADRATIC) {
		_tmp11_ = TRUE;
	} else {
		BirdFontEditPointHandle* _tmp13_;
		_tmp13_ = bird_font_edit_point_get_left_handle (a1);
		_tmp11_ = _tmp13_->type == BIRD_FONT_POINT_TYPE_QUADRATIC;
	}
	if (_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		BirdFontEditPointHandle* _tmp14_;
		_tmp14_ = bird_font_edit_point_get_right_handle (a0);
		_tmp10_ = _tmp14_->type == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		BirdFontEditPointHandle* _tmp15_;
		_tmp15_ = bird_font_edit_point_get_left_handle (a1);
		_tmp9_ = _tmp15_->type == BIRD_FONT_POINT_TYPE_LINE_QUADRATIC;
	}
	if (_tmp9_) {
		block53_data_unref (_data53_);
		_data53_ = NULL;
		if (distance) {
			*distance = _vala_distance;
		}
		if (new_point) {
			*new_point = _vala_new_point;
		} else {
			_g_object_unref0 (_vala_new_point);
		}
		if (step) {
			*step = _vala_step;
		}
		return;
	}
	_data53_->max_d = BIRD_FONT_GLYPH_CANVAS_MIN;
	_data53_->min_d = BIRD_FONT_GLYPH_CANVAS_MAX;
	bird_font_path_all_of (a0, a1, ___lambda117__bird_font_path_raster_iterator, _data53_, _data53_->steps, (gdouble) 0, (gdouble) 1);
	_vala_distance = _data53_->max_d;
	_tmp16_ = _vala_new_point;
	_tmp16_->x = _data53_->x_out;
	_tmp17_ = _vala_new_point;
	_tmp17_->y = _data53_->y_out;
	_vala_step = _data53_->step_out;
	if (distance) {
		*distance = _vala_distance;
	}
	if (new_point) {
		*new_point = _vala_new_point;
	} else {
		_g_object_unref0 (_vala_new_point);
	}
	if (step) {
		*step = _vala_step;
	}
	block53_data_unref (_data53_);
	_data53_ = NULL;
}

static void
bird_font_value_point_converter_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
bird_font_value_point_converter_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		bird_font_point_converter_unref (value->data[0].v_pointer);
	}
}

static void
bird_font_value_point_converter_copy_value (const GValue* src_value,
                                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = bird_font_point_converter_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
bird_font_value_point_converter_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
bird_font_value_point_converter_collect_value (GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BirdFontPointConverter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = bird_font_point_converter_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
bird_font_value_point_converter_lcopy_value (const GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	BirdFontPointConverter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = bird_font_point_converter_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
bird_font_param_spec_point_converter (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags)
{
	BirdFontParamSpecPointConverter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BIRD_FONT_TYPE_POINT_CONVERTER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
bird_font_value_get_point_converter (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_POINT_CONVERTER), NULL);
	return value->data[0].v_pointer;
}

void
bird_font_value_set_point_converter (GValue* value,
                                     gpointer v_object)
{
	BirdFontPointConverter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_POINT_CONVERTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_POINT_CONVERTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		bird_font_point_converter_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_point_converter_unref (old);
	}
}

void
bird_font_value_take_point_converter (GValue* value,
                                      gpointer v_object)
{
	BirdFontPointConverter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BIRD_FONT_TYPE_POINT_CONVERTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BIRD_FONT_TYPE_POINT_CONVERTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		bird_font_point_converter_unref (old);
	}
}

static void
bird_font_point_converter_class_init (BirdFontPointConverterClass * klass,
                                      gpointer klass_data)
{
	bird_font_point_converter_parent_class = g_type_class_peek_parent (klass);
	((BirdFontPointConverterClass *) klass)->finalize = bird_font_point_converter_finalize;
	g_type_class_adjust_private_offset (klass, &BirdFontPointConverter_private_offset);
}

static void
bird_font_point_converter_instance_init (BirdFontPointConverter * self,
                                         gpointer klass)
{
	self->priv = bird_font_point_converter_get_instance_private (self);
	self->ref_count = 1;
}

static void
bird_font_point_converter_finalize (BirdFontPointConverter * obj)
{
	BirdFontPointConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_POINT_CONVERTER, BirdFontPointConverter);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->original_path);
	_g_object_unref0 (self->priv->quadratic_path);
}

/** A class for converting control points. */
static GType
bird_font_point_converter_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bird_font_value_point_converter_init, bird_font_value_point_converter_free_value, bird_font_value_point_converter_copy_value, bird_font_value_point_converter_peek_pointer, "p", bird_font_value_point_converter_collect_value, "p", bird_font_value_point_converter_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontPointConverterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_point_converter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontPointConverter), 0, (GInstanceInitFunc) bird_font_point_converter_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bird_font_point_converter_type_id;
	bird_font_point_converter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BirdFontPointConverter", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BirdFontPointConverter_private_offset = g_type_add_instance_private (bird_font_point_converter_type_id, sizeof (BirdFontPointConverterPrivate));
	return bird_font_point_converter_type_id;
}

GType
bird_font_point_converter_get_type (void)
{
	static volatile gsize bird_font_point_converter_type_id__once = 0;
	if (g_once_init_enter (&bird_font_point_converter_type_id__once)) {
		GType bird_font_point_converter_type_id;
		bird_font_point_converter_type_id = bird_font_point_converter_get_type_once ();
		g_once_init_leave (&bird_font_point_converter_type_id__once, bird_font_point_converter_type_id);
	}
	return bird_font_point_converter_type_id__once;
}

gpointer
bird_font_point_converter_ref (gpointer instance)
{
	BirdFontPointConverter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
bird_font_point_converter_unref (gpointer instance)
{
	BirdFontPointConverter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BIRD_FONT_POINT_CONVERTER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

