/* ScaledBackgrounds.c generated by valac 0.56.17, the Vala compiler
 * generated from ScaledBackgrounds.vala, do not modify */

/*
Copyright (C) 2015 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <cairo-gobject.h>
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_SCALED_BACKGROUNDS_0_PROPERTY,
	BIRD_FONT_SCALED_BACKGROUNDS_NUM_PROPERTIES
};
static GParamSpec* bird_font_scaled_backgrounds_properties[BIRD_FONT_SCALED_BACKGROUNDS_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _BirdFontScaledBackgroundsPrivate {
	cairo_surface_t* original;
	GeeArrayList* scaled;
};

static gint BirdFontScaledBackgrounds_private_offset;
static gpointer bird_font_scaled_backgrounds_parent_class = NULL;

static BirdFontScaledBackground* bird_font_scaled_backgrounds_scale (BirdFontScaledBackgrounds* self,
                                                              gdouble scale_factor);
static void bird_font_scaled_backgrounds_finalize (GObject * obj);
static GType bird_font_scaled_backgrounds_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_scaled_backgrounds_get_instance_private (BirdFontScaledBackgrounds* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontScaledBackgrounds_private_offset);
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

BirdFontScaledBackgrounds*
bird_font_scaled_backgrounds_construct (GType object_type,
                                        cairo_surface_t* original)
{
	BirdFontScaledBackgrounds * self = NULL;
	cairo_surface_t* _tmp0_;
	GeeArrayList* _tmp1_;
	BirdFontScaledBackground* image = NULL;
	BirdFontScaledBackground* _tmp2_;
	GeeArrayList* _tmp3_;
	BirdFontScaledBackground* _tmp4_;
	g_return_val_if_fail (original != NULL, NULL);
	self = (BirdFontScaledBackgrounds*) g_object_new (object_type, NULL);
	_tmp0_ = _cairo_surface_reference0 (original);
	_cairo_surface_destroy0 (self->priv->original);
	self->priv->original = _tmp0_;
	_tmp1_ = gee_array_list_new (BIRD_FONT_TYPE_SCALED_BACKGROUND, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->scaled);
	self->priv->scaled = _tmp1_;
	_tmp2_ = bird_font_scaled_backgrounds_scale (self, 0.01);
	image = _tmp2_;
	_tmp3_ = self->priv->scaled;
	_tmp4_ = image;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp4_);
	{
		gdouble scale_factor = 0.0;
		scale_factor = 0.1;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				BirdFontScaledBackground* _tmp6_;
				GeeArrayList* _tmp7_;
				BirdFontScaledBackground* _tmp8_;
				if (!_tmp5_) {
					scale_factor += 0.1;
				}
				_tmp5_ = FALSE;
				if (!(scale_factor <= ((gdouble) 1))) {
					break;
				}
				_tmp6_ = bird_font_scaled_backgrounds_scale (self, scale_factor);
				_g_object_unref0 (image);
				image = _tmp6_;
				_tmp7_ = self->priv->scaled;
				_tmp8_ = image;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
			}
		}
	}
	_g_object_unref0 (image);
	return self;
}

BirdFontScaledBackgrounds*
bird_font_scaled_backgrounds_new (cairo_surface_t* original)
{
	return bird_font_scaled_backgrounds_construct (BIRD_FONT_TYPE_SCALED_BACKGROUNDS, original);
}

BirdFontScaledBackground*
bird_font_scaled_backgrounds_get_image (BirdFontScaledBackgrounds* self,
                                        gdouble scale)
{
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gpointer _tmp13_;
	BirdFontScaledBackground* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeArrayList* _image_list = NULL;
		GeeArrayList* _tmp0_;
		gint _image_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _image_index = 0;
		_tmp0_ = self->priv->scaled;
		_image_list = _tmp0_;
		_tmp1_ = _image_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_image_size = _tmp3_;
		_image_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BirdFontScaledBackground* image = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			BirdFontScaledBackground* _tmp8_;
			_image_index = _image_index + 1;
			_tmp4_ = _image_index;
			_tmp5_ = _image_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _image_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _image_index);
			image = (BirdFontScaledBackground*) _tmp7_;
			_tmp8_ = image;
			if (bird_font_scaled_background_get_scale (_tmp8_) < scale) {
				_g_object_unref0 (image);
				continue;
			}
			result = image;
			return result;
		}
	}
	_tmp9_ = self->priv->scaled;
	_tmp10_ = self->priv->scaled;
	_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp12_ - 1);
	result = (BirdFontScaledBackground*) _tmp13_;
	return result;
}

static BirdFontScaledBackground*
bird_font_scaled_backgrounds_scale (BirdFontScaledBackgrounds* self,
                                    gdouble scale_factor)
{
	cairo_surface_t* scaled_image = NULL;
	gint width = 0;
	cairo_surface_t* _tmp0_;
	gint height = 0;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_t* context = NULL;
	cairo_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	BirdFontScaledBackground* _tmp5_;
	BirdFontScaledBackground* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (scale_factor <= ((gdouble) 0)) {
		g_warning ("ScaledBackgrounds.vala:54: scale_factor <= 0");
		scale_factor = (gdouble) 1;
	}
	_tmp0_ = self->priv->original;
	width = (gint) (cairo_image_surface_get_width (_tmp0_) * scale_factor);
	_tmp1_ = self->priv->original;
	height = (gint) (cairo_image_surface_get_height (_tmp1_) * scale_factor);
	_tmp2_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);
	_cairo_surface_destroy0 (scaled_image);
	scaled_image = _tmp2_;
	_tmp3_ = cairo_create (scaled_image);
	context = _tmp3_;
	cairo_scale (context, scale_factor, scale_factor);
	_tmp4_ = self->priv->original;
	cairo_set_source_surface (context, _tmp4_, (gdouble) 0, (gdouble) 0);
	cairo_paint (context);
	_tmp5_ = bird_font_scaled_background_new (scaled_image, scale_factor);
	result = _tmp5_;
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (scaled_image);
	return result;
}

static void
bird_font_scaled_backgrounds_class_init (BirdFontScaledBackgroundsClass * klass,
                                         gpointer klass_data)
{
	bird_font_scaled_backgrounds_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontScaledBackgrounds_private_offset);
	G_OBJECT_CLASS (klass)->finalize = bird_font_scaled_backgrounds_finalize;
}

static void
bird_font_scaled_backgrounds_instance_init (BirdFontScaledBackgrounds * self,
                                            gpointer klass)
{
	self->priv = bird_font_scaled_backgrounds_get_instance_private (self);
}

static void
bird_font_scaled_backgrounds_finalize (GObject * obj)
{
	BirdFontScaledBackgrounds * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_SCALED_BACKGROUNDS, BirdFontScaledBackgrounds);
	_cairo_surface_destroy0 (self->priv->original);
	_g_object_unref0 (self->priv->scaled);
	G_OBJECT_CLASS (bird_font_scaled_backgrounds_parent_class)->finalize (obj);
}

static GType
bird_font_scaled_backgrounds_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontScaledBackgroundsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_scaled_backgrounds_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontScaledBackgrounds), 0, (GInstanceInitFunc) bird_font_scaled_backgrounds_instance_init, NULL };
	GType bird_font_scaled_backgrounds_type_id;
	bird_font_scaled_backgrounds_type_id = g_type_register_static (G_TYPE_OBJECT, "BirdFontScaledBackgrounds", &g_define_type_info, 0);
	BirdFontScaledBackgrounds_private_offset = g_type_add_instance_private (bird_font_scaled_backgrounds_type_id, sizeof (BirdFontScaledBackgroundsPrivate));
	return bird_font_scaled_backgrounds_type_id;
}

GType
bird_font_scaled_backgrounds_get_type (void)
{
	static volatile gsize bird_font_scaled_backgrounds_type_id__once = 0;
	if (g_once_init_enter (&bird_font_scaled_backgrounds_type_id__once)) {
		GType bird_font_scaled_backgrounds_type_id;
		bird_font_scaled_backgrounds_type_id = bird_font_scaled_backgrounds_get_type_once ();
		g_once_init_leave (&bird_font_scaled_backgrounds_type_id__once, bird_font_scaled_backgrounds_type_id);
	}
	return bird_font_scaled_backgrounds_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

