/* ZoomBar.c generated by valac 0.56.17, the Vala compiler
 * generated from ZoomBar.vala, do not modify */

/*
Copyright (C) 2014 Johan Mattsson

This library is free software; you can redistribute it and/or modify 
it under the terms of the GNU Lesser General Public License as 
published by the Free Software Foundation; either version 3 of the 
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
Lesser General Public License for more details.
*/

#include "birdfont.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BIRD_FONT_ZOOM_BAR_0_PROPERTY,
	BIRD_FONT_ZOOM_BAR_NUM_PROPERTIES
};
static GParamSpec* bird_font_zoom_bar_properties[BIRD_FONT_ZOOM_BAR_NUM_PROPERTIES];
enum  {
	BIRD_FONT_ZOOM_BAR_NEW_ZOOM_SIGNAL,
	BIRD_FONT_ZOOM_BAR_NUM_SIGNALS
};
static guint bird_font_zoom_bar_signals[BIRD_FONT_ZOOM_BAR_NUM_SIGNALS] = {0};

struct _BirdFontZoomBarPrivate {
	gdouble margin_percent;
};

static gint BirdFontZoomBar_private_offset;
static gpointer bird_font_zoom_bar_parent_class = NULL;

static void __lambda79_ (BirdFontZoomBar* self,
                  BirdFontTool* selected,
                  guint button,
                  gdouble tx,
                  gdouble ty);
static void bird_font_zoom_bar_set_zoom_from_mouse (BirdFontZoomBar* self,
                                             gdouble tx);
static void ___lambda79__bird_font_tool_panel_press_action (BirdFontTool* _sender,
                                                     BirdFontTool* selected,
                                                     guint button,
                                                     gdouble x,
                                                     gdouble y,
                                                     gpointer self);
static gboolean __lambda80_ (BirdFontZoomBar* self,
                      BirdFontTool* selected,
                      BirdFontTool* button,
                      gdouble tx,
                      gdouble ty);
static gboolean ___lambda80__bird_font_tool_panel_move_action (BirdFontTool* _sender,
                                                        BirdFontTool* selected,
                                                        gdouble x,
                                                        gdouble y,
                                                        gpointer self);
static void __lambda81_ (BirdFontZoomBar* self,
                  BirdFontTool* selected,
                  guint button,
                  gdouble tx,
                  gdouble ty);
static void ___lambda81__bird_font_tool_panel_release_action (BirdFontTool* _sender,
                                                       BirdFontTool* selected,
                                                       guint button,
                                                       gdouble x,
                                                       gdouble y,
                                                       gpointer self);
static void bird_font_zoom_bar_real_draw_tool (BirdFontTool* base,
                                        cairo_t* cr,
                                        gdouble px,
                                        gdouble py);
static void bird_font_zoom_bar_draw_bar (BirdFontZoomBar* self,
                                  cairo_t* cr,
                                  gdouble px,
                                  gdouble py);
static void bird_font_zoom_bar_finalize (GObject * obj);
static GType bird_font_zoom_bar_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
bird_font_zoom_bar_get_instance_private (BirdFontZoomBar* self)
{
	return G_STRUCT_MEMBER_P (self, BirdFontZoomBar_private_offset);
}

static void
__lambda79_ (BirdFontZoomBar* self,
             BirdFontTool* selected,
             guint button,
             gdouble tx,
             gdouble ty)
{
	gdouble _tmp0_;
	g_return_if_fail (selected != NULL);
	_tmp0_ = ty;
	if ((((BirdFontTool*) self)->y <= _tmp0_) && (_tmp0_ <= ((((BirdFontTool*) self)->y + ((BirdFontTool*) self)->h) + 4))) {
		bird_font_zoom_bar_set_zoom_from_mouse (self, tx);
		self->update_zoom = TRUE;
	}
}

static void
___lambda79__bird_font_tool_panel_press_action (BirdFontTool* _sender,
                                                BirdFontTool* selected,
                                                guint button,
                                                gdouble x,
                                                gdouble y,
                                                gpointer self)
{
	__lambda79_ ((BirdFontZoomBar*) self, selected, button, x, y);
}

static gboolean
__lambda80_ (BirdFontZoomBar* self,
             BirdFontTool* selected,
             BirdFontTool* button,
             gdouble tx,
             gdouble ty)
{
	gboolean result;
	g_return_val_if_fail (selected != NULL, FALSE);
	g_return_val_if_fail (button != NULL, FALSE);
	if (self->update_zoom) {
		bird_font_zoom_bar_set_zoom_from_mouse (self, tx);
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda80__bird_font_tool_panel_move_action (BirdFontTool* _sender,
                                               BirdFontTool* selected,
                                               gdouble x,
                                               gdouble y,
                                               gpointer self)
{
	gboolean result;
	result = __lambda80_ ((BirdFontZoomBar*) self, _sender, selected, x, y);
	return result;
}

static void
__lambda81_ (BirdFontZoomBar* self,
             BirdFontTool* selected,
             guint button,
             gdouble tx,
             gdouble ty)
{
	g_return_if_fail (selected != NULL);
	if (self->update_zoom) {
		BirdFontZoomTool* _tmp0_;
		_tmp0_ = bird_font_drawing_tools_zoom_tool;
		bird_font_zoom_tool_store_current_view (_tmp0_);
	}
	self->update_zoom = FALSE;
}

static void
___lambda81__bird_font_tool_panel_release_action (BirdFontTool* _sender,
                                                  BirdFontTool* selected,
                                                  guint button,
                                                  gdouble x,
                                                  gdouble y,
                                                  gpointer self)
{
	__lambda81_ ((BirdFontZoomBar*) self, selected, button, x, y);
}

BirdFontZoomBar*
bird_font_zoom_bar_construct (GType object_type)
{
	BirdFontZoomBar * self = NULL;
	self = (BirdFontZoomBar*) bird_font_tool_construct (object_type, NULL, "");
	g_signal_connect_object ((BirdFontTool*) self, "panel-press-action", (GCallback) ___lambda79__bird_font_tool_panel_press_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "panel-move-action", (GCallback) ___lambda80__bird_font_tool_panel_move_action, self, 0);
	g_signal_connect_object ((BirdFontTool*) self, "panel-release-action", (GCallback) ___lambda81__bird_font_tool_panel_release_action, self, 0);
	return self;
}

BirdFontZoomBar*
bird_font_zoom_bar_new (void)
{
	return bird_font_zoom_bar_construct (BIRD_FONT_TYPE_ZOOM_BAR);
}

/** Zoom level from 0 to 1. */
void
bird_font_zoom_bar_set_zoom (BirdFontZoomBar* self,
                             gdouble z)
{
	g_return_if_fail (self != NULL);
	self->zoom_level = z;
}

static void
bird_font_zoom_bar_set_zoom_from_mouse (BirdFontZoomBar* self,
                                        gdouble tx)
{
	gdouble margin = 0.0;
	gdouble bar_width = 0.0;
	g_return_if_fail (self != NULL);
	margin = ((BirdFontTool*) self)->w * self->priv->margin_percent;
	bar_width = (((BirdFontTool*) self)->w - margin) - ((BirdFontTool*) self)->x;
	tx = tx - ((BirdFontTool*) self)->x;
	self->zoom_level = tx / bar_width;
	if (self->zoom_level > ((gdouble) 1)) {
		self->zoom_level = (gdouble) 1;
	}
	if (self->zoom_level < ((gdouble) 0)) {
		self->zoom_level = (gdouble) 0;
	}
	bird_font_zoom_bar_set_zoom (self, self->zoom_level);
	if (!bird_font_menu_tab_has_suppress_event ()) {
		g_signal_emit (self, bird_font_zoom_bar_signals[BIRD_FONT_ZOOM_BAR_NEW_ZOOM_SIGNAL], 0, self->zoom_level);
	}
	bird_font_font_display_dirty_scrollbar = TRUE;
	bird_font_tool_redraw ((BirdFontTool*) self);
}

static void
bird_font_zoom_bar_real_draw_tool (BirdFontTool* base,
                                   cairo_t* cr,
                                   gdouble px,
                                   gdouble py)
{
	BirdFontZoomBar * self;
	gdouble margin = 0.0;
	gdouble bar_width = 0.0;
	self = (BirdFontZoomBar*) base;
	g_return_if_fail (cr != NULL);
	margin = ((BirdFontTool*) self)->w * self->priv->margin_percent;
	bar_width = (((BirdFontTool*) self)->w - margin) - ((BirdFontTool*) self)->x;
	cairo_save (cr);
	bird_font_theme_color (cr, "Button Border 1");
	bird_font_zoom_bar_draw_bar (self, cr, px, py);
	cairo_fill (cr);
	cairo_restore (cr);
	cairo_save (cr);
	bird_font_theme_color (cr, "Default Background");
	cairo_rectangle (cr, (((BirdFontTool*) self)->x + (bar_width * self->zoom_level)) - px, ((BirdFontTool*) self)->y - py, ((BirdFontTool*) self)->w, ((BirdFontTool*) self)->h);
	cairo_fill (cr);
	cairo_restore (cr);
	cairo_save (cr);
	bird_font_theme_color (cr, "Zoom Bar Border");
	cairo_set_line_width (cr, 0.8);
	bird_font_zoom_bar_draw_bar (self, cr, px, py);
	cairo_stroke (cr);
	cairo_restore (cr);
}

static void
bird_font_zoom_bar_draw_bar (BirdFontZoomBar* self,
                             cairo_t* cr,
                             gdouble px,
                             gdouble py)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble height = 0.0;
	gdouble radius = 0.0;
	gdouble margin = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	x = ((BirdFontTool*) self)->x - px;
	y = ((BirdFontTool*) self)->y - py;
	w = ((BirdFontTool*) self)->w - px;
	height = ((BirdFontTool*) self)->h;
	radius = height / 2;
	margin = w * self->priv->margin_percent;
	cairo_move_to (cr, x + radius, y + height);
	cairo_arc (cr, x + radius, y + radius, radius, G_PI / 2, 3 * (G_PI / 2));
	cairo_line_to (cr, (w - margin) - radius, y);
	cairo_arc (cr, (w - margin) - radius, y + radius, radius, 3 * (G_PI / 2), 5 * (G_PI / 2));
	cairo_line_to (cr, x + radius, y + height);
	cairo_close_path (cr);
}

static void
bird_font_zoom_bar_class_init (BirdFontZoomBarClass * klass,
                               gpointer klass_data)
{
	bird_font_zoom_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BirdFontZoomBar_private_offset);
	((BirdFontToolClass *) klass)->draw_tool = (void (*) (BirdFontTool*, cairo_t*, gdouble, gdouble)) bird_font_zoom_bar_real_draw_tool;
	G_OBJECT_CLASS (klass)->finalize = bird_font_zoom_bar_finalize;
	bird_font_zoom_bar_signals[BIRD_FONT_ZOOM_BAR_NEW_ZOOM_SIGNAL] = g_signal_new ("new-zoom", BIRD_FONT_TYPE_ZOOM_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
}

static void
bird_font_zoom_bar_instance_init (BirdFontZoomBar * self,
                                  gpointer klass)
{
	self->priv = bird_font_zoom_bar_get_instance_private (self);
	self->zoom_level = 1 / 3.0;
	self->update_zoom = FALSE;
	self->priv->margin_percent = 0.05;
}

static void
bird_font_zoom_bar_finalize (GObject * obj)
{
	BirdFontZoomBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BIRD_FONT_TYPE_ZOOM_BAR, BirdFontZoomBar);
	G_OBJECT_CLASS (bird_font_zoom_bar_parent_class)->finalize (obj);
}

static GType
bird_font_zoom_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BirdFontZoomBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bird_font_zoom_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirdFontZoomBar), 0, (GInstanceInitFunc) bird_font_zoom_bar_instance_init, NULL };
	GType bird_font_zoom_bar_type_id;
	bird_font_zoom_bar_type_id = g_type_register_static (BIRD_FONT_TYPE_TOOL, "BirdFontZoomBar", &g_define_type_info, 0);
	BirdFontZoomBar_private_offset = g_type_add_instance_private (bird_font_zoom_bar_type_id, sizeof (BirdFontZoomBarPrivate));
	return bird_font_zoom_bar_type_id;
}

GType
bird_font_zoom_bar_get_type (void)
{
	static volatile gsize bird_font_zoom_bar_type_id__once = 0;
	if (g_once_init_enter (&bird_font_zoom_bar_type_id__once)) {
		GType bird_font_zoom_bar_type_id;
		bird_font_zoom_bar_type_id = bird_font_zoom_bar_get_type_once ();
		g_once_init_leave (&bird_font_zoom_bar_type_id__once, bird_font_zoom_bar_type_id);
	}
	return bird_font_zoom_bar_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

