// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/repository_commit.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type RepositoryCommit struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Id              string                 `protobuf:"bytes,1,opt,name=id,proto3"`
	xxx_hidden_CreateTime      *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3"`
	xxx_hidden_Digest          string                 `protobuf:"bytes,3,opt,name=digest,proto3"`
	xxx_hidden_Name            string                 `protobuf:"bytes,4,opt,name=name,proto3"`
	xxx_hidden_Branch          string                 `protobuf:"bytes,5,opt,name=branch,proto3"`
	xxx_hidden_Author          string                 `protobuf:"bytes,7,opt,name=author,proto3"`
	xxx_hidden_Tags            *[]*RepositoryTag      `protobuf:"bytes,8,rep,name=tags,proto3"`
	xxx_hidden_DraftName       string                 `protobuf:"bytes,9,opt,name=draft_name,json=draftName,proto3"`
	xxx_hidden_SpdxLicenseId   string                 `protobuf:"bytes,10,opt,name=spdx_license_id,json=spdxLicenseId,proto3"`
	xxx_hidden_ManifestDigest  string                 `protobuf:"bytes,11,opt,name=manifest_digest,json=manifestDigest,proto3"`
	xxx_hidden_TagCount        int64                  `protobuf:"varint,12,opt,name=tag_count,json=tagCount,proto3"`
	xxx_hidden_GitCommitsCount int64                  `protobuf:"varint,13,opt,name=git_commits_count,json=gitCommitsCount,proto3"`
	xxx_hidden_B5Digest        string                 `protobuf:"bytes,14,opt,name=b5_digest,json=b5Digest,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *RepositoryCommit) Reset() {
	*x = RepositoryCommit{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepositoryCommit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepositoryCommit) ProtoMessage() {}

func (x *RepositoryCommit) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *RepositoryCommit) GetId() string {
	if x != nil {
		return x.xxx_hidden_Id
	}
	return ""
}

func (x *RepositoryCommit) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.xxx_hidden_CreateTime
	}
	return nil
}

func (x *RepositoryCommit) GetDigest() string {
	if x != nil {
		return x.xxx_hidden_Digest
	}
	return ""
}

func (x *RepositoryCommit) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *RepositoryCommit) GetBranch() string {
	if x != nil {
		return x.xxx_hidden_Branch
	}
	return ""
}

func (x *RepositoryCommit) GetAuthor() string {
	if x != nil {
		return x.xxx_hidden_Author
	}
	return ""
}

func (x *RepositoryCommit) GetTags() []*RepositoryTag {
	if x != nil {
		if x.xxx_hidden_Tags != nil {
			return *x.xxx_hidden_Tags
		}
	}
	return nil
}

func (x *RepositoryCommit) GetDraftName() string {
	if x != nil {
		return x.xxx_hidden_DraftName
	}
	return ""
}

func (x *RepositoryCommit) GetSpdxLicenseId() string {
	if x != nil {
		return x.xxx_hidden_SpdxLicenseId
	}
	return ""
}

func (x *RepositoryCommit) GetManifestDigest() string {
	if x != nil {
		return x.xxx_hidden_ManifestDigest
	}
	return ""
}

func (x *RepositoryCommit) GetTagCount() int64 {
	if x != nil {
		return x.xxx_hidden_TagCount
	}
	return 0
}

func (x *RepositoryCommit) GetGitCommitsCount() int64 {
	if x != nil {
		return x.xxx_hidden_GitCommitsCount
	}
	return 0
}

func (x *RepositoryCommit) GetB5Digest() string {
	if x != nil {
		return x.xxx_hidden_B5Digest
	}
	return ""
}

func (x *RepositoryCommit) SetId(v string) {
	x.xxx_hidden_Id = v
}

func (x *RepositoryCommit) SetCreateTime(v *timestamppb.Timestamp) {
	x.xxx_hidden_CreateTime = v
}

func (x *RepositoryCommit) SetDigest(v string) {
	x.xxx_hidden_Digest = v
}

func (x *RepositoryCommit) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *RepositoryCommit) SetBranch(v string) {
	x.xxx_hidden_Branch = v
}

func (x *RepositoryCommit) SetAuthor(v string) {
	x.xxx_hidden_Author = v
}

func (x *RepositoryCommit) SetTags(v []*RepositoryTag) {
	x.xxx_hidden_Tags = &v
}

func (x *RepositoryCommit) SetDraftName(v string) {
	x.xxx_hidden_DraftName = v
}

func (x *RepositoryCommit) SetSpdxLicenseId(v string) {
	x.xxx_hidden_SpdxLicenseId = v
}

func (x *RepositoryCommit) SetManifestDigest(v string) {
	x.xxx_hidden_ManifestDigest = v
}

func (x *RepositoryCommit) SetTagCount(v int64) {
	x.xxx_hidden_TagCount = v
}

func (x *RepositoryCommit) SetGitCommitsCount(v int64) {
	x.xxx_hidden_GitCommitsCount = v
}

func (x *RepositoryCommit) SetB5Digest(v string) {
	x.xxx_hidden_B5Digest = v
}

func (x *RepositoryCommit) HasCreateTime() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_CreateTime != nil
}

func (x *RepositoryCommit) ClearCreateTime() {
	x.xxx_hidden_CreateTime = nil
}

type RepositoryCommit_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// primary key, unique, immutable
	Id string
	// immutable
	CreateTime *timestamppb.Timestamp
	// The digest of the commit.
	Digest string
	// The name of the commit.
	// This is what is referenced by users.
	// Unique, immutable.
	Name string
	// The branch on which this commit was created.
	Branch string
	// The username of the user who authored this commit.
	Author string
	// The tags associated with this commit
	Tags []*RepositoryTag
	// The commit's draft name, if it is a draft commit.
	DraftName string
	// spdx_license_id is the license of the commit, based on the
	// license file pushed, which should be one of the identifier defined in
	// https://spdx.org/licenses, and will be not set if the license file is not
	// presented or cannot be classified into a known license.
	SpdxLicenseId string
	// The manifest digest of the commit.
	ManifestDigest string
	// Number of tags associated with the commit.
	TagCount int64
	// Number of git commits with associated with the BSR commit.
	GitCommitsCount int64
	// The b5 digest of the commit.
	B5Digest string
}

func (b0 RepositoryCommit_builder) Build() *RepositoryCommit {
	m0 := &RepositoryCommit{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Id = b.Id
	x.xxx_hidden_CreateTime = b.CreateTime
	x.xxx_hidden_Digest = b.Digest
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Branch = b.Branch
	x.xxx_hidden_Author = b.Author
	x.xxx_hidden_Tags = &b.Tags
	x.xxx_hidden_DraftName = b.DraftName
	x.xxx_hidden_SpdxLicenseId = b.SpdxLicenseId
	x.xxx_hidden_ManifestDigest = b.ManifestDigest
	x.xxx_hidden_TagCount = b.TagCount
	x.xxx_hidden_GitCommitsCount = b.GitCommitsCount
	x.xxx_hidden_B5Digest = b.B5Digest
	return m0
}

type ListRepositoryCommitsByBranchRequest struct {
	state                           protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryOwner      string                 `protobuf:"bytes,1,opt,name=repository_owner,json=repositoryOwner,proto3"`
	xxx_hidden_RepositoryName       string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_RepositoryBranchName string                 `protobuf:"bytes,3,opt,name=repository_branch_name,json=repositoryBranchName,proto3"`
	xxx_hidden_PageSize             uint32                 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken            string                 `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse              bool                   `protobuf:"varint,6,opt,name=reverse,proto3"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *ListRepositoryCommitsByBranchRequest) Reset() {
	*x = ListRepositoryCommitsByBranchRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryCommitsByBranchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryCommitsByBranchRequest) ProtoMessage() {}

func (x *ListRepositoryCommitsByBranchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryCommitsByBranchRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwner
	}
	return ""
}

func (x *ListRepositoryCommitsByBranchRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *ListRepositoryCommitsByBranchRequest) GetRepositoryBranchName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryBranchName
	}
	return ""
}

func (x *ListRepositoryCommitsByBranchRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListRepositoryCommitsByBranchRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListRepositoryCommitsByBranchRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListRepositoryCommitsByBranchRequest) SetRepositoryOwner(v string) {
	x.xxx_hidden_RepositoryOwner = v
}

func (x *ListRepositoryCommitsByBranchRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *ListRepositoryCommitsByBranchRequest) SetRepositoryBranchName(v string) {
	x.xxx_hidden_RepositoryBranchName = v
}

func (x *ListRepositoryCommitsByBranchRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListRepositoryCommitsByBranchRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListRepositoryCommitsByBranchRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListRepositoryCommitsByBranchRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the repository which the repository branch belongs to.
	RepositoryOwner string
	// The name of the repository which the repository branch belongs to.
	RepositoryName string
	// The name of the repository branch whose commits should be listed.
	RepositoryBranchName string
	PageSize             uint32
	// For now this is the id of he last commit returned in the previous page.
	// This is directly set by the frontend when listing track history starting with a
	// specific commit. If we page_token to be anything other than a commit id
	// we need to change the frontend as well.
	PageToken string
	Reverse   bool
}

func (b0 ListRepositoryCommitsByBranchRequest_builder) Build() *ListRepositoryCommitsByBranchRequest {
	m0 := &ListRepositoryCommitsByBranchRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryOwner = b.RepositoryOwner
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_RepositoryBranchName = b.RepositoryBranchName
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListRepositoryCommitsByBranchResponse struct {
	state                        protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryCommits *[]*RepositoryCommit   `protobuf:"bytes,1,rep,name=repository_commits,json=repositoryCommits,proto3"`
	xxx_hidden_NextPageToken     string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *ListRepositoryCommitsByBranchResponse) Reset() {
	*x = ListRepositoryCommitsByBranchResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryCommitsByBranchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryCommitsByBranchResponse) ProtoMessage() {}

func (x *ListRepositoryCommitsByBranchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryCommitsByBranchResponse) GetRepositoryCommits() []*RepositoryCommit {
	if x != nil {
		if x.xxx_hidden_RepositoryCommits != nil {
			return *x.xxx_hidden_RepositoryCommits
		}
	}
	return nil
}

func (x *ListRepositoryCommitsByBranchResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListRepositoryCommitsByBranchResponse) SetRepositoryCommits(v []*RepositoryCommit) {
	x.xxx_hidden_RepositoryCommits = &v
}

func (x *ListRepositoryCommitsByBranchResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListRepositoryCommitsByBranchResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryCommits []*RepositoryCommit
	NextPageToken     string
}

func (b0 ListRepositoryCommitsByBranchResponse_builder) Build() *ListRepositoryCommitsByBranchResponse {
	m0 := &ListRepositoryCommitsByBranchResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryCommits = &b.RepositoryCommits
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type ListRepositoryCommitsByReferenceRequest struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryOwner string                 `protobuf:"bytes,1,opt,name=repository_owner,json=repositoryOwner,proto3"`
	xxx_hidden_RepositoryName  string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_Reference       string                 `protobuf:"bytes,3,opt,name=reference,proto3"`
	xxx_hidden_PageSize        uint32                 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken       string                 `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse         bool                   `protobuf:"varint,6,opt,name=reverse,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *ListRepositoryCommitsByReferenceRequest) Reset() {
	*x = ListRepositoryCommitsByReferenceRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryCommitsByReferenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryCommitsByReferenceRequest) ProtoMessage() {}

func (x *ListRepositoryCommitsByReferenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryCommitsByReferenceRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwner
	}
	return ""
}

func (x *ListRepositoryCommitsByReferenceRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *ListRepositoryCommitsByReferenceRequest) GetReference() string {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return ""
}

func (x *ListRepositoryCommitsByReferenceRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListRepositoryCommitsByReferenceRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListRepositoryCommitsByReferenceRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListRepositoryCommitsByReferenceRequest) SetRepositoryOwner(v string) {
	x.xxx_hidden_RepositoryOwner = v
}

func (x *ListRepositoryCommitsByReferenceRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *ListRepositoryCommitsByReferenceRequest) SetReference(v string) {
	x.xxx_hidden_Reference = v
}

func (x *ListRepositoryCommitsByReferenceRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListRepositoryCommitsByReferenceRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListRepositoryCommitsByReferenceRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListRepositoryCommitsByReferenceRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the repository which the repository reference belongs to.
	RepositoryOwner string
	// The name of the repository which the repository reference belongs to.
	RepositoryName string
	// The optional reference used to resolve repository commits. Can be a tag or commit.
	// If unspecified, will use the repository's default_branch.
	Reference string
	PageSize  uint32
	PageToken string
	Reverse   bool
}

func (b0 ListRepositoryCommitsByReferenceRequest_builder) Build() *ListRepositoryCommitsByReferenceRequest {
	m0 := &ListRepositoryCommitsByReferenceRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryOwner = b.RepositoryOwner
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_Reference = b.Reference
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListRepositoryCommitsByReferenceResponse struct {
	state                        protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryCommits *[]*RepositoryCommit   `protobuf:"bytes,1,rep,name=repository_commits,json=repositoryCommits,proto3"`
	xxx_hidden_NextPageToken     string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *ListRepositoryCommitsByReferenceResponse) Reset() {
	*x = ListRepositoryCommitsByReferenceResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryCommitsByReferenceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryCommitsByReferenceResponse) ProtoMessage() {}

func (x *ListRepositoryCommitsByReferenceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryCommitsByReferenceResponse) GetRepositoryCommits() []*RepositoryCommit {
	if x != nil {
		if x.xxx_hidden_RepositoryCommits != nil {
			return *x.xxx_hidden_RepositoryCommits
		}
	}
	return nil
}

func (x *ListRepositoryCommitsByReferenceResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListRepositoryCommitsByReferenceResponse) SetRepositoryCommits(v []*RepositoryCommit) {
	x.xxx_hidden_RepositoryCommits = &v
}

func (x *ListRepositoryCommitsByReferenceResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListRepositoryCommitsByReferenceResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryCommits []*RepositoryCommit
	NextPageToken     string
}

func (b0 ListRepositoryCommitsByReferenceResponse_builder) Build() *ListRepositoryCommitsByReferenceResponse {
	m0 := &ListRepositoryCommitsByReferenceResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryCommits = &b.RepositoryCommits
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type GetRepositoryCommitByReferenceRequest struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryOwner string                 `protobuf:"bytes,1,opt,name=repository_owner,json=repositoryOwner,proto3"`
	xxx_hidden_RepositoryName  string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_Reference       string                 `protobuf:"bytes,3,opt,name=reference,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *GetRepositoryCommitByReferenceRequest) Reset() {
	*x = GetRepositoryCommitByReferenceRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryCommitByReferenceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryCommitByReferenceRequest) ProtoMessage() {}

func (x *GetRepositoryCommitByReferenceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryCommitByReferenceRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwner
	}
	return ""
}

func (x *GetRepositoryCommitByReferenceRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *GetRepositoryCommitByReferenceRequest) GetReference() string {
	if x != nil {
		return x.xxx_hidden_Reference
	}
	return ""
}

func (x *GetRepositoryCommitByReferenceRequest) SetRepositoryOwner(v string) {
	x.xxx_hidden_RepositoryOwner = v
}

func (x *GetRepositoryCommitByReferenceRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *GetRepositoryCommitByReferenceRequest) SetReference(v string) {
	x.xxx_hidden_Reference = v
}

type GetRepositoryCommitByReferenceRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the repository which the reference belongs to.
	RepositoryOwner string
	// The name of the repository which the reference belongs to.
	RepositoryName string
	// The optional reference that should be resolved to a commit. Can be a tag or commit.
	// If unspecified, will use the repository's default_branch.
	Reference string
}

func (b0 GetRepositoryCommitByReferenceRequest_builder) Build() *GetRepositoryCommitByReferenceRequest {
	m0 := &GetRepositoryCommitByReferenceRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryOwner = b.RepositoryOwner
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_Reference = b.Reference
	return m0
}

type GetRepositoryCommitByReferenceResponse struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryCommit *RepositoryCommit      `protobuf:"bytes,1,opt,name=repository_commit,json=repositoryCommit,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *GetRepositoryCommitByReferenceResponse) Reset() {
	*x = GetRepositoryCommitByReferenceResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRepositoryCommitByReferenceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryCommitByReferenceResponse) ProtoMessage() {}

func (x *GetRepositoryCommitByReferenceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetRepositoryCommitByReferenceResponse) GetRepositoryCommit() *RepositoryCommit {
	if x != nil {
		return x.xxx_hidden_RepositoryCommit
	}
	return nil
}

func (x *GetRepositoryCommitByReferenceResponse) SetRepositoryCommit(v *RepositoryCommit) {
	x.xxx_hidden_RepositoryCommit = v
}

func (x *GetRepositoryCommitByReferenceResponse) HasRepositoryCommit() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_RepositoryCommit != nil
}

func (x *GetRepositoryCommitByReferenceResponse) ClearRepositoryCommit() {
	x.xxx_hidden_RepositoryCommit = nil
}

type GetRepositoryCommitByReferenceResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	RepositoryCommit *RepositoryCommit
}

func (b0 GetRepositoryCommitByReferenceResponse_builder) Build() *GetRepositoryCommitByReferenceResponse {
	m0 := &GetRepositoryCommitByReferenceResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryCommit = b.RepositoryCommit
	return m0
}

type ListRepositoryDraftCommitsRequest struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryOwner string                 `protobuf:"bytes,1,opt,name=repository_owner,json=repositoryOwner,proto3"`
	xxx_hidden_RepositoryName  string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_PageSize        uint32                 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3"`
	xxx_hidden_PageToken       string                 `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3"`
	xxx_hidden_Reverse         bool                   `protobuf:"varint,5,opt,name=reverse,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *ListRepositoryDraftCommitsRequest) Reset() {
	*x = ListRepositoryDraftCommitsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryDraftCommitsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryDraftCommitsRequest) ProtoMessage() {}

func (x *ListRepositoryDraftCommitsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryDraftCommitsRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwner
	}
	return ""
}

func (x *ListRepositoryDraftCommitsRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *ListRepositoryDraftCommitsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.xxx_hidden_PageSize
	}
	return 0
}

func (x *ListRepositoryDraftCommitsRequest) GetPageToken() string {
	if x != nil {
		return x.xxx_hidden_PageToken
	}
	return ""
}

func (x *ListRepositoryDraftCommitsRequest) GetReverse() bool {
	if x != nil {
		return x.xxx_hidden_Reverse
	}
	return false
}

func (x *ListRepositoryDraftCommitsRequest) SetRepositoryOwner(v string) {
	x.xxx_hidden_RepositoryOwner = v
}

func (x *ListRepositoryDraftCommitsRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *ListRepositoryDraftCommitsRequest) SetPageSize(v uint32) {
	x.xxx_hidden_PageSize = v
}

func (x *ListRepositoryDraftCommitsRequest) SetPageToken(v string) {
	x.xxx_hidden_PageToken = v
}

func (x *ListRepositoryDraftCommitsRequest) SetReverse(v bool) {
	x.xxx_hidden_Reverse = v
}

type ListRepositoryDraftCommitsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the repository which the repository branch belongs to.
	RepositoryOwner string
	// The name of the repository which the repository branch belongs to.
	RepositoryName string
	PageSize       uint32
	PageToken      string
	// By default, draft commits are ordered by last update time descending.
	// Reverse orders them ascending.
	Reverse bool
}

func (b0 ListRepositoryDraftCommitsRequest_builder) Build() *ListRepositoryDraftCommitsRequest {
	m0 := &ListRepositoryDraftCommitsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryOwner = b.RepositoryOwner
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_PageSize = b.PageSize
	x.xxx_hidden_PageToken = b.PageToken
	x.xxx_hidden_Reverse = b.Reverse
	return m0
}

type ListRepositoryDraftCommitsResponse struct {
	state                        protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryCommits *[]*RepositoryCommit   `protobuf:"bytes,1,rep,name=repository_commits,json=repositoryCommits,proto3"`
	xxx_hidden_NextPageToken     string                 `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *ListRepositoryDraftCommitsResponse) Reset() {
	*x = ListRepositoryDraftCommitsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListRepositoryDraftCommitsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoryDraftCommitsResponse) ProtoMessage() {}

func (x *ListRepositoryDraftCommitsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListRepositoryDraftCommitsResponse) GetRepositoryCommits() []*RepositoryCommit {
	if x != nil {
		if x.xxx_hidden_RepositoryCommits != nil {
			return *x.xxx_hidden_RepositoryCommits
		}
	}
	return nil
}

func (x *ListRepositoryDraftCommitsResponse) GetNextPageToken() string {
	if x != nil {
		return x.xxx_hidden_NextPageToken
	}
	return ""
}

func (x *ListRepositoryDraftCommitsResponse) SetRepositoryCommits(v []*RepositoryCommit) {
	x.xxx_hidden_RepositoryCommits = &v
}

func (x *ListRepositoryDraftCommitsResponse) SetNextPageToken(v string) {
	x.xxx_hidden_NextPageToken = v
}

type ListRepositoryDraftCommitsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Each commit will have draft_name set.
	RepositoryCommits []*RepositoryCommit
	NextPageToken     string
}

func (b0 ListRepositoryDraftCommitsResponse_builder) Build() *ListRepositoryDraftCommitsResponse {
	m0 := &ListRepositoryDraftCommitsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryCommits = &b.RepositoryCommits
	x.xxx_hidden_NextPageToken = b.NextPageToken
	return m0
}

type DeleteRepositoryDraftCommitRequest struct {
	state                      protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryOwner string                 `protobuf:"bytes,1,opt,name=repository_owner,json=repositoryOwner,proto3"`
	xxx_hidden_RepositoryName  string                 `protobuf:"bytes,2,opt,name=repository_name,json=repositoryName,proto3"`
	xxx_hidden_DraftName       string                 `protobuf:"bytes,3,opt,name=draft_name,json=draftName,proto3"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *DeleteRepositoryDraftCommitRequest) Reset() {
	*x = DeleteRepositoryDraftCommitRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRepositoryDraftCommitRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRepositoryDraftCommitRequest) ProtoMessage() {}

func (x *DeleteRepositoryDraftCommitRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeleteRepositoryDraftCommitRequest) GetRepositoryOwner() string {
	if x != nil {
		return x.xxx_hidden_RepositoryOwner
	}
	return ""
}

func (x *DeleteRepositoryDraftCommitRequest) GetRepositoryName() string {
	if x != nil {
		return x.xxx_hidden_RepositoryName
	}
	return ""
}

func (x *DeleteRepositoryDraftCommitRequest) GetDraftName() string {
	if x != nil {
		return x.xxx_hidden_DraftName
	}
	return ""
}

func (x *DeleteRepositoryDraftCommitRequest) SetRepositoryOwner(v string) {
	x.xxx_hidden_RepositoryOwner = v
}

func (x *DeleteRepositoryDraftCommitRequest) SetRepositoryName(v string) {
	x.xxx_hidden_RepositoryName = v
}

func (x *DeleteRepositoryDraftCommitRequest) SetDraftName(v string) {
	x.xxx_hidden_DraftName = v
}

type DeleteRepositoryDraftCommitRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The owner of the repository which the repository branch belongs to.
	RepositoryOwner string
	// The name of the repository which the repository branch belongs to.
	RepositoryName string
	// The name of the draft to delete.
	DraftName string
}

func (b0 DeleteRepositoryDraftCommitRequest_builder) Build() *DeleteRepositoryDraftCommitRequest {
	m0 := &DeleteRepositoryDraftCommitRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryOwner = b.RepositoryOwner
	x.xxx_hidden_RepositoryName = b.RepositoryName
	x.xxx_hidden_DraftName = b.DraftName
	return m0
}

type DeleteRepositoryDraftCommitResponse struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteRepositoryDraftCommitResponse) Reset() {
	*x = DeleteRepositoryDraftCommitResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteRepositoryDraftCommitResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRepositoryDraftCommitResponse) ProtoMessage() {}

func (x *DeleteRepositoryDraftCommitResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteRepositoryDraftCommitResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteRepositoryDraftCommitResponse_builder) Build() *DeleteRepositoryDraftCommitResponse {
	m0 := &DeleteRepositoryDraftCommitResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

var File_buf_alpha_registry_v1alpha1_repository_commit_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_repository_commit_proto_rawDesc = "" +
	"\n" +
	"3buf/alpha/registry/v1alpha1/repository_commit.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a0buf/alpha/registry/v1alpha1/repository_tag.proto\x1a\x1fgoogle/protobuf/timestamp.proto\"\xeb\x03\n" +
	"\x10RepositoryCommit\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12;\n" +
	"\vcreate_time\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\n" +
	"createTime\x12\x16\n" +
	"\x06digest\x18\x03 \x01(\tR\x06digest\x12\x12\n" +
	"\x04name\x18\x04 \x01(\tR\x04name\x12\x16\n" +
	"\x06branch\x18\x05 \x01(\tR\x06branch\x12\x16\n" +
	"\x06author\x18\a \x01(\tR\x06author\x12>\n" +
	"\x04tags\x18\b \x03(\v2*.buf.alpha.registry.v1alpha1.RepositoryTagR\x04tags\x12\x1d\n" +
	"\n" +
	"draft_name\x18\t \x01(\tR\tdraftName\x12&\n" +
	"\x0fspdx_license_id\x18\n" +
	" \x01(\tR\rspdxLicenseId\x12'\n" +
	"\x0fmanifest_digest\x18\v \x01(\tR\x0emanifestDigest\x12\x1b\n" +
	"\ttag_count\x18\f \x01(\x03R\btagCount\x12*\n" +
	"\x11git_commits_count\x18\r \x01(\x03R\x0fgitCommitsCount\x12\x1b\n" +
	"\tb5_digest\x18\x0e \x01(\tR\bb5DigestJ\x04\b\x06\x10\aR\x12commit_sequence_id\"\x86\x02\n" +
	"$ListRepositoryCommitsByBranchRequest\x12)\n" +
	"\x10repository_owner\x18\x01 \x01(\tR\x0frepositoryOwner\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\x124\n" +
	"\x16repository_branch_name\x18\x03 \x01(\tR\x14repositoryBranchName\x12\x1b\n" +
	"\tpage_size\x18\x04 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x05 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x06 \x01(\bR\areverse\"\xad\x01\n" +
	"%ListRepositoryCommitsByBranchResponse\x12\\\n" +
	"\x12repository_commits\x18\x01 \x03(\v2-.buf.alpha.registry.v1alpha1.RepositoryCommitR\x11repositoryCommits\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\xf1\x01\n" +
	"'ListRepositoryCommitsByReferenceRequest\x12)\n" +
	"\x10repository_owner\x18\x01 \x01(\tR\x0frepositoryOwner\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\x12\x1c\n" +
	"\treference\x18\x03 \x01(\tR\treference\x12\x1b\n" +
	"\tpage_size\x18\x04 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x05 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x06 \x01(\bR\areverse\"\xb0\x01\n" +
	"(ListRepositoryCommitsByReferenceResponse\x12\\\n" +
	"\x12repository_commits\x18\x01 \x03(\v2-.buf.alpha.registry.v1alpha1.RepositoryCommitR\x11repositoryCommits\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x99\x01\n" +
	"%GetRepositoryCommitByReferenceRequest\x12)\n" +
	"\x10repository_owner\x18\x01 \x01(\tR\x0frepositoryOwner\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\x12\x1c\n" +
	"\treference\x18\x03 \x01(\tR\treference\"\x84\x01\n" +
	"&GetRepositoryCommitByReferenceResponse\x12Z\n" +
	"\x11repository_commit\x18\x01 \x01(\v2-.buf.alpha.registry.v1alpha1.RepositoryCommitR\x10repositoryCommit\"\xcd\x01\n" +
	"!ListRepositoryDraftCommitsRequest\x12)\n" +
	"\x10repository_owner\x18\x01 \x01(\tR\x0frepositoryOwner\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\x12\x1b\n" +
	"\tpage_size\x18\x03 \x01(\rR\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x04 \x01(\tR\tpageToken\x12\x18\n" +
	"\areverse\x18\x05 \x01(\bR\areverse\"\xaa\x01\n" +
	"\"ListRepositoryDraftCommitsResponse\x12\\\n" +
	"\x12repository_commits\x18\x01 \x03(\v2-.buf.alpha.registry.v1alpha1.RepositoryCommitR\x11repositoryCommits\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\x97\x01\n" +
	"\"DeleteRepositoryDraftCommitRequest\x12)\n" +
	"\x10repository_owner\x18\x01 \x01(\tR\x0frepositoryOwner\x12'\n" +
	"\x0frepository_name\x18\x02 \x01(\tR\x0erepositoryName\x12\x1d\n" +
	"\n" +
	"draft_name\x18\x03 \x01(\tR\tdraftName\"%\n" +
	"#DeleteRepositoryDraftCommitResponse2\xff\x06\n" +
	"\x17RepositoryCommitService\x12\xae\x01\n" +
	"\x1dListRepositoryCommitsByBranch\x12A.buf.alpha.registry.v1alpha1.ListRepositoryCommitsByBranchRequest\x1aB.buf.alpha.registry.v1alpha1.ListRepositoryCommitsByBranchResponse\"\x06\x88\x02\x01\x90\x02\x01\x12\xb4\x01\n" +
	" ListRepositoryCommitsByReference\x12D.buf.alpha.registry.v1alpha1.ListRepositoryCommitsByReferenceRequest\x1aE.buf.alpha.registry.v1alpha1.ListRepositoryCommitsByReferenceResponse\"\x03\x90\x02\x01\x12\xae\x01\n" +
	"\x1eGetRepositoryCommitByReference\x12B.buf.alpha.registry.v1alpha1.GetRepositoryCommitByReferenceRequest\x1aC.buf.alpha.registry.v1alpha1.GetRepositoryCommitByReferenceResponse\"\x03\x90\x02\x01\x12\xa2\x01\n" +
	"\x1aListRepositoryDraftCommits\x12>.buf.alpha.registry.v1alpha1.ListRepositoryDraftCommitsRequest\x1a?.buf.alpha.registry.v1alpha1.ListRepositoryDraftCommitsResponse\"\x03\x90\x02\x01\x12\xa5\x01\n" +
	"\x1bDeleteRepositoryDraftCommit\x12?.buf.alpha.registry.v1alpha1.DeleteRepositoryDraftCommitRequest\x1a@.buf.alpha.registry.v1alpha1.DeleteRepositoryDraftCommitResponse\"\x03\x90\x02\x02B\xa2\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\x15RepositoryCommitProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_buf_alpha_registry_v1alpha1_repository_commit_proto_goTypes = []any{
	(*RepositoryCommit)(nil),                         // 0: buf.alpha.registry.v1alpha1.RepositoryCommit
	(*ListRepositoryCommitsByBranchRequest)(nil),     // 1: buf.alpha.registry.v1alpha1.ListRepositoryCommitsByBranchRequest
	(*ListRepositoryCommitsByBranchResponse)(nil),    // 2: buf.alpha.registry.v1alpha1.ListRepositoryCommitsByBranchResponse
	(*ListRepositoryCommitsByReferenceRequest)(nil),  // 3: buf.alpha.registry.v1alpha1.ListRepositoryCommitsByReferenceRequest
	(*ListRepositoryCommitsByReferenceResponse)(nil), // 4: buf.alpha.registry.v1alpha1.ListRepositoryCommitsByReferenceResponse
	(*GetRepositoryCommitByReferenceRequest)(nil),    // 5: buf.alpha.registry.v1alpha1.GetRepositoryCommitByReferenceRequest
	(*GetRepositoryCommitByReferenceResponse)(nil),   // 6: buf.alpha.registry.v1alpha1.GetRepositoryCommitByReferenceResponse
	(*ListRepositoryDraftCommitsRequest)(nil),        // 7: buf.alpha.registry.v1alpha1.ListRepositoryDraftCommitsRequest
	(*ListRepositoryDraftCommitsResponse)(nil),       // 8: buf.alpha.registry.v1alpha1.ListRepositoryDraftCommitsResponse
	(*DeleteRepositoryDraftCommitRequest)(nil),       // 9: buf.alpha.registry.v1alpha1.DeleteRepositoryDraftCommitRequest
	(*DeleteRepositoryDraftCommitResponse)(nil),      // 10: buf.alpha.registry.v1alpha1.DeleteRepositoryDraftCommitResponse
	(*timestamppb.Timestamp)(nil),                    // 11: google.protobuf.Timestamp
	(*RepositoryTag)(nil),                            // 12: buf.alpha.registry.v1alpha1.RepositoryTag
}
var file_buf_alpha_registry_v1alpha1_repository_commit_proto_depIdxs = []int32{
	11, // 0: buf.alpha.registry.v1alpha1.RepositoryCommit.create_time:type_name -> google.protobuf.Timestamp
	12, // 1: buf.alpha.registry.v1alpha1.RepositoryCommit.tags:type_name -> buf.alpha.registry.v1alpha1.RepositoryTag
	0,  // 2: buf.alpha.registry.v1alpha1.ListRepositoryCommitsByBranchResponse.repository_commits:type_name -> buf.alpha.registry.v1alpha1.RepositoryCommit
	0,  // 3: buf.alpha.registry.v1alpha1.ListRepositoryCommitsByReferenceResponse.repository_commits:type_name -> buf.alpha.registry.v1alpha1.RepositoryCommit
	0,  // 4: buf.alpha.registry.v1alpha1.GetRepositoryCommitByReferenceResponse.repository_commit:type_name -> buf.alpha.registry.v1alpha1.RepositoryCommit
	0,  // 5: buf.alpha.registry.v1alpha1.ListRepositoryDraftCommitsResponse.repository_commits:type_name -> buf.alpha.registry.v1alpha1.RepositoryCommit
	1,  // 6: buf.alpha.registry.v1alpha1.RepositoryCommitService.ListRepositoryCommitsByBranch:input_type -> buf.alpha.registry.v1alpha1.ListRepositoryCommitsByBranchRequest
	3,  // 7: buf.alpha.registry.v1alpha1.RepositoryCommitService.ListRepositoryCommitsByReference:input_type -> buf.alpha.registry.v1alpha1.ListRepositoryCommitsByReferenceRequest
	5,  // 8: buf.alpha.registry.v1alpha1.RepositoryCommitService.GetRepositoryCommitByReference:input_type -> buf.alpha.registry.v1alpha1.GetRepositoryCommitByReferenceRequest
	7,  // 9: buf.alpha.registry.v1alpha1.RepositoryCommitService.ListRepositoryDraftCommits:input_type -> buf.alpha.registry.v1alpha1.ListRepositoryDraftCommitsRequest
	9,  // 10: buf.alpha.registry.v1alpha1.RepositoryCommitService.DeleteRepositoryDraftCommit:input_type -> buf.alpha.registry.v1alpha1.DeleteRepositoryDraftCommitRequest
	2,  // 11: buf.alpha.registry.v1alpha1.RepositoryCommitService.ListRepositoryCommitsByBranch:output_type -> buf.alpha.registry.v1alpha1.ListRepositoryCommitsByBranchResponse
	4,  // 12: buf.alpha.registry.v1alpha1.RepositoryCommitService.ListRepositoryCommitsByReference:output_type -> buf.alpha.registry.v1alpha1.ListRepositoryCommitsByReferenceResponse
	6,  // 13: buf.alpha.registry.v1alpha1.RepositoryCommitService.GetRepositoryCommitByReference:output_type -> buf.alpha.registry.v1alpha1.GetRepositoryCommitByReferenceResponse
	8,  // 14: buf.alpha.registry.v1alpha1.RepositoryCommitService.ListRepositoryDraftCommits:output_type -> buf.alpha.registry.v1alpha1.ListRepositoryDraftCommitsResponse
	10, // 15: buf.alpha.registry.v1alpha1.RepositoryCommitService.DeleteRepositoryDraftCommit:output_type -> buf.alpha.registry.v1alpha1.DeleteRepositoryDraftCommitResponse
	11, // [11:16] is the sub-list for method output_type
	6,  // [6:11] is the sub-list for method input_type
	6,  // [6:6] is the sub-list for extension type_name
	6,  // [6:6] is the sub-list for extension extendee
	0,  // [0:6] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_repository_commit_proto_init() }
func file_buf_alpha_registry_v1alpha1_repository_commit_proto_init() {
	if File_buf_alpha_registry_v1alpha1_repository_commit_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_repository_tag_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_repository_commit_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_repository_commit_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_repository_commit_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_repository_commit_proto_depIdxs,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_repository_commit_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_repository_commit_proto = out.File
	file_buf_alpha_registry_v1alpha1_repository_commit_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_repository_commit_proto_depIdxs = nil
}
