/// An identifier of an engine feature required for parsing and/or matching a particular signature or signature element.
#[derive(Clone, Debug, Copy, PartialEq)]
pub enum Feature {
    ByteCode,
    ByteCodeBcPeAll,
    ByteCodeBcPreclass,
    ByteCompareMin,
    ContentMetadataSig,
    DigitalSignaturePkcs7Pem,
    HashSha1,
    HashSha256,
    HashSizeUnknown,
    JsonReadApi,
    LogicalSigMacro,
    LogicalSigVI,
    PdfHooks,
    SubSigPcre,
    TargetTypeFlash,
    TargetTypeInternal,
    TargetTypeJava,
    TargetTypePdf,
    FileType7Z,
    FileType7Zsfx,
    FileTypeAiModel,
    FileTypeAlz,
    FileTypeAny,
    FileTypeApm,
    FileTypeCpioCrc,
    FileTypeCpioNewc,
    FileTypeCpioOdc,
    FileTypeCpioOld,
    FileTypeDmg,
    FileTypeEgg,
    FileTypeEggsfx,
    FileTypeEps,
    FileTypeGif,
    FileTypeGpt,
    FileTypeHwp3,
    FileTypeHwpole2,
    FileTypeInternal,
    FileTypeIshieldMsi,
    FileTypeIso9660,
    FileTypeJava,
    FileTypeJpeg,
    FileTypeLhaLzh,
    FileTypeLnk,
    FileTypeMacho,
    FileTypeMachoUnibin,
    FileTypeMbr,
    FileTypeMhtml,
    FileTypeOnenote,
    FileTypeOoxmlHwp,
    FileTypeOoxmlPpt,
    FileTypeOoxmlWord,
    FileTypeOoxmlXl,
    FileTypeOther,
    FileTypePartAny,
    FileTypePartHfsplus,
    FileTypePng,
    FileTypePs,
    FileTypePythonCompiled,
    FileTypeSwf,
    FileTypeTiff,
    FileTypeUdf,
    FileTypeXar,
    FileTypeXdp,
    FileTypeXmlHwp,
    FileTypeXmlWord,
    FileTypeXmlXl,
    FileTypeXz,
}
impl Feature {
    #[must_use]
    pub fn min_flevel(&self) -> u32 {
        #[allow(clippy::match_same_arms)]
        match self {
        Feature::ByteCode => 51,
        Feature::ByteCodeBcPeAll => 55,
        Feature::ByteCodeBcPreclass => 80,
        Feature::ByteCompareMin => 150,
        Feature::ContentMetadataSig => 51,
        Feature::DigitalSignaturePkcs7Pem => 230,
        Feature::HashSha1 => 74,
        Feature::HashSha256 => 74,
        Feature::HashSizeUnknown => 73,
        Feature::JsonReadApi => 79,
        Feature::LogicalSigMacro => 53,
        Feature::LogicalSigVI => 53,
        Feature::PdfHooks => 54,
        Feature::SubSigPcre => 81,
        Feature::TargetTypeFlash => 74,
        Feature::TargetTypeInternal => 74,
        Feature::TargetTypeJava => 73,
        Feature::TargetTypePdf => 74,
        Feature::FileType7Z => 47,
        Feature::FileType7Zsfx => 70,
        Feature::FileTypeAiModel => 230,
        Feature::FileTypeAlz => 210,
        Feature::FileTypeAny => 49,
        Feature::FileTypeApm => 77,
        Feature::FileTypeCpioCrc => 44,
        Feature::FileTypeCpioNewc => 44,
        Feature::FileTypeCpioOdc => 44,
        Feature::FileTypeCpioOld => 44,
        Feature::FileTypeDmg => 73,
        Feature::FileTypeEgg => 110,
        Feature::FileTypeEggsfx => 110,
        Feature::FileTypeEps => 83,
        Feature::FileTypeGif => 120,
        Feature::FileTypeGpt => 77,
        Feature::FileTypeHwp3 => 82,
        Feature::FileTypeHwpole2 => 82,
        Feature::FileTypeInternal => 78,
        Feature::FileTypeIshieldMsi => 45,
        Feature::FileTypeIso9660 => 71,
        Feature::FileTypeJava => 73,
        Feature::FileTypeJpeg => 130,
        Feature::FileTypeLhaLzh => 210,
        Feature::FileTypeLnk => 100,
        Feature::FileTypeMacho => 45,
        Feature::FileTypeMachoUnibin => 46,
        Feature::FileTypeMbr => 77,
        Feature::FileTypeMhtml => 83,
        Feature::FileTypeOnenote => 200,
        Feature::FileTypeOoxmlHwp => 82,
        Feature::FileTypeOoxmlPpt => 75,
        Feature::FileTypeOoxmlWord => 75,
        Feature::FileTypeOoxmlXl => 75,
        Feature::FileTypeOther => 81,
        Feature::FileTypePartAny => 75,
        Feature::FileTypePartHfsplus => 75,
        Feature::FileTypePng => 120,
        Feature::FileTypePs => 83,
        Feature::FileTypePythonCompiled => 200,
        Feature::FileTypeSwf => 61,
        Feature::FileTypeTiff => 130,
        Feature::FileTypeUdf => 190,
        Feature::FileTypeXar => 73,
        Feature::FileTypeXdp => 79,
        Feature::FileTypeXmlHwp => 82,
        Feature::FileTypeXmlWord => 80,
        Feature::FileTypeXmlXl => 80,
        Feature::FileTypeXz => 75,
        }
    }
}
