/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "clapper-mpris-gdbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__INT64 (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_Int64Func)
       (void *data1,
        gint64 arg_Position,
        void *data2);
  _GDbusCodegenMarshalVoid_Int64Func callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_Int64Func)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_int64 (param_values + 1),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT64 (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectInt64Func)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint64 arg_Offset,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectInt64Func callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectInt64Func)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int64 (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_INT64 (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringInt64Func)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_TrackId,
        gint64 arg_Position,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringInt64Func callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringInt64Func)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_int64 (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_Uri,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_VOID__BOXED_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_BoxedStringFunc)
       (void *data1,
        const gchar *const *arg_Tracks,
        const gchar *arg_CurrentTrack,
        void *data2);
  _GDbusCodegenMarshalVoid_BoxedStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_BoxedStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_boxed (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__VARIANT_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_VariantStringFunc)
       (void *data1,
        GVariant *arg_Metadata,
        const gchar *arg_AfterTrack,
        void *data2);
  _GDbusCodegenMarshalVoid_VariantStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_VariantStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_variant (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringVariantFunc)
       (void *data1,
        const gchar *arg_TrackId,
        GVariant *arg_Metadata,
        void *data2);
  _GDbusCodegenMarshalVoid_StringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_variant (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *const *arg_TrackIds,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boxed (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_Uri,
        const gchar *arg_AfterTrack,
        gboolean arg_SetAsCurrent,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_boolean (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.mpris.MediaPlayer2
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:ClapperEnhancerMprisMediaPlayer2
 * @title: ClapperEnhancerMprisMediaPlayer2
 * @short_description: Generated C code for the org.mpris.MediaPlayer2 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-mpris-MediaPlayer2.top_of_page">org.mpris.MediaPlayer2</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.mpris.MediaPlayer2 ---- */

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_method_info_raise =
{
  {
    -1,
    (gchar *) "Raise",
    NULL,
    NULL,
    NULL
  },
  "handle-raise",
  FALSE
};

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_method_info_quit =
{
  {
    -1,
    (gchar *) "Quit",
    NULL,
    NULL,
    NULL
  },
  "handle-quit",
  FALSE
};

static const GDBusMethodInfo * const _clapper_enhancer_mpris_media_player2_method_info_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_method_info_raise.parent_struct,
  &_clapper_enhancer_mpris_media_player2_method_info_quit.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_property_info_can_quit =
{
  {
    -1,
    (gchar *) "CanQuit",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-quit",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_property_info_fullscreen =
{
  {
    -1,
    (gchar *) "Fullscreen",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "fullscreen",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_property_info_can_set_fullscreen =
{
  {
    -1,
    (gchar *) "CanSetFullscreen",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-set-fullscreen",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_property_info_can_raise =
{
  {
    -1,
    (gchar *) "CanRaise",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-raise",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_property_info_has_track_list =
{
  {
    -1,
    (gchar *) "HasTrackList",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "has-track-list",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_property_info_identity =
{
  {
    -1,
    (gchar *) "Identity",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "identity",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_property_info_desktop_entry =
{
  {
    -1,
    (gchar *) "DesktopEntry",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "desktop-entry",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_property_info_supported_uri_schemes =
{
  {
    -1,
    (gchar *) "SupportedUriSchemes",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-uri-schemes",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_property_info_supported_mime_types =
{
  {
    -1,
    (gchar *) "SupportedMimeTypes",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-mime-types",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _clapper_enhancer_mpris_media_player2_property_info_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_property_info_can_quit.parent_struct,
  &_clapper_enhancer_mpris_media_player2_property_info_fullscreen.parent_struct,
  &_clapper_enhancer_mpris_media_player2_property_info_can_set_fullscreen.parent_struct,
  &_clapper_enhancer_mpris_media_player2_property_info_can_raise.parent_struct,
  &_clapper_enhancer_mpris_media_player2_property_info_has_track_list.parent_struct,
  &_clapper_enhancer_mpris_media_player2_property_info_identity.parent_struct,
  &_clapper_enhancer_mpris_media_player2_property_info_desktop_entry.parent_struct,
  &_clapper_enhancer_mpris_media_player2_property_info_supported_uri_schemes.parent_struct,
  &_clapper_enhancer_mpris_media_player2_property_info_supported_mime_types.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _clapper_enhancer_mpris_media_player2_interface_info =
{
  {
    -1,
    (gchar *) "org.mpris.MediaPlayer2",
    (GDBusMethodInfo **) &_clapper_enhancer_mpris_media_player2_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_clapper_enhancer_mpris_media_player2_property_info_pointers,
    NULL
  },
  "media-player2",
};


/**
 * clapper_enhancer_mpris_media_player2_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-mpris-MediaPlayer2.top_of_page">org.mpris.MediaPlayer2</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
clapper_enhancer_mpris_media_player2_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_interface_info.parent_struct;
}

/**
 * clapper_enhancer_mpris_media_player2_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #ClapperEnhancerMprisMediaPlayer2 interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
clapper_enhancer_mpris_media_player2_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "can-quit");
  g_object_class_override_property (klass, property_id_begin++, "fullscreen");
  g_object_class_override_property (klass, property_id_begin++, "can-set-fullscreen");
  g_object_class_override_property (klass, property_id_begin++, "can-raise");
  g_object_class_override_property (klass, property_id_begin++, "has-track-list");
  g_object_class_override_property (klass, property_id_begin++, "identity");
  g_object_class_override_property (klass, property_id_begin++, "desktop-entry");
  g_object_class_override_property (klass, property_id_begin++, "supported-uri-schemes");
  g_object_class_override_property (klass, property_id_begin++, "supported-mime-types");
  return property_id_begin - 1;
}


inline static void
clapper_enhancer_mpris_media_player2_method_marshal_raise (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_method_marshal_quit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * ClapperEnhancerMprisMediaPlayer2:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2.top_of_page">org.mpris.MediaPlayer2</link>.
 */

/**
 * ClapperEnhancerMprisMediaPlayer2Iface:
 * @parent_iface: The parent interface.
 * @handle_quit: Handler for the #ClapperEnhancerMprisMediaPlayer2::handle-quit signal.
 * @handle_raise: Handler for the #ClapperEnhancerMprisMediaPlayer2::handle-raise signal.
 * @get_can_quit: Getter for the #ClapperEnhancerMprisMediaPlayer2:can-quit property.
 * @get_can_raise: Getter for the #ClapperEnhancerMprisMediaPlayer2:can-raise property.
 * @get_can_set_fullscreen: Getter for the #ClapperEnhancerMprisMediaPlayer2:can-set-fullscreen property.
 * @get_desktop_entry: Getter for the #ClapperEnhancerMprisMediaPlayer2:desktop-entry property.
 * @get_fullscreen: Getter for the #ClapperEnhancerMprisMediaPlayer2:fullscreen property.
 * @get_has_track_list: Getter for the #ClapperEnhancerMprisMediaPlayer2:has-track-list property.
 * @get_identity: Getter for the #ClapperEnhancerMprisMediaPlayer2:identity property.
 * @get_supported_mime_types: Getter for the #ClapperEnhancerMprisMediaPlayer2:supported-mime-types property.
 * @get_supported_uri_schemes: Getter for the #ClapperEnhancerMprisMediaPlayer2:supported-uri-schemes property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2.top_of_page">org.mpris.MediaPlayer2</link>.
 */

typedef ClapperEnhancerMprisMediaPlayer2Iface ClapperEnhancerMprisMediaPlayer2Interface;
G_DEFINE_INTERFACE (ClapperEnhancerMprisMediaPlayer2, clapper_enhancer_mpris_media_player2, G_TYPE_OBJECT)

static void
clapper_enhancer_mpris_media_player2_default_init (ClapperEnhancerMprisMediaPlayer2Iface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * ClapperEnhancerMprisMediaPlayer2::handle-raise:
   * @object: A #ClapperEnhancerMprisMediaPlayer2.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2.Raise">Raise()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_complete_raise() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-raise",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2Iface, handle_raise),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_method_marshal_raise,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ClapperEnhancerMprisMediaPlayer2::handle-quit:
   * @object: A #ClapperEnhancerMprisMediaPlayer2.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2.Quit">Quit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_complete_quit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-quit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2Iface, handle_quit),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_method_marshal_quit,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * ClapperEnhancerMprisMediaPlayer2:can-quit:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2.CanQuit">"CanQuit"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-quit", "CanQuit", "CanQuit", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2:fullscreen:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2.Fullscreen">"Fullscreen"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("fullscreen", "Fullscreen", "Fullscreen", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2:can-set-fullscreen:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2.CanSetFullscreen">"CanSetFullscreen"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-set-fullscreen", "CanSetFullscreen", "CanSetFullscreen", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2:can-raise:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2.CanRaise">"CanRaise"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-raise", "CanRaise", "CanRaise", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2:has-track-list:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2.HasTrackList">"HasTrackList"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("has-track-list", "HasTrackList", "HasTrackList", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2:identity:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2.Identity">"Identity"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("identity", "Identity", "Identity", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2:desktop-entry:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2.DesktopEntry">"DesktopEntry"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("desktop-entry", "DesktopEntry", "DesktopEntry", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2:supported-uri-schemes:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2.SupportedUriSchemes">"SupportedUriSchemes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("supported-uri-schemes", "SupportedUriSchemes", "SupportedUriSchemes", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2:supported-mime-types:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2.SupportedMimeTypes">"SupportedMimeTypes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("supported-mime-types", "SupportedMimeTypes", "SupportedMimeTypes", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * clapper_enhancer_mpris_media_player2_get_can_quit: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2.CanQuit">"CanQuit"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
clapper_enhancer_mpris_media_player2_get_can_quit (ClapperEnhancerMprisMediaPlayer2 *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2 (object), FALSE);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_GET_IFACE (object)->get_can_quit (object);
}

/**
 * clapper_enhancer_mpris_media_player2_set_can_quit: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2.CanQuit">"CanQuit"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_set_can_quit (ClapperEnhancerMprisMediaPlayer2 *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-quit", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_get_fullscreen: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2.Fullscreen">"Fullscreen"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
clapper_enhancer_mpris_media_player2_get_fullscreen (ClapperEnhancerMprisMediaPlayer2 *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2 (object), FALSE);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_GET_IFACE (object)->get_fullscreen (object);
}

/**
 * clapper_enhancer_mpris_media_player2_set_fullscreen: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2.Fullscreen">"Fullscreen"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
clapper_enhancer_mpris_media_player2_set_fullscreen (ClapperEnhancerMprisMediaPlayer2 *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "fullscreen", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_get_can_set_fullscreen: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2.CanSetFullscreen">"CanSetFullscreen"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
clapper_enhancer_mpris_media_player2_get_can_set_fullscreen (ClapperEnhancerMprisMediaPlayer2 *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2 (object), FALSE);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_GET_IFACE (object)->get_can_set_fullscreen (object);
}

/**
 * clapper_enhancer_mpris_media_player2_set_can_set_fullscreen: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2.CanSetFullscreen">"CanSetFullscreen"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_set_can_set_fullscreen (ClapperEnhancerMprisMediaPlayer2 *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-set-fullscreen", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_get_can_raise: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2.CanRaise">"CanRaise"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
clapper_enhancer_mpris_media_player2_get_can_raise (ClapperEnhancerMprisMediaPlayer2 *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2 (object), FALSE);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_GET_IFACE (object)->get_can_raise (object);
}

/**
 * clapper_enhancer_mpris_media_player2_set_can_raise: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2.CanRaise">"CanRaise"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_set_can_raise (ClapperEnhancerMprisMediaPlayer2 *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-raise", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_get_has_track_list: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2.HasTrackList">"HasTrackList"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
clapper_enhancer_mpris_media_player2_get_has_track_list (ClapperEnhancerMprisMediaPlayer2 *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2 (object), FALSE);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_GET_IFACE (object)->get_has_track_list (object);
}

/**
 * clapper_enhancer_mpris_media_player2_set_has_track_list: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2.HasTrackList">"HasTrackList"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_set_has_track_list (ClapperEnhancerMprisMediaPlayer2 *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "has-track-list", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_get_identity: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2.Identity">"Identity"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use clapper_enhancer_mpris_media_player2_dup_identity() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
clapper_enhancer_mpris_media_player2_get_identity (ClapperEnhancerMprisMediaPlayer2 *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2 (object), NULL);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_GET_IFACE (object)->get_identity (object);
}

/**
 * clapper_enhancer_mpris_media_player2_dup_identity: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2.Identity">"Identity"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
clapper_enhancer_mpris_media_player2_dup_identity (ClapperEnhancerMprisMediaPlayer2 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "identity", &value, NULL);
  return value;
}

/**
 * clapper_enhancer_mpris_media_player2_set_identity: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2.Identity">"Identity"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_set_identity (ClapperEnhancerMprisMediaPlayer2 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "identity", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_get_desktop_entry: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2.DesktopEntry">"DesktopEntry"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use clapper_enhancer_mpris_media_player2_dup_desktop_entry() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
clapper_enhancer_mpris_media_player2_get_desktop_entry (ClapperEnhancerMprisMediaPlayer2 *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2 (object), NULL);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_GET_IFACE (object)->get_desktop_entry (object);
}

/**
 * clapper_enhancer_mpris_media_player2_dup_desktop_entry: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2.DesktopEntry">"DesktopEntry"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
clapper_enhancer_mpris_media_player2_dup_desktop_entry (ClapperEnhancerMprisMediaPlayer2 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "desktop-entry", &value, NULL);
  return value;
}

/**
 * clapper_enhancer_mpris_media_player2_set_desktop_entry: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2.DesktopEntry">"DesktopEntry"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_set_desktop_entry (ClapperEnhancerMprisMediaPlayer2 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "desktop-entry", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_get_supported_uri_schemes: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2.SupportedUriSchemes">"SupportedUriSchemes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use clapper_enhancer_mpris_media_player2_dup_supported_uri_schemes() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
clapper_enhancer_mpris_media_player2_get_supported_uri_schemes (ClapperEnhancerMprisMediaPlayer2 *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2 (object), NULL);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_GET_IFACE (object)->get_supported_uri_schemes (object);
}

/**
 * clapper_enhancer_mpris_media_player2_dup_supported_uri_schemes: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2.SupportedUriSchemes">"SupportedUriSchemes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
clapper_enhancer_mpris_media_player2_dup_supported_uri_schemes (ClapperEnhancerMprisMediaPlayer2 *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "supported-uri-schemes", &value, NULL);
  return value;
}

/**
 * clapper_enhancer_mpris_media_player2_set_supported_uri_schemes: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2.SupportedUriSchemes">"SupportedUriSchemes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_set_supported_uri_schemes (ClapperEnhancerMprisMediaPlayer2 *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "supported-uri-schemes", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_get_supported_mime_types: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2.SupportedMimeTypes">"SupportedMimeTypes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use clapper_enhancer_mpris_media_player2_dup_supported_mime_types() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
clapper_enhancer_mpris_media_player2_get_supported_mime_types (ClapperEnhancerMprisMediaPlayer2 *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2 (object), NULL);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_GET_IFACE (object)->get_supported_mime_types (object);
}

/**
 * clapper_enhancer_mpris_media_player2_dup_supported_mime_types: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2.SupportedMimeTypes">"SupportedMimeTypes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
clapper_enhancer_mpris_media_player2_dup_supported_mime_types (ClapperEnhancerMprisMediaPlayer2 *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "supported-mime-types", &value, NULL);
  return value;
}

/**
 * clapper_enhancer_mpris_media_player2_set_supported_mime_types: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2.SupportedMimeTypes">"SupportedMimeTypes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_set_supported_mime_types (ClapperEnhancerMprisMediaPlayer2 *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "supported-mime-types", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_call_raise:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2.Raise">Raise()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_call_raise_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_call_raise_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_call_raise (
    ClapperEnhancerMprisMediaPlayer2 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Raise",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_call_raise_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_call_raise().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_call_raise().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_call_raise_finish (
    ClapperEnhancerMprisMediaPlayer2 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_call_raise_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2.Raise">Raise()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_call_raise() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_call_raise_sync (
    ClapperEnhancerMprisMediaPlayer2 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Raise",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_call_quit:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2.Quit">Quit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_call_quit_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_call_quit_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_call_quit (
    ClapperEnhancerMprisMediaPlayer2 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Quit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_call_quit_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_call_quit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_call_quit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_call_quit_finish (
    ClapperEnhancerMprisMediaPlayer2 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_call_quit_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2.Quit">Quit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_call_quit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_call_quit_sync (
    ClapperEnhancerMprisMediaPlayer2 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Quit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_complete_raise:
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2.Raise">Raise()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_complete_raise (
    ClapperEnhancerMprisMediaPlayer2 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * clapper_enhancer_mpris_media_player2_complete_quit:
 * @object: A #ClapperEnhancerMprisMediaPlayer2.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2.Quit">Quit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_complete_quit (
    ClapperEnhancerMprisMediaPlayer2 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * ClapperEnhancerMprisMediaPlayer2Proxy:
 *
 * The #ClapperEnhancerMprisMediaPlayer2Proxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ClapperEnhancerMprisMediaPlayer2ProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ClapperEnhancerMprisMediaPlayer2Proxy.
 */

struct _ClapperEnhancerMprisMediaPlayer2ProxyPrivate
{
  GData *qdata;
};

static void clapper_enhancer_mpris_media_player2_proxy_iface_init (ClapperEnhancerMprisMediaPlayer2Iface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ClapperEnhancerMprisMediaPlayer2Proxy, clapper_enhancer_mpris_media_player2_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (ClapperEnhancerMprisMediaPlayer2Proxy)
                         G_IMPLEMENT_INTERFACE (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2, clapper_enhancer_mpris_media_player2_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ClapperEnhancerMprisMediaPlayer2Proxy, clapper_enhancer_mpris_media_player2_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2, clapper_enhancer_mpris_media_player2_proxy_iface_init))

#endif
static void
clapper_enhancer_mpris_media_player2_proxy_finalize (GObject *object)
{
  ClapperEnhancerMprisMediaPlayer2Proxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (clapper_enhancer_mpris_media_player2_proxy_parent_class)->finalize (object);
}

static void
clapper_enhancer_mpris_media_player2_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _clapper_enhancer_mpris_media_player2_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
clapper_enhancer_mpris_media_player2_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.mpris.MediaPlayer2: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
clapper_enhancer_mpris_media_player2_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _clapper_enhancer_mpris_media_player2_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.mpris.MediaPlayer2", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) clapper_enhancer_mpris_media_player2_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
clapper_enhancer_mpris_media_player2_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
clapper_enhancer_mpris_media_player2_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  ClapperEnhancerMprisMediaPlayer2Proxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
clapper_enhancer_mpris_media_player2_proxy_get_can_quit (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Proxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanQuit");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_proxy_get_fullscreen (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Proxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Fullscreen");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_proxy_get_can_set_fullscreen (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Proxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanSetFullscreen");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_proxy_get_can_raise (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Proxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanRaise");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_proxy_get_has_track_list (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Proxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "HasTrackList");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
clapper_enhancer_mpris_media_player2_proxy_get_identity (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Proxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Identity");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
clapper_enhancer_mpris_media_player2_proxy_get_desktop_entry (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Proxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DesktopEntry");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
clapper_enhancer_mpris_media_player2_proxy_get_supported_uri_schemes (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Proxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "SupportedUriSchemes");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedUriSchemes");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "SupportedUriSchemes", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
clapper_enhancer_mpris_media_player2_proxy_get_supported_mime_types (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Proxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "SupportedMimeTypes");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedMimeTypes");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "SupportedMimeTypes", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
clapper_enhancer_mpris_media_player2_proxy_init (ClapperEnhancerMprisMediaPlayer2Proxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = clapper_enhancer_mpris_media_player2_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PROXY, ClapperEnhancerMprisMediaPlayer2ProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), clapper_enhancer_mpris_media_player2_interface_info ());
}

static void
clapper_enhancer_mpris_media_player2_proxy_class_init (ClapperEnhancerMprisMediaPlayer2ProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = clapper_enhancer_mpris_media_player2_proxy_finalize;
  gobject_class->get_property = clapper_enhancer_mpris_media_player2_proxy_get_property;
  gobject_class->set_property = clapper_enhancer_mpris_media_player2_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = clapper_enhancer_mpris_media_player2_proxy_g_signal;
  proxy_class->g_properties_changed = clapper_enhancer_mpris_media_player2_proxy_g_properties_changed;

  clapper_enhancer_mpris_media_player2_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ClapperEnhancerMprisMediaPlayer2ProxyPrivate));
#endif
}

static void
clapper_enhancer_mpris_media_player2_proxy_iface_init (ClapperEnhancerMprisMediaPlayer2Iface *iface)
{
  iface->get_can_quit = clapper_enhancer_mpris_media_player2_proxy_get_can_quit;
  iface->get_fullscreen = clapper_enhancer_mpris_media_player2_proxy_get_fullscreen;
  iface->get_can_set_fullscreen = clapper_enhancer_mpris_media_player2_proxy_get_can_set_fullscreen;
  iface->get_can_raise = clapper_enhancer_mpris_media_player2_proxy_get_can_raise;
  iface->get_has_track_list = clapper_enhancer_mpris_media_player2_proxy_get_has_track_list;
  iface->get_identity = clapper_enhancer_mpris_media_player2_proxy_get_identity;
  iface->get_desktop_entry = clapper_enhancer_mpris_media_player2_proxy_get_desktop_entry;
  iface->get_supported_uri_schemes = clapper_enhancer_mpris_media_player2_proxy_get_supported_uri_schemes;
  iface->get_supported_mime_types = clapper_enhancer_mpris_media_player2_proxy_get_supported_mime_types;
}

/**
 * clapper_enhancer_mpris_media_player2_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2.top_of_page">org.mpris.MediaPlayer2</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_proxy_new_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
clapper_enhancer_mpris_media_player2_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2", NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_proxy_new().
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2Proxy): The constructed proxy object or %NULL if @error is set.
 */
ClapperEnhancerMprisMediaPlayer2 *
clapper_enhancer_mpris_media_player2_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2 (ret);
  else
    return NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2.top_of_page">org.mpris.MediaPlayer2</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2Proxy): The constructed proxy object or %NULL if @error is set.
 */
ClapperEnhancerMprisMediaPlayer2 *
clapper_enhancer_mpris_media_player2_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2", NULL);
  if (ret != NULL)
    return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2 (ret);
  else
    return NULL;
}


/**
 * clapper_enhancer_mpris_media_player2_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like clapper_enhancer_mpris_media_player2_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
clapper_enhancer_mpris_media_player2_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2", NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2Proxy): The constructed proxy object or %NULL if @error is set.
 */
ClapperEnhancerMprisMediaPlayer2 *
clapper_enhancer_mpris_media_player2_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2 (ret);
  else
    return NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like clapper_enhancer_mpris_media_player2_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2Proxy): The constructed proxy object or %NULL if @error is set.
 */
ClapperEnhancerMprisMediaPlayer2 *
clapper_enhancer_mpris_media_player2_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2", NULL);
  if (ret != NULL)
    return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2 (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * ClapperEnhancerMprisMediaPlayer2Skeleton:
 *
 * The #ClapperEnhancerMprisMediaPlayer2Skeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ClapperEnhancerMprisMediaPlayer2SkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ClapperEnhancerMprisMediaPlayer2Skeleton.
 */

struct _ClapperEnhancerMprisMediaPlayer2SkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_clapper_enhancer_mpris_media_player2_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_clapper_enhancer_mpris_media_player2_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_clapper_enhancer_mpris_media_player2_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _clapper_enhancer_mpris_media_player2_skeleton_vtable =
{
  _clapper_enhancer_mpris_media_player2_skeleton_handle_method_call,
  _clapper_enhancer_mpris_media_player2_skeleton_handle_get_property,
  _clapper_enhancer_mpris_media_player2_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
clapper_enhancer_mpris_media_player2_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return clapper_enhancer_mpris_media_player2_interface_info ();
}

static GDBusInterfaceVTable *
clapper_enhancer_mpris_media_player2_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_clapper_enhancer_mpris_media_player2_skeleton_vtable;
}

static GVariant *
clapper_enhancer_mpris_media_player2_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_clapper_enhancer_mpris_media_player2_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _clapper_enhancer_mpris_media_player2_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _clapper_enhancer_mpris_media_player2_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _clapper_enhancer_mpris_media_player2_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mpris.MediaPlayer2", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _clapper_enhancer_mpris_media_player2_emit_changed (gpointer user_data);

static void
clapper_enhancer_mpris_media_player2_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _clapper_enhancer_mpris_media_player2_emit_changed (skeleton);
}

static void clapper_enhancer_mpris_media_player2_skeleton_iface_init (ClapperEnhancerMprisMediaPlayer2Iface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ClapperEnhancerMprisMediaPlayer2Skeleton, clapper_enhancer_mpris_media_player2_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (ClapperEnhancerMprisMediaPlayer2Skeleton)
                         G_IMPLEMENT_INTERFACE (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2, clapper_enhancer_mpris_media_player2_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ClapperEnhancerMprisMediaPlayer2Skeleton, clapper_enhancer_mpris_media_player2_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2, clapper_enhancer_mpris_media_player2_skeleton_iface_init))

#endif
static void
clapper_enhancer_mpris_media_player2_skeleton_finalize (GObject *object)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (object);
  guint n;
  for (n = 0; n < 9; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (clapper_enhancer_mpris_media_player2_skeleton_parent_class)->finalize (object);
}

static void
clapper_enhancer_mpris_media_player2_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_clapper_enhancer_mpris_media_player2_emit_changed (gpointer user_data)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.mpris.MediaPlayer2",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_clapper_enhancer_mpris_media_player2_schedule_emit_changed (ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
clapper_enhancer_mpris_media_player2_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _clapper_enhancer_mpris_media_player2_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _clapper_enhancer_mpris_media_player2_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
clapper_enhancer_mpris_media_player2_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _clapper_enhancer_mpris_media_player2_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _clapper_enhancer_mpris_media_player2_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
clapper_enhancer_mpris_media_player2_skeleton_init (ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = clapper_enhancer_mpris_media_player2_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_SKELETON, ClapperEnhancerMprisMediaPlayer2SkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 9);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_STRV);
}

static gboolean 
clapper_enhancer_mpris_media_player2_skeleton_get_can_quit (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_skeleton_get_fullscreen (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_skeleton_get_can_set_fullscreen (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_skeleton_get_can_raise (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_skeleton_get_has_track_list (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
clapper_enhancer_mpris_media_player2_skeleton_get_identity (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
clapper_enhancer_mpris_media_player2_skeleton_get_desktop_entry (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
clapper_enhancer_mpris_media_player2_skeleton_get_supported_uri_schemes (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
clapper_enhancer_mpris_media_player2_skeleton_get_supported_mime_types (ClapperEnhancerMprisMediaPlayer2 *object)
{
  ClapperEnhancerMprisMediaPlayer2Skeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
clapper_enhancer_mpris_media_player2_skeleton_class_init (ClapperEnhancerMprisMediaPlayer2SkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = clapper_enhancer_mpris_media_player2_skeleton_finalize;
  gobject_class->get_property = clapper_enhancer_mpris_media_player2_skeleton_get_property;
  gobject_class->set_property = clapper_enhancer_mpris_media_player2_skeleton_set_property;
  gobject_class->notify       = clapper_enhancer_mpris_media_player2_skeleton_notify;


  clapper_enhancer_mpris_media_player2_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = clapper_enhancer_mpris_media_player2_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = clapper_enhancer_mpris_media_player2_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = clapper_enhancer_mpris_media_player2_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = clapper_enhancer_mpris_media_player2_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ClapperEnhancerMprisMediaPlayer2SkeletonPrivate));
#endif
}

static void
clapper_enhancer_mpris_media_player2_skeleton_iface_init (ClapperEnhancerMprisMediaPlayer2Iface *iface)
{
  iface->get_can_quit = clapper_enhancer_mpris_media_player2_skeleton_get_can_quit;
  iface->get_fullscreen = clapper_enhancer_mpris_media_player2_skeleton_get_fullscreen;
  iface->get_can_set_fullscreen = clapper_enhancer_mpris_media_player2_skeleton_get_can_set_fullscreen;
  iface->get_can_raise = clapper_enhancer_mpris_media_player2_skeleton_get_can_raise;
  iface->get_has_track_list = clapper_enhancer_mpris_media_player2_skeleton_get_has_track_list;
  iface->get_identity = clapper_enhancer_mpris_media_player2_skeleton_get_identity;
  iface->get_desktop_entry = clapper_enhancer_mpris_media_player2_skeleton_get_desktop_entry;
  iface->get_supported_uri_schemes = clapper_enhancer_mpris_media_player2_skeleton_get_supported_uri_schemes;
  iface->get_supported_mime_types = clapper_enhancer_mpris_media_player2_skeleton_get_supported_mime_types;
}

/**
 * clapper_enhancer_mpris_media_player2_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2.top_of_page">org.mpris.MediaPlayer2</link>.
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2Skeleton): The skeleton object.
 */
ClapperEnhancerMprisMediaPlayer2 *
clapper_enhancer_mpris_media_player2_skeleton_new (void)
{
  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2 (g_object_new (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.mpris.MediaPlayer2.Player
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:ClapperEnhancerMprisMediaPlayer2Player
 * @title: ClapperEnhancerMprisMediaPlayer2Player
 * @short_description: Generated C code for the org.mpris.MediaPlayer2.Player D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link> D-Bus interface in C.
 */

enum
{
  CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_PLAYER_SEEKED,
};

static unsigned CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_PLAYER_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.mpris.MediaPlayer2.Player ---- */

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_player_method_info_next =
{
  {
    -1,
    (gchar *) "Next",
    NULL,
    NULL,
    NULL
  },
  "handle-next",
  FALSE
};

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_player_method_info_previous =
{
  {
    -1,
    (gchar *) "Previous",
    NULL,
    NULL,
    NULL
  },
  "handle-previous",
  FALSE
};

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_player_method_info_pause =
{
  {
    -1,
    (gchar *) "Pause",
    NULL,
    NULL,
    NULL
  },
  "handle-pause",
  FALSE
};

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_player_method_info_play_pause =
{
  {
    -1,
    (gchar *) "PlayPause",
    NULL,
    NULL,
    NULL
  },
  "handle-play-pause",
  FALSE
};

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_player_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_player_method_info_play =
{
  {
    -1,
    (gchar *) "Play",
    NULL,
    NULL,
    NULL
  },
  "handle-play",
  FALSE
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_player_method_info_seek_IN_ARG_Offset =
{
  {
    -1,
    (gchar *) "Offset",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _clapper_enhancer_mpris_media_player2_player_method_info_seek_IN_ARG_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_player_method_info_seek_IN_ARG_Offset.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_player_method_info_seek =
{
  {
    -1,
    (gchar *) "Seek",
    (GDBusArgInfo **) &_clapper_enhancer_mpris_media_player2_player_method_info_seek_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-seek",
  FALSE
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_player_method_info_set_position_IN_ARG_TrackId =
{
  {
    -1,
    (gchar *) "TrackId",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_player_method_info_set_position_IN_ARG_Position =
{
  {
    -1,
    (gchar *) "Position",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _clapper_enhancer_mpris_media_player2_player_method_info_set_position_IN_ARG_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_player_method_info_set_position_IN_ARG_TrackId.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_method_info_set_position_IN_ARG_Position.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_player_method_info_set_position =
{
  {
    -1,
    (gchar *) "SetPosition",
    (GDBusArgInfo **) &_clapper_enhancer_mpris_media_player2_player_method_info_set_position_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-position",
  FALSE
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_player_method_info_open_uri_IN_ARG_Uri =
{
  {
    -1,
    (gchar *) "Uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _clapper_enhancer_mpris_media_player2_player_method_info_open_uri_IN_ARG_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_player_method_info_open_uri_IN_ARG_Uri.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_player_method_info_open_uri =
{
  {
    -1,
    (gchar *) "OpenUri",
    (GDBusArgInfo **) &_clapper_enhancer_mpris_media_player2_player_method_info_open_uri_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-open-uri",
  FALSE
};

static const GDBusMethodInfo * const _clapper_enhancer_mpris_media_player2_player_method_info_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_player_method_info_next.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_method_info_previous.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_method_info_pause.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_method_info_play_pause.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_method_info_stop.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_method_info_play.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_method_info_seek.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_method_info_set_position.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_method_info_open_uri.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_player_signal_info_seeked_ARG_Position =
{
  {
    -1,
    (gchar *) "Position",
    (gchar *) "x",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _clapper_enhancer_mpris_media_player2_player_signal_info_seeked_ARG_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_player_signal_info_seeked_ARG_Position.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _clapper_enhancer_mpris_media_player2_player_signal_info_seeked =
{
  {
    -1,
    (gchar *) "Seeked",
    (GDBusArgInfo **) &_clapper_enhancer_mpris_media_player2_player_signal_info_seeked_ARG_pointers,
    NULL
  },
  "seeked"
};

static const GDBusSignalInfo * const _clapper_enhancer_mpris_media_player2_player_signal_info_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_player_signal_info_seeked.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_playback_status =
{
  {
    -1,
    (gchar *) "PlaybackStatus",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "playback-status",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_loop_status =
{
  {
    -1,
    (gchar *) "LoopStatus",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "loop-status",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_rate =
{
  {
    -1,
    (gchar *) "Rate",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "rate",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_shuffle =
{
  {
    -1,
    (gchar *) "Shuffle",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "shuffle",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_metadata =
{
  {
    -1,
    (gchar *) "Metadata",
    (gchar *) "a{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "metadata",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_volume =
{
  {
    -1,
    (gchar *) "Volume",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "volume",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_position =
{
  {
    -1,
    (gchar *) "Position",
    (gchar *) "x",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "position",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_minimum_rate =
{
  {
    -1,
    (gchar *) "MinimumRate",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "minimum-rate",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_maximum_rate =
{
  {
    -1,
    (gchar *) "MaximumRate",
    (gchar *) "d",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "maximum-rate",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_can_go_next =
{
  {
    -1,
    (gchar *) "CanGoNext",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-go-next",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_can_go_previous =
{
  {
    -1,
    (gchar *) "CanGoPrevious",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-go-previous",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_can_play =
{
  {
    -1,
    (gchar *) "CanPlay",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-play",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_can_pause =
{
  {
    -1,
    (gchar *) "CanPause",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-pause",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_can_seek =
{
  {
    -1,
    (gchar *) "CanSeek",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-seek",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_player_property_info_can_control =
{
  {
    -1,
    (gchar *) "CanControl",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-control",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _clapper_enhancer_mpris_media_player2_player_property_info_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_player_property_info_playback_status.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_property_info_loop_status.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_property_info_rate.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_property_info_shuffle.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_property_info_metadata.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_property_info_volume.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_property_info_position.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_property_info_minimum_rate.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_property_info_maximum_rate.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_property_info_can_go_next.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_property_info_can_go_previous.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_property_info_can_play.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_property_info_can_pause.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_property_info_can_seek.parent_struct,
  &_clapper_enhancer_mpris_media_player2_player_property_info_can_control.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _clapper_enhancer_mpris_media_player2_player_interface_info =
{
  {
    -1,
    (gchar *) "org.mpris.MediaPlayer2.Player",
    (GDBusMethodInfo **) &_clapper_enhancer_mpris_media_player2_player_method_info_pointers,
    (GDBusSignalInfo **) &_clapper_enhancer_mpris_media_player2_player_signal_info_pointers,
    (GDBusPropertyInfo **) &_clapper_enhancer_mpris_media_player2_player_property_info_pointers,
    NULL
  },
  "media-player2-player",
};


/**
 * clapper_enhancer_mpris_media_player2_player_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
clapper_enhancer_mpris_media_player2_player_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_player_interface_info.parent_struct;
}

/**
 * clapper_enhancer_mpris_media_player2_player_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #ClapperEnhancerMprisMediaPlayer2Player interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
clapper_enhancer_mpris_media_player2_player_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "playback-status");
  g_object_class_override_property (klass, property_id_begin++, "loop-status");
  g_object_class_override_property (klass, property_id_begin++, "rate");
  g_object_class_override_property (klass, property_id_begin++, "shuffle");
  g_object_class_override_property (klass, property_id_begin++, "metadata");
  g_object_class_override_property (klass, property_id_begin++, "volume");
  g_object_class_override_property (klass, property_id_begin++, "position");
  g_object_class_override_property (klass, property_id_begin++, "minimum-rate");
  g_object_class_override_property (klass, property_id_begin++, "maximum-rate");
  g_object_class_override_property (klass, property_id_begin++, "can-go-next");
  g_object_class_override_property (klass, property_id_begin++, "can-go-previous");
  g_object_class_override_property (klass, property_id_begin++, "can-play");
  g_object_class_override_property (klass, property_id_begin++, "can-pause");
  g_object_class_override_property (klass, property_id_begin++, "can-seek");
  g_object_class_override_property (klass, property_id_begin++, "can-control");
  return property_id_begin - 1;
}


inline static void
clapper_enhancer_mpris_media_player2_player_signal_marshal_seeked (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__INT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_player_method_marshal_next (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_player_method_marshal_previous (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_player_method_marshal_pause (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_player_method_marshal_play_pause (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_player_method_marshal_stop (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_player_method_marshal_play (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_player_method_marshal_seek (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_player_method_marshal_set_position (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_INT64 (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_player_method_marshal_open_uri (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * ClapperEnhancerMprisMediaPlayer2Player:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>.
 */

/**
 * ClapperEnhancerMprisMediaPlayer2PlayerIface:
 * @parent_iface: The parent interface.
 * @handle_next: Handler for the #ClapperEnhancerMprisMediaPlayer2Player::handle-next signal.
 * @handle_open_uri: Handler for the #ClapperEnhancerMprisMediaPlayer2Player::handle-open-uri signal.
 * @handle_pause: Handler for the #ClapperEnhancerMprisMediaPlayer2Player::handle-pause signal.
 * @handle_play: Handler for the #ClapperEnhancerMprisMediaPlayer2Player::handle-play signal.
 * @handle_play_pause: Handler for the #ClapperEnhancerMprisMediaPlayer2Player::handle-play-pause signal.
 * @handle_previous: Handler for the #ClapperEnhancerMprisMediaPlayer2Player::handle-previous signal.
 * @handle_seek: Handler for the #ClapperEnhancerMprisMediaPlayer2Player::handle-seek signal.
 * @handle_set_position: Handler for the #ClapperEnhancerMprisMediaPlayer2Player::handle-set-position signal.
 * @handle_stop: Handler for the #ClapperEnhancerMprisMediaPlayer2Player::handle-stop signal.
 * @get_can_control: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:can-control property.
 * @get_can_go_next: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:can-go-next property.
 * @get_can_go_previous: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:can-go-previous property.
 * @get_can_pause: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:can-pause property.
 * @get_can_play: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:can-play property.
 * @get_can_seek: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:can-seek property.
 * @get_loop_status: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:loop-status property.
 * @get_maximum_rate: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:maximum-rate property.
 * @get_metadata: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:metadata property.
 * @get_minimum_rate: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:minimum-rate property.
 * @get_playback_status: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:playback-status property.
 * @get_position: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:position property.
 * @get_rate: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:rate property.
 * @get_shuffle: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:shuffle property.
 * @get_volume: Getter for the #ClapperEnhancerMprisMediaPlayer2Player:volume property.
 * @seeked: Handler for the #ClapperEnhancerMprisMediaPlayer2Player::seeked signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>.
 */

typedef ClapperEnhancerMprisMediaPlayer2PlayerIface ClapperEnhancerMprisMediaPlayer2PlayerInterface;
G_DEFINE_INTERFACE (ClapperEnhancerMprisMediaPlayer2Player, clapper_enhancer_mpris_media_player2_player, G_TYPE_OBJECT)

static void
clapper_enhancer_mpris_media_player2_player_default_init (ClapperEnhancerMprisMediaPlayer2PlayerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * ClapperEnhancerMprisMediaPlayer2Player::handle-next:
   * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_player_complete_next() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-next",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2PlayerIface, handle_next),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_player_method_marshal_next,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ClapperEnhancerMprisMediaPlayer2Player::handle-previous:
   * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_player_complete_previous() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-previous",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2PlayerIface, handle_previous),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_player_method_marshal_previous,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ClapperEnhancerMprisMediaPlayer2Player::handle-pause:
   * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_player_complete_pause() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pause",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2PlayerIface, handle_pause),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_player_method_marshal_pause,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ClapperEnhancerMprisMediaPlayer2Player::handle-play-pause:
   * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_player_complete_play_pause() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-play-pause",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2PlayerIface, handle_play_pause),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_player_method_marshal_play_pause,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ClapperEnhancerMprisMediaPlayer2Player::handle-stop:
   * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_player_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2PlayerIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_player_method_marshal_stop,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ClapperEnhancerMprisMediaPlayer2Player::handle-play:
   * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_player_complete_play() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-play",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2PlayerIface, handle_play),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_player_method_marshal_play,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ClapperEnhancerMprisMediaPlayer2Player::handle-seek:
   * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_Offset: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_player_complete_seek() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-seek",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2PlayerIface, handle_seek),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_player_method_marshal_seek,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT64);

  /**
   * ClapperEnhancerMprisMediaPlayer2Player::handle-set-position:
   * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_TrackId: Argument passed by remote caller.
   * @arg_Position: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_player_complete_set_position() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-position",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2PlayerIface, handle_set_position),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_player_method_marshal_set_position,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_INT64);

  /**
   * ClapperEnhancerMprisMediaPlayer2Player::handle-open-uri:
   * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_Uri: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.OpenUri">OpenUri()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_player_complete_open_uri() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-uri",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2PlayerIface, handle_open_uri),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_player_method_marshal_open_uri,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * ClapperEnhancerMprisMediaPlayer2Player::seeked:
   * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
   * @arg_Position: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-mpris-MediaPlayer2-Player.Seeked">"Seeked"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_PLAYER_SIGNALS[CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_PLAYER_SEEKED] =
    g_signal_new ("seeked",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2PlayerIface, seeked),
      NULL,
      NULL,
      clapper_enhancer_mpris_media_player2_player_signal_marshal_seeked,
      G_TYPE_NONE,
      1, G_TYPE_INT64);

  /* GObject properties for D-Bus properties: */
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:playback-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("playback-status", "PlaybackStatus", "PlaybackStatus", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:loop-status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.LoopStatus">"LoopStatus"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("loop-status", "LoopStatus", "LoopStatus", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:rate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Rate">"Rate"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("rate", "Rate", "Rate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:shuffle:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Shuffle">"Shuffle"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("shuffle", "Shuffle", "Shuffle", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:metadata:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("metadata", "Metadata", "Metadata", G_VARIANT_TYPE ("a{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:volume:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Volume">"Volume"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("volume", "Volume", "Volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:position:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Position">"Position"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int64 ("position", "Position", "Position", G_MININT64, G_MAXINT64, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:minimum-rate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MinimumRate">"MinimumRate"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("minimum-rate", "MinimumRate", "MinimumRate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:maximum-rate:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MaximumRate">"MaximumRate"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_double ("maximum-rate", "MaximumRate", "MaximumRate", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:can-go-next:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoNext">"CanGoNext"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-go-next", "CanGoNext", "CanGoNext", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:can-go-previous:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoPrevious">"CanGoPrevious"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-go-previous", "CanGoPrevious", "CanGoPrevious", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:can-play:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPlay">"CanPlay"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-play", "CanPlay", "CanPlay", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:can-pause:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPause">"CanPause"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-pause", "CanPause", "CanPause", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:can-seek:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanSeek">"CanSeek"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-seek", "CanSeek", "CanSeek", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2Player:can-control:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanControl">"CanControl"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-control", "CanControl", "CanControl", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_playback_status: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use clapper_enhancer_mpris_media_player2_player_dup_playback_status() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
clapper_enhancer_mpris_media_player2_player_get_playback_status (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), NULL);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_playback_status (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_dup_playback_status: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
clapper_enhancer_mpris_media_player2_player_dup_playback_status (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "playback-status", &value, NULL);
  return value;
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_playback_status: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.PlaybackStatus">"PlaybackStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_playback_status (ClapperEnhancerMprisMediaPlayer2Player *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "playback-status", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_loop_status: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.LoopStatus">"LoopStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use clapper_enhancer_mpris_media_player2_player_dup_loop_status() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
clapper_enhancer_mpris_media_player2_player_get_loop_status (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), NULL);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_loop_status (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_dup_loop_status: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.LoopStatus">"LoopStatus"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
clapper_enhancer_mpris_media_player2_player_dup_loop_status (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "loop-status", &value, NULL);
  return value;
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_loop_status: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.LoopStatus">"LoopStatus"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_loop_status (ClapperEnhancerMprisMediaPlayer2Player *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "loop-status", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_rate: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Rate">"Rate"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
clapper_enhancer_mpris_media_player2_player_get_rate (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), 0.0);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_rate (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_rate: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Rate">"Rate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_rate (ClapperEnhancerMprisMediaPlayer2Player *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "rate", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_shuffle: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Shuffle">"Shuffle"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
clapper_enhancer_mpris_media_player2_player_get_shuffle (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), FALSE);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_shuffle (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_shuffle: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Shuffle">"Shuffle"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_shuffle (ClapperEnhancerMprisMediaPlayer2Player *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "shuffle", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_metadata: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use clapper_enhancer_mpris_media_player2_player_dup_metadata() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
clapper_enhancer_mpris_media_player2_player_get_metadata (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), NULL);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_metadata (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_dup_metadata: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
clapper_enhancer_mpris_media_player2_player_dup_metadata (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "metadata", &value, NULL);
  return value;
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_metadata: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Metadata">"Metadata"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_metadata (ClapperEnhancerMprisMediaPlayer2Player *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "metadata", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_volume: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Volume">"Volume"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
clapper_enhancer_mpris_media_player2_player_get_volume (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), 0.0);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_volume (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_volume: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Volume">"Volume"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_volume (ClapperEnhancerMprisMediaPlayer2Player *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "volume", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_position: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Position">"Position"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint64 
clapper_enhancer_mpris_media_player2_player_get_position (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), 0);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_position (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_position: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.Position">"Position"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_position (ClapperEnhancerMprisMediaPlayer2Player *object, gint64 value)
{
  g_object_set (G_OBJECT (object), "position", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_minimum_rate: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MinimumRate">"MinimumRate"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
clapper_enhancer_mpris_media_player2_player_get_minimum_rate (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), 0.0);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_minimum_rate (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_minimum_rate: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MinimumRate">"MinimumRate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_minimum_rate (ClapperEnhancerMprisMediaPlayer2Player *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "minimum-rate", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_maximum_rate: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MaximumRate">"MaximumRate"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gdouble 
clapper_enhancer_mpris_media_player2_player_get_maximum_rate (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), 0.0);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_maximum_rate (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_maximum_rate: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.MaximumRate">"MaximumRate"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_maximum_rate (ClapperEnhancerMprisMediaPlayer2Player *object, gdouble value)
{
  g_object_set (G_OBJECT (object), "maximum-rate", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_can_go_next: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoNext">"CanGoNext"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
clapper_enhancer_mpris_media_player2_player_get_can_go_next (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), FALSE);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_can_go_next (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_can_go_next: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoNext">"CanGoNext"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_can_go_next (ClapperEnhancerMprisMediaPlayer2Player *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-go-next", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_can_go_previous: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoPrevious">"CanGoPrevious"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
clapper_enhancer_mpris_media_player2_player_get_can_go_previous (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), FALSE);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_can_go_previous (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_can_go_previous: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanGoPrevious">"CanGoPrevious"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_can_go_previous (ClapperEnhancerMprisMediaPlayer2Player *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-go-previous", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_can_play: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPlay">"CanPlay"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
clapper_enhancer_mpris_media_player2_player_get_can_play (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), FALSE);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_can_play (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_can_play: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPlay">"CanPlay"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_can_play (ClapperEnhancerMprisMediaPlayer2Player *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-play", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_can_pause: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPause">"CanPause"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
clapper_enhancer_mpris_media_player2_player_get_can_pause (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), FALSE);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_can_pause (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_can_pause: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanPause">"CanPause"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_can_pause (ClapperEnhancerMprisMediaPlayer2Player *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-pause", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_can_seek: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanSeek">"CanSeek"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
clapper_enhancer_mpris_media_player2_player_get_can_seek (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), FALSE);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_can_seek (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_can_seek: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanSeek">"CanSeek"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_can_seek (ClapperEnhancerMprisMediaPlayer2Player *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-seek", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_get_can_control: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanControl">"CanControl"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
clapper_enhancer_mpris_media_player2_player_get_can_control (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_PLAYER (object), FALSE);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_GET_IFACE (object)->get_can_control (object);
}

/**
 * clapper_enhancer_mpris_media_player2_player_set_can_control: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-Player.CanControl">"CanControl"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_player_set_can_control (ClapperEnhancerMprisMediaPlayer2Player *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-control", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_emit_seeked:
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @arg_Position: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-mpris-MediaPlayer2-Player.Seeked">"Seeked"</link> D-Bus signal.
 */
void
clapper_enhancer_mpris_media_player2_player_emit_seeked (
    ClapperEnhancerMprisMediaPlayer2Player *object,
    gint64 arg_Position)
{
  g_signal_emit (object, CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_PLAYER_SIGNALS[CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_PLAYER_SEEKED], 0, arg_Position);
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_next:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_player_call_next_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_next_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_player_call_next (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Next",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_next_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_player_call_next().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_player_call_next().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_next_finish (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_next_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_next() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_next_sync (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Next",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_previous:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_player_call_previous_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_previous_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_player_call_previous (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Previous",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_previous_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_player_call_previous().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_player_call_previous().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_previous_finish (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_previous_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_previous() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_previous_sync (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Previous",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_pause:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_player_call_pause_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_pause_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_player_call_pause (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_pause_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_player_call_pause().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_player_call_pause().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_pause_finish (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_pause_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_pause() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_pause_sync (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_play_pause:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_player_call_play_pause_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_play_pause_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_player_call_play_pause (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PlayPause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_play_pause_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_player_call_play_pause().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_player_call_play_pause().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_play_pause_finish (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_play_pause_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_play_pause() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_play_pause_sync (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PlayPause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_stop:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_player_call_stop_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_player_call_stop (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_stop_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_player_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_player_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_stop_finish (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_stop_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_stop_sync (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_play:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_player_call_play_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_play_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_player_call_play (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Play",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_play_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_player_call_play().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_player_call_play().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_play_finish (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_play_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_play() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_play_sync (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Play",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_seek:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @arg_Offset: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_player_call_seek_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_seek_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_player_call_seek (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    gint64 arg_Offset,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Seek",
    g_variant_new ("(x)",
                   arg_Offset),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_seek_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_player_call_seek().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_player_call_seek().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_seek_finish (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_seek_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @arg_Offset: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_seek() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_seek_sync (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    gint64 arg_Offset,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Seek",
    g_variant_new ("(x)",
                   arg_Offset),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_set_position:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @arg_TrackId: Argument to pass with the method invocation.
 * @arg_Position: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_player_call_set_position_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_set_position_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_player_call_set_position (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    const gchar *arg_TrackId,
    gint64 arg_Position,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetPosition",
    g_variant_new ("(ox)",
                   arg_TrackId,
                   arg_Position),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_set_position_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_player_call_set_position().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_player_call_set_position().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_set_position_finish (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_set_position_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @arg_TrackId: Argument to pass with the method invocation.
 * @arg_Position: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_set_position() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_set_position_sync (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    const gchar *arg_TrackId,
    gint64 arg_Position,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetPosition",
    g_variant_new ("(ox)",
                   arg_TrackId,
                   arg_Position),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_open_uri:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @arg_Uri: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.OpenUri">OpenUri()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_player_call_open_uri_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_open_uri_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_player_call_open_uri (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    const gchar *arg_Uri,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "OpenUri",
    g_variant_new ("(s)",
                   arg_Uri),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_open_uri_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_player_call_open_uri().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_player_call_open_uri().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_open_uri_finish (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_call_open_uri_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 * @arg_Uri: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.OpenUri">OpenUri()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_player_call_open_uri() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_player_call_open_uri_sync (
    ClapperEnhancerMprisMediaPlayer2Player *proxy,
    const gchar *arg_Uri,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "OpenUri",
    g_variant_new ("(s)",
                   arg_Uri),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_complete_next:
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Next">Next()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_player_complete_next (
    ClapperEnhancerMprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * clapper_enhancer_mpris_media_player2_player_complete_previous:
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Previous">Previous()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_player_complete_previous (
    ClapperEnhancerMprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * clapper_enhancer_mpris_media_player2_player_complete_pause:
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Pause">Pause()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_player_complete_pause (
    ClapperEnhancerMprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * clapper_enhancer_mpris_media_player2_player_complete_play_pause:
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.PlayPause">PlayPause()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_player_complete_play_pause (
    ClapperEnhancerMprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * clapper_enhancer_mpris_media_player2_player_complete_stop:
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_player_complete_stop (
    ClapperEnhancerMprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * clapper_enhancer_mpris_media_player2_player_complete_play:
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Play">Play()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_player_complete_play (
    ClapperEnhancerMprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * clapper_enhancer_mpris_media_player2_player_complete_seek:
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.Seek">Seek()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_player_complete_seek (
    ClapperEnhancerMprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * clapper_enhancer_mpris_media_player2_player_complete_set_position:
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.SetPosition">SetPosition()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_player_complete_set_position (
    ClapperEnhancerMprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * clapper_enhancer_mpris_media_player2_player_complete_open_uri:
 * @object: A #ClapperEnhancerMprisMediaPlayer2Player.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-Player.OpenUri">OpenUri()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_player_complete_open_uri (
    ClapperEnhancerMprisMediaPlayer2Player *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * ClapperEnhancerMprisMediaPlayer2PlayerProxy:
 *
 * The #ClapperEnhancerMprisMediaPlayer2PlayerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ClapperEnhancerMprisMediaPlayer2PlayerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ClapperEnhancerMprisMediaPlayer2PlayerProxy.
 */

struct _ClapperEnhancerMprisMediaPlayer2PlayerProxyPrivate
{
  GData *qdata;
};

static void clapper_enhancer_mpris_media_player2_player_proxy_iface_init (ClapperEnhancerMprisMediaPlayer2PlayerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ClapperEnhancerMprisMediaPlayer2PlayerProxy, clapper_enhancer_mpris_media_player2_player_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (ClapperEnhancerMprisMediaPlayer2PlayerProxy)
                         G_IMPLEMENT_INTERFACE (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER, clapper_enhancer_mpris_media_player2_player_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ClapperEnhancerMprisMediaPlayer2PlayerProxy, clapper_enhancer_mpris_media_player2_player_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER, clapper_enhancer_mpris_media_player2_player_proxy_iface_init))

#endif
static void
clapper_enhancer_mpris_media_player2_player_proxy_finalize (GObject *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (clapper_enhancer_mpris_media_player2_player_proxy_parent_class)->finalize (object);
}

static void
clapper_enhancer_mpris_media_player2_player_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 15);
  info = (const _ExtendedGDBusPropertyInfo *) _clapper_enhancer_mpris_media_player2_player_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
clapper_enhancer_mpris_media_player2_player_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.mpris.MediaPlayer2.Player: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
clapper_enhancer_mpris_media_player2_player_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 15);
  info = (const _ExtendedGDBusPropertyInfo *) _clapper_enhancer_mpris_media_player2_player_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.mpris.MediaPlayer2.Player", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) clapper_enhancer_mpris_media_player2_player_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
clapper_enhancer_mpris_media_player2_player_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_player_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
clapper_enhancer_mpris_media_player2_player_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_player_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_player_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
clapper_enhancer_mpris_media_player2_player_proxy_get_playback_status (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PlaybackStatus");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
clapper_enhancer_mpris_media_player2_player_proxy_get_loop_status (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoopStatus");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
clapper_enhancer_mpris_media_player2_player_proxy_get_rate (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Rate");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_player_proxy_get_shuffle (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Shuffle");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
clapper_enhancer_mpris_media_player2_player_proxy_get_metadata (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Metadata");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static gdouble 
clapper_enhancer_mpris_media_player2_player_proxy_get_volume (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Volume");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gint64 
clapper_enhancer_mpris_media_player2_player_proxy_get_position (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gint64 value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Position");
  if (variant != NULL)
    {
      value = g_variant_get_int64 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
clapper_enhancer_mpris_media_player2_player_proxy_get_minimum_rate (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MinimumRate");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gdouble 
clapper_enhancer_mpris_media_player2_player_proxy_get_maximum_rate (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gdouble value = 0.0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "MaximumRate");
  if (variant != NULL)
    {
      value = g_variant_get_double (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_player_proxy_get_can_go_next (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanGoNext");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_player_proxy_get_can_go_previous (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanGoPrevious");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_player_proxy_get_can_play (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanPlay");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_player_proxy_get_can_pause (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanPause");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_player_proxy_get_can_seek (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanSeek");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_player_proxy_get_can_control (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanControl");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
clapper_enhancer_mpris_media_player2_player_proxy_init (ClapperEnhancerMprisMediaPlayer2PlayerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = clapper_enhancer_mpris_media_player2_player_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER_PROXY, ClapperEnhancerMprisMediaPlayer2PlayerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), clapper_enhancer_mpris_media_player2_player_interface_info ());
}

static void
clapper_enhancer_mpris_media_player2_player_proxy_class_init (ClapperEnhancerMprisMediaPlayer2PlayerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = clapper_enhancer_mpris_media_player2_player_proxy_finalize;
  gobject_class->get_property = clapper_enhancer_mpris_media_player2_player_proxy_get_property;
  gobject_class->set_property = clapper_enhancer_mpris_media_player2_player_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = clapper_enhancer_mpris_media_player2_player_proxy_g_signal;
  proxy_class->g_properties_changed = clapper_enhancer_mpris_media_player2_player_proxy_g_properties_changed;

  clapper_enhancer_mpris_media_player2_player_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ClapperEnhancerMprisMediaPlayer2PlayerProxyPrivate));
#endif
}

static void
clapper_enhancer_mpris_media_player2_player_proxy_iface_init (ClapperEnhancerMprisMediaPlayer2PlayerIface *iface)
{
  iface->get_playback_status = clapper_enhancer_mpris_media_player2_player_proxy_get_playback_status;
  iface->get_loop_status = clapper_enhancer_mpris_media_player2_player_proxy_get_loop_status;
  iface->get_rate = clapper_enhancer_mpris_media_player2_player_proxy_get_rate;
  iface->get_shuffle = clapper_enhancer_mpris_media_player2_player_proxy_get_shuffle;
  iface->get_metadata = clapper_enhancer_mpris_media_player2_player_proxy_get_metadata;
  iface->get_volume = clapper_enhancer_mpris_media_player2_player_proxy_get_volume;
  iface->get_position = clapper_enhancer_mpris_media_player2_player_proxy_get_position;
  iface->get_minimum_rate = clapper_enhancer_mpris_media_player2_player_proxy_get_minimum_rate;
  iface->get_maximum_rate = clapper_enhancer_mpris_media_player2_player_proxy_get_maximum_rate;
  iface->get_can_go_next = clapper_enhancer_mpris_media_player2_player_proxy_get_can_go_next;
  iface->get_can_go_previous = clapper_enhancer_mpris_media_player2_player_proxy_get_can_go_previous;
  iface->get_can_play = clapper_enhancer_mpris_media_player2_player_proxy_get_can_play;
  iface->get_can_pause = clapper_enhancer_mpris_media_player2_player_proxy_get_can_pause;
  iface->get_can_seek = clapper_enhancer_mpris_media_player2_player_proxy_get_can_seek;
  iface->get_can_control = clapper_enhancer_mpris_media_player2_player_proxy_get_can_control;
}

/**
 * clapper_enhancer_mpris_media_player2_player_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_player_proxy_new_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_player_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
clapper_enhancer_mpris_media_player2_player_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_player_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_player_proxy_new().
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2PlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
ClapperEnhancerMprisMediaPlayer2Player *
clapper_enhancer_mpris_media_player2_player_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER (ret);
  else
    return NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_player_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2PlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
ClapperEnhancerMprisMediaPlayer2Player *
clapper_enhancer_mpris_media_player2_player_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
  if (ret != NULL)
    return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER (ret);
  else
    return NULL;
}


/**
 * clapper_enhancer_mpris_media_player2_player_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like clapper_enhancer_mpris_media_player2_player_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_player_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_player_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
clapper_enhancer_mpris_media_player2_player_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_player_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_player_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_player_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2PlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
ClapperEnhancerMprisMediaPlayer2Player *
clapper_enhancer_mpris_media_player2_player_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER (ret);
  else
    return NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_player_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like clapper_enhancer_mpris_media_player2_player_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_player_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2PlayerProxy): The constructed proxy object or %NULL if @error is set.
 */
ClapperEnhancerMprisMediaPlayer2Player *
clapper_enhancer_mpris_media_player2_player_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.Player", NULL);
  if (ret != NULL)
    return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * ClapperEnhancerMprisMediaPlayer2PlayerSkeleton:
 *
 * The #ClapperEnhancerMprisMediaPlayer2PlayerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ClapperEnhancerMprisMediaPlayer2PlayerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ClapperEnhancerMprisMediaPlayer2PlayerSkeleton.
 */

struct _ClapperEnhancerMprisMediaPlayer2PlayerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_clapper_enhancer_mpris_media_player2_player_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_clapper_enhancer_mpris_media_player2_player_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_player_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_clapper_enhancer_mpris_media_player2_player_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_player_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _clapper_enhancer_mpris_media_player2_player_skeleton_vtable =
{
  _clapper_enhancer_mpris_media_player2_player_skeleton_handle_method_call,
  _clapper_enhancer_mpris_media_player2_player_skeleton_handle_get_property,
  _clapper_enhancer_mpris_media_player2_player_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
clapper_enhancer_mpris_media_player2_player_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return clapper_enhancer_mpris_media_player2_player_interface_info ();
}

static GDBusInterfaceVTable *
clapper_enhancer_mpris_media_player2_player_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_clapper_enhancer_mpris_media_player2_player_skeleton_vtable;
}

static GVariant *
clapper_enhancer_mpris_media_player2_player_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_clapper_enhancer_mpris_media_player2_player_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _clapper_enhancer_mpris_media_player2_player_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _clapper_enhancer_mpris_media_player2_player_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _clapper_enhancer_mpris_media_player2_player_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mpris.MediaPlayer2.Player", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _clapper_enhancer_mpris_media_player2_player_emit_changed (gpointer user_data);

static void
clapper_enhancer_mpris_media_player2_player_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _clapper_enhancer_mpris_media_player2_player_emit_changed (skeleton);
}

static void
_clapper_enhancer_mpris_media_player2_player_on_signal_seeked (
    ClapperEnhancerMprisMediaPlayer2Player *object,
    gint64 arg_Position)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(x)",
                   arg_Position));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mpris.MediaPlayer2.Player", "Seeked",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void clapper_enhancer_mpris_media_player2_player_skeleton_iface_init (ClapperEnhancerMprisMediaPlayer2PlayerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ClapperEnhancerMprisMediaPlayer2PlayerSkeleton, clapper_enhancer_mpris_media_player2_player_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (ClapperEnhancerMprisMediaPlayer2PlayerSkeleton)
                         G_IMPLEMENT_INTERFACE (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER, clapper_enhancer_mpris_media_player2_player_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ClapperEnhancerMprisMediaPlayer2PlayerSkeleton, clapper_enhancer_mpris_media_player2_player_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER, clapper_enhancer_mpris_media_player2_player_skeleton_iface_init))

#endif
static void
clapper_enhancer_mpris_media_player2_player_skeleton_finalize (GObject *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  guint n;
  for (n = 0; n < 15; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (clapper_enhancer_mpris_media_player2_player_skeleton_parent_class)->finalize (object);
}

static void
clapper_enhancer_mpris_media_player2_player_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 15);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_clapper_enhancer_mpris_media_player2_player_emit_changed (gpointer user_data)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.mpris.MediaPlayer2.Player",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_clapper_enhancer_mpris_media_player2_player_schedule_emit_changed (ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
clapper_enhancer_mpris_media_player2_player_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _clapper_enhancer_mpris_media_player2_player_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _clapper_enhancer_mpris_media_player2_player_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
clapper_enhancer_mpris_media_player2_player_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 15);
  info = (const _ExtendedGDBusPropertyInfo *) _clapper_enhancer_mpris_media_player2_player_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _clapper_enhancer_mpris_media_player2_player_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
clapper_enhancer_mpris_media_player2_player_skeleton_init (ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = clapper_enhancer_mpris_media_player2_player_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER_SKELETON, ClapperEnhancerMprisMediaPlayer2PlayerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 15);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_INT64);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_DOUBLE);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[10], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[11], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[12], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[13], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[14], G_TYPE_BOOLEAN);
}

static const gchar *
clapper_enhancer_mpris_media_player2_player_skeleton_get_playback_status (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
clapper_enhancer_mpris_media_player2_player_skeleton_get_loop_status (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
clapper_enhancer_mpris_media_player2_player_skeleton_get_rate (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_player_skeleton_get_shuffle (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
clapper_enhancer_mpris_media_player2_player_skeleton_get_metadata (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_variant (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
clapper_enhancer_mpris_media_player2_player_skeleton_get_volume (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint64 
clapper_enhancer_mpris_media_player2_player_skeleton_get_position (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gint64 value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_int64 (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
clapper_enhancer_mpris_media_player2_player_skeleton_get_minimum_rate (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gdouble 
clapper_enhancer_mpris_media_player2_player_skeleton_get_maximum_rate (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gdouble value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_double (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_player_skeleton_get_can_go_next (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_player_skeleton_get_can_go_previous (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[10]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_player_skeleton_get_can_play (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[11]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_player_skeleton_get_can_pause (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[12]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_player_skeleton_get_can_seek (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[13]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_player_skeleton_get_can_control (ClapperEnhancerMprisMediaPlayer2Player *object)
{
  ClapperEnhancerMprisMediaPlayer2PlayerSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[14]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
clapper_enhancer_mpris_media_player2_player_skeleton_class_init (ClapperEnhancerMprisMediaPlayer2PlayerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = clapper_enhancer_mpris_media_player2_player_skeleton_finalize;
  gobject_class->get_property = clapper_enhancer_mpris_media_player2_player_skeleton_get_property;
  gobject_class->set_property = clapper_enhancer_mpris_media_player2_player_skeleton_set_property;
  gobject_class->notify       = clapper_enhancer_mpris_media_player2_player_skeleton_notify;


  clapper_enhancer_mpris_media_player2_player_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = clapper_enhancer_mpris_media_player2_player_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = clapper_enhancer_mpris_media_player2_player_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = clapper_enhancer_mpris_media_player2_player_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = clapper_enhancer_mpris_media_player2_player_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ClapperEnhancerMprisMediaPlayer2PlayerSkeletonPrivate));
#endif
}

static void
clapper_enhancer_mpris_media_player2_player_skeleton_iface_init (ClapperEnhancerMprisMediaPlayer2PlayerIface *iface)
{
  iface->seeked = _clapper_enhancer_mpris_media_player2_player_on_signal_seeked;
  iface->get_playback_status = clapper_enhancer_mpris_media_player2_player_skeleton_get_playback_status;
  iface->get_loop_status = clapper_enhancer_mpris_media_player2_player_skeleton_get_loop_status;
  iface->get_rate = clapper_enhancer_mpris_media_player2_player_skeleton_get_rate;
  iface->get_shuffle = clapper_enhancer_mpris_media_player2_player_skeleton_get_shuffle;
  iface->get_metadata = clapper_enhancer_mpris_media_player2_player_skeleton_get_metadata;
  iface->get_volume = clapper_enhancer_mpris_media_player2_player_skeleton_get_volume;
  iface->get_position = clapper_enhancer_mpris_media_player2_player_skeleton_get_position;
  iface->get_minimum_rate = clapper_enhancer_mpris_media_player2_player_skeleton_get_minimum_rate;
  iface->get_maximum_rate = clapper_enhancer_mpris_media_player2_player_skeleton_get_maximum_rate;
  iface->get_can_go_next = clapper_enhancer_mpris_media_player2_player_skeleton_get_can_go_next;
  iface->get_can_go_previous = clapper_enhancer_mpris_media_player2_player_skeleton_get_can_go_previous;
  iface->get_can_play = clapper_enhancer_mpris_media_player2_player_skeleton_get_can_play;
  iface->get_can_pause = clapper_enhancer_mpris_media_player2_player_skeleton_get_can_pause;
  iface->get_can_seek = clapper_enhancer_mpris_media_player2_player_skeleton_get_can_seek;
  iface->get_can_control = clapper_enhancer_mpris_media_player2_player_skeleton_get_can_control;
}

/**
 * clapper_enhancer_mpris_media_player2_player_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-Player.top_of_page">org.mpris.MediaPlayer2.Player</link>.
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2PlayerSkeleton): The skeleton object.
 */
ClapperEnhancerMprisMediaPlayer2Player *
clapper_enhancer_mpris_media_player2_player_skeleton_new (void)
{
  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_PLAYER (g_object_new (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_PLAYER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.mpris.MediaPlayer2.TrackList
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:ClapperEnhancerMprisMediaPlayer2TrackList
 * @title: ClapperEnhancerMprisMediaPlayer2TrackList
 * @short_description: Generated C code for the org.mpris.MediaPlayer2.TrackList D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-mpris-MediaPlayer2-TrackList.top_of_page">org.mpris.MediaPlayer2.TrackList</link> D-Bus interface in C.
 */

enum
{
  CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_TRACK_LIST_REPLACED,
  CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_TRACK_ADDED,
  CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_TRACK_REMOVED,
  CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_TRACK_METADATA_CHANGED,
};

static unsigned CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_SIGNALS[4] = { 0 };

/* ---- Introspection data for org.mpris.MediaPlayer2.TrackList ---- */

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_track_list_method_info_get_tracks_metadata_IN_ARG_TrackIds =
{
  {
    -1,
    (gchar *) "TrackIds",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _clapper_enhancer_mpris_media_player2_track_list_method_info_get_tracks_metadata_IN_ARG_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_track_list_method_info_get_tracks_metadata_IN_ARG_TrackIds.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_track_list_method_info_get_tracks_metadata_OUT_ARG_Metadata =
{
  {
    -1,
    (gchar *) "Metadata",
    (gchar *) "aa{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _clapper_enhancer_mpris_media_player2_track_list_method_info_get_tracks_metadata_OUT_ARG_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_track_list_method_info_get_tracks_metadata_OUT_ARG_Metadata.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_track_list_method_info_get_tracks_metadata =
{
  {
    -1,
    (gchar *) "GetTracksMetadata",
    (GDBusArgInfo **) &_clapper_enhancer_mpris_media_player2_track_list_method_info_get_tracks_metadata_IN_ARG_pointers,
    (GDBusArgInfo **) &_clapper_enhancer_mpris_media_player2_track_list_method_info_get_tracks_metadata_OUT_ARG_pointers,
    NULL
  },
  "handle-get-tracks-metadata",
  FALSE
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_track_list_method_info_add_track_IN_ARG_Uri =
{
  {
    -1,
    (gchar *) "Uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_track_list_method_info_add_track_IN_ARG_AfterTrack =
{
  {
    -1,
    (gchar *) "AfterTrack",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_track_list_method_info_add_track_IN_ARG_SetAsCurrent =
{
  {
    -1,
    (gchar *) "SetAsCurrent",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _clapper_enhancer_mpris_media_player2_track_list_method_info_add_track_IN_ARG_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_track_list_method_info_add_track_IN_ARG_Uri.parent_struct,
  &_clapper_enhancer_mpris_media_player2_track_list_method_info_add_track_IN_ARG_AfterTrack.parent_struct,
  &_clapper_enhancer_mpris_media_player2_track_list_method_info_add_track_IN_ARG_SetAsCurrent.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_track_list_method_info_add_track =
{
  {
    -1,
    (gchar *) "AddTrack",
    (GDBusArgInfo **) &_clapper_enhancer_mpris_media_player2_track_list_method_info_add_track_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-add-track",
  FALSE
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_track_list_method_info_remove_track_IN_ARG_TrackId =
{
  {
    -1,
    (gchar *) "TrackId",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _clapper_enhancer_mpris_media_player2_track_list_method_info_remove_track_IN_ARG_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_track_list_method_info_remove_track_IN_ARG_TrackId.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_track_list_method_info_remove_track =
{
  {
    -1,
    (gchar *) "RemoveTrack",
    (GDBusArgInfo **) &_clapper_enhancer_mpris_media_player2_track_list_method_info_remove_track_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-remove-track",
  FALSE
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_track_list_method_info_go_to_IN_ARG_TrackId =
{
  {
    -1,
    (gchar *) "TrackId",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _clapper_enhancer_mpris_media_player2_track_list_method_info_go_to_IN_ARG_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_track_list_method_info_go_to_IN_ARG_TrackId.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _clapper_enhancer_mpris_media_player2_track_list_method_info_go_to =
{
  {
    -1,
    (gchar *) "GoTo",
    (GDBusArgInfo **) &_clapper_enhancer_mpris_media_player2_track_list_method_info_go_to_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-go-to",
  FALSE
};

static const GDBusMethodInfo * const _clapper_enhancer_mpris_media_player2_track_list_method_info_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_track_list_method_info_get_tracks_metadata.parent_struct,
  &_clapper_enhancer_mpris_media_player2_track_list_method_info_add_track.parent_struct,
  &_clapper_enhancer_mpris_media_player2_track_list_method_info_remove_track.parent_struct,
  &_clapper_enhancer_mpris_media_player2_track_list_method_info_go_to.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_list_replaced_ARG_Tracks =
{
  {
    -1,
    (gchar *) "Tracks",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_list_replaced_ARG_CurrentTrack =
{
  {
    -1,
    (gchar *) "CurrentTrack",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_list_replaced_ARG_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_list_replaced_ARG_Tracks.parent_struct,
  &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_list_replaced_ARG_CurrentTrack.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_list_replaced =
{
  {
    -1,
    (gchar *) "TrackListReplaced",
    (GDBusArgInfo **) &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_list_replaced_ARG_pointers,
    NULL
  },
  "track-list-replaced"
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_added_ARG_Metadata =
{
  {
    -1,
    (gchar *) "Metadata",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_added_ARG_AfterTrack =
{
  {
    -1,
    (gchar *) "AfterTrack",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_added_ARG_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_added_ARG_Metadata.parent_struct,
  &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_added_ARG_AfterTrack.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_added =
{
  {
    -1,
    (gchar *) "TrackAdded",
    (GDBusArgInfo **) &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_added_ARG_pointers,
    NULL
  },
  "track-added"
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_removed_ARG_TrackId =
{
  {
    -1,
    (gchar *) "TrackId",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_removed_ARG_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_removed_ARG_TrackId.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_removed =
{
  {
    -1,
    (gchar *) "TrackRemoved",
    (GDBusArgInfo **) &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_removed_ARG_pointers,
    NULL
  },
  "track-removed"
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_metadata_changed_ARG_TrackId =
{
  {
    -1,
    (gchar *) "TrackId",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_metadata_changed_ARG_Metadata =
{
  {
    -1,
    (gchar *) "Metadata",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_metadata_changed_ARG_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_metadata_changed_ARG_TrackId.parent_struct,
  &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_metadata_changed_ARG_Metadata.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _clapper_enhancer_mpris_media_player2_track_list_signal_info_track_metadata_changed =
{
  {
    -1,
    (gchar *) "TrackMetadataChanged",
    (GDBusArgInfo **) &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_metadata_changed_ARG_pointers,
    NULL
  },
  "track-metadata-changed"
};

static const GDBusSignalInfo * const _clapper_enhancer_mpris_media_player2_track_list_signal_info_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_list_replaced.parent_struct,
  &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_added.parent_struct,
  &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_removed.parent_struct,
  &_clapper_enhancer_mpris_media_player2_track_list_signal_info_track_metadata_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_track_list_property_info_tracks =
{
  {
    -1,
    (gchar *) "Tracks",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "tracks",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _clapper_enhancer_mpris_media_player2_track_list_property_info_can_edit_tracks =
{
  {
    -1,
    (gchar *) "CanEditTracks",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "can-edit-tracks",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _clapper_enhancer_mpris_media_player2_track_list_property_info_pointers[] =
{
  &_clapper_enhancer_mpris_media_player2_track_list_property_info_tracks.parent_struct,
  &_clapper_enhancer_mpris_media_player2_track_list_property_info_can_edit_tracks.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _clapper_enhancer_mpris_media_player2_track_list_interface_info =
{
  {
    -1,
    (gchar *) "org.mpris.MediaPlayer2.TrackList",
    (GDBusMethodInfo **) &_clapper_enhancer_mpris_media_player2_track_list_method_info_pointers,
    (GDBusSignalInfo **) &_clapper_enhancer_mpris_media_player2_track_list_signal_info_pointers,
    (GDBusPropertyInfo **) &_clapper_enhancer_mpris_media_player2_track_list_property_info_pointers,
    NULL
  },
  "media-player2-track-list",
};


/**
 * clapper_enhancer_mpris_media_player2_track_list_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-mpris-MediaPlayer2-TrackList.top_of_page">org.mpris.MediaPlayer2.TrackList</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
clapper_enhancer_mpris_media_player2_track_list_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_track_list_interface_info.parent_struct;
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #ClapperEnhancerMprisMediaPlayer2TrackList interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
clapper_enhancer_mpris_media_player2_track_list_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "tracks");
  g_object_class_override_property (klass, property_id_begin++, "can-edit-tracks");
  return property_id_begin - 1;
}


inline static void
clapper_enhancer_mpris_media_player2_track_list_signal_marshal_track_list_replaced (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__BOXED_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_track_list_signal_marshal_track_added (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__VARIANT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_track_list_signal_marshal_track_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_track_list_signal_marshal_track_metadata_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_track_list_method_marshal_get_tracks_metadata (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_track_list_method_marshal_add_track (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_track_list_method_marshal_remove_track (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
clapper_enhancer_mpris_media_player2_track_list_method_marshal_go_to (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * ClapperEnhancerMprisMediaPlayer2TrackList:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-TrackList.top_of_page">org.mpris.MediaPlayer2.TrackList</link>.
 */

/**
 * ClapperEnhancerMprisMediaPlayer2TrackListIface:
 * @parent_iface: The parent interface.
 * @handle_add_track: Handler for the #ClapperEnhancerMprisMediaPlayer2TrackList::handle-add-track signal.
 * @handle_get_tracks_metadata: Handler for the #ClapperEnhancerMprisMediaPlayer2TrackList::handle-get-tracks-metadata signal.
 * @handle_go_to: Handler for the #ClapperEnhancerMprisMediaPlayer2TrackList::handle-go-to signal.
 * @handle_remove_track: Handler for the #ClapperEnhancerMprisMediaPlayer2TrackList::handle-remove-track signal.
 * @get_can_edit_tracks: Getter for the #ClapperEnhancerMprisMediaPlayer2TrackList:can-edit-tracks property.
 * @get_tracks: Getter for the #ClapperEnhancerMprisMediaPlayer2TrackList:tracks property.
 * @track_added: Handler for the #ClapperEnhancerMprisMediaPlayer2TrackList::track-added signal.
 * @track_list_replaced: Handler for the #ClapperEnhancerMprisMediaPlayer2TrackList::track-list-replaced signal.
 * @track_metadata_changed: Handler for the #ClapperEnhancerMprisMediaPlayer2TrackList::track-metadata-changed signal.
 * @track_removed: Handler for the #ClapperEnhancerMprisMediaPlayer2TrackList::track-removed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-TrackList.top_of_page">org.mpris.MediaPlayer2.TrackList</link>.
 */

typedef ClapperEnhancerMprisMediaPlayer2TrackListIface ClapperEnhancerMprisMediaPlayer2TrackListInterface;
G_DEFINE_INTERFACE (ClapperEnhancerMprisMediaPlayer2TrackList, clapper_enhancer_mpris_media_player2_track_list, G_TYPE_OBJECT)

static void
clapper_enhancer_mpris_media_player2_track_list_default_init (ClapperEnhancerMprisMediaPlayer2TrackListIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * ClapperEnhancerMprisMediaPlayer2TrackList::handle-get-tracks-metadata:
   * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_TrackIds: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.GetTracksMetadata">GetTracksMetadata()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_track_list_complete_get_tracks_metadata() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-tracks-metadata",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2TrackListIface, handle_get_tracks_metadata),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_track_list_method_marshal_get_tracks_metadata,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * ClapperEnhancerMprisMediaPlayer2TrackList::handle-add-track:
   * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_Uri: Argument passed by remote caller.
   * @arg_AfterTrack: Argument passed by remote caller.
   * @arg_SetAsCurrent: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.AddTrack">AddTrack()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_track_list_complete_add_track() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-track",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2TrackListIface, handle_add_track),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_track_list_method_marshal_add_track,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * ClapperEnhancerMprisMediaPlayer2TrackList::handle-remove-track:
   * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_TrackId: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.RemoveTrack">RemoveTrack()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_track_list_complete_remove_track() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-remove-track",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2TrackListIface, handle_remove_track),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_track_list_method_marshal_remove_track,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ClapperEnhancerMprisMediaPlayer2TrackList::handle-go-to:
   * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_TrackId: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.GoTo">GoTo()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call clapper_enhancer_mpris_media_player2_track_list_complete_go_to() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-go-to",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2TrackListIface, handle_go_to),
    g_signal_accumulator_true_handled,
    NULL,
      clapper_enhancer_mpris_media_player2_track_list_method_marshal_go_to,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * ClapperEnhancerMprisMediaPlayer2TrackList::track-list-replaced:
   * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
   * @arg_Tracks: Argument.
   * @arg_CurrentTrack: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-mpris-MediaPlayer2-TrackList.TrackListReplaced">"TrackListReplaced"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_SIGNALS[CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_TRACK_LIST_REPLACED] =
    g_signal_new ("track-list-replaced",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2TrackListIface, track_list_replaced),
      NULL,
      NULL,
      clapper_enhancer_mpris_media_player2_track_list_signal_marshal_track_list_replaced,
      G_TYPE_NONE,
      2, G_TYPE_STRV, G_TYPE_STRING);

  /**
   * ClapperEnhancerMprisMediaPlayer2TrackList::track-added:
   * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
   * @arg_Metadata: Argument.
   * @arg_AfterTrack: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-mpris-MediaPlayer2-TrackList.TrackAdded">"TrackAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_SIGNALS[CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_TRACK_ADDED] =
    g_signal_new ("track-added",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2TrackListIface, track_added),
      NULL,
      NULL,
      clapper_enhancer_mpris_media_player2_track_list_signal_marshal_track_added,
      G_TYPE_NONE,
      2, G_TYPE_VARIANT, G_TYPE_STRING);

  /**
   * ClapperEnhancerMprisMediaPlayer2TrackList::track-removed:
   * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
   * @arg_TrackId: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-mpris-MediaPlayer2-TrackList.TrackRemoved">"TrackRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_SIGNALS[CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_TRACK_REMOVED] =
    g_signal_new ("track-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2TrackListIface, track_removed),
      NULL,
      NULL,
      clapper_enhancer_mpris_media_player2_track_list_signal_marshal_track_removed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * ClapperEnhancerMprisMediaPlayer2TrackList::track-metadata-changed:
   * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
   * @arg_TrackId: Argument.
   * @arg_Metadata: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-mpris-MediaPlayer2-TrackList.TrackMetadataChanged">"TrackMetadataChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_SIGNALS[CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_TRACK_METADATA_CHANGED] =
    g_signal_new ("track-metadata-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (ClapperEnhancerMprisMediaPlayer2TrackListIface, track_metadata_changed),
      NULL,
      NULL,
      clapper_enhancer_mpris_media_player2_track_list_signal_marshal_track_metadata_changed,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * ClapperEnhancerMprisMediaPlayer2TrackList:tracks:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-TrackList.Tracks">"Tracks"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("tracks", "Tracks", "Tracks", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * ClapperEnhancerMprisMediaPlayer2TrackList:can-edit-tracks:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-mpris-MediaPlayer2-TrackList.CanEditTracks">"CanEditTracks"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("can-edit-tracks", "CanEditTracks", "CanEditTracks", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_get_tracks: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-TrackList.Tracks">"Tracks"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use clapper_enhancer_mpris_media_player2_track_list_dup_tracks() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
clapper_enhancer_mpris_media_player2_track_list_get_tracks (ClapperEnhancerMprisMediaPlayer2TrackList *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_TRACK_LIST (object), NULL);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_GET_IFACE (object)->get_tracks (object);
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_dup_tracks: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-TrackList.Tracks">"Tracks"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
clapper_enhancer_mpris_media_player2_track_list_dup_tracks (ClapperEnhancerMprisMediaPlayer2TrackList *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "tracks", &value, NULL);
  return value;
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_set_tracks: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-TrackList.Tracks">"Tracks"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_track_list_set_tracks (ClapperEnhancerMprisMediaPlayer2TrackList *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "tracks", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_get_can_edit_tracks: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
 *
 * Gets the value of the <link linkend="gdbus-property-org-mpris-MediaPlayer2-TrackList.CanEditTracks">"CanEditTracks"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
clapper_enhancer_mpris_media_player2_track_list_get_can_edit_tracks (ClapperEnhancerMprisMediaPlayer2TrackList *object)
{
  g_return_val_if_fail (CLAPPER_ENHANCER_MPRIS_IS_MEDIA_PLAYER2_TRACK_LIST (object), FALSE);

  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_GET_IFACE (object)->get_can_edit_tracks (object);
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_set_can_edit_tracks: (skip)
 * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-mpris-MediaPlayer2-TrackList.CanEditTracks">"CanEditTracks"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
clapper_enhancer_mpris_media_player2_track_list_set_can_edit_tracks (ClapperEnhancerMprisMediaPlayer2TrackList *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "can-edit-tracks", value, NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_emit_track_list_replaced:
 * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
 * @arg_Tracks: Argument to pass with the signal.
 * @arg_CurrentTrack: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-mpris-MediaPlayer2-TrackList.TrackListReplaced">"TrackListReplaced"</link> D-Bus signal.
 */
void
clapper_enhancer_mpris_media_player2_track_list_emit_track_list_replaced (
    ClapperEnhancerMprisMediaPlayer2TrackList *object,
    const gchar *const *arg_Tracks,
    const gchar *arg_CurrentTrack)
{
  g_signal_emit (object, CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_SIGNALS[CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_TRACK_LIST_REPLACED], 0, arg_Tracks, arg_CurrentTrack);
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_emit_track_added:
 * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
 * @arg_Metadata: Argument to pass with the signal.
 * @arg_AfterTrack: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-mpris-MediaPlayer2-TrackList.TrackAdded">"TrackAdded"</link> D-Bus signal.
 */
void
clapper_enhancer_mpris_media_player2_track_list_emit_track_added (
    ClapperEnhancerMprisMediaPlayer2TrackList *object,
    GVariant *arg_Metadata,
    const gchar *arg_AfterTrack)
{
  g_signal_emit (object, CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_SIGNALS[CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_TRACK_ADDED], 0, arg_Metadata, arg_AfterTrack);
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_emit_track_removed:
 * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
 * @arg_TrackId: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-mpris-MediaPlayer2-TrackList.TrackRemoved">"TrackRemoved"</link> D-Bus signal.
 */
void
clapper_enhancer_mpris_media_player2_track_list_emit_track_removed (
    ClapperEnhancerMprisMediaPlayer2TrackList *object,
    const gchar *arg_TrackId)
{
  g_signal_emit (object, CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_SIGNALS[CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_TRACK_REMOVED], 0, arg_TrackId);
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_emit_track_metadata_changed:
 * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
 * @arg_TrackId: Argument to pass with the signal.
 * @arg_Metadata: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-mpris-MediaPlayer2-TrackList.TrackMetadataChanged">"TrackMetadataChanged"</link> D-Bus signal.
 */
void
clapper_enhancer_mpris_media_player2_track_list_emit_track_metadata_changed (
    ClapperEnhancerMprisMediaPlayer2TrackList *object,
    const gchar *arg_TrackId,
    GVariant *arg_Metadata)
{
  g_signal_emit (object, CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_SIGNALS[CLAPPER_ENHANCER_MPRIS__MEDIA_PLAYER2_TRACK_LIST_TRACK_METADATA_CHANGED], 0, arg_TrackId, arg_Metadata);
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_call_get_tracks_metadata:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2TrackListProxy.
 * @arg_TrackIds: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.GetTracksMetadata">GetTracksMetadata()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_track_list_call_get_tracks_metadata_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_track_list_call_get_tracks_metadata_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_track_list_call_get_tracks_metadata (
    ClapperEnhancerMprisMediaPlayer2TrackList *proxy,
    const gchar *const *arg_TrackIds,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetTracksMetadata",
    g_variant_new ("(^ao)",
                   arg_TrackIds),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_call_get_tracks_metadata_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2TrackListProxy.
 * @out_Metadata: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_track_list_call_get_tracks_metadata().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_track_list_call_get_tracks_metadata().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_track_list_call_get_tracks_metadata_finish (
    ClapperEnhancerMprisMediaPlayer2TrackList *proxy,
    GVariant **out_Metadata,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@aa{sv})",
                 out_Metadata);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_call_get_tracks_metadata_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2TrackListProxy.
 * @arg_TrackIds: Argument to pass with the method invocation.
 * @out_Metadata: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.GetTracksMetadata">GetTracksMetadata()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_track_list_call_get_tracks_metadata() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_track_list_call_get_tracks_metadata_sync (
    ClapperEnhancerMprisMediaPlayer2TrackList *proxy,
    const gchar *const *arg_TrackIds,
    GVariant **out_Metadata,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetTracksMetadata",
    g_variant_new ("(^ao)",
                   arg_TrackIds),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@aa{sv})",
                 out_Metadata);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_call_add_track:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2TrackListProxy.
 * @arg_Uri: Argument to pass with the method invocation.
 * @arg_AfterTrack: Argument to pass with the method invocation.
 * @arg_SetAsCurrent: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.AddTrack">AddTrack()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_track_list_call_add_track_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_track_list_call_add_track_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_track_list_call_add_track (
    ClapperEnhancerMprisMediaPlayer2TrackList *proxy,
    const gchar *arg_Uri,
    const gchar *arg_AfterTrack,
    gboolean arg_SetAsCurrent,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddTrack",
    g_variant_new ("(sob)",
                   arg_Uri,
                   arg_AfterTrack,
                   arg_SetAsCurrent),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_call_add_track_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2TrackListProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_track_list_call_add_track().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_track_list_call_add_track().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_track_list_call_add_track_finish (
    ClapperEnhancerMprisMediaPlayer2TrackList *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_call_add_track_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2TrackListProxy.
 * @arg_Uri: Argument to pass with the method invocation.
 * @arg_AfterTrack: Argument to pass with the method invocation.
 * @arg_SetAsCurrent: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.AddTrack">AddTrack()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_track_list_call_add_track() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_track_list_call_add_track_sync (
    ClapperEnhancerMprisMediaPlayer2TrackList *proxy,
    const gchar *arg_Uri,
    const gchar *arg_AfterTrack,
    gboolean arg_SetAsCurrent,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddTrack",
    g_variant_new ("(sob)",
                   arg_Uri,
                   arg_AfterTrack,
                   arg_SetAsCurrent),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_call_remove_track:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2TrackListProxy.
 * @arg_TrackId: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.RemoveTrack">RemoveTrack()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_track_list_call_remove_track_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_track_list_call_remove_track_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_track_list_call_remove_track (
    ClapperEnhancerMprisMediaPlayer2TrackList *proxy,
    const gchar *arg_TrackId,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RemoveTrack",
    g_variant_new ("(o)",
                   arg_TrackId),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_call_remove_track_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2TrackListProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_track_list_call_remove_track().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_track_list_call_remove_track().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_track_list_call_remove_track_finish (
    ClapperEnhancerMprisMediaPlayer2TrackList *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_call_remove_track_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2TrackListProxy.
 * @arg_TrackId: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.RemoveTrack">RemoveTrack()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_track_list_call_remove_track() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_track_list_call_remove_track_sync (
    ClapperEnhancerMprisMediaPlayer2TrackList *proxy,
    const gchar *arg_TrackId,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RemoveTrack",
    g_variant_new ("(o)",
                   arg_TrackId),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_call_go_to:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2TrackListProxy.
 * @arg_TrackId: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.GoTo">GoTo()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_track_list_call_go_to_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_track_list_call_go_to_sync() for the synchronous, blocking version of this method.
 */
void
clapper_enhancer_mpris_media_player2_track_list_call_go_to (
    ClapperEnhancerMprisMediaPlayer2TrackList *proxy,
    const gchar *arg_TrackId,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GoTo",
    g_variant_new ("(o)",
                   arg_TrackId),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_call_go_to_finish:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2TrackListProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_track_list_call_go_to().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_track_list_call_go_to().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_track_list_call_go_to_finish (
    ClapperEnhancerMprisMediaPlayer2TrackList *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_call_go_to_sync:
 * @proxy: A #ClapperEnhancerMprisMediaPlayer2TrackListProxy.
 * @arg_TrackId: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.GoTo">GoTo()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_track_list_call_go_to() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
clapper_enhancer_mpris_media_player2_track_list_call_go_to_sync (
    ClapperEnhancerMprisMediaPlayer2TrackList *proxy,
    const gchar *arg_TrackId,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GoTo",
    g_variant_new ("(o)",
                   arg_TrackId),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_complete_get_tracks_metadata:
 * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @Metadata: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.GetTracksMetadata">GetTracksMetadata()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_track_list_complete_get_tracks_metadata (
    ClapperEnhancerMprisMediaPlayer2TrackList *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *Metadata)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@aa{sv})",
                   Metadata));
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_complete_add_track:
 * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.AddTrack">AddTrack()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_track_list_complete_add_track (
    ClapperEnhancerMprisMediaPlayer2TrackList *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_complete_remove_track:
 * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.RemoveTrack">RemoveTrack()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_track_list_complete_remove_track (
    ClapperEnhancerMprisMediaPlayer2TrackList *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_complete_go_to:
 * @object: A #ClapperEnhancerMprisMediaPlayer2TrackList.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-mpris-MediaPlayer2-TrackList.GoTo">GoTo()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
clapper_enhancer_mpris_media_player2_track_list_complete_go_to (
    ClapperEnhancerMprisMediaPlayer2TrackList *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * ClapperEnhancerMprisMediaPlayer2TrackListProxy:
 *
 * The #ClapperEnhancerMprisMediaPlayer2TrackListProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ClapperEnhancerMprisMediaPlayer2TrackListProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ClapperEnhancerMprisMediaPlayer2TrackListProxy.
 */

struct _ClapperEnhancerMprisMediaPlayer2TrackListProxyPrivate
{
  GData *qdata;
};

static void clapper_enhancer_mpris_media_player2_track_list_proxy_iface_init (ClapperEnhancerMprisMediaPlayer2TrackListIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ClapperEnhancerMprisMediaPlayer2TrackListProxy, clapper_enhancer_mpris_media_player2_track_list_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (ClapperEnhancerMprisMediaPlayer2TrackListProxy)
                         G_IMPLEMENT_INTERFACE (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST, clapper_enhancer_mpris_media_player2_track_list_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ClapperEnhancerMprisMediaPlayer2TrackListProxy, clapper_enhancer_mpris_media_player2_track_list_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST, clapper_enhancer_mpris_media_player2_track_list_proxy_iface_init))

#endif
static void
clapper_enhancer_mpris_media_player2_track_list_proxy_finalize (GObject *object)
{
  ClapperEnhancerMprisMediaPlayer2TrackListProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (clapper_enhancer_mpris_media_player2_track_list_proxy_parent_class)->finalize (object);
}

static void
clapper_enhancer_mpris_media_player2_track_list_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _clapper_enhancer_mpris_media_player2_track_list_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
clapper_enhancer_mpris_media_player2_track_list_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.mpris.MediaPlayer2.TrackList: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
clapper_enhancer_mpris_media_player2_track_list_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _clapper_enhancer_mpris_media_player2_track_list_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.mpris.MediaPlayer2.TrackList", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) clapper_enhancer_mpris_media_player2_track_list_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
clapper_enhancer_mpris_media_player2_track_list_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_track_list_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
clapper_enhancer_mpris_media_player2_track_list_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  ClapperEnhancerMprisMediaPlayer2TrackListProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_track_list_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_track_list_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *const *
clapper_enhancer_mpris_media_player2_track_list_proxy_get_tracks (ClapperEnhancerMprisMediaPlayer2TrackList *object)
{
  ClapperEnhancerMprisMediaPlayer2TrackListProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Tracks");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Tracks");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Tracks", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_track_list_proxy_get_can_edit_tracks (ClapperEnhancerMprisMediaPlayer2TrackList *object)
{
  ClapperEnhancerMprisMediaPlayer2TrackListProxy *proxy = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_PROXY (object);
  GVariant *variant;
  gboolean value = FALSE;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "CanEditTracks");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
clapper_enhancer_mpris_media_player2_track_list_proxy_init (ClapperEnhancerMprisMediaPlayer2TrackListProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = clapper_enhancer_mpris_media_player2_track_list_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST_PROXY, ClapperEnhancerMprisMediaPlayer2TrackListProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), clapper_enhancer_mpris_media_player2_track_list_interface_info ());
}

static void
clapper_enhancer_mpris_media_player2_track_list_proxy_class_init (ClapperEnhancerMprisMediaPlayer2TrackListProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = clapper_enhancer_mpris_media_player2_track_list_proxy_finalize;
  gobject_class->get_property = clapper_enhancer_mpris_media_player2_track_list_proxy_get_property;
  gobject_class->set_property = clapper_enhancer_mpris_media_player2_track_list_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = clapper_enhancer_mpris_media_player2_track_list_proxy_g_signal;
  proxy_class->g_properties_changed = clapper_enhancer_mpris_media_player2_track_list_proxy_g_properties_changed;

  clapper_enhancer_mpris_media_player2_track_list_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ClapperEnhancerMprisMediaPlayer2TrackListProxyPrivate));
#endif
}

static void
clapper_enhancer_mpris_media_player2_track_list_proxy_iface_init (ClapperEnhancerMprisMediaPlayer2TrackListIface *iface)
{
  iface->get_tracks = clapper_enhancer_mpris_media_player2_track_list_proxy_get_tracks;
  iface->get_can_edit_tracks = clapper_enhancer_mpris_media_player2_track_list_proxy_get_can_edit_tracks;
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-TrackList.top_of_page">org.mpris.MediaPlayer2.TrackList</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_track_list_proxy_new_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_track_list_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
clapper_enhancer_mpris_media_player2_track_list_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.TrackList", NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_track_list_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_track_list_proxy_new().
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2TrackListProxy): The constructed proxy object or %NULL if @error is set.
 */
ClapperEnhancerMprisMediaPlayer2TrackList *
clapper_enhancer_mpris_media_player2_track_list_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST (ret);
  else
    return NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-TrackList.top_of_page">org.mpris.MediaPlayer2.TrackList</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_track_list_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2TrackListProxy): The constructed proxy object or %NULL if @error is set.
 */
ClapperEnhancerMprisMediaPlayer2TrackList *
clapper_enhancer_mpris_media_player2_track_list_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.TrackList", NULL);
  if (ret != NULL)
    return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST (ret);
  else
    return NULL;
}


/**
 * clapper_enhancer_mpris_media_player2_track_list_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like clapper_enhancer_mpris_media_player2_track_list_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call clapper_enhancer_mpris_media_player2_track_list_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See clapper_enhancer_mpris_media_player2_track_list_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
clapper_enhancer_mpris_media_player2_track_list_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.TrackList", NULL);
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to clapper_enhancer_mpris_media_player2_track_list_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with clapper_enhancer_mpris_media_player2_track_list_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2TrackListProxy): The constructed proxy object or %NULL if @error is set.
 */
ClapperEnhancerMprisMediaPlayer2TrackList *
clapper_enhancer_mpris_media_player2_track_list_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST (ret);
  else
    return NULL;
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like clapper_enhancer_mpris_media_player2_track_list_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See clapper_enhancer_mpris_media_player2_track_list_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2TrackListProxy): The constructed proxy object or %NULL if @error is set.
 */
ClapperEnhancerMprisMediaPlayer2TrackList *
clapper_enhancer_mpris_media_player2_track_list_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.mpris.MediaPlayer2.TrackList", NULL);
  if (ret != NULL)
    return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * ClapperEnhancerMprisMediaPlayer2TrackListSkeleton:
 *
 * The #ClapperEnhancerMprisMediaPlayer2TrackListSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ClapperEnhancerMprisMediaPlayer2TrackListSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ClapperEnhancerMprisMediaPlayer2TrackListSkeleton.
 */

struct _ClapperEnhancerMprisMediaPlayer2TrackListSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_clapper_enhancer_mpris_media_player2_track_list_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_clapper_enhancer_mpris_media_player2_track_list_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_track_list_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_clapper_enhancer_mpris_media_player2_track_list_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_clapper_enhancer_mpris_media_player2_track_list_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _clapper_enhancer_mpris_media_player2_track_list_skeleton_vtable =
{
  _clapper_enhancer_mpris_media_player2_track_list_skeleton_handle_method_call,
  _clapper_enhancer_mpris_media_player2_track_list_skeleton_handle_get_property,
  _clapper_enhancer_mpris_media_player2_track_list_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
clapper_enhancer_mpris_media_player2_track_list_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return clapper_enhancer_mpris_media_player2_track_list_interface_info ();
}

static GDBusInterfaceVTable *
clapper_enhancer_mpris_media_player2_track_list_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_clapper_enhancer_mpris_media_player2_track_list_skeleton_vtable;
}

static GVariant *
clapper_enhancer_mpris_media_player2_track_list_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_clapper_enhancer_mpris_media_player2_track_list_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _clapper_enhancer_mpris_media_player2_track_list_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _clapper_enhancer_mpris_media_player2_track_list_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _clapper_enhancer_mpris_media_player2_track_list_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mpris.MediaPlayer2.TrackList", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _clapper_enhancer_mpris_media_player2_track_list_emit_changed (gpointer user_data);

static void
clapper_enhancer_mpris_media_player2_track_list_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _clapper_enhancer_mpris_media_player2_track_list_emit_changed (skeleton);
}

static void
_clapper_enhancer_mpris_media_player2_track_list_on_signal_track_list_replaced (
    ClapperEnhancerMprisMediaPlayer2TrackList *object,
    const gchar *const *arg_Tracks,
    const gchar *arg_CurrentTrack)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(^aoo)",
                   arg_Tracks,
                   arg_CurrentTrack));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mpris.MediaPlayer2.TrackList", "TrackListReplaced",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_clapper_enhancer_mpris_media_player2_track_list_on_signal_track_added (
    ClapperEnhancerMprisMediaPlayer2TrackList *object,
    GVariant *arg_Metadata,
    const gchar *arg_AfterTrack)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(@a{sv}o)",
                   arg_Metadata,
                   arg_AfterTrack));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mpris.MediaPlayer2.TrackList", "TrackAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_clapper_enhancer_mpris_media_player2_track_list_on_signal_track_removed (
    ClapperEnhancerMprisMediaPlayer2TrackList *object,
    const gchar *arg_TrackId)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_TrackId));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mpris.MediaPlayer2.TrackList", "TrackRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_clapper_enhancer_mpris_media_player2_track_list_on_signal_track_metadata_changed (
    ClapperEnhancerMprisMediaPlayer2TrackList *object,
    const gchar *arg_TrackId,
    GVariant *arg_Metadata)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o@a{sv})",
                   arg_TrackId,
                   arg_Metadata));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.mpris.MediaPlayer2.TrackList", "TrackMetadataChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void clapper_enhancer_mpris_media_player2_track_list_skeleton_iface_init (ClapperEnhancerMprisMediaPlayer2TrackListIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ClapperEnhancerMprisMediaPlayer2TrackListSkeleton, clapper_enhancer_mpris_media_player2_track_list_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (ClapperEnhancerMprisMediaPlayer2TrackListSkeleton)
                         G_IMPLEMENT_INTERFACE (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST, clapper_enhancer_mpris_media_player2_track_list_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ClapperEnhancerMprisMediaPlayer2TrackListSkeleton, clapper_enhancer_mpris_media_player2_track_list_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST, clapper_enhancer_mpris_media_player2_track_list_skeleton_iface_init))

#endif
static void
clapper_enhancer_mpris_media_player2_track_list_skeleton_finalize (GObject *object)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (clapper_enhancer_mpris_media_player2_track_list_skeleton_parent_class)->finalize (object);
}

static void
clapper_enhancer_mpris_media_player2_track_list_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_clapper_enhancer_mpris_media_player2_track_list_emit_changed (gpointer user_data)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.mpris.MediaPlayer2.TrackList",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_clapper_enhancer_mpris_media_player2_track_list_schedule_emit_changed (ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
clapper_enhancer_mpris_media_player2_track_list_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _clapper_enhancer_mpris_media_player2_track_list_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _clapper_enhancer_mpris_media_player2_track_list_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
clapper_enhancer_mpris_media_player2_track_list_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _clapper_enhancer_mpris_media_player2_track_list_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _clapper_enhancer_mpris_media_player2_track_list_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
clapper_enhancer_mpris_media_player2_track_list_skeleton_init (ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = clapper_enhancer_mpris_media_player2_track_list_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST_SKELETON, ClapperEnhancerMprisMediaPlayer2TrackListSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
}

static const gchar *const *
clapper_enhancer_mpris_media_player2_track_list_skeleton_get_tracks (ClapperEnhancerMprisMediaPlayer2TrackList *object)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boxed (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
clapper_enhancer_mpris_media_player2_track_list_skeleton_get_can_edit_tracks (ClapperEnhancerMprisMediaPlayer2TrackList *object)
{
  ClapperEnhancerMprisMediaPlayer2TrackListSkeleton *skeleton = CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
clapper_enhancer_mpris_media_player2_track_list_skeleton_class_init (ClapperEnhancerMprisMediaPlayer2TrackListSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = clapper_enhancer_mpris_media_player2_track_list_skeleton_finalize;
  gobject_class->get_property = clapper_enhancer_mpris_media_player2_track_list_skeleton_get_property;
  gobject_class->set_property = clapper_enhancer_mpris_media_player2_track_list_skeleton_set_property;
  gobject_class->notify       = clapper_enhancer_mpris_media_player2_track_list_skeleton_notify;


  clapper_enhancer_mpris_media_player2_track_list_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = clapper_enhancer_mpris_media_player2_track_list_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = clapper_enhancer_mpris_media_player2_track_list_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = clapper_enhancer_mpris_media_player2_track_list_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = clapper_enhancer_mpris_media_player2_track_list_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ClapperEnhancerMprisMediaPlayer2TrackListSkeletonPrivate));
#endif
}

static void
clapper_enhancer_mpris_media_player2_track_list_skeleton_iface_init (ClapperEnhancerMprisMediaPlayer2TrackListIface *iface)
{
  iface->track_list_replaced = _clapper_enhancer_mpris_media_player2_track_list_on_signal_track_list_replaced;
  iface->track_added = _clapper_enhancer_mpris_media_player2_track_list_on_signal_track_added;
  iface->track_removed = _clapper_enhancer_mpris_media_player2_track_list_on_signal_track_removed;
  iface->track_metadata_changed = _clapper_enhancer_mpris_media_player2_track_list_on_signal_track_metadata_changed;
  iface->get_tracks = clapper_enhancer_mpris_media_player2_track_list_skeleton_get_tracks;
  iface->get_can_edit_tracks = clapper_enhancer_mpris_media_player2_track_list_skeleton_get_can_edit_tracks;
}

/**
 * clapper_enhancer_mpris_media_player2_track_list_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-mpris-MediaPlayer2-TrackList.top_of_page">org.mpris.MediaPlayer2.TrackList</link>.
 *
 * Returns: (transfer full) (type ClapperEnhancerMprisMediaPlayer2TrackListSkeleton): The skeleton object.
 */
ClapperEnhancerMprisMediaPlayer2TrackList *
clapper_enhancer_mpris_media_player2_track_list_skeleton_new (void)
{
  return CLAPPER_ENHANCER_MPRIS_MEDIA_PLAYER2_TRACK_LIST (g_object_new (CLAPPER_ENHANCER_MPRIS_TYPE_MEDIA_PLAYER2_TRACK_LIST_SKELETON, NULL));
}

