/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package internal

import (
	fmt "fmt"
	sync "sync"

	typed "sigs.k8s.io/structured-merge-diff/v6/typed"
)

func Parser() *typed.Parser {
	parserOnce.Do(func() {
		var err error
		parser, err = typed.NewParser(schemaYAML)
		if err != nil {
			panic(fmt.Sprintf("Failed to parse schema: %v", err))
		}
	})
	return parser
}

var parserOnce sync.Once
var parser *typed.Parser
var schemaYAML = typed.YAMLObject(`types:
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEAuthorization
  map:
    fields:
    - name: challenges
      type:
        list:
          elementType:
            namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallenge
          elementRelationship: atomic
    - name: identifier
      type:
        scalar: string
    - name: initialState
      type:
        scalar: string
    - name: url
      type:
        scalar: string
      default: ""
    - name: wildcard
      type:
        scalar: boolean
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallenge
  map:
    fields:
    - name: token
      type:
        scalar: string
      default: ""
    - name: type
      type:
        scalar: string
      default: ""
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolver
  map:
    fields:
    - name: dns01
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverDNS01
    - name: http01
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01
    - name: selector
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.CertificateDNSNameSelector
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverDNS01
  map:
    fields:
    - name: acmeDNS
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderAcmeDNS
    - name: akamai
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderAkamai
    - name: azureDNS
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderAzureDNS
    - name: cloudDNS
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderCloudDNS
    - name: cloudflare
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderCloudflare
    - name: cnameStrategy
      type:
        scalar: string
    - name: digitalocean
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderDigitalOcean
    - name: rfc2136
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderRFC2136
    - name: route53
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderRoute53
    - name: webhook
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderWebhook
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01
  map:
    fields:
    - name: gatewayHTTPRoute
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01GatewayHTTPRoute
    - name: ingress
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01Ingress
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01GatewayHTTPRoute
  map:
    fields:
    - name: labels
      type:
        map:
          elementType:
            scalar: string
    - name: parentRefs
      type:
        list:
          elementType:
            namedType: io.k8s.sigs.gateway-api.apis.v1.ParentReference
          elementRelationship: atomic
    - name: podTemplate
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressPodTemplate
    - name: serviceType
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01Ingress
  map:
    fields:
    - name: class
      type:
        scalar: string
    - name: ingressClassName
      type:
        scalar: string
    - name: ingressTemplate
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressTemplate
    - name: name
      type:
        scalar: string
    - name: podTemplate
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressPodTemplate
    - name: serviceType
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressObjectMeta
  map:
    fields:
    - name: annotations
      type:
        map:
          elementType:
            scalar: string
    - name: labels
      type:
        map:
          elementType:
            scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressPodObjectMeta
  map:
    fields:
    - name: annotations
      type:
        map:
          elementType:
            scalar: string
    - name: labels
      type:
        map:
          elementType:
            scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressPodResources
  map:
    fields:
    - name: limits
      type:
        map:
          elementType:
            namedType: io.k8s.apimachinery.pkg.api.resource.Quantity
    - name: requests
      type:
        map:
          elementType:
            namedType: io.k8s.apimachinery.pkg.api.resource.Quantity
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressPodSecurityContext
  map:
    fields:
    - name: fsGroup
      type:
        scalar: numeric
    - name: fsGroupChangePolicy
      type:
        scalar: string
    - name: runAsGroup
      type:
        scalar: numeric
    - name: runAsNonRoot
      type:
        scalar: boolean
    - name: runAsUser
      type:
        scalar: numeric
    - name: seLinuxOptions
      type:
        namedType: io.k8s.api.core.v1.SELinuxOptions
    - name: seccompProfile
      type:
        namedType: io.k8s.api.core.v1.SeccompProfile
    - name: supplementalGroups
      type:
        list:
          elementType:
            scalar: numeric
          elementRelationship: atomic
    - name: sysctls
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.Sysctl
          elementRelationship: atomic
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressPodSpec
  map:
    fields:
    - name: affinity
      type:
        namedType: io.k8s.api.core.v1.Affinity
    - name: imagePullSecrets
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.LocalObjectReference
          elementRelationship: associative
          keys:
          - name
    - name: nodeSelector
      type:
        map:
          elementType:
            scalar: string
    - name: priorityClassName
      type:
        scalar: string
    - name: resources
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressPodResources
    - name: securityContext
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressPodSecurityContext
    - name: serviceAccountName
      type:
        scalar: string
    - name: tolerations
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.Toleration
          elementRelationship: atomic
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressPodTemplate
  map:
    fields:
    - name: metadata
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressPodObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressPodSpec
      default: {}
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressTemplate
  map:
    fields:
    - name: metadata
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolverHTTP01IngressObjectMeta
      default: {}
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEExternalAccountBinding
  map:
    fields:
    - name: keyAlgorithm
      type:
        scalar: string
    - name: keyID
      type:
        scalar: string
      default: ""
    - name: keySecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
      default: {}
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuer
  map:
    fields:
    - name: caBundle
      type:
        scalar: string
    - name: disableAccountKeyGeneration
      type:
        scalar: boolean
    - name: email
      type:
        scalar: string
    - name: enableDurationFeature
      type:
        scalar: boolean
    - name: externalAccountBinding
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEExternalAccountBinding
    - name: preferredChain
      type:
        scalar: string
    - name: privateKeySecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
      default: {}
    - name: profile
      type:
        scalar: string
    - name: server
      type:
        scalar: string
      default: ""
    - name: skipTLSVerify
      type:
        scalar: boolean
    - name: solvers
      type:
        list:
          elementType:
            namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolver
          elementRelationship: atomic
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderAcmeDNS
  map:
    fields:
    - name: accountSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
      default: {}
    - name: host
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderAkamai
  map:
    fields:
    - name: accessTokenSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
      default: {}
    - name: clientSecretSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
      default: {}
    - name: clientTokenSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
      default: {}
    - name: serviceConsumerDomain
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderAzureDNS
  map:
    fields:
    - name: clientID
      type:
        scalar: string
    - name: clientSecretSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
    - name: environment
      type:
        scalar: string
    - name: hostedZoneName
      type:
        scalar: string
    - name: managedIdentity
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.AzureManagedIdentity
    - name: resourceGroupName
      type:
        scalar: string
      default: ""
    - name: subscriptionID
      type:
        scalar: string
      default: ""
    - name: tenantID
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderCloudDNS
  map:
    fields:
    - name: hostedZoneName
      type:
        scalar: string
    - name: project
      type:
        scalar: string
      default: ""
    - name: serviceAccountSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderCloudflare
  map:
    fields:
    - name: apiKeySecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
    - name: apiTokenSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
    - name: email
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderDigitalOcean
  map:
    fields:
    - name: tokenSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
      default: {}
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderRFC2136
  map:
    fields:
    - name: nameserver
      type:
        scalar: string
      default: ""
    - name: protocol
      type:
        scalar: string
    - name: tsigAlgorithm
      type:
        scalar: string
    - name: tsigKeyName
      type:
        scalar: string
    - name: tsigSecretSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
      default: {}
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderRoute53
  map:
    fields:
    - name: accessKeyID
      type:
        scalar: string
    - name: accessKeyIDSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
    - name: auth
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.Route53Auth
    - name: hostedZoneID
      type:
        scalar: string
    - name: region
      type:
        scalar: string
    - name: role
      type:
        scalar: string
    - name: secretAccessKeySecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
      default: {}
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerDNS01ProviderWebhook
  map:
    fields:
    - name: config
      type:
        namedType: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSON
    - name: groupName
      type:
        scalar: string
      default: ""
    - name: solverName
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerStatus
  map:
    fields:
    - name: lastPrivateKeyHash
      type:
        scalar: string
    - name: lastRegisteredEmail
      type:
        scalar: string
    - name: uri
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.AzureManagedIdentity
  map:
    fields:
    - name: clientID
      type:
        scalar: string
    - name: resourceID
      type:
        scalar: string
    - name: tenantID
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.CertificateDNSNameSelector
  map:
    fields:
    - name: dnsNames
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: dnsZones
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: matchLabels
      type:
        map:
          elementType:
            scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.Challenge
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ChallengeSpec
      default: {}
    - name: status
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ChallengeStatus
      default: {}
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ChallengeSpec
  map:
    fields:
    - name: authorizationURL
      type:
        scalar: string
      default: ""
    - name: dnsName
      type:
        scalar: string
      default: ""
    - name: issuerRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.IssuerReference
      default: {}
    - name: key
      type:
        scalar: string
      default: ""
    - name: solver
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEChallengeSolver
      default: {}
    - name: token
      type:
        scalar: string
      default: ""
    - name: type
      type:
        scalar: string
      default: ""
    - name: url
      type:
        scalar: string
      default: ""
    - name: wildcard
      type:
        scalar: boolean
      default: false
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ChallengeStatus
  map:
    fields:
    - name: presented
      type:
        scalar: boolean
      default: false
    - name: processing
      type:
        scalar: boolean
      default: false
    - name: reason
      type:
        scalar: string
    - name: state
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.Order
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.OrderSpec
      default: {}
    - name: status
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.OrderStatus
      default: {}
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.OrderSpec
  map:
    fields:
    - name: commonName
      type:
        scalar: string
    - name: dnsNames
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: duration
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: ipAddresses
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: issuerRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.IssuerReference
      default: {}
    - name: profile
      type:
        scalar: string
    - name: request
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.OrderStatus
  map:
    fields:
    - name: authorizations
      type:
        list:
          elementType:
            namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEAuthorization
          elementRelationship: atomic
    - name: certificate
      type:
        scalar: string
    - name: failureTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: finalizeURL
      type:
        scalar: string
    - name: reason
      type:
        scalar: string
    - name: state
      type:
        scalar: string
    - name: url
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.Route53Auth
  map:
    fields:
    - name: kubernetes
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.Route53KubernetesAuth
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.Route53KubernetesAuth
  map:
    fields:
    - name: serviceAccountRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ServiceAccountRef
- name: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ServiceAccountRef
  map:
    fields:
    - name: audiences
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CAIssuer
  map:
    fields:
    - name: crlDistributionPoints
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: issuingCertificateURLs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: ocspServers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: secretName
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.Certificate
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateSpec
      default: {}
    - name: status
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateStatus
      default: {}
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateAdditionalOutputFormat
  map:
    fields:
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateCondition
  map:
    fields:
    - name: lastTransitionTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: message
      type:
        scalar: string
    - name: observedGeneration
      type:
        scalar: numeric
    - name: reason
      type:
        scalar: string
    - name: status
      type:
        scalar: string
      default: ""
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateKeystores
  map:
    fields:
    - name: jks
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.JKSKeystore
    - name: pkcs12
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.PKCS12Keystore
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificatePrivateKey
  map:
    fields:
    - name: algorithm
      type:
        scalar: string
    - name: encoding
      type:
        scalar: string
    - name: rotationPolicy
      type:
        scalar: string
    - name: size
      type:
        scalar: numeric
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateRequest
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateRequestSpec
      default: {}
    - name: status
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateRequestStatus
      default: {}
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateRequestCondition
  map:
    fields:
    - name: lastTransitionTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: message
      type:
        scalar: string
    - name: reason
      type:
        scalar: string
    - name: status
      type:
        scalar: string
      default: ""
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateRequestSpec
  map:
    fields:
    - name: duration
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: extra
      type:
        map:
          elementType:
            list:
              elementType:
                scalar: string
              elementRelationship: atomic
    - name: groups
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: isCA
      type:
        scalar: boolean
    - name: issuerRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.IssuerReference
      default: {}
    - name: request
      type:
        scalar: string
    - name: uid
      type:
        scalar: string
    - name: usages
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: username
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateRequestStatus
  map:
    fields:
    - name: ca
      type:
        scalar: string
    - name: certificate
      type:
        scalar: string
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateRequestCondition
          elementRelationship: associative
          keys:
          - type
    - name: failureTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateSecretTemplate
  map:
    fields:
    - name: annotations
      type:
        map:
          elementType:
            scalar: string
    - name: labels
      type:
        map:
          elementType:
            scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateSpec
  map:
    fields:
    - name: additionalOutputFormats
      type:
        list:
          elementType:
            namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateAdditionalOutputFormat
          elementRelationship: atomic
    - name: commonName
      type:
        scalar: string
    - name: dnsNames
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: duration
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: emailAddresses
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: encodeUsagesInRequest
      type:
        scalar: boolean
    - name: ipAddresses
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: isCA
      type:
        scalar: boolean
    - name: issuerRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.IssuerReference
      default: {}
    - name: keystores
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateKeystores
    - name: literalSubject
      type:
        scalar: string
    - name: nameConstraints
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.NameConstraints
    - name: otherNames
      type:
        list:
          elementType:
            namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.OtherName
          elementRelationship: atomic
    - name: privateKey
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificatePrivateKey
    - name: renewBefore
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: renewBeforePercentage
      type:
        scalar: numeric
    - name: revisionHistoryLimit
      type:
        scalar: numeric
    - name: secretName
      type:
        scalar: string
      default: ""
    - name: secretTemplate
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateSecretTemplate
    - name: signatureAlgorithm
      type:
        scalar: string
    - name: subject
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.X509Subject
    - name: uris
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: usages
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CertificateCondition
          elementRelationship: associative
          keys:
          - type
    - name: failedIssuanceAttempts
      type:
        scalar: numeric
    - name: lastFailureTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: nextPrivateKeySecretName
      type:
        scalar: string
    - name: notAfter
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: notBefore
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: renewalTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: revision
      type:
        scalar: numeric
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.ClusterIssuer
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.IssuerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.IssuerStatus
      default: {}
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.Issuer
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.IssuerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.IssuerStatus
      default: {}
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.IssuerCondition
  map:
    fields:
    - name: lastTransitionTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: message
      type:
        scalar: string
    - name: observedGeneration
      type:
        scalar: numeric
    - name: reason
      type:
        scalar: string
    - name: status
      type:
        scalar: string
      default: ""
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.IssuerSpec
  map:
    fields:
    - name: acme
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuer
    - name: ca
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.CAIssuer
    - name: selfSigned
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.SelfSignedIssuer
    - name: vault
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VaultIssuer
    - name: venafi
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VenafiIssuer
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.IssuerStatus
  map:
    fields:
    - name: acme
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.acme.v1.ACMEIssuerStatus
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.IssuerCondition
          elementRelationship: associative
          keys:
          - type
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.JKSKeystore
  map:
    fields:
    - name: alias
      type:
        scalar: string
    - name: create
      type:
        scalar: boolean
      default: false
    - name: password
      type:
        scalar: string
    - name: passwordSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
      default: {}
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.NameConstraintItem
  map:
    fields:
    - name: dnsDomains
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: emailAddresses
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: ipRanges
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: uriDomains
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.NameConstraints
  map:
    fields:
    - name: critical
      type:
        scalar: boolean
    - name: excluded
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.NameConstraintItem
    - name: permitted
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.NameConstraintItem
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.OtherName
  map:
    fields:
    - name: oid
      type:
        scalar: string
    - name: utf8Value
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.PKCS12Keystore
  map:
    fields:
    - name: create
      type:
        scalar: boolean
      default: false
    - name: password
      type:
        scalar: string
    - name: passwordSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
      default: {}
    - name: profile
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.SelfSignedIssuer
  map:
    fields:
    - name: crlDistributionPoints
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.ServiceAccountRef
  map:
    fields:
    - name: audiences
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VaultAppRole
  map:
    fields:
    - name: path
      type:
        scalar: string
      default: ""
    - name: roleId
      type:
        scalar: string
      default: ""
    - name: secretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
      default: {}
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VaultAuth
  map:
    fields:
    - name: appRole
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VaultAppRole
    - name: clientCertificate
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VaultClientCertificateAuth
    - name: kubernetes
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VaultKubernetesAuth
    - name: tokenSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VaultClientCertificateAuth
  map:
    fields:
    - name: mountPath
      type:
        scalar: string
    - name: name
      type:
        scalar: string
    - name: secretName
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VaultIssuer
  map:
    fields:
    - name: auth
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VaultAuth
      default: {}
    - name: caBundle
      type:
        scalar: string
    - name: caBundleSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
    - name: clientCertSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
    - name: clientKeySecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
    - name: namespace
      type:
        scalar: string
    - name: path
      type:
        scalar: string
      default: ""
    - name: server
      type:
        scalar: string
      default: ""
    - name: serverName
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VaultKubernetesAuth
  map:
    fields:
    - name: mountPath
      type:
        scalar: string
    - name: role
      type:
        scalar: string
      default: ""
    - name: secretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
      default: {}
    - name: serviceAccountRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.ServiceAccountRef
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VenafiCloud
  map:
    fields:
    - name: apiTokenSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
      default: {}
    - name: url
      type:
        scalar: string
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VenafiIssuer
  map:
    fields:
    - name: cloud
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VenafiCloud
    - name: tpp
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VenafiTPP
    - name: zone
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.VenafiTPP
  map:
    fields:
    - name: caBundle
      type:
        scalar: string
    - name: caBundleSecretRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
    - name: credentialsRef
      type:
        namedType: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.LocalObjectReference
      default: {}
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.certmanager.v1.X509Subject
  map:
    fields:
    - name: countries
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: localities
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: organizationalUnits
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: organizations
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: postalCodes
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: provinces
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: serialNumber
      type:
        scalar: string
    - name: streetAddresses
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.IssuerReference
  map:
    fields:
    - name: group
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.LocalObjectReference
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.cert-manager.cert-manager.pkg.apis.meta.v1.SecretKeySelector
  map:
    fields:
    - name: key
      type:
        scalar: string
    - name: name
      type:
        scalar: string
      default: ""
- name: io.k8s.api.core.v1.Affinity
  map:
    fields:
    - name: nodeAffinity
      type:
        namedType: io.k8s.api.core.v1.NodeAffinity
    - name: podAffinity
      type:
        namedType: io.k8s.api.core.v1.PodAffinity
    - name: podAntiAffinity
      type:
        namedType: io.k8s.api.core.v1.PodAntiAffinity
- name: io.k8s.api.core.v1.LocalObjectReference
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    elementRelationship: atomic
- name: io.k8s.api.core.v1.NodeAffinity
  map:
    fields:
    - name: preferredDuringSchedulingIgnoredDuringExecution
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.PreferredSchedulingTerm
          elementRelationship: atomic
    - name: requiredDuringSchedulingIgnoredDuringExecution
      type:
        namedType: io.k8s.api.core.v1.NodeSelector
- name: io.k8s.api.core.v1.NodeSelector
  map:
    fields:
    - name: nodeSelectorTerms
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.NodeSelectorTerm
          elementRelationship: atomic
    elementRelationship: atomic
- name: io.k8s.api.core.v1.NodeSelectorRequirement
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: operator
      type:
        scalar: string
      default: ""
    - name: values
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: io.k8s.api.core.v1.NodeSelectorTerm
  map:
    fields:
    - name: matchExpressions
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.NodeSelectorRequirement
          elementRelationship: atomic
    - name: matchFields
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.NodeSelectorRequirement
          elementRelationship: atomic
    elementRelationship: atomic
- name: io.k8s.api.core.v1.PodAffinity
  map:
    fields:
    - name: preferredDuringSchedulingIgnoredDuringExecution
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.WeightedPodAffinityTerm
          elementRelationship: atomic
    - name: requiredDuringSchedulingIgnoredDuringExecution
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.PodAffinityTerm
          elementRelationship: atomic
- name: io.k8s.api.core.v1.PodAffinityTerm
  map:
    fields:
    - name: labelSelector
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
    - name: matchLabelKeys
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: mismatchLabelKeys
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: namespaceSelector
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
    - name: namespaces
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: topologyKey
      type:
        scalar: string
      default: ""
- name: io.k8s.api.core.v1.PodAntiAffinity
  map:
    fields:
    - name: preferredDuringSchedulingIgnoredDuringExecution
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.WeightedPodAffinityTerm
          elementRelationship: atomic
    - name: requiredDuringSchedulingIgnoredDuringExecution
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.PodAffinityTerm
          elementRelationship: atomic
- name: io.k8s.api.core.v1.PreferredSchedulingTerm
  map:
    fields:
    - name: preference
      type:
        namedType: io.k8s.api.core.v1.NodeSelectorTerm
      default: {}
    - name: weight
      type:
        scalar: numeric
      default: 0
- name: io.k8s.api.core.v1.SELinuxOptions
  map:
    fields:
    - name: level
      type:
        scalar: string
    - name: role
      type:
        scalar: string
    - name: type
      type:
        scalar: string
    - name: user
      type:
        scalar: string
- name: io.k8s.api.core.v1.SeccompProfile
  map:
    fields:
    - name: localhostProfile
      type:
        scalar: string
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: localhostProfile
        discriminatorValue: LocalhostProfile
- name: io.k8s.api.core.v1.Sysctl
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: value
      type:
        scalar: string
      default: ""
- name: io.k8s.api.core.v1.Toleration
  map:
    fields:
    - name: effect
      type:
        scalar: string
    - name: key
      type:
        scalar: string
    - name: operator
      type:
        scalar: string
    - name: tolerationSeconds
      type:
        scalar: numeric
    - name: value
      type:
        scalar: string
- name: io.k8s.api.core.v1.WeightedPodAffinityTerm
  map:
    fields:
    - name: podAffinityTerm
      type:
        namedType: io.k8s.api.core.v1.PodAffinityTerm
      default: {}
    - name: weight
      type:
        scalar: numeric
      default: 0
- name: io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSON
  scalar: untyped
  list:
    elementType:
      namedType: __untyped_atomic_
    elementRelationship: atomic
  map:
    elementType:
      namedType: __untyped_deduced_
    elementRelationship: separable
- name: io.k8s.apimachinery.pkg.api.resource.Quantity
  scalar: untyped
- name: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
  scalar: string
- name: io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
  map:
    fields:
    - name: matchExpressions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement
          elementRelationship: atomic
    - name: matchLabels
      type:
        map:
          elementType:
            scalar: string
    elementRelationship: atomic
- name: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: operator
      type:
        scalar: string
      default: ""
    - name: values
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: fieldsType
      type:
        scalar: string
    - name: fieldsV1
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1
    - name: manager
      type:
        scalar: string
    - name: operation
      type:
        scalar: string
    - name: subresource
      type:
        scalar: string
    - name: time
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
- name: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
  map:
    fields:
    - name: annotations
      type:
        map:
          elementType:
            scalar: string
    - name: creationTimestamp
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: deletionGracePeriodSeconds
      type:
        scalar: numeric
    - name: deletionTimestamp
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: finalizers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: generateName
      type:
        scalar: string
    - name: generation
      type:
        scalar: numeric
    - name: labels
      type:
        map:
          elementType:
            scalar: string
    - name: managedFields
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry
          elementRelationship: atomic
    - name: name
      type:
        scalar: string
    - name: namespace
      type:
        scalar: string
    - name: ownerReferences
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference
          elementRelationship: associative
          keys:
          - uid
    - name: resourceVersion
      type:
        scalar: string
    - name: selfLink
      type:
        scalar: string
    - name: uid
      type:
        scalar: string
- name: io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
      default: ""
    - name: blockOwnerDeletion
      type:
        scalar: boolean
    - name: controller
      type:
        scalar: boolean
    - name: kind
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: uid
      type:
        scalar: string
      default: ""
    elementRelationship: atomic
- name: io.k8s.apimachinery.pkg.apis.meta.v1.Time
  scalar: untyped
- name: io.k8s.sigs.gateway-api.apis.v1.ParentReference
  map:
    fields:
    - name: group
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: name
      type:
        scalar: string
      default: ""
    - name: namespace
      type:
        scalar: string
    - name: port
      type:
        scalar: numeric
    - name: sectionName
      type:
        scalar: string
- name: __untyped_atomic_
  scalar: untyped
  list:
    elementType:
      namedType: __untyped_atomic_
    elementRelationship: atomic
  map:
    elementType:
      namedType: __untyped_atomic_
    elementRelationship: atomic
- name: __untyped_deduced_
  scalar: untyped
  list:
    elementType:
      namedType: __untyped_atomic_
    elementRelationship: atomic
  map:
    elementType:
      namedType: __untyped_deduced_
    elementRelationship: separable
`)
