/*      Compiler: ECL 24.5.10                                         */
/*      Source: /build/ecl/src/ecl-24.5.10/src/clos/streams.lsp       */
#include <ecl/ecl-cmp.h>
#include "clos/streams.eclh"
/*      function definition for BUG-OR-ERROR                          */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L2422bug_or_error(cl_object v1stream, cl_object v2fun)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  if (Null(cl_streamp(v1stream))) { goto L1; }
  value0 = cl_error(3, VV[3], v1stream, v2fun);
  return value0;
L1:;
  value0 = cl_error(5, ECL_SYM("TYPE-ERROR",872), ECL_SYM("DATUM",1242), v1stream, ECL_SYM("EXPECTED-TYPE",1260), ECL_SYM("STREAM",801));
  return value0;
 }
}
/*      local function STREAM-ADVANCE-TO-COLUMN                       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2423stream_advance_to_column(cl_object v1stream, cl_object v2column)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_object v3current_column;
   v3current_column = ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-LINE-COLUMN",1700))(1, v1stream) /*  STREAM-LINE-COLUMN */;
   if (Null(v3current_column)) { goto L2; }
   {
    cl_object v4fill;
    T0 = ecl_minus(v2column,v3current_column);
    v4fill = ecl_floor1(T0);
    {
     cl_object v5i;
     v5i = ecl_make_fixnum(0);
     goto L8;
L7:;
     ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-WRITE-CHAR",1713))(2, v1stream, ECL_CODE_CHAR(32)) /*  STREAM-WRITE-CHAR */;
     v5i = ecl_one_plus(v5i);
L8:;
     if (!(ecl_lower(v5i,v4fill))) { goto L13; }
     goto L7;
L13:;
    }
   }
   value0 = ECL_T;
   cl_env_copy->nvalues = 1;
   return value0;
L2:;
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}
/*      local function STREAM-CLEAR-INPUT                             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2424stream_clear_input(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-CLEAR-INPUT                             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2425stream_clear_input(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_clear_input(1, v1stream);
  return value0;
 }
}
/*      local function STREAM-CLEAR-INPUT                             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2426stream_clear_input(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-CLEAR-INPUT",1689));
  return value0;
 }
}
/*      local function STREAM-CLEAR-OUTPUT                            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2427stream_clear_output(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-CLEAR-OUTPUT                            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2428stream_clear_output(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_clear_output(1, v1stream);
  return value0;
 }
}
/*      local function STREAM-CLEAR-OUTPUT                            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2429stream_clear_output(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-CLEAR-OUTPUT",1690));
  return value0;
 }
}
/*      local function CLOSE                                          */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2430close(cl_narg narg, cl_object v1stream, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<1)) FEwrong_num_arguments_anonym();
 {
  cl_object v2abort;
  ecl_va_list args; ecl_va_start(args,v1stream,narg,1);
  {
   cl_object keyvars[2];
   cl_parse_key(args,1,LC2430closekeys,keyvars,NULL,TRUE);
   ecl_va_end(args);
   v2abort = keyvars[0];
  }
  (cl_env_copy->function=ecl_fdefinition(VV[23]))->cfun.entry(2, ECL_NIL, v1stream) /*  (SETF OPEN-STREAM-P) */;
  value0 = ECL_T;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function CLOSE                                          */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2431close(cl_narg narg, cl_object v1stream, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<1)) FEwrong_num_arguments_anonym();
 {
  cl_object v2abort;
  ecl_va_list args; ecl_va_start(args,v1stream,narg,1);
  {
   cl_object keyvars[2];
   cl_parse_key(args,1,LC2431closekeys,keyvars,NULL,TRUE);
   ecl_va_end(args);
   v2abort = keyvars[0];
  }
  value0 = cl_close(3, v1stream, ECL_SYM("ABORT",1222), v2abort);
  return value0;
 }
}
/*      local function CLOSE                                          */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2432close(cl_narg narg, cl_object v1stream, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<1)) FEwrong_num_arguments_anonym();
 {
  cl_object v2abort;
  ecl_va_list args; ecl_va_start(args,v1stream,narg,1);
  {
   cl_object keyvars[2];
   cl_parse_key(args,1,LC2432closekeys,keyvars,NULL,TRUE);
   ecl_va_end(args);
   v2abort = keyvars[0];
  }
  value0 = L2422bug_or_error(v1stream, ECL_SYM("CLOSE",1683));
  return value0;
 }
}
/*      local function STREAM-ELEMENT-TYPE                            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2433stream_element_type(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_SYM("CHARACTER",224);
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-ELEMENT-TYPE                            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2434stream_element_type(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_stream_element_type(v1stream);
  return value0;
 }
}
/*      local function STREAM-ELEMENT-TYPE                            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2435stream_element_type(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-ELEMENT-TYPE",1691));
  return value0;
 }
}
/*      local function STREAM-FINISH-OUTPUT                           */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2436stream_finish_output(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-FINISH-OUTPUT                           */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2437stream_finish_output(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_finish_output(1, v1stream);
  return value0;
 }
}
/*      local function STREAM-FINISH-OUTPUT                           */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2438stream_finish_output(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-FINISH-OUTPUT",1696));
  return value0;
 }
}
/*      local function STREAM-FORCE-OUTPUT                            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2439stream_force_output(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-FORCE-OUTPUT                            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2440stream_force_output(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_force_output(1, v1stream);
  return value0;
 }
}
/*      local function STREAM-FORCE-OUTPUT                            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2441stream_force_output(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-FORCE-OUTPUT",1697));
  return value0;
 }
}
/*      local function STREAM-FRESH-LINE                              */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2442stream_fresh_line(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  if ((ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-START-LINE-P",1709))(1, v1stream) /*  STREAM-START-LINE-P */)!=ECL_NIL) { goto L1; }
  ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-TERPRI",1710))(1, v1stream) /*  STREAM-TERPRI */;
  value0 = ECL_T;
  cl_env_copy->nvalues = 1;
  return value0;
L1:;
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-FRESH-LINE                              */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2443stream_fresh_line(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_fresh_line(1, v1stream);
  return value0;
 }
}
/*      local function INPUT-STREAM-P                                 */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2444input_stream_p(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function INPUT-STREAM-P                                 */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2445input_stream_p(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_T;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function INPUT-STREAM-P                                 */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2446input_stream_p(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_input_stream_p(v1stream);
  return value0;
 }
}
/*      local function INPUT-STREAM-P                                 */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2447input_stream_p(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("INPUT-STREAM-P",1685));
  return value0;
 }
}
/*      local function STREAM-INTERACTIVE-P                           */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2448stream_interactive_p(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_interactive_stream_p(v1stream);
  return value0;
 }
}
/*      local function STREAM-INTERACTIVE-P                           */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2449stream_interactive_p(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-INTERACTIVE-P",1699));
  return value0;
 }
}
/*      local function STREAM-LINE-COLUMN                             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2450stream_line_column(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-LINE-LENGTH                             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2451stream_line_length(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-LINE-LENGTH                             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2452stream_line_length(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-LINE-LENGTH                             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2453stream_line_length(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-LINE-LENGTH",1701));
  return value0;
 }
}
/*      local function STREAM-LISTEN                                  */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2454stream_listen(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_object v2char;
   v2char = ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-READ-CHAR-NO-HANG",1706))(1, v1stream) /*  STREAM-READ-CHAR-NO-HANG */;
   if (!(ECL_CHARACTERP(v2char))) { goto L2; }
   ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-UNREAD-CHAR",1711))(2, v1stream, v2char) /*  STREAM-UNREAD-CHAR */;
   value0 = ECL_T;
   cl_env_copy->nvalues = 1;
   return value0;
L2:;
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}
/*      local function STREAM-LISTEN                                  */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2455stream_listen(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_listen(1, v1stream);
  return value0;
 }
}
/*      local function STREAM-LISTEN                                  */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2456stream_listen(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-LISTEN",1702));
  return value0;
 }
}
/*      local function OPEN-STREAM-P                                  */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2457open_stream_p(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_open_stream_p(v1stream);
  return value0;
 }
}
/*      local function OPEN-STREAM-P                                  */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2458open_stream_p(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("OPEN-STREAM-P",1687));
  return value0;
 }
}
/*      local function OUTPUT-STREAM-P                                */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2459output_stream_p(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function OUTPUT-STREAM-P                                */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2460output_stream_p(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_T;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function OUTPUT-STREAM-P                                */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2461output_stream_p(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_output_stream_p(v1stream);
  return value0;
 }
}
/*      local function OUTPUT-STREAM-P                                */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2462output_stream_p(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("OUTPUT-STREAM-P",1686));
  return value0;
 }
}
/*      local function STREAM-PEEK-CHAR                               */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2463stream_peek_char(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_object v2char;
   v2char = ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-READ-CHAR",1705))(1, v1stream) /*  STREAM-READ-CHAR */;
   if ((v2char)==(ECL_SYM("EOF",1256))) { goto L2; }
   ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-UNREAD-CHAR",1711))(2, v1stream, v2char) /*  STREAM-UNREAD-CHAR */;
L2:;
   value0 = v2char;
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}
/*      local function STREAM-PEEK-CHAR                               */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2464stream_peek_char(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_peek_char(1, v1stream);
  return value0;
 }
}
/*      local function STREAM-PEEK-CHAR                               */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2465stream_peek_char(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-PEEK-CHAR",1703));
  return value0;
 }
}
/*      local function STREAM-READ-BYTE                               */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2466stream_read_byte(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_read_byte(1, v1stream);
  return value0;
 }
}
/*      local function STREAM-READ-BYTE                               */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2467stream_read_byte(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-READ-BYTE",1704));
  return value0;
 }
}
/*      local function STREAM-READ-CHAR                               */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2468stream_read_char(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_read_char(1, v1stream);
  return value0;
 }
}
/*      local function STREAM-READ-CHAR                               */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2469stream_read_char(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-READ-CHAR",1705));
  return value0;
 }
}
/*      local function STREAM-UNREAD-CHAR                             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2470stream_unread_char(cl_object v1stream, cl_object v2character)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_unread_char(2, v2character, v1stream);
  return value0;
 }
}
/*      local function STREAM-UNREAD-CHAR                             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2471stream_unread_char(cl_object v1stream, cl_object v2character)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-UNREAD-CHAR",1711));
  return value0;
 }
}
/*      local function STREAM-READ-CHAR-NO-HANG                       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2472stream_read_char_no_hang(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-READ-CHAR",1705))(1, v1stream) /*  STREAM-READ-CHAR */;
  return value0;
 }
}
/*      local function STREAM-READ-CHAR-NO-HANG                       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2473stream_read_char_no_hang(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_read_char_no_hang(1, v1stream);
  return value0;
 }
}
/*      local function STREAM-READ-CHAR-NO-HANG                       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2474stream_read_char_no_hang(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-READ-CHAR-NO-HANG",1706));
  return value0;
 }
}
/*      local function STREAM-READ-LINE                               */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2475stream_read_line(cl_object v1stream)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_object v2;
   cl_object v3res;
   cl_object v4len;
   cl_object v5index;
   v2 = cl_make_string(1, ecl_make_fixnum(80));
   v3res = v2;
   v4len = ecl_make_fixnum(80);
   v5index = ecl_make_fixnum(0);
L5:;
   {
    cl_object v6ch;
    v6ch = ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-READ-CHAR",1705))(1, v1stream) /*  STREAM-READ-CHAR */;
    if (!((v6ch)==(ECL_SYM("EOF",1256)))) { goto L8; }
    T0 = ecl_function_dispatch(cl_env_copy,ECL_SYM("SHRINK-VECTOR",1876))(2, v3res, v5index) /*  SHRINK-VECTOR */;
    cl_env_copy->nvalues = 2;
    cl_env_copy->values[1] = ECL_T;
    cl_env_copy->values[0] = T0;
    return cl_env_copy->values[0];
L8:;
    if (!(ecl_char_code(v6ch)==ecl_char_code(ECL_CODE_CHAR(10)))) { goto L10; }
    T0 = ecl_function_dispatch(cl_env_copy,ECL_SYM("SHRINK-VECTOR",1876))(2, v3res, v5index) /*  SHRINK-VECTOR */;
    cl_env_copy->nvalues = 2;
    cl_env_copy->values[1] = ECL_NIL;
    cl_env_copy->values[0] = T0;
    return cl_env_copy->values[0];
L10:;
    if (!(ecl_number_equalp(v5index,v4len))) { goto L12; }
    v4len = ecl_times(v4len,ecl_make_fixnum(2));
    {
     cl_object v7new;
     v7new = cl_make_string(1, v4len);
     cl_replace(2, v7new, v3res);
     v3res = v7new;
    }
L12:;
    ecl_elt_set(v3res,ecl_to_size(v5index),v6ch);
    v5index = ecl_plus(v5index,ecl_make_fixnum(1));
   }
   goto L5;
  }
 }
}
/*      local function STREAM-READ-LINE                               */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2476stream_read_line(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_read_line(1, v1stream);
  return value0;
 }
}
/*      local function STREAM-READ-LINE                               */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2477stream_read_line(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-READ-LINE",1707));
  return value0;
 }
}
/*      function definition for CLOS-DEFAULT-READ-SEQUENCE            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L2478clos_default_read_sequence(cl_object v1stream, cl_object v2sequence, cl_object v3start, cl_object v4end)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  if (ecl_unlikely(!(ECL_LISTP(v2sequence) || ECL_VECTORP(v2sequence))))
           FEtype_error_sequence(v2sequence);
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 0;
  {
   bool v5;
   v5 = ECL_FIXNUMP(v3start);
   if (ecl_unlikely(!(v5)))
         FEwrong_type_argument(ECL_SYM("FIXNUM",374),v3start);
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 0;
  }
  {
   cl_object v5;
   cl_object v6;
   cl_fixnum v7end;
   value0 = v4end;
   if ((value0)!=ECL_NIL) { goto L5; }
   v5 = ecl_make_fixnum(ecl_length(v2sequence));
   goto L3;
L5:;
   v5 = value0;
   goto L3;
L3:;
   v6 = ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-ELEMENT-TYPE",1691))(1, v1stream) /*  STREAM-ELEMENT-TYPE */;
   {
    cl_object v8;
    v8 = v5;
    {
     bool v9;
     v9 = ECL_FIXNUMP(v8);
     if (ecl_unlikely(!(v9)))
         FEwrong_type_argument(ECL_SYM("FIXNUM",374),v8);
     value0 = ECL_NIL;
     cl_env_copy->nvalues = 0;
    }
    v7end = ecl_fixnum(v8);
   }
   if ((v6)==(ECL_SYM("CHARACTER",224))) { goto L13; }
   if (!((v6)==(ECL_SYM("BASE-CHAR",122)))) { goto L11; }
   goto L12;
L13:;
L12:;
   {
    cl_object v8pos;
    v8pos = v3start;
L16:;
    if (!(ecl_greatereq(v8pos,ecl_make_fixnum(v7end)))) { goto L18; }
    goto L17;
L18:;
    {
     cl_object v9c;
     v9c = ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-READ-CHAR",1705))(1, v1stream) /*  STREAM-READ-CHAR */;
     if (!(ecl_eql(v9c,ECL_SYM("EOF",1256)))) { goto L22; }
     value0 = v8pos;
     cl_env_copy->nvalues = 1;
     return value0;
L22:;
     ecl_elt_set(v2sequence,ecl_to_size(v8pos),v9c);
    }
    v8pos = ecl_one_plus(v8pos);
    goto L16;
L17:;
    value0 = v8pos;
    cl_env_copy->nvalues = 1;
    return value0;
   }
L11:;
   {
    cl_object v9pos;
    v9pos = v3start;
L29:;
    if (!(ecl_greatereq(v9pos,ecl_make_fixnum(v7end)))) { goto L31; }
    goto L30;
L31:;
    {
     cl_object v10b;
     v10b = ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-READ-BYTE",1704))(1, v1stream) /*  STREAM-READ-BYTE */;
     if (!(ecl_eql(v10b,ECL_SYM("EOF",1256)))) { goto L35; }
     value0 = v9pos;
     cl_env_copy->nvalues = 1;
     return value0;
L35:;
     ecl_elt_set(v2sequence,ecl_to_size(v9pos),v10b);
    }
    v9pos = ecl_one_plus(v9pos);
    goto L29;
L30:;
    value0 = v9pos;
    cl_env_copy->nvalues = 1;
    return value0;
   }
  }
 }
}
/*      local function STREAM-READ-SEQUENCE                           */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2479stream_read_sequence(cl_narg narg, cl_object v1stream, cl_object v2sequence, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<2)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>4)) FEwrong_num_arguments_anonym();
 {
  cl_object v3start;
  cl_object v4end;
  va_list args; va_start(args,v2sequence);
  {
   int i = 2;
   if (i >= narg) {
    v3start = ecl_make_fixnum(0);
   } else {
    i++;
    v3start = va_arg(args,cl_object);
   }
   if (i >= narg) {
    v4end = ECL_NIL;
   } else {
    i++;
    v4end = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = L2478clos_default_read_sequence(v1stream, v2sequence, v3start, v4end);
  return value0;
 }
}
/*      local function STREAM-READ-SEQUENCE                           */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2480stream_read_sequence(cl_narg narg, cl_object v1stream, cl_object v2sequence, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<2)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>4)) FEwrong_num_arguments_anonym();
 {
  cl_object v3start;
  cl_object v4end;
  va_list args; va_start(args,v2sequence);
  {
   int i = 2;
   if (i >= narg) {
    v3start = ecl_make_fixnum(0);
   } else {
    i++;
    v3start = va_arg(args,cl_object);
   }
   if (i >= narg) {
    v4end = ECL_NIL;
   } else {
    i++;
    v4end = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = L2478clos_default_read_sequence(v1stream, v2sequence, v3start, v4end);
  return value0;
 }
}
/*      local function STREAM-READ-SEQUENCE                           */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2481stream_read_sequence(cl_narg narg, cl_object v1stream, cl_object v2sequence, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<2)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>4)) FEwrong_num_arguments_anonym();
 {
  cl_object v3start;
  cl_object v4end;
  va_list args; va_start(args,v2sequence);
  {
   int i = 2;
   if (i >= narg) {
    v3start = ecl_make_fixnum(0);
   } else {
    i++;
    v3start = va_arg(args,cl_object);
   }
   if (i >= narg) {
    v4end = ECL_NIL;
   } else {
    i++;
    v4end = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = si_do_read_sequence(v2sequence, v1stream, v3start, v4end);
  return value0;
 }
}
/*      local function STREAM-READ-SEQUENCE                           */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2482stream_read_sequence(cl_narg narg, cl_object v1stream, cl_object v2sequence, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<2)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>4)) FEwrong_num_arguments_anonym();
 {
  cl_object v3start;
  cl_object v4end;
  va_list args; va_start(args,v2sequence);
  {
   int i = 2;
   if (i >= narg) {
    v3start = ECL_NIL;
   } else {
    i++;
    v3start = va_arg(args,cl_object);
   }
   if (i >= narg) {
    v4end = ECL_NIL;
   } else {
    i++;
    v4end = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-READ-SEQUENCE",1708));
  return value0;
 }
}
/*      local function STREAM-START-LINE-P                            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2483stream_start_line_p(cl_object v1stream)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  T0 = ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-LINE-COLUMN",1700))(1, v1stream) /*  STREAM-LINE-COLUMN */;
  value0 = ecl_make_bool((T0)==(ecl_make_fixnum(0)));
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-FILE-POSITION                           */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2484stream_file_position(cl_narg narg, cl_object v1stream, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<1)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>2)) FEwrong_num_arguments_anonym();
 {
  cl_object v2position;
  va_list args; va_start(args,v1stream);
  {
   int i = 1;
   if (i >= narg) {
    v2position = ECL_NIL;
   } else {
    i++;
    v2position = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = cl_file_position(2, v1stream, v2position);
  return value0;
 }
}
/*      local function STREAM-FILE-POSITION                           */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2485stream_file_position(cl_narg narg, cl_object v1stream, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<1)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>2)) FEwrong_num_arguments_anonym();
 {
  cl_object v2position;
  va_list args; va_start(args,v1stream);
  {
   int i = 1;
   if (i >= narg) {
    v2position = ECL_NIL;
   } else {
    i++;
    v2position = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-FILE-LENGTH                             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2486stream_file_length(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_file_length(v1stream);
  return value0;
 }
}
/*      local function STREAM-FILE-LENGTH                             */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2487stream_file_length(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_error(5, ECL_SYM("TYPE-ERROR",872), ECL_SYM("DATUM",1242), v1stream, ECL_SYM("EXPECTED-TYPE",1260), ECL_SYM("FILE-STREAM",360));
  return value0;
 }
}
/*      local function STREAM-FILE-STRING-LENGTH                      */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2488stream_file_string_length(cl_object v1stream, cl_object v2string)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_file_string_length(v1stream, v2string);
  return value0;
 }
}
/*      local function STREAM-FILE-STRING-LENGTH                      */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2489stream_file_string_length(cl_object v1stream, cl_object v2string)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAMP                                        */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2490streamp(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_T;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAMP                                        */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2491streamp(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-WRITE-BYTE                              */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2492stream_write_byte(cl_object v1stream, cl_object v2integer)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_write_byte(v2integer, v1stream);
  return value0;
 }
}
/*      local function STREAM-WRITE-BYTE                              */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2493stream_write_byte(cl_object v1stream, cl_object v2integer)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-WRITE-BYTE",1712));
  return value0;
 }
}
/*      local function STREAM-WRITE-CHAR                              */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2494stream_write_char(cl_object v1stream, cl_object v2character)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_write_char(2, v2character, v1stream);
  return value0;
 }
}
/*      local function STREAM-WRITE-CHAR                              */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2495stream_write_char(cl_object v1stream, cl_object v2character)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-WRITE-CHAR",1713));
  return value0;
 }
}
/*      function definition for CLOS-DEFAULT-WRITE-SEQUENCE           */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L2496clos_default_write_sequence(cl_object v1stream, cl_object v2sequence, cl_object v3start, cl_object v4end)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  if (ecl_unlikely(!(ECL_LISTP(v2sequence) || ECL_VECTORP(v2sequence))))
           FEtype_error_sequence(v2sequence);
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 0;
  {
   bool v5;
   v5 = ECL_FIXNUMP(v3start);
   if (ecl_unlikely(!(v5)))
         FEwrong_type_argument(ECL_SYM("FIXNUM",374),v3start);
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 0;
  }
  {
   cl_object v5;
   cl_object v6;
   cl_fixnum v7end;
   value0 = v4end;
   if ((value0)!=ECL_NIL) { goto L6; }
   v5 = ecl_make_fixnum(ecl_length(v2sequence));
   goto L4;
L6:;
   v5 = value0;
   goto L4;
L4:;
   v6 = ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-ELEMENT-TYPE",1691))(1, v1stream) /*  STREAM-ELEMENT-TYPE */;
   {
    cl_object v8;
    v8 = v5;
    {
     bool v9;
     v9 = ECL_FIXNUMP(v8);
     if (ecl_unlikely(!(v9)))
         FEwrong_type_argument(ECL_SYM("FIXNUM",374),v8);
     value0 = ECL_NIL;
     cl_env_copy->nvalues = 0;
    }
    v7end = ecl_fixnum(v8);
   }
   if ((v6)==(ECL_SYM("CHARACTER",224))) { goto L14; }
   if (!((v6)==(ECL_SYM("BASE-CHAR",122)))) { goto L12; }
   goto L13;
L14:;
L13:;
   {
    cl_object v8pos;
    v8pos = v3start;
L17:;
    if (!(ecl_greatereq(v8pos,ecl_make_fixnum(v7end)))) { goto L19; }
    goto L18;
L19:;
    T0 = ecl_elt(v2sequence,ecl_to_size(v8pos));
    ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-WRITE-CHAR",1713))(2, v1stream, T0) /*  STREAM-WRITE-CHAR */;
    v8pos = ecl_one_plus(v8pos);
    goto L17;
L18:;
    goto L3;
   }
L12:;
   {
    cl_object v9pos;
    v9pos = v3start;
L26:;
    if (!(ecl_greatereq(v9pos,ecl_make_fixnum(v7end)))) { goto L28; }
    goto L27;
L28:;
    T0 = ecl_elt(v2sequence,ecl_to_size(v9pos));
    ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-WRITE-BYTE",1712))(2, v1stream, T0) /*  STREAM-WRITE-BYTE */;
    v9pos = ecl_one_plus(v9pos);
    goto L26;
L27:;
   }
  }
L3:;
  value0 = v2sequence;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-WRITE-SEQUENCE                          */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2497stream_write_sequence(cl_narg narg, cl_object v1stream, cl_object v2sequence, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<2)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>4)) FEwrong_num_arguments_anonym();
 {
  cl_object v3start;
  cl_object v4end;
  va_list args; va_start(args,v2sequence);
  {
   int i = 2;
   if (i >= narg) {
    v3start = ecl_make_fixnum(0);
   } else {
    i++;
    v3start = va_arg(args,cl_object);
   }
   if (i >= narg) {
    v4end = ECL_NIL;
   } else {
    i++;
    v4end = va_arg(args,cl_object);
   }
  }
  va_end(args);
  if (!(ECL_STRINGP(v2sequence))) { goto L3; }
  value0 = ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-WRITE-STRING",1715))(4, v1stream, v2sequence, v3start, v4end) /*  STREAM-WRITE-STRING */;
  return value0;
L3:;
  value0 = L2496clos_default_write_sequence(v1stream, v2sequence, v3start, v4end);
  return value0;
 }
}
/*      local function STREAM-WRITE-SEQUENCE                          */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2498stream_write_sequence(cl_narg narg, cl_object v1stream, cl_object v2sequence, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<2)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>4)) FEwrong_num_arguments_anonym();
 {
  cl_object v3start;
  cl_object v4end;
  va_list args; va_start(args,v2sequence);
  {
   int i = 2;
   if (i >= narg) {
    v3start = ecl_make_fixnum(0);
   } else {
    i++;
    v3start = va_arg(args,cl_object);
   }
   if (i >= narg) {
    v4end = ECL_NIL;
   } else {
    i++;
    v4end = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = L2496clos_default_write_sequence(v1stream, v2sequence, v3start, v4end);
  return value0;
 }
}
/*      local function STREAM-WRITE-SEQUENCE                          */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2499stream_write_sequence(cl_narg narg, cl_object v1stream, cl_object v2sequence, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<2)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>4)) FEwrong_num_arguments_anonym();
 {
  cl_object v3start;
  cl_object v4end;
  va_list args; va_start(args,v2sequence);
  {
   int i = 2;
   if (i >= narg) {
    v3start = ecl_make_fixnum(0);
   } else {
    i++;
    v3start = va_arg(args,cl_object);
   }
   if (i >= narg) {
    v4end = ECL_NIL;
   } else {
    i++;
    v4end = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = si_do_write_sequence(v2sequence, v1stream, v3start, v4end);
  return value0;
 }
}
/*      local function STREAM-WRITE-SEQUENCE                          */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2500stream_write_sequence(cl_narg narg, cl_object v1stream, cl_object v2sequence, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<2)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>4)) FEwrong_num_arguments_anonym();
 {
  cl_object v3start;
  cl_object v4end;
  va_list args; va_start(args,v2sequence);
  {
   int i = 2;
   if (i >= narg) {
    v3start = ECL_NIL;
   } else {
    i++;
    v3start = va_arg(args,cl_object);
   }
   if (i >= narg) {
    v4end = ECL_NIL;
   } else {
    i++;
    v4end = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-WRITE-SEQUENCE",1714));
  return value0;
 }
}
/*      local function STREAM-WRITE-STRING                            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2501stream_write_string(cl_narg narg, cl_object v1stream, cl_object v2string, ...)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<2)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>4)) FEwrong_num_arguments_anonym();
 {
  cl_object v3start;
  cl_object v4end;
  va_list args; va_start(args,v2string);
  {
   int i = 2;
   if (i >= narg) {
    v3start = ecl_make_fixnum(0);
   } else {
    i++;
    v3start = va_arg(args,cl_object);
    {
     bool v5;
     v5 = ECL_FIXNUMP(v3start);
     if (ecl_unlikely(!(v5)))
         FEwrong_type_argument(ECL_SYM("FIXNUM",374),v3start);
     value0 = ECL_NIL;
     cl_env_copy->nvalues = 0;
    }
   }
   if (i >= narg) {
    v4end = ECL_NIL;
   } else {
    i++;
    v4end = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   bool v5;
   v5 = ECL_STRINGP(v2string);
   if (ecl_unlikely(!(v5)))
         FEwrong_type_argument(ECL_SYM("STRING",807),v2string);
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 0;
  }
  {
   cl_fixnum v5end;
   {
    cl_object v6;
    value0 = v4end;
    if ((value0)!=ECL_NIL) { goto L9; }
    v6 = ecl_make_fixnum(ecl_length(v2string));
    goto L7;
L9:;
    v6 = value0;
    goto L7;
L7:;
    {
     bool v7;
     v7 = ECL_FIXNUMP(v6);
     if (ecl_unlikely(!(v7)))
         FEwrong_type_argument(ECL_SYM("FIXNUM",374),v6);
     value0 = ECL_NIL;
     cl_env_copy->nvalues = 0;
    }
    v5end = ecl_fixnum(v6);
   }
   {
    cl_fixnum v6pos;
    {
     cl_fixnum v7;
     v7 = ecl_fixnum(v3start);
     {
      cl_fixnum v8;
      v8 = 0;
      v8 = v7;
      if (!((v8)<=(2305843009213693951))) { goto L23; }
      T0 = ecl_make_bool((v8)>=(0));
      goto L15;
L23:;
      T0 = ECL_NIL;
      goto L15;
      T0 = ECL_NIL;
      goto L15;
     }
L15:;
     if (ecl_unlikely(!((T0)!=ECL_NIL)))
         FEwrong_type_argument(VV[6],ecl_make_fixnum(v7));
     value0 = ECL_NIL;
     cl_env_copy->nvalues = 0;
     v6pos = v7;
    }
    goto L27;
L26:;
    {
     ecl_character v7;
     {
      cl_object v8;
      v8 = v2string;
      T0 = v8;
      {
       cl_fixnum v9;
       {
        cl_fixnum v10;
        v10 = v6pos;
        if (ecl_unlikely((v10)>=(v8)->vector.dim))
           FEwrong_index(ECL_NIL,v8,-1,ecl_make_fixnum(v10),(v8)->vector.dim);
        value0 = ECL_NIL;
        cl_env_copy->nvalues = 0;
        v9 = v10;
       }
       v7 = ECL_CHAR_CODE(ecl_aref_unsafe(T0,v9));
      }
     }
     ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-WRITE-CHAR",1713))(2, v1stream, ECL_CODE_CHAR(v7)) /*  STREAM-WRITE-CHAR */;
    }
    {
     cl_object v7;
     v7 = ecl_make_integer((v6pos)+1);
     {
      cl_fixnum v8;
      v8 = 0;
      if (!(ECL_FIXNUMP(v7))) { goto L43; }
      v8 = ecl_fixnum(v7);
      if (!((v8)<=(2305843009213693951))) { goto L48; }
      T0 = ecl_make_bool((v8)>=(0));
      goto L40;
L48:;
      T0 = ECL_NIL;
      goto L40;
L43:;
      T0 = ECL_NIL;
      goto L40;
     }
L40:;
     if (ecl_unlikely(!((T0)!=ECL_NIL)))
         FEwrong_type_argument(VV[6],v7);
     value0 = ECL_NIL;
     cl_env_copy->nvalues = 0;
     v6pos = ecl_fixnum(v7);
    }
L27:;
    if ((v6pos)>=(v5end)) { goto L50; }
    goto L26;
L50:;
   }
  }
  value0 = v2string;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-WRITE-STRING                            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2502stream_write_string(cl_narg narg, cl_object v1stream, cl_object v2string, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<2)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>4)) FEwrong_num_arguments_anonym();
 {
  cl_object v3start;
  cl_object v4end;
  va_list args; va_start(args,v2string);
  {
   int i = 2;
   if (i >= narg) {
    v3start = ecl_make_fixnum(0);
   } else {
    i++;
    v3start = va_arg(args,cl_object);
   }
   if (i >= narg) {
    v4end = ECL_NIL;
   } else {
    i++;
    v4end = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = cl_write_string(6, v2string, v1stream, ECL_SYM("START",1344), v3start, ECL_SYM("END",1253), v4end);
  return value0;
 }
}
/*      local function STREAM-WRITE-STRING                            */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2503stream_write_string(cl_narg narg, cl_object v1stream, cl_object v2string, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<2)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>4)) FEwrong_num_arguments_anonym();
 {
  cl_object v3start;
  cl_object v4end;
  va_list args; va_start(args,v2string);
  {
   int i = 2;
   if (i >= narg) {
    v3start = ECL_NIL;
   } else {
    i++;
    v3start = va_arg(args,cl_object);
   }
   if (i >= narg) {
    v4end = ECL_NIL;
   } else {
    i++;
    v4end = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-WRITE-STRING",1715));
  return value0;
 }
}
/*      local function STREAM-TERPRI                                  */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2504stream_terpri(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-WRITE-CHAR",1713))(2, v1stream, ECL_CODE_CHAR(10)) /*  STREAM-WRITE-CHAR */;
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-TERPRI                                  */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2505stream_terpri(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = ecl_terpri(v1stream);
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function STREAM-TERPRI                                  */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2506stream_terpri(cl_object v1stream)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-TERPRI",1710));
  return value0;
 }
}
/*      local function STREAM-FILE-DESCRIPTOR                         */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2507stream_file_descriptor(cl_narg narg, cl_object v1stream, ...)
{
 cl_object T0, T1;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<1)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>2)) FEwrong_num_arguments_anonym();
 {
  cl_object v2direction;
  va_list args; va_start(args,v1stream);
  {
   int i = 1;
   if (i >= narg) {
    v2direction = ECL_SYM("INPUT",1286);
   } else {
    i++;
    v2direction = va_arg(args,cl_object);
   }
  }
  va_end(args);
  {
   cl_object v4;                                  /*  PREDICATE       */
   cl_object v5;                                  /*  KIND            */
   if (!((v2direction)==(ECL_SYM("INPUT",1286)))) { goto L3; }
   cl_env_copy->nvalues = 2;
   cl_env_copy->values[1] = VV[7];
   cl_env_copy->values[0] = ECL_SYM("INPUT-STREAM-P",1685);
   value0 = cl_env_copy->values[0];
   goto L2;
L3:;
   if (!((v2direction)==(ECL_SYM("OUTPUT",1316)))) { goto L5; }
   cl_env_copy->nvalues = 2;
   cl_env_copy->values[1] = VV[8];
   cl_env_copy->values[0] = ECL_SYM("OUTPUT-STREAM-P",1686);
   value0 = cl_env_copy->values[0];
   goto L2;
L5:;
   T0 = ecl_list1(v2direction);
   value0 = cl_error(9, ECL_SYM("SIMPLE-TYPE-ERROR",775), ECL_SYM("FORMAT-CONTROL",1269), VV[9], ECL_SYM("FORMAT-ARGUMENTS",1268), T0, ECL_SYM("DATUM",1242), v2direction, ECL_SYM("EXPECTED-TYPE",1260), VV[10]);
L2:;
   {
    const int v6 = cl_env_copy->nvalues;
    v4 = value0;
    cl_object v7;
    v7 = (v6<=1)? ECL_NIL : cl_env_copy->values[1];
    v5 = v7;
   }
   if ((ecl_function_dispatch(cl_env_copy,v4)(1, v1stream))!=ECL_NIL) { goto L7; }
   T0 = cl_list(3, v5, v1stream, v2direction);
   T1 = cl_list(2, ECL_SYM("SATISFIES",737), v4);
   value0 = cl_error(9, ECL_SYM("SIMPLE-TYPE-ERROR",775), ECL_SYM("FORMAT-CONTROL",1269), VV[11], ECL_SYM("FORMAT-ARGUMENTS",1268), T0, ECL_SYM("DATUM",1242), v1stream, ECL_SYM("EXPECTED-TYPE",1260), T1);
   return value0;
L7:;
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}
/*      local function STREAM-FILE-DESCRIPTOR                         */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2508stream_file_descriptor(cl_narg narg, cl_object v1stream, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<1)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>2)) FEwrong_num_arguments_anonym();
 {
  cl_object v2direction;
  va_list args; va_start(args,v1stream);
  {
   int i = 1;
   if (i >= narg) {
    v2direction = ECL_NIL;
   } else {
    i++;
    v2direction = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = L2422bug_or_error(v1stream, ECL_SYM("STREAM-FILE-DESCRIPTOR",1692));
  return value0;
 }
}
/*      local function STREAM-FILE-DESCRIPTOR                         */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2509stream_file_descriptor(cl_narg narg, cl_object v1stream, ...)
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<1)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>2)) FEwrong_num_arguments_anonym();
 {
  cl_object v2direction;
  va_list args; va_start(args,v1stream);
  {
   int i = 1;
   if (i >= narg) {
    v2direction = ECL_SYM("INPUT",1286);
   } else {
    i++;
    v2direction = va_arg(args,cl_object);
   }
  }
  va_end(args);
  if (!((v2direction)==(ECL_SYM("INPUT",1286)))) { goto L3; }
  T0 = cl_two_way_stream_input_stream(v1stream);
  goto L2;
L3:;
  if (!((v2direction)==(ECL_SYM("OUTPUT",1316)))) { goto L5; }
  T0 = cl_two_way_stream_output_stream(v1stream);
  goto L2;
L5:;
  T0 = ECL_NIL;
L2:;
  value0 = ecl_function_dispatch(cl_env_copy,ECL_SYM("STREAM-FILE-DESCRIPTOR",1692))(2, T0, v2direction) /*  STREAM-FILE-DESCRIPTOR */;
  return value0;
 }
}
/*      local function STREAM-FILE-DESCRIPTOR                         */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2510stream_file_descriptor(cl_narg narg, cl_object v1stream, ...)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 if (ecl_unlikely(narg<1)) FEwrong_num_arguments_anonym();
 if (ecl_unlikely(narg>2)) FEwrong_num_arguments_anonym();
 {
  cl_object v2direction;
  va_list args; va_start(args,v1stream);
  {
   int i = 1;
   if (i >= narg) {
    v2direction = ECL_SYM("INPUT",1286);
   } else {
    i++;
    v2direction = va_arg(args,cl_object);
   }
  }
  va_end(args);
  value0 = si_file_stream_fd(v1stream);
  return value0;
 }
}
/*      local function PATHNAME                                       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2511pathname(cl_object v1pathspec)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_pathname(v1pathspec);
  return value0;
 }
}
/*      local function PATHNAME                                       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2512pathname(cl_object v1pathspec)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = v1pathspec;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      local function PATHNAME                                       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2513pathname(cl_object v1pathspec)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_pathname(v1pathspec);
  return value0;
 }
}
/*      local function PATHNAME                                       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2514pathname(cl_object v1pathspec)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_error(5, ECL_SYM("TYPE-ERROR",872), ECL_SYM("DATUM",1242), v1pathspec, ECL_SYM("EXPECTED-TYPE",1260), VV[12]);
  return value0;
 }
}
/*      local function TRUENAME                                       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2515truename(cl_object v1filespec)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_truename(v1filespec);
  return value0;
 }
}
/*      local function TRUENAME                                       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2516truename(cl_object v1filespec)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_truename(v1filespec);
  return value0;
 }
}
/*      local function TRUENAME                                       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2517truename(cl_object v1filespec)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_truename(v1filespec);
  return value0;
 }
}
/*      local function TRUENAME                                       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2518truename(cl_object v1filespec)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  value0 = cl_error(5, ECL_SYM("TYPE-ERROR",872), ECL_SYM("DATUM",1242), v1filespec, ECL_SYM("EXPECTED-TYPE",1260), VV[12]);
  return value0;
 }
}
/*      function definition for %REDEFINE-CL-FUNCTIONS                */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L2519_redefine_cl_functions(cl_object v1cl_symbol, cl_object v2gray_symbol, cl_object v3gray_package)
{
 cl_object T0, T1;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  T0 = cl_fdefinition(v1cl_symbol);
  if ((si_of_class_p(2, T0, ECL_SYM("GENERIC-FUNCTION",947)))!=ECL_NIL) { goto L1; }
  {
   cl_object v4gf;
   v4gf = cl_fdefinition(v2gray_symbol);
   si_fset(2, v1cl_symbol, v4gf);
   T0 = ecl_symbol_name(v1cl_symbol);
   T1 = ecl_symbol_name(v2gray_symbol);
   if (!(ecl_string_eq(T0,T1))) { goto L5; }
   cl_unintern(2, v2gray_symbol, v3gray_package);
   cl_import(2, v1cl_symbol, v3gray_package);
   cl_export(2, v1cl_symbol, v3gray_package);
L5:;
   value0 = (cl_env_copy->function=ECL_CONS_CAR(VV[28]))->cfun.entry(3, v1cl_symbol, v4gf, ECL_SYM("NAME",1606)) /*  (SETF SLOT-VALUE) */;
   return value0;
  }
L1:;
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}
/*      function definition for REDEFINE-CL-FUNCTIONS                 */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object L2520redefine_cl_functions()
{
 cl_object T0;
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  {
   cl_object v1;
   cl_object v2;
   v1 = si_package_lock(VV[14], ECL_NIL);
   v2 = cl_find_package(VV[15]);
   {
    cl_object v3cl_symbol;
    cl_object v4;
    v3cl_symbol = ECL_NIL;
    v4 = VV[16];
    {
     cl_object v5gray_symbol;
     v5gray_symbol = ECL_NIL;
L7:;
     v3cl_symbol = ECL_CONS_CAR(v4);
     {
      cl_object v6;
      v6 = ECL_CONS_CDR(v4);
      if (ecl_unlikely(!ECL_LISTP(v6))) FEtype_error_list(v6);
      value0 = ECL_NIL;
      cl_env_copy->nvalues = 0;
      v4 = v6;
     }
     T0 = ecl_symbol_name(v3cl_symbol);
     v5gray_symbol = cl_find_symbol(2, T0, v2);
     L2519_redefine_cl_functions(v3cl_symbol, v5gray_symbol, v2);
     if (!(ecl_endp(v4))) { goto L18; }
     goto L8;
L18:;
     goto L7;
L8:;
    }
   }
   L2519_redefine_cl_functions(ECL_SYM("FILE-POSITION",359), ECL_SYM("STREAM-FILE-POSITION",1694), v2);
   L2519_redefine_cl_functions(ECL_SYM("FILE-LENGTH",357), ECL_SYM("STREAM-FILE-LENGTH",1693), v2);
   si_package_lock(VV[14], v1);
   cl_provide(VV[17]);
   value0 = ECL_NIL;
   cl_env_copy->nvalues = 1;
   return value0;
  }
 }
}
/*      local function LAMBDA94                                       */
/*      optimize speed 1, debug 1, space 1, safety 2                  */
static cl_object LC2521__lambda94(cl_object v1module)
{
 cl_object env0 = ECL_NIL;
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 ecl_cs_check(cl_env_copy,value0);
 {
TTL:
  if (Null(cl_string_equal(2, v1module, VV[20]))) { goto L1; }
  L2520redefine_cl_functions();
  value0 = ECL_T;
  cl_env_copy->nvalues = 1;
  return value0;
L1:;
  value0 = ECL_NIL;
  cl_env_copy->nvalues = 1;
  return value0;
 }
}

#include "clos/streams.data"
#ifdef __cplusplus
extern "C"
#endif
ECL_DLLEXPORT void _eclT9LBgSoBij8q9_xk24ud71(cl_object flag)
{
 const cl_env_ptr cl_env_copy = ecl_process_env();
 cl_object value0;
 cl_object *VVtemp;
 if (flag != OBJNULL){
 Cblock = flag;
 #ifndef ECL_DYNAMIC_VV
 flag->cblock.data = VV;
 #endif
 flag->cblock.data_size = VM;
 flag->cblock.temp_data_size = VMtemp;
 flag->cblock.data_text = compiler_data_text;
 flag->cblock.cfuns_size = compiler_cfuns_size;
 flag->cblock.cfuns = compiler_cfuns;
 flag->cblock.source = ecl_make_constant_base_string("SRC:CLOS;STREAMS.LSP.NEWEST",-1);
 return;}
 #ifdef ECL_DYNAMIC_VV
 VV = Cblock->cblock.data;
 #endif
 Cblock->cblock.data_text = (const cl_object *)"@EcLtAg:_eclT9LBgSoBij8q9_xk24ud71@";
 VVtemp = Cblock->cblock.temp_data;
 ECL_DEFINE_SETF_FUNCTIONS
  si_select_package(VVtemp[0]);
  cl_import(1, ECL_SYM("ANSI-STREAM",1871));
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-ADVANCE-TO-COLUMN",1688), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[1], ECL_SYM("DOCUMENTATION",1250), VVtemp[2]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-CLEAR-INPUT",1689), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[4]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-CLEAR-OUTPUT",1690), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[5]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("CLOSE",1683), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[6], ECL_SYM("DOCUMENTATION",1250), VVtemp[7]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-ELEMENT-TYPE",1691), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[8]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-FINISH-OUTPUT",1696), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[9]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-FORCE-OUTPUT",1697), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[10]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-FRESH-LINE",1698), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[11]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("INPUT-STREAM-P",1685), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[12]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, VV[1], VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[13]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-INTERACTIVE-P",1699), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[14]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-LINE-COLUMN",1700), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[15]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-LINE-LENGTH",1701), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[16]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(5, ECL_SYM("STREAM-LISTEN",1702), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("OPEN-STREAM-P",1687), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[17]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("OUTPUT-STREAM-P",1686), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[18]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-PEEK-CHAR",1703), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[19]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-READ-BYTE",1704), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[20]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-READ-CHAR",1705), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[21]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-READ-CHAR-NO-HANG",1706), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[22]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-READ-LINE",1707), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[23]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-READ-SEQUENCE",1708), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[24], ECL_SYM("DOCUMENTATION",1250), VVtemp[25]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-START-LINE-P",1709), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[26]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-TERPRI",1710), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[27]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-UNREAD-CHAR",1711), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[28], ECL_SYM("DOCUMENTATION",1250), VVtemp[29]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-WRITE-BYTE",1712), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[30], ECL_SYM("DOCUMENTATION",1250), VVtemp[31]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-WRITE-CHAR",1713), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[28], ECL_SYM("DOCUMENTATION",1250), VVtemp[32]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-WRITE-STRING",1715), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[33], ECL_SYM("DOCUMENTATION",1250), VVtemp[34]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-WRITE-SEQUENCE",1714), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[24], ECL_SYM("DOCUMENTATION",1250), VVtemp[35]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-FILE-POSITION",1694), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[36], ECL_SYM("DOCUMENTATION",1250), VVtemp[37]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-FILE-LENGTH",1693), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[3], ECL_SYM("DOCUMENTATION",1250), VVtemp[38]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-FILE-STRING-LENGTH",1695), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[39], ECL_SYM("DOCUMENTATION",1250), VVtemp[40]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("STREAM-FILE-DESCRIPTOR",1692), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[41], ECL_SYM("DOCUMENTATION",1250), VVtemp[42]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("PATHNAME",1681), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[43], ECL_SYM("DOCUMENTATION",1250), VVtemp[44]) /*  ENSURE-GENERIC-FUNCTION */;
  (cl_env_copy->function=(ECL_SYM("ENSURE-GENERIC-FUNCTION",944)->symbol.gfdef))->cfun.entry(7, ECL_SYM("TRUENAME",1682), VV[0], ECL_T, ECL_SYM("LAMBDA-LIST",1000), VVtemp[43], ECL_SYM("DOCUMENTATION",1250), VVtemp[45]) /*  ENSURE-GENERIC-FUNCTION */;
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  ecl_bds_bind(cl_env_copy,VV[2],ECL_SYM("MAP-DEPENDENTS",1600)); /*  *CLOS-BOOTED* */
  T0 = cl_list(2, ECL_SYM("DOCUMENTATION",1250), VVtemp[48]);
  clos_load_defclass(ECL_SYM("FUNDAMENTAL-STREAM",1716), VVtemp[46], VVtemp[47], T0);
  ecl_bds_unwind1(cl_env_copy);
 }
  clos_load_defclass(ECL_SYM("FUNDAMENTAL-INPUT-STREAM",1717), VVtemp[49], ECL_NIL, ECL_NIL);
  clos_load_defclass(ECL_SYM("FUNDAMENTAL-OUTPUT-STREAM",1718), VVtemp[49], ECL_NIL, ECL_NIL);
  clos_load_defclass(ECL_SYM("FUNDAMENTAL-CHARACTER-STREAM",1719), VVtemp[49], ECL_NIL, ECL_NIL);
  clos_load_defclass(ECL_SYM("FUNDAMENTAL-BINARY-STREAM",1720), VVtemp[49], ECL_NIL, ECL_NIL);
  clos_load_defclass(ECL_SYM("FUNDAMENTAL-CHARACTER-INPUT-STREAM",1721), VVtemp[50], ECL_NIL, ECL_NIL);
  clos_load_defclass(ECL_SYM("FUNDAMENTAL-CHARACTER-OUTPUT-STREAM",1722), VVtemp[51], ECL_NIL, ECL_NIL);
  clos_load_defclass(ECL_SYM("FUNDAMENTAL-BINARY-INPUT-STREAM",1723), VVtemp[52], ECL_NIL, ECL_NIL);
  clos_load_defclass(ECL_SYM("FUNDAMENTAL-BINARY-OUTPUT-STREAM",1724), VVtemp[53], ECL_NIL, ECL_NIL);
  (void)0; /* No entry created for BUG-OR-ERROR */
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2423stream_advance_to_column,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-ADVANCE-TO-COLUMN",1688), ECL_NIL, VVtemp[54], VVtemp[1], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2424stream_clear_input,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-CLEAR-INPUT",1689), ECL_NIL, VVtemp[55], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2425stream_clear_input,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-CLEAR-INPUT",1689), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2426stream_clear_input,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-CLEAR-INPUT",1689), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2427stream_clear_output,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-CLEAR-OUTPUT",1690), ECL_NIL, VVtemp[58], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2428stream_clear_output,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-CLEAR-OUTPUT",1690), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2429stream_clear_output,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-CLEAR-OUTPUT",1690), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2430close,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("CLOSE",1683), ECL_NIL, VVtemp[49], VVtemp[6], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2431close,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("CLOSE",1683), ECL_NIL, VVtemp[56], VVtemp[6], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2432close,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("CLOSE",1683), ECL_NIL, VVtemp[3], VVtemp[6], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2433stream_element_type,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-ELEMENT-TYPE",1691), ECL_NIL, VVtemp[59], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2434stream_element_type,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-ELEMENT-TYPE",1691), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2435stream_element_type,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-ELEMENT-TYPE",1691), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2436stream_finish_output,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FINISH-OUTPUT",1696), ECL_NIL, VVtemp[58], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2437stream_finish_output,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FINISH-OUTPUT",1696), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2438stream_finish_output,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FINISH-OUTPUT",1696), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2439stream_force_output,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FORCE-OUTPUT",1697), ECL_NIL, VVtemp[58], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2440stream_force_output,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FORCE-OUTPUT",1697), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2441stream_force_output,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FORCE-OUTPUT",1697), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2442stream_fresh_line,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FRESH-LINE",1698), ECL_NIL, VVtemp[60], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2443stream_fresh_line,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FRESH-LINE",1698), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2444input_stream_p,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("INPUT-STREAM-P",1685), ECL_NIL, VVtemp[49], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2445input_stream_p,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("INPUT-STREAM-P",1685), ECL_NIL, VVtemp[61], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2446input_stream_p,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("INPUT-STREAM-P",1685), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2447input_stream_p,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("INPUT-STREAM-P",1685), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2448stream_interactive_p,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-INTERACTIVE-P",1699), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2449stream_interactive_p,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-INTERACTIVE-P",1699), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2450stream_line_column,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-LINE-COLUMN",1700), ECL_NIL, VVtemp[60], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2451stream_line_length,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-LINE-LENGTH",1701), ECL_NIL, VVtemp[60], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2452stream_line_length,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-LINE-LENGTH",1701), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2453stream_line_length,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-LINE-LENGTH",1701), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2454stream_listen,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-LISTEN",1702), ECL_NIL, VVtemp[55], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2455stream_listen,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-LISTEN",1702), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2456stream_listen,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-LISTEN",1702), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2457open_stream_p,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("OPEN-STREAM-P",1687), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2458open_stream_p,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("OPEN-STREAM-P",1687), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2459output_stream_p,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("OUTPUT-STREAM-P",1686), ECL_NIL, VVtemp[49], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2460output_stream_p,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("OUTPUT-STREAM-P",1686), ECL_NIL, VVtemp[58], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2461output_stream_p,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("OUTPUT-STREAM-P",1686), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2462output_stream_p,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("OUTPUT-STREAM-P",1686), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2463stream_peek_char,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-PEEK-CHAR",1703), ECL_NIL, VVtemp[55], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2464stream_peek_char,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-PEEK-CHAR",1703), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2465stream_peek_char,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-PEEK-CHAR",1703), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2466stream_read_byte,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-READ-BYTE",1704), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2467stream_read_byte,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-READ-BYTE",1704), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2468stream_read_char,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-READ-CHAR",1705), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2469stream_read_char,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-READ-CHAR",1705), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2470stream_unread_char,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-UNREAD-CHAR",1711), ECL_NIL, VVtemp[62], VVtemp[28], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2471stream_unread_char,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-UNREAD-CHAR",1711), ECL_NIL, VVtemp[62], VVtemp[28], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2472stream_read_char_no_hang,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-READ-CHAR-NO-HANG",1706), ECL_NIL, VVtemp[55], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2473stream_read_char_no_hang,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-READ-CHAR-NO-HANG",1706), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2474stream_read_char_no_hang,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-READ-CHAR-NO-HANG",1706), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2475stream_read_line,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-READ-LINE",1707), ECL_NIL, VVtemp[55], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2476stream_read_line,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-READ-LINE",1707), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2477stream_read_line,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-READ-LINE",1707), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
  ecl_cmp_defun(VV[24]);                          /*  CLOS-DEFAULT-READ-SEQUENCE */
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2479stream_read_sequence,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-READ-SEQUENCE",1708), ECL_NIL, VVtemp[63], VVtemp[64], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2480stream_read_sequence,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-READ-SEQUENCE",1708), ECL_NIL, VVtemp[65], VVtemp[64], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2481stream_read_sequence,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-READ-SEQUENCE",1708), ECL_NIL, VVtemp[62], VVtemp[64], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2482stream_read_sequence,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-READ-SEQUENCE",1708), ECL_NIL, VVtemp[66], VVtemp[24], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2483stream_start_line_p,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-START-LINE-P",1709), ECL_NIL, VVtemp[60], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2484stream_file_position,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FILE-POSITION",1694), ECL_NIL, VVtemp[56], VVtemp[36], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2485stream_file_position,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FILE-POSITION",1694), ECL_NIL, VVtemp[57], VVtemp[36], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2486stream_file_length,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FILE-LENGTH",1693), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2487stream_file_length,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FILE-LENGTH",1693), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2488stream_file_string_length,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FILE-STRING-LENGTH",1695), ECL_NIL, VVtemp[62], VVtemp[39], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2489stream_file_string_length,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FILE-STRING-LENGTH",1695), ECL_NIL, VVtemp[54], VVtemp[39], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2490streamp,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAMP",1684), ECL_NIL, VVtemp[3], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2491streamp,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAMP",1684), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2492stream_write_byte,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-WRITE-BYTE",1712), ECL_NIL, VVtemp[62], VVtemp[30], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2493stream_write_byte,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-WRITE-BYTE",1712), ECL_NIL, VVtemp[66], VVtemp[30], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2494stream_write_char,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-WRITE-CHAR",1713), ECL_NIL, VVtemp[62], VVtemp[28], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2495stream_write_char,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-WRITE-CHAR",1713), ECL_NIL, VVtemp[66], VVtemp[28], T0) /*  INSTALL-METHOD */;
 }
  ecl_cmp_defun(VV[25]);                          /*  CLOS-DEFAULT-WRITE-SEQUENCE */
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2497stream_write_sequence,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-WRITE-SEQUENCE",1714), ECL_NIL, VVtemp[54], VVtemp[67], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2498stream_write_sequence,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-WRITE-SEQUENCE",1714), ECL_NIL, VVtemp[68], VVtemp[67], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2499stream_write_sequence,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-WRITE-SEQUENCE",1714), ECL_NIL, VVtemp[62], VVtemp[67], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2500stream_write_sequence,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-WRITE-SEQUENCE",1714), ECL_NIL, VVtemp[66], VVtemp[24], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2501stream_write_string,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-WRITE-STRING",1715), ECL_NIL, VVtemp[54], VVtemp[69], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2502stream_write_string,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-WRITE-STRING",1715), ECL_NIL, VVtemp[62], VVtemp[69], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2503stream_write_string,ECL_NIL,Cblock,2);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-WRITE-STRING",1715), ECL_NIL, VVtemp[66], VVtemp[33], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2504stream_terpri,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-TERPRI",1710), ECL_NIL, VVtemp[60], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2505stream_terpri,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-TERPRI",1710), ECL_NIL, VVtemp[56], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2506stream_terpri,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-TERPRI",1710), ECL_NIL, VVtemp[57], VVtemp[3], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2507stream_file_descriptor,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FILE-DESCRIPTOR",1692), VVtemp[70], VVtemp[57], VVtemp[71], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2508stream_file_descriptor,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FILE-DESCRIPTOR",1692), ECL_NIL, VVtemp[57], VVtemp[41], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2509stream_file_descriptor,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FILE-DESCRIPTOR",1692), ECL_NIL, VVtemp[72], VVtemp[71], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun_va((cl_objectfn)LC2510stream_file_descriptor,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("STREAM-FILE-DESCRIPTOR",1692), ECL_NIL, VVtemp[73], VVtemp[71], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2511pathname,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("PATHNAME",1681), ECL_NIL, VVtemp[74], VVtemp[43], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2512pathname,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("PATHNAME",1681), ECL_NIL, VVtemp[75], VVtemp[43], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2513pathname,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("PATHNAME",1681), ECL_NIL, VVtemp[56], VVtemp[43], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2514pathname,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("PATHNAME",1681), ECL_NIL, VVtemp[57], VVtemp[43], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2515truename,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("TRUENAME",1682), ECL_NIL, VVtemp[74], VVtemp[76], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2516truename,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("TRUENAME",1682), ECL_NIL, VVtemp[75], VVtemp[76], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2517truename,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("TRUENAME",1682), ECL_NIL, VVtemp[56], VVtemp[76], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2518truename,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  ecl_function_dispatch(cl_env_copy,VV[21])(5, ECL_SYM("TRUENAME",1682), ECL_NIL, VVtemp[57], VVtemp[76], T0) /*  INSTALL-METHOD */;
 }
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object v1p;
   v1p = cl_find_package(VVtemp[0]);
   cl_export(2, VVtemp[77], v1p);
   {
    cl_object v2;
    cl_object v3;
    cl_object v4s;
    T0 = cl_find_package(VVtemp[78]);
    v2 = ecl_function_dispatch(cl_env_copy,VV[26])(3, T0, VVtemp[79], ECL_T) /*  PACKAGES-ITERATOR */;
    v3 = ECL_NIL;
    v4s = ECL_NIL;
    goto L253;
L252:;
    value0 = ecl_function_dispatch(cl_env_copy,v2)(0);
    {
     const int v5 = cl_env_copy->nvalues;
     v3 = value0;
     cl_object v6;
     v6 = (v5<=1)? ECL_NIL : cl_env_copy->values[1];
     v4s = v6;
    }
    if ((v3)!=ECL_NIL) { goto L257; }
    goto L245;
L257:;
    {
     cl_object v5;
     cl_object v6;
     v5 = v4s;
     v6 = VVtemp[80];
     if ((ecl_memql(v5,v6))!=ECL_NIL) { goto L259; }
    }
    cl_export(2, v4s, v1p);
L259:;
L253:;
    goto L252;
   }
  }
L245:;
 }
  ecl_cmp_defun(VV[27]);                          /*  %REDEFINE-CL-FUNCTIONS */
  ecl_cmp_defun(VV[29]);                          /*  REDEFINE-CL-FUNCTIONS */
  cl_set(ECL_SYM("*FEATURES*",36),cl_adjoin(2, VV[19], ecl_symbol_value(ECL_SYM("*FEATURES*",36))));
 {
  cl_object T0;
  cl_object volatile env0 = ECL_NIL;
  {
   cl_object volatile v1;
   v1 = ecl_make_cfun((cl_objectfn_fixed)LC2521__lambda94,ECL_NIL,Cblock,1);
   T0 = v1;
  }
  cl_set(ECL_SYM("*MODULE-PROVIDER-FUNCTIONS*",44),cl_adjoin(2, T0, ecl_symbol_value(ECL_SYM("*MODULE-PROVIDER-FUNCTIONS*",44))));
 }
  cl_set(VV[2],ECL_T);
}
