/* utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from utils.vala, do not modify */

/* SPDX-FileCopyrightText: 2010-2020 Sébastien Wilmet
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <tepl/tepl.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

VALA_EXTERN const gchar* utils_get_string_from_resource (const gchar* resource_path);
VALA_EXTERN void utils_delete_file (GFile* file);
VALA_EXTERN gboolean utils_save_file (GFile* file,
                          const gchar* contents,
                          gboolean make_backup);
VALA_EXTERN gchar* utils_load_file (GFile* file);
VALA_EXTERN GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
VALA_EXTERN gint utils_get_selected_row (GtkTreeView* view,
                             GtkTreeIter* iter);
static void _vala_GtkTreePath_free (GtkTreePath* self);
VALA_EXTERN void utils_flush_queue (void);

/*************************************************************************/
const gchar*
utils_get_string_from_resource (const gchar* resource_path)
{
	GError* _inner_error0_ = NULL;
	const gchar* result;
	g_return_val_if_fail (resource_path != NULL, NULL);
	{
		GBytes* bytes = NULL;
		GBytes* _tmp0_;
		gsize _tmp1_ = 0;
		guint8* _tmp2_;
		_tmp0_ = g_resources_lookup_data (resource_path, 0, &_inner_error0_);
		bytes = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_bytes_get_data (bytes, &_tmp1_);
		result = (const gchar*) _tmp2_;
		_g_bytes_unref0 (bytes);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("utils.vala:21: Failed to load data from resource '%s': %s", resource_path, _tmp4_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

/*************************************************************************/
void
utils_delete_file (GFile* file)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	if (!g_file_query_exists (file, NULL)) {
		return;
	}
	{
		g_file_delete (file, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = g_file_get_parse_name (file);
		_tmp1_ = _tmp0_;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("utils.vala:44: Delete file '%s' failed: %s", _tmp1_, _tmp3_);
		_g_free0 (_tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gboolean
utils_save_file (GFile* file,
                 const gchar* contents,
                 gboolean make_backup)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (contents != NULL, FALSE);
	{
		guint8* _tmp0_;
		gint _tmp0__length1;
		gint _tmp1_ = 0;
		guint8* _tmp2_;
		gint _tmp2__length1;
		tepl_utils_create_parent_directories (file, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp0_ = string_get_data (contents, &_tmp1_);
		_tmp0__length1 = _tmp1_;
		_tmp2_ = _tmp0_;
		_tmp2__length1 = _tmp0__length1;
		g_file_replace_contents (file, (const char*) _tmp2_, (gsize) _tmp2__length1, NULL, make_backup, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = g_file_get_parse_name (file);
		_tmp4_ = _tmp3_;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("utils.vala:59: Failed to save the file '%s': %s", _tmp4_, _tmp6_);
		_g_free0 (_tmp4_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	result = TRUE;
	return result;
}

gchar*
utils_load_file (GFile* file)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		guint8* _tmp0_ = NULL;
		gsize _tmp1_ = 0;
		guint8* _tmp2_;
		gint _tmp2__length1;
		g_file_load_contents (file, NULL, &_tmp0_, &_tmp1_, NULL, &_inner_error0_);
		chars = (g_free (chars), NULL);
		chars = _tmp0_;
		chars_length1 = _tmp1_;
		_chars_size_ = chars_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			chars = (g_free (chars), NULL);
			goto __catch0_g_error;
		}
		_tmp2_ = chars;
		_tmp2__length1 = chars_length1;
		chars = NULL;
		chars_length1 = 0;
		result = (gchar*) _tmp2_;
		chars = (g_free (chars), NULL);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = g_file_get_parse_name (file);
		_tmp4_ = _tmp3_;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("utils.vala:78: Failed to load the file '%s': %s", _tmp4_, _tmp6_);
		_g_free0 (_tmp4_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

/*************************************************************************/
GtkScrolledWindow*
utils_add_scrollbar (GtkWidget* child)
{
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkScrolledWindow* result;
	g_return_val_if_fail (child != NULL, NULL);
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	sw = _tmp0_;
	gtk_container_add ((GtkContainer*) sw, child);
	result = sw;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

gint
utils_get_selected_row (GtkTreeView* view,
                        GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	gint result;
	g_return_val_if_fail (view != NULL, 0);
	_tmp0_ = gtk_tree_view_get_selection (view);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	select = _tmp1_;
	_tmp2_ = select;
	_tmp4_ = gtk_tree_selection_get_selected (_tmp2_, NULL, &_tmp3_);
	_vala_iter = _tmp3_;
	if (_tmp4_) {
		GtkTreeModel* model = NULL;
		GtkTreeModel* _tmp5_;
		GtkTreeModel* _tmp6_;
		GtkTreePath* path = NULL;
		GtkTreeModel* _tmp7_;
		GtkTreeIter _tmp8_;
		GtkTreePath* _tmp9_;
		GtkTreePath* _tmp10_;
		gint _tmp11_ = 0;
		gint* _tmp12_;
		gint _tmp13_;
		_tmp5_ = gtk_tree_view_get_model (view);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		model = _tmp6_;
		_tmp7_ = model;
		_tmp8_ = _vala_iter;
		_tmp9_ = gtk_tree_model_get_path (_tmp7_, &_tmp8_);
		path = _tmp9_;
		_tmp10_ = path;
		_tmp12_ = gtk_tree_path_get_indices_with_depth (_tmp10_, &_tmp11_);
		_tmp13_ = _tmp12_[0];
		result = _tmp13_;
		__vala_GtkTreePath_free0 (path);
		_g_object_unref0 (model);
		_g_object_unref0 (select);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	result = -1;
	_g_object_unref0 (select);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

/*************************************************************************/
void
utils_flush_queue (void)
{
	while (TRUE) {
		if (!gtk_events_pending ()) {
			break;
		}
		gtk_main_iteration ();
	}
}

