/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-amd-kria-som-eeprom-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_struct_ipmi_common_ref: (skip):
 **/
FuStructIpmiCommon *
fu_struct_ipmi_common_ref(FuStructIpmiCommon *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ipmi_common_unref: (skip):
 **/
void
fu_struct_ipmi_common_unref(FuStructIpmiCommon *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructIpmiCommon refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ipmi_common_new_internal: (skip):
 **/
static FuStructIpmiCommon *
fu_struct_ipmi_common_new_internal(void)
{
    FuStructIpmiCommon *st = g_new0(FuStructIpmiCommon, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ipmi_common_get_version: (skip):
 **/
guint8
fu_struct_ipmi_common_get_version(const FuStructIpmiCommon *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_ipmi_common_get_internal_offest: (skip):
 **/
guint8
fu_struct_ipmi_common_get_internal_offest(const FuStructIpmiCommon *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_ipmi_common_get_chassis_offeset: (skip):
 **/
guint8
fu_struct_ipmi_common_get_chassis_offeset(const FuStructIpmiCommon *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_ipmi_common_get_board_offset: (skip):
 **/
guint8
fu_struct_ipmi_common_get_board_offset(const FuStructIpmiCommon *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_ipmi_common_get_product_offset: (skip):
 **/
guint8
fu_struct_ipmi_common_get_product_offset(const FuStructIpmiCommon *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_ipmi_common_get_multirecord_offset: (skip):
 **/
guint8
fu_struct_ipmi_common_get_multirecord_offset(const FuStructIpmiCommon *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_ipmi_common_get_checksum: (skip):
 **/
guint8
fu_struct_ipmi_common_get_checksum(const FuStructIpmiCommon *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}

/* setters */
/**
 * fu_struct_ipmi_common_to_string: (skip):
 **/
static gchar *
fu_struct_ipmi_common_to_string(const FuStructIpmiCommon *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIpmiCommon:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_ipmi_common_get_version(st));
    g_string_append_printf(str, "  internal_offest: 0x%x\n",
                           (guint) fu_struct_ipmi_common_get_internal_offest(st));
    g_string_append_printf(str, "  chassis_offeset: 0x%x\n",
                           (guint) fu_struct_ipmi_common_get_chassis_offeset(st));
    g_string_append_printf(str, "  board_offset: 0x%x\n",
                           (guint) fu_struct_ipmi_common_get_board_offset(st));
    g_string_append_printf(str, "  product_offset: 0x%x\n",
                           (guint) fu_struct_ipmi_common_get_product_offset(st));
    g_string_append_printf(str, "  multirecord_offset: 0x%x\n",
                           (guint) fu_struct_ipmi_common_get_multirecord_offset(st));
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_ipmi_common_get_checksum(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ipmi_common_validate_internal(FuStructIpmiCommon *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ipmi_common_parse_internal(FuStructIpmiCommon *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ipmi_common_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ipmi_common_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ipmi_common_parse_stream: (skip):
 **/
FuStructIpmiCommon *
fu_struct_ipmi_common_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructIpmiCommon) st = fu_struct_ipmi_common_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 8, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructIpmiCommon failed read of 0x%x: ", (guint) 8);
        return NULL;
    }
    if (st->buf->len != 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIpmiCommon requested 0x%x and got 0x%x",
                    (guint) 8,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_ipmi_common_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_board_info_ref: (skip):
 **/
FuStructBoardInfo *
fu_struct_board_info_ref(FuStructBoardInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_board_info_unref: (skip):
 **/
void
fu_struct_board_info_unref(FuStructBoardInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructBoardInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_board_info_new_internal: (skip):
 **/
static FuStructBoardInfo *
fu_struct_board_info_new_internal(void)
{
    FuStructBoardInfo *st = g_new0(FuStructBoardInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_board_info_get_version: (skip):
 **/
guint8
fu_struct_board_info_get_version(const FuStructBoardInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_board_info_get_length: (skip):
 **/
guint8
fu_struct_board_info_get_length(const FuStructBoardInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_board_info_get_lang_code: (skip):
 **/
guint8
fu_struct_board_info_get_lang_code(const FuStructBoardInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_board_info_get_mfg_date: (skip):
 **/
guint32
fu_struct_board_info_get_mfg_date(const FuStructBoardInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->buf->data + 3, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_board_info_get_manufacturer_len: (skip):
 **/
guint8
fu_struct_board_info_get_manufacturer_len(const FuStructBoardInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}

/* setters */
/**
 * fu_struct_board_info_to_string: (skip):
 **/
static gchar *
fu_struct_board_info_to_string(const FuStructBoardInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructBoardInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_board_info_get_version(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_board_info_get_length(st));
    g_string_append_printf(str, "  lang_code: 0x%x\n",
                           (guint) fu_struct_board_info_get_lang_code(st));
    g_string_append_printf(str, "  mfg_date: 0x%x\n",
                           (guint) fu_struct_board_info_get_mfg_date(st));
    g_string_append_printf(str, "  manufacturer_len: 0x%x\n",
                           (guint) fu_struct_board_info_get_manufacturer_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_board_info_validate_internal(FuStructBoardInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_board_info_parse_internal(FuStructBoardInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_board_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_board_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_board_info_parse_stream: (skip):
 **/
FuStructBoardInfo *
fu_struct_board_info_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructBoardInfo) st = fu_struct_board_info_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 7, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructBoardInfo failed read of 0x%x: ", (guint) 7);
        return NULL;
    }
    if (st->buf->len != 7) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructBoardInfo requested 0x%x and got 0x%x",
                    (guint) 7,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_board_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
