/* state-machine.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from state-machine.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_STATE_MACHINE_0_PROPERTY,
	GEARY_STATE_MACHINE_STATE_PROPERTY,
	GEARY_STATE_MACHINE_ABORT_ON_NO_TRANSITION_PROPERTY,
	GEARY_STATE_MACHINE_LOGGING_PROPERTY,
	GEARY_STATE_MACHINE_NUM_PROPERTIES
};
static GParamSpec* geary_state_machine_properties[GEARY_STATE_MACHINE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearyStateMachinePrivate {
	guint _state;
	gboolean _abort_on_no_transition;
	gboolean _logging;
	GearyStateMachineDescriptor* descriptor;
	GearyStateMapping** transitions;
	gint transitions_length1;
	gint transitions_length2;
	GearyStateTransition default_transition;
	gpointer default_transition_target;
	gboolean locked;
	GearyStatePostTransition post_transition;
	gpointer post_transition_target;
	void* post_user;
	GObject* post_object;
	GError* post_err;
};

static gint GearyStateMachine_private_offset;
static gpointer geary_state_machine_parent_class = NULL;

static void geary_state_machine_set_state (GearyStateMachine* self,
                                    guint value);
static void geary_state_machine_set_logging (GearyStateMachine* self,
                                      gboolean value);
static void geary_state_machine_finalize (GObject * obj);
static GType geary_state_machine_get_type_once (void);
static void _vala_geary_state_machine_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_geary_state_machine_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
geary_state_machine_get_instance_private (GearyStateMachine* self)
{
	return G_STRUCT_MEMBER_P (self, GearyStateMachine_private_offset);
}

guint
geary_state_machine_get_state (GearyStateMachine* self)
{
	guint result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE (self), 0U);
	result = self->priv->_state;
	return result;
}

static void
geary_state_machine_set_state (GearyStateMachine* self,
                               guint value)
{
	guint old_value;
	g_return_if_fail (GEARY_STATE_IS_MACHINE (self));
	old_value = geary_state_machine_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, geary_state_machine_properties[GEARY_STATE_MACHINE_STATE_PROPERTY]);
	}
}

gboolean
geary_state_machine_get_abort_on_no_transition (GearyStateMachine* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE (self), FALSE);
	result = self->priv->_abort_on_no_transition;
	return result;
}

void
geary_state_machine_set_abort_on_no_transition (GearyStateMachine* self,
                                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_STATE_IS_MACHINE (self));
	old_value = geary_state_machine_get_abort_on_no_transition (self);
	if (old_value != value) {
		self->priv->_abort_on_no_transition = value;
		g_object_notify_by_pspec ((GObject *) self, geary_state_machine_properties[GEARY_STATE_MACHINE_ABORT_ON_NO_TRANSITION_PROPERTY]);
	}
}

gboolean
geary_state_machine_get_logging (GearyStateMachine* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE (self), FALSE);
	result = self->priv->_logging;
	return result;
}

static void
geary_state_machine_set_logging (GearyStateMachine* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_STATE_IS_MACHINE (self));
	old_value = geary_state_machine_get_logging (self);
	if (old_value != value) {
		self->priv->_logging = value;
		g_object_notify_by_pspec ((GObject *) self, geary_state_machine_properties[GEARY_STATE_MACHINE_LOGGING_PROPERTY]);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyStateMachine*
geary_state_machine_construct (GType object_type,
                               GearyStateMachineDescriptor* descriptor,
                               GearyStateMapping** mappings,
                               gint mappings_length1,
                               GearyStateTransition default_transition,
                               gpointer default_transition_target)
{
	GearyStateMachine * self = NULL;
	GearyStateMachineDescriptor* _tmp0_;
	guint _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	GearyStateMapping** _tmp14_;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE_DESCRIPTOR (descriptor), NULL);
	self = (GearyStateMachine*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (descriptor);
	_g_object_unref0 (self->priv->descriptor);
	self->priv->descriptor = _tmp0_;
	self->priv->default_transition = default_transition;
	self->priv->default_transition_target = default_transition_target;
	{
		GearyStateMapping** mapping_collection = NULL;
		gint mapping_collection_length1 = 0;
		gint _mapping_collection_size_ = 0;
		gint mapping_it = 0;
		mapping_collection = mappings;
		mapping_collection_length1 = mappings_length1;
		for (mapping_it = 0; mapping_it < mapping_collection_length1; mapping_it = mapping_it + 1) {
			GearyStateMapping* _tmp1_;
			GearyStateMapping* mapping = NULL;
			_tmp1_ = _g_object_ref0 (mapping_collection[mapping_it]);
			mapping = _tmp1_;
			{
				GearyStateMapping* _tmp2_;
				guint _tmp3_;
				guint _tmp4_;
				GearyStateMapping* _tmp5_;
				guint _tmp6_;
				guint _tmp7_;
				_tmp2_ = mapping;
				_tmp3_ = geary_state_machine_descriptor_get_state_count (descriptor);
				_tmp4_ = _tmp3_;
				_vala_assert (_tmp2_->state < _tmp4_, "mapping.state < descriptor.state_count");
				_tmp5_ = mapping;
				_tmp6_ = geary_state_machine_descriptor_get_event_count (descriptor);
				_tmp7_ = _tmp6_;
				_vala_assert (_tmp5_->event < _tmp7_, "mapping.event < descriptor.event_count");
				_g_object_unref0 (mapping);
			}
		}
	}
	_tmp8_ = geary_state_machine_descriptor_get_start_state (descriptor);
	_tmp9_ = _tmp8_;
	geary_state_machine_set_state (self, _tmp9_);
	_tmp10_ = geary_state_machine_descriptor_get_state_count (descriptor);
	_tmp11_ = _tmp10_;
	_tmp12_ = geary_state_machine_descriptor_get_event_count (descriptor);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_new0 (GearyStateMapping*, (_tmp11_ * _tmp13_) + 1);
	self->priv->transitions = (_vala_array_free (self->priv->transitions, self->priv->transitions_length1 * self->priv->transitions_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->transitions = _tmp14_;
	self->priv->transitions_length1 = _tmp11_;
	self->priv->transitions_length2 = _tmp13_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				GearyStateMapping* mapping = NULL;
				GearyStateMapping* _tmp17_;
				GearyStateMapping* _tmp18_;
				GearyStateMapping** _tmp19_;
				gint _tmp19__length1;
				gint _tmp19__length2;
				GearyStateMapping* _tmp20_;
				GearyStateMapping* _tmp21_;
				GearyStateMapping* _tmp22_;
				GearyStateMapping** _tmp23_;
				gint _tmp23__length1;
				gint _tmp23__length2;
				GearyStateMapping* _tmp24_;
				GearyStateMapping* _tmp25_;
				GearyStateMapping* _tmp26_;
				GearyStateMapping* _tmp27_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = ctr;
					ctr = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				if (!(ctr < mappings_length1)) {
					break;
				}
				_tmp17_ = mappings[ctr];
				_tmp18_ = _g_object_ref0 (_tmp17_);
				mapping = _tmp18_;
				_tmp19_ = self->priv->transitions;
				_tmp19__length1 = self->priv->transitions_length1;
				_tmp19__length2 = self->priv->transitions_length2;
				_tmp20_ = mapping;
				_tmp21_ = mapping;
				_tmp22_ = _tmp19_[(_tmp20_->state * _tmp19__length2) + _tmp21_->event];
				_vala_assert (_tmp22_ == NULL, "transitions[mapping.state, mapping.event] == null");
				_tmp23_ = self->priv->transitions;
				_tmp23__length1 = self->priv->transitions_length1;
				_tmp23__length2 = self->priv->transitions_length2;
				_tmp24_ = mapping;
				_tmp25_ = mapping;
				_tmp26_ = mapping;
				_tmp27_ = _g_object_ref0 (_tmp26_);
				_g_object_unref0 (_tmp23_[(_tmp24_->state * _tmp23__length2) + _tmp25_->event]);
				_tmp23_[(_tmp24_->state * _tmp23__length2) + _tmp25_->event] = _tmp27_;
				_g_object_unref0 (mapping);
			}
		}
	}
	return self;
}

GearyStateMachine*
geary_state_machine_new (GearyStateMachineDescriptor* descriptor,
                         GearyStateMapping** mappings,
                         gint mappings_length1,
                         GearyStateTransition default_transition,
                         gpointer default_transition_target)
{
	return geary_state_machine_construct (GEARY_STATE_TYPE_MACHINE, descriptor, mappings, mappings_length1, default_transition, default_transition_target);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

guint
geary_state_machine_issue (GearyStateMachine* self,
                           guint event,
                           void* user,
                           GObject* object,
                           GError* err)
{
	GearyStateMachineDescriptor* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	GearyStateMachineDescriptor* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	GearyStateMapping* mapping = NULL;
	GearyStateMapping** _tmp7_;
	gint _tmp7__length1;
	gint _tmp7__length2;
	guint _tmp8_;
	GearyStateMapping* _tmp9_;
	GearyStateTransition _tmp10_ = NULL;
	gpointer _tmp10__target = NULL;
	GearyStateMapping* _tmp11_;
	GearyStateTransition transition = NULL;
	gpointer transition_target;
	GearyStateTransition _tmp15_;
	gpointer _tmp15__target;
	guint old_state = 0U;
	guint _tmp37_;
	GearyStateTransition _tmp38_;
	gpointer _tmp38__target;
	guint _tmp39_;
	guint _tmp40_;
	GearyStateMachineDescriptor* _tmp41_;
	guint _tmp42_;
	guint _tmp43_;
	gboolean _tmp50_;
	GearyStatePostTransition _tmp56_;
	gpointer _tmp56__target;
	guint _tmp67_;
	guint result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE (self), 0U);
	g_return_val_if_fail ((object == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (object, G_TYPE_OBJECT), 0U);
	_tmp0_ = self->priv->descriptor;
	_tmp1_ = geary_state_machine_descriptor_get_event_count (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_assert (event < _tmp2_, "event < descriptor.event_count");
	_tmp3_ = self->priv->_state;
	_tmp4_ = self->priv->descriptor;
	_tmp5_ = geary_state_machine_descriptor_get_state_count (_tmp4_);
	_tmp6_ = _tmp5_;
	_vala_assert (_tmp3_ < _tmp6_, "state < descriptor.state_count");
	_tmp7_ = self->priv->transitions;
	_tmp7__length1 = self->priv->transitions_length1;
	_tmp7__length2 = self->priv->transitions_length2;
	_tmp8_ = self->priv->_state;
	_tmp9_ = _tmp7_[(_tmp8_ * _tmp7__length2) + event];
	mapping = _tmp9_;
	_tmp11_ = mapping;
	if (_tmp11_ != NULL) {
		GearyStateMapping* _tmp12_;
		GearyStateTransition _tmp13_;
		gpointer _tmp13__target;
		_tmp12_ = mapping;
		_tmp13_ = _tmp12_->transition;
		_tmp13__target = _tmp12_->transition_target;
		_tmp10_ = _tmp13_;
		_tmp10__target = _tmp13__target;
	} else {
		GearyStateTransition _tmp14_;
		gpointer _tmp14__target;
		_tmp14_ = self->priv->default_transition;
		_tmp14__target = self->priv->default_transition_target;
		_tmp10_ = _tmp14_;
		_tmp10__target = _tmp14__target;
	}
	transition = _tmp10_;
	transition_target = _tmp10__target;
	_tmp15_ = transition;
	_tmp15__target = transition_target;
	if (_tmp15_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GearyStateMachineDescriptor* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GearyStateMachineDescriptor* _tmp21_;
		guint _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gboolean _tmp27_;
		guint _tmp30_;
		_tmp16_ = geary_state_machine_to_string (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->descriptor;
		_tmp19_ = geary_state_machine_descriptor_get_event_string (_tmp18_, event);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->descriptor;
		_tmp22_ = self->priv->_state;
		_tmp23_ = geary_state_machine_descriptor_get_state_string (_tmp21_, _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup_printf ("%s: No transition defined for %s@%s", _tmp17_, _tmp20_, _tmp24_);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp17_);
		msg = _tmp26_;
		_tmp27_ = self->priv->_abort_on_no_transition;
		if (_tmp27_) {
			const gchar* _tmp28_;
			_tmp28_ = msg;
			g_error ("state-machine.vala:61: %s", _tmp28_);
		} else {
			const gchar* _tmp29_;
			_tmp29_ = msg;
			g_critical ("state-machine.vala:63: %s", _tmp29_);
		}
		_tmp30_ = self->priv->_state;
		result = _tmp30_;
		_g_free0 (msg);
		return result;
	}
	if (self->priv->locked) {
		GearyStateMachineDescriptor* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		guint _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp31_ = self->priv->descriptor;
		_tmp32_ = geary_state_machine_descriptor_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = self->priv->_state;
		_tmp35_ = geary_state_machine_get_event_issued_string (self, _tmp34_, event);
		_tmp36_ = _tmp35_;
		g_error ("state-machine.vala:71: Fatal reentrancy on locked state machine %s: %s", _tmp33_, _tmp36_);
		_g_free0 (_tmp36_);
	}
	self->priv->locked = TRUE;
	_tmp37_ = self->priv->_state;
	old_state = _tmp37_;
	_tmp38_ = transition;
	_tmp38__target = transition_target;
	_tmp39_ = self->priv->_state;
	geary_state_machine_set_state (self, _tmp38_ (_tmp39_, event, user, object, err, _tmp38__target));
	_tmp40_ = self->priv->_state;
	_tmp41_ = self->priv->descriptor;
	_tmp42_ = geary_state_machine_descriptor_get_state_count (_tmp41_);
	_tmp43_ = _tmp42_;
	_vala_assert (_tmp40_ < _tmp43_, "state < descriptor.state_count");
	if (!self->priv->locked) {
		GearyStateMachineDescriptor* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		guint _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		_tmp44_ = self->priv->descriptor;
		_tmp45_ = geary_state_machine_descriptor_get_name (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = self->priv->_state;
		_tmp48_ = geary_state_machine_get_transition_string (self, old_state, event, _tmp47_);
		_tmp49_ = _tmp48_;
		g_error ("state-machine.vala:81: Exited transition to unlocked state machine %s:" \
" %s", _tmp46_, _tmp49_);
		_g_free0 (_tmp49_);
	}
	self->priv->locked = FALSE;
	_tmp50_ = self->priv->_logging;
	if (_tmp50_) {
		gchar* _tmp51_;
		gchar* _tmp52_;
		guint _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp51_ = geary_state_machine_to_string (self);
		_tmp52_ = _tmp51_;
		_tmp53_ = self->priv->_state;
		_tmp54_ = geary_state_machine_get_transition_string (self, old_state, event, _tmp53_);
		_tmp55_ = _tmp54_;
		g_message ("state-machine.vala:87: %s: %s", _tmp52_, _tmp55_);
		_g_free0 (_tmp55_);
		_g_free0 (_tmp52_);
	}
	_tmp56_ = self->priv->post_transition;
	_tmp56__target = self->priv->post_transition_target;
	if (_tmp56_ != NULL) {
		GearyStatePostTransition perform = NULL;
		GearyStatePostTransition _tmp57_;
		gpointer _tmp57__target;
		gpointer perform_target;
		void* perform_user = NULL;
		void* _tmp58_;
		GObject* perform_object = NULL;
		GObject* _tmp59_;
		GObject* _tmp60_;
		GError* perform_err = NULL;
		GError* _tmp61_;
		GError* _tmp62_;
		GearyStatePostTransition _tmp63_;
		gpointer _tmp63__target;
		void* _tmp64_;
		GObject* _tmp65_;
		GError* _tmp66_;
		_tmp57_ = self->priv->post_transition;
		_tmp57__target = self->priv->post_transition_target;
		perform = _tmp57_;
		perform_target = _tmp57__target;
		_tmp58_ = self->priv->post_user;
		perform_user = _tmp58_;
		_tmp59_ = self->priv->post_object;
		_tmp60_ = _g_object_ref0 (_tmp59_);
		perform_object = _tmp60_;
		_tmp61_ = self->priv->post_err;
		_tmp62_ = _g_error_copy0 (_tmp61_);
		perform_err = _tmp62_;
		self->priv->post_transition = NULL;
		self->priv->post_transition_target = NULL;
		self->priv->post_user = NULL;
		_g_object_unref0 (self->priv->post_object);
		self->priv->post_object = NULL;
		_g_error_free0 (self->priv->post_err);
		self->priv->post_err = NULL;
		_tmp63_ = perform;
		_tmp63__target = perform_target;
		_tmp64_ = perform_user;
		_tmp65_ = perform_object;
		_tmp66_ = perform_err;
		_tmp63_ (_tmp64_, _tmp65_, _tmp66_, _tmp63__target);
		_g_error_free0 (perform_err);
		_g_object_unref0 (perform_object);
	}
	_tmp67_ = self->priv->_state;
	result = _tmp67_;
	return result;
}

gboolean
geary_state_machine_do_post_transition (GearyStateMachine* self,
                                        GearyStatePostTransition post_transition,
                                        gpointer post_transition_target,
                                        void* user,
                                        GObject* object,
                                        GError* err)
{
	GObject* _tmp2_;
	GError* _tmp3_;
	gboolean result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE (self), FALSE);
	g_return_val_if_fail ((object == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (object, G_TYPE_OBJECT), FALSE);
	if (!self->priv->locked) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = geary_state_machine_to_string (self);
		_tmp1_ = _tmp0_;
		g_warning ("state-machine.vala:120: %s: Attempt to register post-transition while " \
"machine is unlocked", _tmp1_);
		_g_free0 (_tmp1_);
		result = FALSE;
		return result;
	}
	self->priv->post_transition = post_transition;
	self->priv->post_transition_target = post_transition_target;
	self->priv->post_user = user;
	_tmp2_ = _g_object_ref0 (object);
	_g_object_unref0 (self->priv->post_object);
	self->priv->post_object = _tmp2_;
	_tmp3_ = _g_error_copy0 (err);
	_g_error_free0 (self->priv->post_err);
	self->priv->post_err = _tmp3_;
	result = TRUE;
	return result;
}

gchar*
geary_state_machine_get_state_string (GearyStateMachine* self,
                                      guint state)
{
	GearyStateMachineDescriptor* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE (self), NULL);
	_tmp0_ = self->priv->descriptor;
	_tmp1_ = geary_state_machine_descriptor_get_state_string (_tmp0_, state);
	result = _tmp1_;
	return result;
}

gchar*
geary_state_machine_get_event_string (GearyStateMachine* self,
                                      guint event)
{
	GearyStateMachineDescriptor* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE (self), NULL);
	_tmp0_ = self->priv->descriptor;
	_tmp1_ = geary_state_machine_descriptor_get_event_string (_tmp0_, event);
	result = _tmp1_;
	return result;
}

gchar*
geary_state_machine_get_event_issued_string (GearyStateMachine* self,
                                             guint state,
                                             guint event)
{
	GearyStateMachineDescriptor* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GearyStateMachineDescriptor* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE (self), NULL);
	_tmp0_ = self->priv->descriptor;
	_tmp1_ = geary_state_machine_descriptor_get_state_string (_tmp0_, state);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->descriptor;
	_tmp4_ = geary_state_machine_descriptor_get_event_string (_tmp3_, event);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s@%s", _tmp2_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp7_;
	return result;
}

gchar*
geary_state_machine_get_transition_string (GearyStateMachine* self,
                                           guint old_state,
                                           guint event,
                                           guint new_state)
{
	GearyStateMachineDescriptor* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GearyStateMachineDescriptor* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GearyStateMachineDescriptor* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE (self), NULL);
	_tmp0_ = self->priv->descriptor;
	_tmp1_ = geary_state_machine_descriptor_get_state_string (_tmp0_, old_state);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->descriptor;
	_tmp4_ = geary_state_machine_descriptor_get_event_string (_tmp3_, event);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->descriptor;
	_tmp7_ = geary_state_machine_descriptor_get_state_string (_tmp6_, new_state);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("%s@%s -> %s", _tmp2_, _tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp10_;
	return result;
}

gchar*
geary_state_machine_to_string (GearyStateMachine* self)
{
	GearyStateMachineDescriptor* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GearyStateMachineDescriptor* _tmp3_;
	guint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (GEARY_STATE_IS_MACHINE (self), NULL);
	_tmp0_ = self->priv->descriptor;
	_tmp1_ = geary_state_machine_descriptor_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->descriptor;
	_tmp4_ = self->priv->_state;
	_tmp5_ = geary_state_machine_descriptor_get_state_string (_tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("Machine %s [%s]", _tmp2_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	result = _tmp8_;
	return result;
}

static void
geary_state_machine_class_init (GearyStateMachineClass * klass,
                                gpointer klass_data)
{
	geary_state_machine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyStateMachine_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_state_machine_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_state_machine_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_state_machine_finalize;
	/** The state machine's current state. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_STATE_MACHINE_STATE_PROPERTY, geary_state_machine_properties[GEARY_STATE_MACHINE_STATE_PROPERTY] = g_param_spec_uint ("state", "state", "state", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if the state machine crashes your app when mis-configured. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_STATE_MACHINE_ABORT_ON_NO_TRANSITION_PROPERTY, geary_state_machine_properties[GEARY_STATE_MACHINE_ABORT_ON_NO_TRANSITION_PROPERTY] = g_param_spec_boolean ("abort-on-no-transition", "abort-on-no-transition", "abort-on-no-transition", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Determines if transition logging is enabled. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_STATE_MACHINE_LOGGING_PROPERTY, geary_state_machine_properties[GEARY_STATE_MACHINE_LOGGING_PROPERTY] = g_param_spec_boolean ("logging", "logging", "logging", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_state_machine_instance_init (GearyStateMachine * self,
                                   gpointer klass)
{
	self->priv = geary_state_machine_get_instance_private (self);
	self->priv->_abort_on_no_transition = TRUE;
	self->priv->_logging = FALSE;
	self->priv->locked = FALSE;
	self->priv->post_transition = NULL;
	self->priv->post_transition_target = NULL;
	self->priv->post_user = NULL;
	self->priv->post_object = NULL;
	self->priv->post_err = NULL;
}

static void
geary_state_machine_finalize (GObject * obj)
{
	GearyStateMachine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_STATE_TYPE_MACHINE, GearyStateMachine);
	_g_object_unref0 (self->priv->descriptor);
	self->priv->transitions = (_vala_array_free (self->priv->transitions, self->priv->transitions_length1 * self->priv->transitions_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->post_object);
	_g_error_free0 (self->priv->post_err);
	G_OBJECT_CLASS (geary_state_machine_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_state_machine_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyStateMachineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_state_machine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyStateMachine), 0, (GInstanceInitFunc) geary_state_machine_instance_init, NULL };
	GType geary_state_machine_type_id;
	geary_state_machine_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyStateMachine", &g_define_type_info, 0);
	GearyStateMachine_private_offset = g_type_add_instance_private (geary_state_machine_type_id, sizeof (GearyStateMachinePrivate));
	return geary_state_machine_type_id;
}

GType
geary_state_machine_get_type (void)
{
	static gsize geary_state_machine_type_id__once = 0;
	if (g_once_init_enter (&geary_state_machine_type_id__once)) {
		GType geary_state_machine_type_id;
		geary_state_machine_type_id = geary_state_machine_get_type_once ();
		g_once_init_leave (&geary_state_machine_type_id__once, geary_state_machine_type_id);
	}
	return geary_state_machine_type_id__once;
}

static void
_vala_geary_state_machine_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GearyStateMachine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_STATE_TYPE_MACHINE, GearyStateMachine);
	switch (property_id) {
		case GEARY_STATE_MACHINE_STATE_PROPERTY:
		g_value_set_uint (value, geary_state_machine_get_state (self));
		break;
		case GEARY_STATE_MACHINE_ABORT_ON_NO_TRANSITION_PROPERTY:
		g_value_set_boolean (value, geary_state_machine_get_abort_on_no_transition (self));
		break;
		case GEARY_STATE_MACHINE_LOGGING_PROPERTY:
		g_value_set_boolean (value, geary_state_machine_get_logging (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_state_machine_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GearyStateMachine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_STATE_TYPE_MACHINE, GearyStateMachine);
	switch (property_id) {
		case GEARY_STATE_MACHINE_STATE_PROPERTY:
		geary_state_machine_set_state (self, g_value_get_uint (value));
		break;
		case GEARY_STATE_MACHINE_ABORT_ON_NO_TRANSITION_PROPERTY:
		geary_state_machine_set_abort_on_no_transition (self, g_value_get_boolean (value));
		break;
		case GEARY_STATE_MACHINE_LOGGING_PROPERTY:
		geary_state_machine_set_logging (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

